/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.Version;
import org.elasticsearch.bootstrap.JarHell;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.plugins.MetaPluginInfo;

public class PluginInfo
implements Writeable,
ToXContentObject {
    public static final String ES_PLUGIN_PROPERTIES = "plugin-descriptor.properties";
    public static final String ES_PLUGIN_POLICY = "plugin-security.policy";
    private final String name;
    private final String description;
    private final String version;
    private final String classname;
    private final List<String> extendedPlugins;
    private final boolean hasNativeController;
    private final boolean requiresKeystore;

    public PluginInfo(String name, String description, String version, String classname, List<String> extendedPlugins, boolean hasNativeController, boolean requiresKeystore) {
        this.name = name;
        this.description = description;
        this.version = version;
        this.classname = classname;
        this.extendedPlugins = Collections.unmodifiableList(extendedPlugins);
        this.hasNativeController = hasNativeController;
        this.requiresKeystore = requiresKeystore;
    }

    public PluginInfo(StreamInput in) throws IOException {
        this.name = in.readString();
        this.description = in.readString();
        this.version = in.readString();
        this.classname = in.readString();
        this.extendedPlugins = in.getVersion().onOrAfter(Version.V_6_2_0) ? in.readList(StreamInput::readString) : Collections.emptyList();
        this.hasNativeController = in.getVersion().onOrAfter(Version.V_5_4_0) ? in.readBoolean() : false;
        this.requiresKeystore = in.getVersion().onOrAfter(Version.V_6_0_0_beta2) ? in.readBoolean() : false;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.description);
        out.writeString(this.version);
        out.writeString(this.classname);
        if (out.getVersion().onOrAfter(Version.V_6_2_0)) {
            out.writeStringList(this.extendedPlugins);
        }
        if (out.getVersion().onOrAfter(Version.V_5_4_0)) {
            out.writeBoolean(this.hasNativeController);
        }
        if (out.getVersion().onOrAfter(Version.V_6_0_0_beta2)) {
            out.writeBoolean(this.requiresKeystore);
        }
    }

    public static List<Path> extractAllPlugins(Path rootPath) throws IOException {
        LinkedList<Path> plugins = new LinkedList<Path>();
        HashSet<String> seen = new HashSet<String>();
        if (Files.exists(rootPath, new LinkOption[0])) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(rootPath);){
                for (Path plugin : stream) {
                    if (FileSystemUtils.isDesktopServicesStore(plugin) || plugin.getFileName().toString().startsWith(".removing-")) continue;
                    if (!seen.add(plugin.getFileName().toString())) {
                        throw new IllegalStateException("duplicate plugin: " + plugin);
                    }
                    if (MetaPluginInfo.isMetaPlugin(plugin)) {
                        DirectoryStream<Path> subStream = Files.newDirectoryStream(plugin);
                        Throwable throwable = null;
                        try {
                            for (Path subPlugin : subStream) {
                                if (MetaPluginInfo.isPropertiesFile(subPlugin) || FileSystemUtils.isDesktopServicesStore(subPlugin)) continue;
                                if (!seen.add(subPlugin.getFileName().toString())) {
                                    throw new IllegalStateException("duplicate plugin: " + subPlugin);
                                }
                                plugins.add(subPlugin);
                            }
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (subStream != null) {
                                PluginInfo.$closeResource(throwable, subStream);
                            }
                            continue;
                        }
                    }
                    plugins.add(plugin);
                }
            }
        }
        return plugins;
    }

    public static PluginInfo readFromProperties(Path path) throws IOException {
        return PluginInfo.readFromProperties(path, true);
    }

    static PluginInfo readFromProperties(Path path, boolean enforceVersion) throws IOException {
        boolean requiresKeystore;
        boolean hasNativeController;
        Path descriptor = path.resolve(ES_PLUGIN_PROPERTIES);
        Properties props = new Properties();
        try (InputStream stream = Files.newInputStream(descriptor, new OpenOption[0]);){
            props.load(stream);
        }
        Map propsMap = props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty));
        String name = propsMap.remove("name");
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("property [name] is missing in [" + descriptor + "]");
        }
        String description = propsMap.remove("description");
        if (description == null) {
            throw new IllegalArgumentException("property [description] is missing for plugin [" + name + "]");
        }
        String version = propsMap.remove("version");
        if (version == null) {
            throw new IllegalArgumentException("property [version] is missing for plugin [" + name + "]");
        }
        String esVersionString = propsMap.remove("elasticsearch.version");
        if (esVersionString == null) {
            throw new IllegalArgumentException("property [elasticsearch.version] is missing for plugin [" + name + "]");
        }
        Version esVersion = Version.fromString(esVersionString);
        if (enforceVersion && !esVersion.equals(Version.CURRENT)) {
            String message = String.format(Locale.ROOT, "plugin [%s] is incompatible with version [%s]; was designed for version [%s]", name, Version.CURRENT.toString(), esVersionString);
            throw new IllegalArgumentException(message);
        }
        String javaVersionString = propsMap.remove("java.version");
        if (javaVersionString == null) {
            throw new IllegalArgumentException("property [java.version] is missing for plugin [" + name + "]");
        }
        JarHell.checkVersionFormat((String)javaVersionString);
        JarHell.checkJavaVersion((String)name, (String)javaVersionString);
        String classname = propsMap.remove("classname");
        if (classname == null) {
            throw new IllegalArgumentException("property [classname] is missing for plugin [" + name + "]");
        }
        String extendedString = propsMap.remove("extended.plugins");
        List<Object> extendedPlugins = extendedString == null ? Collections.emptyList() : Arrays.asList(Strings.delimitedListToStringArray(extendedString, ","));
        String hasNativeControllerValue = propsMap.remove("has.native.controller");
        if (hasNativeControllerValue == null) {
            hasNativeController = false;
        } else {
            switch (hasNativeControllerValue) {
                case "true": {
                    hasNativeController = true;
                    break;
                }
                case "false": {
                    hasNativeController = false;
                    break;
                }
                default: {
                    String message = String.format(Locale.ROOT, "property [%s] must be [%s], [%s], or unspecified but was [%s]", "has_native_controller", "true", "false", hasNativeControllerValue);
                    throw new IllegalArgumentException(message);
                }
            }
        }
        String requiresKeystoreValue = propsMap.remove("requires.keystore");
        if (requiresKeystoreValue == null) {
            requiresKeystoreValue = "false";
        }
        try {
            requiresKeystore = Booleans.parseBoolean(requiresKeystoreValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("property [requires.keystore] must be [true] or [false], but was [" + requiresKeystoreValue + "]", e);
        }
        if (!propsMap.isEmpty()) {
            throw new IllegalArgumentException("Unknown properties in plugin descriptor: " + propsMap.keySet());
        }
        return new PluginInfo(name, description, version, classname, extendedPlugins, hasNativeController, requiresKeystore);
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getClassname() {
        return this.classname;
    }

    public List<String> getExtendedPlugins() {
        return this.extendedPlugins;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasNativeController() {
        return this.hasNativeController;
    }

    public boolean requiresKeystore() {
        return this.requiresKeystore;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("name", this.name);
        builder.field("version", this.version);
        builder.field("description", this.description);
        builder.field("classname", this.classname);
        builder.field("extended_plugins", this.extendedPlugins);
        builder.field("has_native_controller", this.hasNativeController);
        builder.field("requires_keystore", this.requiresKeystore);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PluginInfo that = (PluginInfo)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        return !(this.version != null ? !this.version.equals(that.version) : that.version != null);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder information = new StringBuilder().append(prefix).append("- Plugin information:\n").append(prefix).append("Name: ").append(this.name).append("\n").append(prefix).append("Description: ").append(this.description).append("\n").append(prefix).append("Version: ").append(this.version).append("\n").append(prefix).append("Native Controller: ").append(this.hasNativeController).append("\n").append(prefix).append("Requires Keystore: ").append(this.requiresKeystore).append("\n").append(prefix).append("Extended Plugins: ").append(this.extendedPlugins).append("\n").append(prefix).append(" * Classname: ").append(this.classname);
        return information.toString();
    }
}

