/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories.fs;

import java.io.IOException;
import java.nio.file.Path;
import java.util.function.Function;
import org.elasticsearch.cluster.metadata.RepositoryMetaData;
import org.elasticsearch.common.blobstore.BlobPath;
import org.elasticsearch.common.blobstore.BlobStore;
import org.elasticsearch.common.blobstore.fs.FsBlobStore;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.repositories.RepositoryException;
import org.elasticsearch.repositories.blobstore.BlobStoreRepository;

public class FsRepository
extends BlobStoreRepository {
    public static final String TYPE = "fs";
    public static final Setting<String> LOCATION_SETTING = new Setting("location", "", Function.identity(), Setting.Property.NodeScope);
    public static final Setting<String> REPOSITORIES_LOCATION_SETTING = new Setting<String>("repositories.fs.location", LOCATION_SETTING, Function.identity(), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> CHUNK_SIZE_SETTING = Setting.byteSizeSetting("chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> REPOSITORIES_CHUNK_SIZE_SETTING = Setting.byteSizeSetting("repositories.fs.chunk_size", new ByteSizeValue(Long.MAX_VALUE), new ByteSizeValue(5L), new ByteSizeValue(Long.MAX_VALUE), Setting.Property.NodeScope);
    public static final Setting<Boolean> COMPRESS_SETTING = Setting.boolSetting("compress", false, Setting.Property.NodeScope);
    public static final Setting<Boolean> REPOSITORIES_COMPRESS_SETTING = Setting.boolSetting("repositories.fs.compress", false, Setting.Property.NodeScope);
    private final FsBlobStore blobStore;
    private ByteSizeValue chunkSize;
    private final BlobPath basePath;
    private boolean compress;

    public FsRepository(RepositoryMetaData metadata, Environment environment, NamedXContentRegistry namedXContentRegistry) throws IOException {
        super(metadata, environment.settings(), namedXContentRegistry);
        String location = REPOSITORIES_LOCATION_SETTING.get(metadata.settings());
        if (location.isEmpty()) {
            this.logger.warn("the repository location is missing, it should point to a shared file system location that is available on all master and data nodes");
            throw new RepositoryException(metadata.name(), "missing location");
        }
        Path locationFile = environment.resolveRepoFile(location);
        if (locationFile == null) {
            if (environment.repoFiles().length > 0) {
                this.logger.warn("The specified location [{}] doesn't start with any repository paths specified by the path.repo setting: [{}] ", (Object)location, (Object)environment.repoFiles());
                throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo");
            }
            this.logger.warn("The specified location [{}] should start with a repository path specified by the path.repo setting, but the path.repo setting was not set on this node", (Object)location);
            throw new RepositoryException(metadata.name(), "location [" + location + "] doesn't match any of the locations specified by path.repo because this setting is empty");
        }
        this.blobStore = new FsBlobStore(this.settings, locationFile);
        this.chunkSize = CHUNK_SIZE_SETTING.exists(metadata.settings()) ? CHUNK_SIZE_SETTING.get(metadata.settings()) : REPOSITORIES_CHUNK_SIZE_SETTING.get(this.settings);
        this.compress = COMPRESS_SETTING.exists(metadata.settings()) ? COMPRESS_SETTING.get(metadata.settings()) : REPOSITORIES_COMPRESS_SETTING.get(this.settings);
        this.basePath = BlobPath.cleanPath();
    }

    @Override
    protected BlobStore blobStore() {
        return this.blobStore;
    }

    @Override
    protected boolean isCompress() {
        return this.compress;
    }

    @Override
    protected ByteSizeValue chunkSize() {
        return this.chunkSize;
    }

    @Override
    protected BlobPath basePath() {
        return this.basePath;
    }
}

