/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui.colour;

import java.awt.Color;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;
import tim.prune.data.DataPoint;
import tim.prune.data.Timestamp;
import tim.prune.data.Track;
import tim.prune.data.TrackInfo;
import tim.prune.gui.colour.DiscretePointColourer;

public class DateColourer
extends DiscretePointColourer {
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateInstance();

    public DateColourer(Color color, Color color2, int n) {
        super(color, color2, n);
    }

    public void calculateColours(TrackInfo trackInfo) {
        Track track = trackInfo == null ? null : trackInfo.getTrack();
        int n = track == null ? 0 : track.getNumPoints();
        this.init(n);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>(20);
        String string = null;
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < n) {
            DataPoint dataPoint = track.getPoint(n4);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                n3 = 0;
                String string2 = DateColourer.getDate(dataPoint.getTimestamp());
                if (string2 != null) {
                    if (string != null && string2.equals(string)) {
                        n3 = n2;
                    } else {
                        Integer n5 = (Integer)hashMap.get(string2);
                        if (n5 == null) {
                            n3 = hashMap.size() + 1;
                            hashMap.put(string2, n3);
                        } else {
                            n3 = n5;
                        }
                        string = string2;
                        n2 = n3;
                    }
                }
                this.setColour(n4, n3);
            }
            ++n4;
        }
        this.generateDiscreteColours(hashMap.size() + 1);
    }

    private static String getDate(Timestamp timestamp) {
        if (timestamp == null || !timestamp.isValid()) {
            return null;
        }
        Calendar calendar = timestamp.getCalendar();
        calendar.setTimeZone(TimeZone.getDefault());
        return DEFAULT_DATE_FORMAT.format(calendar.getTime());
    }
}

