/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.util.Date;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.M4;
import javajs.util.P3;
import javajs.util.P3i;
import javajs.util.SB;
import javajs.util.V3;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.RadiusData;
import org.jmol.c.VDW;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.VolumeDataReader;
import org.jmol.util.BSUtil;
import org.jmol.util.ContactPair;
import org.jmol.util.Logger;

abstract class AtomDataReader
extends VolumeDataReader {
    protected float maxDistance;
    protected ContactPair contactPair;
    protected String fileName;
    protected String fileDotModel;
    protected int modelIndex;
    protected AtomData atomData = new AtomData();
    protected P3[] atomXyzTruncated;
    protected float[] atomRadius;
    protected float[] atomProp;
    protected int[] atomNo;
    protected int[] atomIndex;
    protected int[] myIndex;
    protected int ac;
    protected int myAtomCount;
    protected int nearbyAtomCount;
    protected int firstNearbyAtom;
    protected BS bsMySelected = new BS();
    protected BS bsMyIgnored = new BS();
    protected BS bsNearby;
    protected boolean doAddHydrogens;
    protected boolean havePlane;
    protected boolean doUseIterator;
    protected float theProperty;
    protected boolean haveOneProperty;
    private float minPtsPerAng;
    protected float sr;
    protected float[] rs;
    protected float[] rs2;
    protected float maxRS;
    protected float[] thisPlane;
    protected BS thisAtomSet;
    protected int thisX;
    protected float margin;
    protected float vl0;
    protected float vl1;
    protected float vl2;
    protected BS bsSurfaceVoxels;
    protected BS validSpheres;
    protected BS noFaceSpheres;
    protected int[] voxelSource;
    protected final P3 ptY0 = new P3();
    protected final P3 ptZ0 = new P3();
    protected final P3i pt0 = new P3i();
    protected final P3i pt1 = new P3i();
    protected final P3 ptV = new P3();

    AtomDataReader() {
    }

    protected void initADR(SurfaceGenerator sg) {
        this.initVDR(sg);
        this.precalculateVoxelData = true;
    }

    @Override
    protected void setup(boolean isMapData) {
        this.setup2();
    }

    protected void setup2() {
        this.contactPair = this.params.contactPair;
        this.doAddHydrogens = this.sg.atomDataServer != null && this.params.addHydrogens;
        this.modelIndex = this.params.modelIndex;
        if (this.params.bsIgnore != null) {
            this.bsMyIgnored = this.params.bsIgnore;
        }
        if (this.params.volumeData != null) {
            this.setVolumeDataV(this.params.volumeData);
            this.setBBox(this.volumeData.volumetricOrigin, 0.0f);
            this.ptV.setT(this.volumeData.volumetricOrigin);
            for (int i = 0; i < 3; ++i) {
                this.ptV.scaleAdd2(this.volumeData.voxelCounts[i] - 1, this.volumeData.volumetricVectors[i], this.ptV);
            }
            this.setBBox(this.ptV, 0.0f);
        }
        boolean bl = this.havePlane = this.params.thePlane != null;
        if (this.havePlane) {
            this.volumeData.setPlaneParameters(this.params.thePlane);
        }
    }

    protected void markPlaneVoxels(P3 p, float r) {
        int i = 0;
        int pt = this.thisX * this.yzCount;
        int pt1 = pt + this.yzCount;
        while (pt < pt1) {
            this.volumeData.getPoint(pt, this.ptV);
            this.thisPlane[i] = this.ptV.distance(p) - r;
            ++pt;
            ++i;
        }
    }

    protected void setVolumeForPlane() {
        if (this.useOriginStepsPoints) {
            this.xyzMin = P3.newP(this.params.origin);
            this.xyzMax = P3.newP(this.params.origin);
            this.xyzMax.add3((this.params.points.x - 1.0f) * this.params.steps.x, (this.params.points.y - 1.0f) * this.params.steps.y, (this.params.points.z - 1.0f) * this.params.steps.z);
        } else if (this.params.boundingBox == null) {
            this.getAtoms(this.params.bsSelected, false, true, false, false, false, false, this.params.mep_marginAngstroms, this.params.modelInvRotation);
            if (this.xyzMin == null) {
                this.xyzMin = P3.new3(-10.0f, -10.0f, -10.0f);
                this.xyzMax = P3.new3(10.0f, 10.0f, 10.0f);
            }
        } else {
            this.xyzMin = P3.newP(this.params.boundingBox[0]);
            this.xyzMax = P3.newP(this.params.boundingBox[1]);
        }
        this.setRanges(this.params.plane_ptsPerAngstrom, this.params.plane_gridMax, 0.0f);
    }

    protected void getAtoms(BS bsSelected, boolean doAddHydrogens, boolean getRadii, boolean getMolecules, boolean getAllModels, boolean addNearbyAtoms, boolean getAtomMinMax, float marginAtoms, M4 modelInvRotation) {
        int i;
        if (addNearbyAtoms) {
            getRadii = true;
        }
        if (getRadii) {
            if (this.params.atomRadiusData == null) {
                this.params.atomRadiusData = new RadiusData(null, 1.0f, RadiusData.EnumType.FACTOR, VDW.AUTO);
            }
            this.atomData.radiusData = this.params.atomRadiusData;
            this.atomData.radiusData.valueExtended = this.params.solventExtendedAtomRadius;
            if (doAddHydrogens) {
                this.atomData.radiusData.vdwType = VDW.NOJMOL;
            }
        }
        this.atomData.modelIndex = this.modelIndex;
        this.atomData.bsSelected = bsSelected;
        this.atomData.bsIgnored = this.bsMyIgnored;
        this.sg.fillAtomData(this.atomData, 1 | (getAllModels ? 16 : 0) | (getMolecules ? 4 : 0) | (getRadii ? 2 : 0));
        if (this.doUseIterator) {
            this.atomData.bsSelected = null;
        }
        this.ac = this.atomData.ac;
        this.modelIndex = this.atomData.firstModelIndex;
        boolean needRadius = false;
        for (int i2 = 0; i2 < this.ac; ++i2) {
            if ((bsSelected == null || bsSelected.get(i2)) && !this.bsMyIgnored.get(i2)) {
                if (this.havePlane) {
                    float f;
                    this.atomData.atomRadius[i2] = this.getWorkingRadius(i2, marginAtoms);
                    if (Math.abs(this.volumeData.distancePointToPlane(this.atomData.xyz[i2])) > 2.0f * f) continue;
                }
                this.bsMySelected.set(i2);
                boolean bl = needRadius = !this.havePlane;
            }
            if (!getRadii || !addNearbyAtoms && !needRadius) continue;
            this.atomData.atomRadius[i2] = this.getWorkingRadius(i2, marginAtoms);
        }
        float rH = getRadii && doAddHydrogens ? this.getWorkingRadius(-1, marginAtoms) : 0.0f;
        this.myAtomCount = BSUtil.cardinalityOf(this.bsMySelected);
        BS atomSet = BSUtil.copy(this.bsMySelected);
        int nH = 0;
        this.atomProp = null;
        this.theProperty = Float.MAX_VALUE;
        this.haveOneProperty = false;
        float[] props = this.params.theProperty;
        if (this.myAtomCount > 0) {
            int i3;
            P3[] hAtoms = null;
            if (doAddHydrogens) {
                this.atomData.bsSelected = atomSet;
                this.sg.atomDataServer.fillAtomData(this.atomData, 8);
                nH = this.atomData.hydrogenAtomCount;
                hAtoms = new P3[nH];
                for (i = 0; i < this.atomData.hAtoms.length; ++i) {
                    if (this.atomData.hAtoms[i] == null) continue;
                    int j = this.atomData.hAtoms[i].length;
                    while (--j >= 0) {
                        hAtoms[--nH] = this.atomData.hAtoms[i][j];
                    }
                }
                nH = hAtoms.length;
                Logger.info(nH + " attached hydrogens added");
            }
            int n = nH + this.myAtomCount;
            if (getRadii) {
                this.atomRadius = new float[n];
            }
            this.atomXyzTruncated = new P3[n];
            if (this.params.theProperty != null) {
                this.atomProp = new float[n];
            }
            this.atomNo = new int[n];
            this.atomIndex = new int[n];
            this.myIndex = new int[this.ac];
            for (i3 = 0; i3 < nH; ++i3) {
                if (getRadii) {
                    this.atomRadius[i3] = rH;
                }
                this.atomXyzTruncated[i3] = hAtoms[i3];
                this.atomNo[i3] = -1;
                if (this.atomProp == null) continue;
                this.addAtomProp(i3, Float.NaN);
            }
            this.myAtomCount = nH;
            i3 = atomSet.nextSetBit(0);
            while (i3 >= 0) {
                if (this.atomProp != null) {
                    this.addAtomProp(this.myAtomCount, props != null && i3 < props.length ? props[i3] : Float.NaN);
                }
                this.atomXyzTruncated[this.myAtomCount] = this.atomData.xyz[i3];
                this.atomNo[this.myAtomCount] = this.atomData.atomicNumber[i3];
                this.atomIndex[this.myAtomCount] = i3;
                this.myIndex[i3] = this.myAtomCount;
                if (getRadii) {
                    this.atomRadius[this.myAtomCount] = this.atomData.atomRadius[i3];
                }
                ++this.myAtomCount;
                i3 = atomSet.nextSetBit(i3 + 1);
            }
        }
        this.firstNearbyAtom = this.myAtomCount;
        if (!this.isQuiet) {
            Logger.info(this.myAtomCount + " atoms will be used in the surface calculation");
        }
        if (modelInvRotation != null) {
            this.atomData.transformXYZ(modelInvRotation, bsSelected);
        }
        if (this.myAtomCount == 0) {
            this.setBBox(P3.new3(10.0f, 10.0f, 10.0f), 0.0f);
            this.setBBox(P3.new3(-10.0f, -10.0f, -10.0f), 0.0f);
        }
        for (int i4 = 0; i4 < this.myAtomCount; ++i4) {
            this.setBBox(this.atomXyzTruncated[i4], getRadii ? this.atomRadius[i4] + 0.5f : 0.0f);
        }
        if (!Float.isNaN(this.params.scale)) {
            V3 v = V3.newVsub(this.xyzMax, this.xyzMin);
            v.scale(0.5f);
            this.xyzMin.add(v);
            v.scale(this.params.scale);
            this.xyzMax.add2(this.xyzMin, v);
            this.xyzMin.sub(v);
        }
        if (!addNearbyAtoms || this.myAtomCount == 0) {
            return;
        }
        P3 pt = new P3();
        this.bsNearby = new BS();
        for (i = 0; i < this.ac; ++i) {
            if (atomSet.get(i) || this.bsMyIgnored.get(i)) continue;
            float rA = this.atomData.atomRadius[i];
            if (this.params.thePlane != null && Math.abs(this.volumeData.distancePointToPlane(this.atomData.xyz[i])) > 2.0f * rA) continue;
            if (this.params.theProperty != null) {
                rA += this.maxDistance;
            }
            pt = this.atomData.xyz[i];
            if (!(pt.x + rA > this.xyzMin.x) || !(pt.x - rA < this.xyzMax.x) || !(pt.y + rA > this.xyzMin.y) || !(pt.y - rA < this.xyzMax.y) || !(pt.z + rA > this.xyzMin.z) || !(pt.z - rA < this.xyzMax.z)) continue;
            this.bsNearby.set(i);
            ++this.nearbyAtomCount;
        }
        int nAtoms = this.myAtomCount;
        if (this.nearbyAtomCount != 0) {
            this.atomRadius = AU.arrayCopyF(this.atomRadius, nAtoms += this.nearbyAtomCount);
            this.atomXyzTruncated = (P3[])AU.arrayCopyObject(this.atomXyzTruncated, nAtoms);
            if (this.atomIndex != null) {
                this.atomIndex = AU.arrayCopyI(this.atomIndex, nAtoms);
            }
            if (props != null) {
                this.atomProp = AU.arrayCopyF(this.atomProp, nAtoms);
            }
            int i5 = this.bsNearby.nextSetBit(0);
            while (i5 >= 0) {
                if (props != null) {
                    this.addAtomProp(this.myAtomCount, props[i5]);
                }
                this.myIndex[i5] = this.myAtomCount;
                this.atomIndex[this.myAtomCount] = i5;
                this.atomXyzTruncated[this.myAtomCount] = this.atomData.xyz[i5];
                this.atomRadius[this.myAtomCount++] = this.atomData.atomRadius[i5];
                i5 = this.bsNearby.nextSetBit(i5 + 1);
            }
        }
        if (getRadii) {
            this.setRadii();
        }
        this.haveOneProperty = !Float.isNaN(this.theProperty);
    }

    protected void setRadii() {
        if (this.rs != null) {
            return;
        }
        this.maxRS = 0.0f;
        this.rs = new float[this.myAtomCount];
        this.rs2 = new float[this.myAtomCount];
        for (int i = 0; i < this.myAtomCount; ++i) {
            this.rs[i] = this.atomRadius[i] + this.sr;
            float r = this.rs[i];
            if (r > this.maxRS) {
                this.maxRS = r;
            }
            this.rs2[i] = this.rs[i] * this.rs[i];
        }
    }

    private void addAtomProp(int i, float f) {
        this.atomProp[i] = f;
        if (!Float.isNaN(this.theProperty) && f != this.theProperty) {
            this.theProperty = this.theProperty == Float.MAX_VALUE ? f : Float.NaN;
        }
    }

    private float getWorkingRadius(int i, float marginAtoms) {
        float r = i < 0 ? this.atomData.hAtomRadius : this.atomData.atomRadius[i];
        return Float.isNaN(marginAtoms) ? Math.max(r, 0.1f) : r + marginAtoms;
    }

    protected void setHeader(String calcType, String line2) {
        this.jvxlFileHeaderBuffer = new SB();
        if (this.atomData.programInfo != null) {
            this.jvxlFileHeaderBuffer.append("#created by ").append(this.atomData.programInfo).append(" on ").append("" + new Date()).append("\n");
        }
        this.jvxlFileHeaderBuffer.append(calcType).append("\n").append(line2).append("\n");
    }

    protected void setRanges(float ptsPerAngstrom, int maxGrid, float minPtsPerAng) {
        if (this.xyzMin == null) {
            return;
        }
        this.ptsPerAngstrom = ptsPerAngstrom;
        this.maxGrid = maxGrid;
        this.minPtsPerAng = minPtsPerAng;
        this.setVolumeData();
        JvxlCoder.jvxlCreateHeader(this.volumeData, this.jvxlFileHeaderBuffer);
    }

    @Override
    protected void setVolumeData() {
        this.setVolumeDataADR();
    }

    protected void setVolumeDataADR() {
        if (!this.setVolumeDataParams()) {
            this.setVoxelRange(0, this.xyzMin.x, this.xyzMax.x, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
            this.setVoxelRange(1, this.xyzMin.y, this.xyzMax.y, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
            this.setVoxelRange(2, this.xyzMin.z, this.xyzMax.z, this.ptsPerAngstrom, this.maxGrid, this.minPtsPerAng);
        }
    }

    protected void setVertexSource() {
        if (this.meshDataServer != null) {
            this.meshDataServer.fillMeshData(this.meshData, 1, null);
        }
        if (this.params.vertexSource != null) {
            this.params.vertexSource = AU.arrayCopyI(this.params.vertexSource, this.meshData.vc);
            for (int i = 0; i < this.meshData.vc; ++i) {
                this.params.vertexSource[i] = Math.abs(this.params.vertexSource[i]) - 1;
            }
        }
    }

    protected void resetPlane(float value) {
        for (int i = 0; i < this.yzCount; ++i) {
            this.thisPlane[i] = value;
        }
    }

    protected void resetVoxelData(float value) {
        for (int x = 0; x < this.nPointsX; ++x) {
            for (int y = 0; y < this.nPointsY; ++y) {
                for (int z = 0; z < this.nPointsZ; ++z) {
                    this.voxelData[x][y][z] = value;
                }
            }
        }
    }

    private float getVoxel(int i, int j, int k, int ipt) {
        return this.isProgressive ? this.thisPlane[ipt % this.yzCount] : this.voxelData[i][j][k];
    }

    protected void unsetVoxelData() {
        this.unsetVoxelData2();
    }

    protected void unsetVoxelData2() {
        if (this.isProgressive) {
            for (int i = 0; i < this.yzCount; ++i) {
                if (this.thisPlane[i] != Float.MAX_VALUE) continue;
                this.thisPlane[i] = Float.NaN;
            }
        } else {
            for (int x = 0; x < this.nPointsX; ++x) {
                for (int y = 0; y < this.nPointsY; ++y) {
                    for (int z = 0; z < this.nPointsZ; ++z) {
                        if (this.voxelData[x][y][z] != Float.MAX_VALUE) continue;
                        this.voxelData[x][y][z] = Float.NaN;
                    }
                }
            }
        }
    }

    protected void setGridLimitsForAtom(P3 ptA, float rA, P3i pt0, P3i pt1) {
        this.volumeData.xyzToVoxelPt(ptA.x, ptA.y, ptA.z, pt0);
        int x = (int)Math.floor((rA += this.margin) / this.volumeData.volumetricVectorLengths[0]);
        int y = (int)Math.floor(rA / this.volumeData.volumetricVectorLengths[1]);
        int z = (int)Math.floor(rA / this.volumeData.volumetricVectorLengths[2]);
        pt1.set(pt0.x + x, pt0.y + y, pt0.z + z);
        pt0.set(pt0.x - x, pt0.y - y, pt0.z - z);
        pt0.x = Math.max(pt0.x - 1, 0);
        pt0.y = Math.max(pt0.y - 1, 0);
        pt0.z = Math.max(pt0.z - 1, 0);
        pt1.x = Math.min(pt1.x + 1, this.nPointsX);
        pt1.y = Math.min(pt1.y + 1, this.nPointsY);
        pt1.z = Math.min(pt1.z + 1, this.nPointsZ);
    }

    protected void getAtomMinMax(BS bs, BS[] bsAtomMinMax) {
        for (int i = 0; i < this.nPointsX; ++i) {
            bsAtomMinMax[i] = new BS();
        }
        int iAtom = this.myAtomCount;
        while (--iAtom >= 0) {
            if (bs != null && !bs.get(iAtom)) continue;
            this.setGridLimitsForAtom(this.atomXyzTruncated[iAtom], this.atomRadius[iAtom], this.pt0, this.pt1);
            for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                bsAtomMinMax[i].set(iAtom);
            }
        }
    }

    protected void markSphereVoxels(float r0, float distance) {
        boolean isWithin = distance != Float.MAX_VALUE && this.point != null;
        V3 v0 = this.volumetricVectors[0];
        V3 v1 = this.volumetricVectors[1];
        V3 v2 = this.volumetricVectors[2];
        int iAtom = this.thisAtomSet.nextSetBit(0);
        while (iAtom >= 0) {
            if (this.havePlane || this.validSpheres == null || this.validSpheres.get(iAtom)) {
                boolean isSurface = this.noFaceSpheres != null && this.noFaceSpheres.get(iAtom);
                boolean isNearby = iAtom >= this.firstNearbyAtom;
                P3 ptA = this.atomXyzTruncated[iAtom];
                float rA = this.atomRadius[iAtom];
                if (!isWithin || !((double)ptA.distance(this.point) > (double)(distance + rA) + 0.5)) {
                    float rA0 = rA + r0;
                    this.setGridLimitsForAtom(ptA, rA0, this.pt0, this.pt1);
                    if (this.isProgressive) {
                        this.pt0.x = this.thisX;
                        this.pt1.x = this.thisX + 1;
                    }
                    this.volumeData.voxelPtToXYZ(this.pt0.x, this.pt0.y, this.pt0.z, this.ptV);
                    for (int i = this.pt0.x; i < this.pt1.x; ++i) {
                        this.ptY0.setT(this.ptV);
                        for (int j = this.pt0.y; j < this.pt1.y; ++j) {
                            this.ptZ0.setT(this.ptV);
                            for (int k = this.pt0.z; k < this.pt1.z; ++k) {
                                float value = this.ptV.distance(ptA) - rA;
                                int ipt = this.volumeData.getPointIndex(i, j, k);
                                if ((r0 == 0.0f || value <= rA0) && value < this.getVoxel(i, j, k, ipt)) {
                                    if (isNearby || isWithin && this.ptV.distance(this.point) > distance) {
                                        value = Float.NaN;
                                    }
                                    this.setVoxel(i, j, k, ipt, value);
                                    if (!Float.isNaN(value)) {
                                        if (this.voxelSource != null) {
                                            this.voxelSource[ipt] = iAtom + 1;
                                        }
                                        if (value < 0.0f && isSurface) {
                                            this.bsSurfaceVoxels.set(ipt);
                                        }
                                    }
                                }
                                this.ptV.add(v2);
                            }
                            this.ptV.add2(v1, this.ptZ0);
                        }
                        this.ptV.add2(v0, this.ptY0);
                    }
                }
            }
            iAtom = this.thisAtomSet.nextSetBit(iAtom + 1);
        }
    }

    protected void setVoxel(int i, int j, int k, int ipt, float value) {
        if (this.isProgressive) {
            this.thisPlane[ipt % this.yzCount] = value;
        } else {
            this.voxelData[i][j][k] = value;
        }
    }
}

