/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.Lst;
import javajs.util.PT;
import org.jmol.adapter.readers.quantum.SlaterReader;
import org.jmol.api.JmolAdapter;
import org.jmol.quantum.SlaterData;
import org.jmol.util.Logger;

public class AdfReader
extends SlaterReader {
    private Map<String, SymmetryData> htSymmetries;
    private Lst<SymmetryData> vSymmetries;
    private String energy = null;
    private int nXX = 0;
    private String symLine;

    @Override
    protected boolean checkLine() throws Exception {
        if (this.line.indexOf("Irreducible Representations, including subspecies") >= 0) {
            this.readSymmetries();
            return true;
        }
        if (this.line.indexOf("S F O s  ***  (Symmetrized Fragment Orbitals)  ***") >= 0) {
            this.readSlaterBasis();
            return true;
        }
        if (this.line.indexOf(" Coordinates (Cartesian, in Input Orientation)") >= 0 || this.line.indexOf("G E O M E T R Y  ***") >= 0) {
            if (!this.doGetModel(++this.modelNumber, null)) {
                return this.checkLastModel();
            }
            this.readCoordinates();
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            if (this.doReadMolecularOrbitals) {
                this.readMolecularOrbitals(PT.getTokens(this.symLine)[1]);
            }
            return true;
        }
        if (!this.doProcessLines) {
            return true;
        }
        if (this.line.indexOf("Energy:") >= 0) {
            String[] tokens = PT.getTokens(this.line.substring(this.line.indexOf("Energy:")));
            this.energy = tokens[1];
            return true;
        }
        if (this.line.indexOf("Vibrations") >= 0) {
            this.readFrequencies();
            return true;
        }
        if (this.line.indexOf(" === ") >= 0) {
            this.symLine = this.line;
            return true;
        }
        if (this.line.indexOf(" ======  Eigenvectors (rows) in BAS representation") >= 0) {
            this.readMolecularOrbitals(PT.getTokens(this.symLine)[1]);
            return true;
        }
        return true;
    }

    private void readCoordinates() throws Exception {
        String[] tokens;
        boolean isGeometry = this.line.indexOf("G E O M E T R Y") >= 0;
        this.asc.newAtomSet();
        this.asc.setAtomSetName("" + this.energy);
        this.discardLinesUntilContains("----");
        int pt0 = isGeometry ? 2 : 5;
        this.nXX = 0;
        while (this.rd() != null && !this.line.startsWith(" -----") && (tokens = this.getTokens()).length >= 5) {
            String symbol = tokens[1];
            String name = null;
            if (symbol.indexOf(".") >= 0) {
                name = symbol;
                symbol = symbol.substring(0, symbol.indexOf("."));
            }
            if (JmolAdapter.getElementNumber(symbol) < 1) {
                ++this.nXX;
                continue;
            }
            this.addAtomXYZSymName(tokens, pt0, symbol, name);
        }
    }

    private void readFrequencies() throws Exception {
        this.rd();
        while (this.rd() != null) {
            while (this.rd() != null && this.line.indexOf(".") < 0 && this.line.indexOf("====") < 0) {
            }
            if (this.line == null || this.line.indexOf(".") < 0) {
                return;
            }
            String[] frequencies = this.getTokens();
            this.rd();
            int iAtom0 = this.asc.ac;
            int ac = this.asc.getLastAtomSetAtomCount();
            int frequencyCount = frequencies.length;
            boolean[] ignore = new boolean[frequencyCount];
            for (int i = 0; i < frequencyCount; ++i) {
                boolean bl = ignore[i] = !this.doGetVibration(++this.vibrationNumber);
                if (ignore[i]) continue;
                this.asc.cloneLastAtomSet();
                this.asc.setAtomSetFrequency(null, null, frequencies[i], null);
            }
            this.readLines(this.nXX);
            this.fillFrequencyData(iAtom0, ac, ac, ignore, true, 0, 0, null, 0, null);
        }
    }

    private void readSymmetries() throws Exception {
        this.vSymmetries = new Lst();
        this.htSymmetries = new Hashtable<String, SymmetryData>();
        this.rd();
        int index = 0;
        String syms = "";
        while (this.rd() != null && this.line.length() > 1) {
            syms = syms + this.line;
        }
        String[] tokens = PT.getTokens(syms);
        for (int i = 0; i < tokens.length; ++i) {
            SymmetryData sd = new SymmetryData(index++, tokens[i]);
            this.htSymmetries.put(tokens[i], sd);
            this.vSymmetries.addLast(sd);
        }
    }

    private void readSlaterBasis() throws Exception {
        if (this.vSymmetries == null) {
            return;
        }
        int nBF = 0;
        for (int i = 0; i < this.vSymmetries.size(); ++i) {
            SymmetryData sd = (SymmetryData)this.vSymmetries.get(i);
            Logger.info(sd.sym);
            this.discardLinesUntilContains("=== " + sd.sym + " ===");
            if (this.line == null) {
                Logger.error("Symmetry slater basis section not found: " + sd.sym);
                return;
            }
            sd.nSFO = this.parseIntAt(this.rd(), 15);
            sd.nBF = this.parseIntAt(this.rd(), 75);
            String funcList = "";
            while (this.rd() != null && this.line.length() > 1) {
                funcList = funcList + this.line;
            }
            String[] tokens = PT.getTokens(funcList);
            if (tokens.length != sd.nBF) {
                return;
            }
            sd.basisFunctions = new int[tokens.length];
            int j = tokens.length;
            while (--j >= 0) {
                int n = this.parseIntStr(tokens[j]);
                if (n > nBF) {
                    nBF = n;
                }
                sd.basisFunctions[j] = n - 1;
            }
        }
        this.slaterArray = new SlaterData[nBF];
        this.discardLinesUntilContains("(power of)");
        this.readLines(2);
        while (this.rd() != null && this.line.length() > 3 && this.line.charAt(3) == ' ') {
            String data = this.line;
            while (this.rd().indexOf("---") < 0) {
                data = data + this.line;
            }
            String[] tokens = PT.getTokens(data);
            int nAtoms = tokens.length - 1;
            int[] atomList = new int[nAtoms];
            for (int i = 1; i <= nAtoms; ++i) {
                atomList[i - 1] = this.parseIntStr(tokens[i]) - 1;
            }
            this.rd();
            while (this.line.length() >= 10) {
                data = this.line;
                while (this.rd().length() > 35 && this.line.substring(0, 35).trim().length() == 0) {
                    data = data + this.line;
                }
                tokens = PT.getTokens(data);
                boolean isCore = tokens[0].equals("Core");
                int pt = isCore ? 1 : 0;
                int x = this.parseIntStr(tokens[pt++]);
                int y = this.parseIntStr(tokens[pt++]);
                int z = this.parseIntStr(tokens[pt++]);
                int r = this.parseIntStr(tokens[pt++]);
                float zeta = this.parseFloatStr(tokens[pt++]);
                for (int i = 0; i < nAtoms; ++i) {
                    int ptBF = this.parseIntStr(tokens[pt++]) - 1;
                    this.slaterArray[ptBF] = new SlaterData(atomList[i], x, y, z, r, zeta, 1.0);
                    this.slaterArray[ptBF].index = ptBF;
                }
            }
        }
    }

    private void readMolecularOrbitals(String sym) throws Exception {
        int pt;
        SymmetryData sd = this.htSymmetries.get(sym);
        if (sd == null) {
            return;
        }
        int ptSym = sd.index;
        boolean isLast = ptSym == this.vSymmetries.size() - 1;
        int n = 0;
        int nBF = this.slaterArray.length;
        sd.coefs = new float[sd.nSFO][nBF];
        while (n < sd.nBF) {
            this.rd();
            int nLine = PT.getTokens(this.rd()).length;
            this.rd();
            sd.mos = AU.createArrayOfHashtable(sd.nSFO);
            String[][] data = new String[sd.nSFO][];
            this.fillDataBlock(data, 0);
            for (int j = 1; j < nLine; ++j) {
                int pt2 = sd.basisFunctions[n++];
                for (int i = 0; i < sd.nSFO; ++i) {
                    sd.coefs[i][pt2] = this.parseFloatStr(data[i][j]);
                }
            }
        }
        for (int i = 0; i < sd.nSFO; ++i) {
            Hashtable<String, Object> mo = new Hashtable<String, Object>();
            mo.put("coefficients", sd.coefs[i]);
            mo.put("id", sym + " " + (i + 1));
            sd.mos[i] = mo;
        }
        if (!isLast) {
            return;
        }
        int nSym = this.htSymmetries.size();
        this.discardLinesUntilContains(nSym == 1 ? "Orbital Energies, per Irrep" : "Orbital Energies, all Irreps");
        this.readLines(4);
        int n2 = pt = nSym == 1 ? 0 : 1;
        if (nSym == 1) {
            sym = this.rd().trim();
        }
        while (this.rd() != null && this.line.length() > 10) {
            this.line = this.line.replace('(', ' ').replace(')', ' ');
            String[] tokens = this.getTokens();
            int len = tokens.length;
            if (nSym > 1) {
                sym = tokens[0];
            }
            int moPt = this.parseIntStr(tokens[pt]);
            float occ = this.parseFloatStr(tokens[len - 4 + pt]);
            float energy = this.parseFloatStr(tokens[len - 2 + pt]);
            this.addMo(sym, moPt, occ, energy);
        }
        int iAtom0 = this.asc.getLastAtomSetAtomIndex();
        for (int i = 0; i < nBF; ++i) {
            this.slaterArray[i].atomNo += iAtom0 + 1;
        }
        this.setSlaters(true, true);
        this.sortOrbitals();
        this.setMOs("eV");
    }

    private void addMo(String sym, int moPt, float occ, float energy) {
        SymmetryData sd = this.htSymmetries.get(sym);
        if (sd == null) {
            for (Map.Entry<String, SymmetryData> entry : this.htSymmetries.entrySet()) {
                if (!entry.getKey().startsWith(sym + ":")) continue;
                sd = entry.getValue();
                break;
            }
            if (sd == null) {
                return;
            }
        }
        Map<String, Object> mo = sd.mos[moPt - 1];
        mo.put("occupancy", Float.valueOf(occ > 2.0f ? 2.0f : occ));
        mo.put("energy", Float.valueOf(energy));
        mo.put("symmetry", sd.sym + "_" + moPt);
        this.setMO(mo);
    }

    private class SymmetryData {
        int index;
        String sym;
        int nSFO;
        int nBF;
        float[][] coefs;
        Map<String, Object>[] mos;
        int[] basisFunctions;

        public SymmetryData(int index, String sym) {
            Logger.info("ADF reader creating SymmetryData " + sym + " " + index);
            this.index = index;
            this.sym = sym;
        }
    }
}

