/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.renderspecial;

import javajs.util.BS;
import javajs.util.P3i;
import javajs.util.T3;
import javajs.util.V3;
import org.jmol.modelset.Atom;
import org.jmol.render.ShapeRenderer;
import org.jmol.shapespecial.Dots;
import org.jmol.util.C;
import org.jmol.util.Geodesic;

public class DotsRenderer
extends ShapeRenderer {
    public boolean iShowSolid;
    public int screenLevel;
    public int screenDotCount;
    public int[] scrCoords;
    public int[] faceMap = null;
    private V3 v3temp = new V3();
    private P3i scrTemp = new P3i();
    private int dotScale;

    protected void initRenderer() {
        this.screenLevel = Dots.MAX_LEVEL;
        this.screenDotCount = Geodesic.getVertexCount((int)Dots.MAX_LEVEL);
        this.scrCoords = new int[3 * this.screenDotCount];
    }

    protected boolean render() {
        this.render1((Dots)this.shape);
        return false;
    }

    protected void render1(Dots dots) {
        if (!this.iShowSolid && !this.g3d.setC((short)4)) {
            return;
        }
        int sppa = (int)this.vwr.getScalePixelsPerAngstrom(true);
        int n = this.iShowSolid || sppa > 20 ? 3 : (sppa > 10 ? 2 : (this.screenLevel = sppa > 5 ? 1 : 0));
        if (!this.iShowSolid) {
            this.screenLevel += this.vwr.getInt(553648143) - 3;
        }
        this.screenLevel = Math.max(Math.min(this.screenLevel, Dots.MAX_LEVEL), 0);
        this.screenDotCount = Geodesic.getVertexCount((int)this.screenLevel);
        this.dotScale = this.vwr.getInt(0x21000010);
        BS[] maps = dots.ec.getDotsConvexMaps();
        int i = dots.ec.getDotsConvexMax();
        while (--i >= 0) {
            Atom atom = this.ms.at[i];
            BS map = maps[i];
            if (map == null || !this.isVisibleForMe(atom) || !this.g3d.isInDisplayRange(atom.sX, atom.sY)) continue;
            try {
                float radius = dots.ec.getAppropriateRadius(i);
                if (this.iShowSolid && this.exportType == 1) {
                    this.g3d.drawAtom(atom, radius);
                    continue;
                }
                int nPoints = 0;
                int j = 0;
                int iDot = Math.min(map.size(), this.screenDotCount);
                while (--iDot >= 0) {
                    if (!map.get(iDot)) continue;
                    this.v3temp.scaleAdd2(radius, (T3)Geodesic.getVertexVector((int)iDot), (T3)atom);
                    this.tm.transformPtScr((T3)this.v3temp, this.scrTemp);
                    if (this.faceMap != null) {
                        this.faceMap[iDot] = j;
                    }
                    this.scrCoords[j++] = this.scrTemp.x;
                    this.scrCoords[j++] = this.scrTemp.y;
                    this.scrCoords[j++] = this.scrTemp.z;
                    ++nPoints;
                }
                if (nPoints == 0) continue;
                this.renderConvex(C.getColixInherited((short)dots.colixes[i], (short)atom.colixAtom), map, nPoints);
            }
            catch (Exception e) {
                System.out.println("Dots rendering error");
                System.out.println(e.toString());
            }
        }
    }

    protected void renderConvex(short colix, BS map, int nPoints) {
        this.colix = C.getColixTranslucent3((short)colix, (boolean)false, (float)0.0f);
        this.renderDots(nPoints);
    }

    protected void renderDots(int nPoints) {
        this.g3d.setC(this.colix);
        this.g3d.drawPoints(nPoints, this.scrCoords, this.dotScale);
    }
}

