/*
 * Decompiled with CFR 0.152.
 */
package org.protege.owlapi.inference.cls;

import java.util.HashSet;
import java.util.Set;
import org.protege.owlapi.inference.cls.NamedClassExtractor;
import org.protege.owlapi.inference.cls.NamedConjunctChecker;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.util.OWLAxiomVisitorAdapter;

public class ChildClassExtractor
extends OWLAxiomVisitorAdapter {
    private NamedConjunctChecker checker = new NamedConjunctChecker();
    private NamedClassExtractor namedClassExtractor = new NamedClassExtractor();
    private OWLClass currentParentClass;
    private Set<OWLClass> results = new HashSet<OWLClass>();

    public void reset() {
        this.results.clear();
        this.namedClassExtractor.reset();
    }

    public void setCurrentParentClass(OWLClass currentParentClass) {
        this.currentParentClass = currentParentClass;
        this.reset();
    }

    public Set<OWLClass> getResult() {
        return new HashSet<OWLClass>(this.results);
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        if (this.checker.containsConjunct(this.currentParentClass, axiom.getSuperClass()) && !axiom.getSubClass().isAnonymous()) {
            this.results.add(axiom.getSubClass().asOWLClass());
        }
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        if (!this.namedClassInEquivalentAxiom(axiom)) {
            return;
        }
        HashSet<OWLClassExpression> candidateDescriptions = new HashSet<OWLClassExpression>();
        boolean found = false;
        for (OWLClassExpression equivalentClass : axiom.getClassExpressions()) {
            if (!this.checker.containsConjunct(this.currentParentClass, equivalentClass)) {
                candidateDescriptions.add(equivalentClass);
                continue;
            }
            if (!equivalentClass.isAnonymous()) continue;
            found = true;
        }
        if (!found) {
            return;
        }
        this.namedClassExtractor.reset();
        for (OWLClassExpression desc : candidateDescriptions) {
            desc.accept((OWLClassExpressionVisitor)this.namedClassExtractor);
        }
        this.results.addAll(this.namedClassExtractor.getResult());
    }

    private boolean namedClassInEquivalentAxiom(OWLEquivalentClassesAxiom axiom) {
        for (OWLClassExpression equiv : axiom.getClassExpressions()) {
            if (equiv.isAnonymous()) continue;
            return true;
        }
        return false;
    }
}

