// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Communicator.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Communicator_h__
#define __Ice_Communicator_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/LoggerF.h>
#include <Ice/InstrumentationF.h>
#include <Ice/ObjectAdapterF.h>
#include <Ice/ObjectFactory.h>
#include <Ice/ValueFactory.h>
#include <Ice/Router.h>
#include <Ice/Locator.h>
#include <Ice/PluginF.h>
#include <Ice/ImplicitContextF.h>
#include <Ice/Current.h>
#include <Ice/Properties.h>
#include <Ice/FacetMap.h>
#include <Ice/Connection.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class Communicator;

}

namespace Ice
{

enum class ToStringMode : unsigned char
{
    Unicode,
    ASCII,
    Compat
};

}

namespace Ice
{

class ICE_CLASS(ICE_API) Communicator
{
public:

    ICE_MEMBER(ICE_API) virtual ~Communicator();

    virtual void destroy() noexcept = 0;

    virtual void shutdown() = 0;

    virtual void waitForShutdown() = 0;

    virtual bool isShutdown() const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> stringToProxy(const ::std::string&) const = 0;

    virtual ::std::string proxyToString(const ::std::shared_ptr<::Ice::ObjectPrx>&) const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> propertyToProxy(const ::std::string&) const = 0;

    virtual ::Ice::PropertyDict proxyToProperty(const ::std::shared_ptr<::Ice::ObjectPrx>&, const ::std::string&) const = 0;

    ICE_DEPRECATED_API("stringToIdentity() is deprecated, use the static stringToIdentity() method instead.") virtual ::Ice::Identity stringToIdentity(const ::std::string&) const = 0;

    virtual ::std::string identityToString(const ::Ice::Identity&) const = 0;

    virtual ::std::shared_ptr<::Ice::ObjectAdapter> createObjectAdapter(const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectAdapter> createObjectAdapterWithEndpoints(const ::std::string&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectAdapter> createObjectAdapterWithRouter(const ::std::string&, const ::std::shared_ptr<::Ice::RouterPrx>&) = 0;

    ICE_DEPRECATED_API("addObjectFactory() is deprecated, use ValueFactoryManager::add() instead.") virtual void addObjectFactory(const ::std::shared_ptr<::Ice::ObjectFactory>&, const ::std::string&) = 0;

    ICE_DEPRECATED_API("findObjectFactory() is deprecated, use ValueFactoryManager::find() instead.") virtual ::std::shared_ptr<::Ice::ObjectFactory> findObjectFactory(const ::std::string&) const = 0;

    virtual ::std::shared_ptr<::Ice::ImplicitContext> getImplicitContext() const = 0;

    virtual ::std::shared_ptr<::Ice::Properties> getProperties() const = 0;

    virtual ::std::shared_ptr<::Ice::Logger> getLogger() const = 0;

    virtual ::std::shared_ptr<::Ice::Instrumentation::CommunicatorObserver> getObserver() const = 0;

    virtual ::std::shared_ptr<::Ice::RouterPrx> getDefaultRouter() const = 0;

    virtual void setDefaultRouter(const ::std::shared_ptr<::Ice::RouterPrx>&) = 0;

    virtual ::std::shared_ptr<::Ice::LocatorPrx> getDefaultLocator() const = 0;

    virtual void setDefaultLocator(const ::std::shared_ptr<::Ice::LocatorPrx>&) = 0;

    virtual ::std::shared_ptr<::Ice::PluginManager> getPluginManager() const = 0;

    virtual ::std::shared_ptr<::Ice::ValueFactoryManager> getValueFactoryManager() const = 0;

    virtual void flushBatchRequests(::Ice::CompressBatch compress)
    {
        flushBatchRequestsAsync(compress).get();
    }

    virtual ::std::function<void()>
    flushBatchRequestsAsync(::Ice::CompressBatch compress,
                            ::std::function<void(::std::exception_ptr)> exception,
                            ::std::function<void(bool)> sent = nullptr) = 0;

    template<template<typename> class P = ::std::promise>
    auto flushBatchRequestsAsync(::Ice::CompressBatch compress)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        using Promise = P<void>;
        auto promise = ::std::make_shared<Promise>();
        flushBatchRequestsAsync(compress,
                                [promise](::std::exception_ptr ex)
                                {
                                    promise->set_exception(::std::move(ex));
                                },
                                [promise](bool)
                                {
                                    promise->set_value();
                                });
        return promise->get_future();
    }

    virtual ::std::shared_ptr<::Ice::ObjectPrx> createAdmin(const ::std::shared_ptr<::Ice::ObjectAdapter>&, const ::Ice::Identity&) = 0;

    virtual ::std::shared_ptr<::Ice::ObjectPrx> getAdmin() const = 0;

    virtual void addAdminFacet(const ::std::shared_ptr<::Ice::Object>&, const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> removeAdminFacet(const ::std::string&) = 0;

    virtual ::std::shared_ptr<::Ice::Object> findAdminFacet(const ::std::string&) = 0;

    virtual ::Ice::FacetMap findAllAdminFacets() = 0;
};

}

namespace Ice
{

}

namespace Ice
{

using CommunicatorPtr = ::std::shared_ptr<Communicator>;

}

#else // C++98 mapping

namespace IceProxy
{

}

namespace Ice
{

class Communicator;
ICE_API ::Ice::LocalObject* upCast(::Ice::Communicator*);
typedef ::IceInternal::Handle< ::Ice::Communicator> CommunicatorPtr;

}

namespace Ice
{

enum ToStringMode
{
    Unicode,
    ASCII,
    Compat
};

}

namespace IceAsync
{

}

namespace Ice
{

class Callback_Communicator_flushBatchRequests_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Communicator_flushBatchRequests_Base> Callback_Communicator_flushBatchRequestsPtr;

}

namespace IceProxy
{

}

namespace Ice
{

class ICE_API Communicator : public virtual ::Ice::LocalObject
{
public:

    typedef CommunicatorPtr PointerType;

    virtual ~Communicator();

    virtual void destroy() ICE_NOEXCEPT = 0;

    virtual void shutdown() = 0;

    virtual void waitForShutdown() = 0;

    virtual bool isShutdown() const = 0;

    virtual ::Ice::ObjectPrx stringToProxy(const ::std::string&) const = 0;

    virtual ::std::string proxyToString(const ::Ice::ObjectPrx&) const = 0;

    virtual ::Ice::ObjectPrx propertyToProxy(const ::std::string&) const = 0;

    virtual ::Ice::PropertyDict proxyToProperty(const ::Ice::ObjectPrx&, const ::std::string&) const = 0;

    ICE_DEPRECATED_API("stringToIdentity() is deprecated, use the static stringToIdentity() method instead.") virtual ::Ice::Identity stringToIdentity(const ::std::string&) const = 0;

    virtual ::std::string identityToString(const ::Ice::Identity&) const = 0;

    virtual ::Ice::ObjectAdapterPtr createObjectAdapter(const ::std::string&) = 0;

    virtual ::Ice::ObjectAdapterPtr createObjectAdapterWithEndpoints(const ::std::string&, const ::std::string&) = 0;

    virtual ::Ice::ObjectAdapterPtr createObjectAdapterWithRouter(const ::std::string&, const ::Ice::RouterPrx&) = 0;

    ICE_DEPRECATED_API("addObjectFactory() is deprecated, use ValueFactoryManager::add() instead.") virtual void addObjectFactory(const ::Ice::ObjectFactoryPtr&, const ::std::string&) = 0;

    ICE_DEPRECATED_API("findObjectFactory() is deprecated, use ValueFactoryManager::find() instead.") virtual ::Ice::ObjectFactoryPtr findObjectFactory(const ::std::string&) const = 0;

    virtual ::Ice::ImplicitContextPtr getImplicitContext() const = 0;

    virtual ::Ice::PropertiesPtr getProperties() const = 0;

    virtual ::Ice::LoggerPtr getLogger() const = 0;

    virtual ::Ice::Instrumentation::CommunicatorObserverPtr getObserver() const = 0;

    virtual ::Ice::RouterPrx getDefaultRouter() const = 0;

    virtual void setDefaultRouter(const ::Ice::RouterPrx&) = 0;

    virtual ::Ice::LocatorPrx getDefaultLocator() const = 0;

    virtual void setDefaultLocator(const ::Ice::LocatorPrx&) = 0;

    virtual ::Ice::PluginManagerPtr getPluginManager() const = 0;

    virtual ::Ice::ValueFactoryManagerPtr getValueFactoryManager() const = 0;

    virtual void flushBatchRequests(::Ice::CompressBatch) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual ::Ice::AsyncResultPtr begin_flushBatchRequests(::Ice::CompressBatch compress, const ::Ice::Callback_Communicator_flushBatchRequestsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0) = 0;

    virtual void end_flushBatchRequests(const ::Ice::AsyncResultPtr&) = 0;

    virtual ::Ice::ObjectPrx createAdmin(const ::Ice::ObjectAdapterPtr&, const ::Ice::Identity&) = 0;

    virtual ::Ice::ObjectPrx getAdmin() const = 0;

    virtual void addAdminFacet(const ::Ice::ObjectPtr&, const ::std::string&) = 0;

    virtual ::Ice::ObjectPtr removeAdminFacet(const ::std::string&) = 0;

    virtual ::Ice::ObjectPtr findAdminFacet(const ::std::string&) = 0;

    virtual ::Ice::FacetMap findAllAdminFacets() = 0;
};

inline bool operator==(const Communicator& lhs, const Communicator& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) == static_cast<const ::Ice::LocalObject&>(rhs);
}

inline bool operator<(const Communicator& lhs, const Communicator& rhs)
{
    return static_cast<const ::Ice::LocalObject&>(lhs) < static_cast<const ::Ice::LocalObject&>(rhs);
}

}

namespace Ice
{

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
