#ifndef EFL_IO_BUFFER_EO_HH
#define EFL_IO_BUFFER_EO_HH
#include <Eo.h>

extern "C" {
#include "efl_io_buffer.eo.h"
#include "efl_io_closer.eo.h"
#include "efl_io_positioner.eo.h"
#include "efl_io_reader.eo.h"
#include "efl_io_sizer.eo.h"
#include "efl_io_writer.eo.h"
#include "efl_object.eo.h"
}
#include <Eina.hh>
#include <Eo.hh>
#include "efl_io_closer.eo.hh"
#include "efl_io_positioner.eo.hh"
#include "efl_io_reader.eo.hh"
#include "efl_io_sizer.eo.hh"
#include "efl_io_writer.eo.hh"
#include "efl_object.eo.hh"
namespace efl { namespace io { 
struct Buffer;
} } 
namespace efl { namespace eo { template<> struct is_eolian_object< ::efl::io::Buffer> : ::std::true_type {}; } }
namespace efl { namespace io { 
struct Buffer;
} } 
namespace efl { 
struct Object;
} 
namespace efl { namespace io { 
struct Reader;
} } 
namespace efl { namespace io { 
struct Writer;
} } 
namespace efl { namespace io { 
struct Closer;
} } 
namespace efl { namespace io { 
struct Sizer;
} } 
namespace efl { namespace io { 
struct Positioner;
} } 

namespace eo_cxx {
namespace efl { namespace io { 
struct Buffer {
   ::efl::eolian::return_traits< size_t>::type limit_get() const;
   ::efl::eolian::return_traits<void>::type limit_set( ::efl::eolian::in_traits< size_t>::type size) const;
   ::efl::eolian::return_traits< uint64_t>::type position_read_get() const;
   ::efl::eolian::return_traits<bool>::type position_read_set( ::efl::eolian::in_traits< uint64_t>::type position) const;
   ::efl::eolian::return_traits< uint64_t>::type position_write_get() const;
   ::efl::eolian::return_traits<bool>::type position_write_set( ::efl::eolian::in_traits< uint64_t>::type position) const;
   ::efl::eolian::return_traits<Eina_Slice>::type slice_get() const;
   ::efl::eolian::return_traits<void>::type preallocate( ::efl::eolian::in_traits< size_t>::type size) const;
   ::efl::eolian::return_traits<void>::type adopt_readonly( ::efl::eolian::in_traits<Eina_Slice const>::type slice) const;
   ::efl::eolian::return_traits<void>::type adopt_readwrite( ::efl::eolian::in_traits<Eina_Rw_Slice>::type slice) const;
   ::efl::eolian::return_traits< ::std::unique_ptr<Eina_Binbuf, ::efl::eina::malloc_deleter>>::type binbuf_steal() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IO_BUFFER_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   operator ::efl::io::Buffer() const;
   operator ::efl::io::Buffer&();
   operator ::efl::io::Buffer const&() const;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Buffer,  ::efl::Object,  ::efl::io::Closer,  ::efl::io::Positioner,  ::efl::io::Reader,  ::efl::io::Sizer,  ::efl::io::Writer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Buffer const ,  ::efl::Object const ,  ::efl::io::Closer const ,  ::efl::io::Positioner const ,  ::efl::io::Reader const ,  ::efl::io::Sizer const ,  ::efl::io::Writer const > operator&() const { return {this}; }
   /// @endcond
};
} } 
}
namespace efl { namespace io { 
struct Buffer : ::efl::eo::concrete
   , EO_CXX_INHERIT( ::efl::Object)
   , EO_CXX_INHERIT( ::efl ::io::Closer)
   , EO_CXX_INHERIT( ::efl ::io::Positioner)
   , EO_CXX_INHERIT( ::efl ::io::Reader)
   , EO_CXX_INHERIT( ::efl ::io::Sizer)
   , EO_CXX_INHERIT( ::efl ::io::Writer)
{
   explicit Buffer( ::Eo* eo)
      : ::efl::eo::concrete(eo) {}
   explicit Buffer(std::nullptr_t)
      : ::efl::eo::concrete(nullptr) {}
   Buffer(Buffer const& other) = default;
   Buffer(Buffer&& other) = default;
   Buffer& operator=(Buffer const& other) = default;
   Buffer& operator=(Buffer&& other) = default;
   Buffer()
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class());
   }
   Buffer( ::efl::eo::concrete parent)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, parent, _eo_class());
   }
   template <typename F> Buffer(F f, typename ::std::enable_if< ::efl::eolian::is_callable<F>::value>::type* = 0)
   {
      ::efl::eolian::do_eo_add( ::efl::eo::concrete::_eo_raw, ::efl::eo::concrete{nullptr}, _eo_class(), f);
   }
   ::efl::eolian::return_traits< size_t>::type limit_get() const;
   ::efl::eolian::return_traits<void>::type limit_set( ::efl::eolian::in_traits< size_t>::type size) const;
   ::efl::eolian::return_traits< uint64_t>::type position_read_get() const;
   ::efl::eolian::return_traits<bool>::type position_read_set( ::efl::eolian::in_traits< uint64_t>::type position) const;
   ::efl::eolian::return_traits< uint64_t>::type position_write_get() const;
   ::efl::eolian::return_traits<bool>::type position_write_set( ::efl::eolian::in_traits< uint64_t>::type position) const;
   ::efl::eolian::return_traits<Eina_Slice>::type slice_get() const;
   ::efl::eolian::return_traits<void>::type preallocate( ::efl::eolian::in_traits< size_t>::type size) const;
   ::efl::eolian::return_traits<void>::type adopt_readonly( ::efl::eolian::in_traits<Eina_Slice const>::type slice) const;
   ::efl::eolian::return_traits<void>::type adopt_readwrite( ::efl::eolian::in_traits<Eina_Rw_Slice>::type slice) const;
   ::efl::eolian::return_traits< ::std::unique_ptr<Eina_Binbuf, ::efl::eina::malloc_deleter>>::type binbuf_steal() const;
   static Efl_Class const* _eo_class()
   {
      return EFL_IO_BUFFER_CLASS;
   }
   Eo* _eo_ptr() const { return *(Eo**)this; }
   static struct position_read_changed_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IO_BUFFER_EVENT_POSITION_READ_CHANGED; }
      typedef void parameter_type;
   } const position_read_changed_event;
   static struct position_write_changed_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IO_BUFFER_EVENT_POSITION_WRITE_CHANGED; }
      typedef void parameter_type;
   } const position_write_changed_event;
   static struct reallocated_event
   {
      static Efl_Event_Description const* description()
      { return EFL_IO_BUFFER_EVENT_REALLOCATED; }
      typedef void parameter_type;
   } const reallocated_event;
   /// @cond LOCAL
    ::efl::eolian::address_of_operator<Buffer,  ::efl::Object,  ::efl::io::Closer,  ::efl::io::Positioner,  ::efl::io::Reader,  ::efl::io::Sizer,  ::efl::io::Writer> operator&() { return {this}; }
    ::efl::eolian::address_of_operator<Buffer const ,  ::efl::Object const ,  ::efl::io::Closer const ,  ::efl::io::Positioner const ,  ::efl::io::Reader const ,  ::efl::io::Sizer const ,  ::efl::io::Writer const > operator&() const { return {this}; }
   /// @endcond
};
static_assert(sizeof(Buffer) == sizeof(Eo*), "");
static_assert(std::is_standard_layout<Buffer>::value, "");
} } 
#endif
