/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_br extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_bn = "bengali";
        final String metaValue_gu = "gujarati";
        final String metaValue_km = "khmer";
        final String metaValue_la = "latin";
        final String metaValue_ml = "malayalam";
        final String metaValue_or = "oriya";
        final String metaValue_te = "telougou";
        final String metaValue_th = "thai";
        final String metaValue_tl = "tagalog";
        final String metaValue_frm = "krennc\u02bchalleg";
        final String metaValue_vai = "vai";
        final Object[][] data = new Object[][] {
            { "ksh", "koluneg" },
            { "Ogam", "ogam" },
            { "mwl", "mirandeg" },
            { "Zsym", "arouezio\u00f9" },
            { "cch", "atsam" },
            { "%%NJIVA", "rannyezh Gniva/Njiva" },
            { "xmf", "megreleg" },
            { "egy", "henegipteg" },
            { "raj", "rajasthani" },
            { "rap", "rapanui" },
            { "ter", "tereno" },
            { "AC", "Enez Ascension" },
            { "rar", "rarotonga" },
            { "tet", "tetum" },
            { "AD", "Andorra" },
            { "AE", "Emirelezhio\u00f9 Arab Unanet" },
            { "nl_BE", "flandrezeg" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua ha Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albania" },
            { "AM", "Armenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Arc\u02bchantina" },
            { "AS", "Samoa Amerikan" },
            { "AT", "Aostria" },
            { "AU", "Aostralia" },
            { "AW", "Aruba" },
            { "en_US", "saozneg Amerika" },
            { "AX", "Inizi \u00c5land" },
            { "AZ", "Azerbaidjan" },
            { "%%AREVELA", "armenianeg ar Reter" },
            { "BA", "Bosnia ha Herzegovina" },
            { "BB", "Barbados" },
            { "ceb", "cebuano" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "gmh", "krennalamaneg uhel" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "kut", "kutenai" },
            { "myv", "erza" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Karib Nederlandat" },
            { "BR", "Brazil" },
            { "BS", "Bahamas" },
            { "BT", "Bhoutan" },
            { "BV", "Enez Bouvet" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Inizi Kokoz" },
            { "CD", "Kongo - Kinshasa" },
            { "CF", "Republik Kreizafrikan" },
            { "CG", "Kongo - Brazzaville" },
            { "CH", "Suis" },
            { "CI", "Aod an Olifant" },
            { "CK", "Inizi Cook" },
            { "CL", "Chile" },
            { "CM", "Kameroun" },
            { "CN", "Sina" },
            { "CO", "Kolombia" },
            { "CP", "Enez Clipperton" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kab-Glas" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Enez Christmas" },
            { "CY", "Kiprenez" },
            { "CZ", "Republik Tchek" },
            { "eka", "ekajuk" },
            { "vls", "flandrezeg ar c\u2019horn\u00f4g" },
            { "%%RIGIK", "volap\u00fck klasel" },
            { "DE", "Alamagn" },
            { "goh", "henalamaneg uhel" },
            { "ace", "achineg" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Danmark" },
            { "ach", "acoli" },
            { "Brai", "Braille" },
            { "DM", "Dominica" },
            { "DO", "Republik Dominikan" },
            { "gor", "gorontalo" },
            { "got", "goteg" },
            { "zun", "zuni" },
            { "tig", "tigreaneg" },
            { "DZ", "Aljeria" },
            { "pag", "pangasinan" },
            { "pal", "pahlavi" },
            { "EA", "Ceuta ha Melilla" },
            { "chb", "chibcha" },
            { "pam", "pampanga" },
            { "EC", "Ecuador" },
            { "pap", "papiamento" },
            { "ada", "adangme" },
            { "EE", "Estonia" },
            { "tiv", "tiv" },
            { "EG", "Egipt" },
            { "EH", "Sahara ar C\u02bchorn\u00f4g" },
            { "pau", "palau" },
            { "chm", "marieg" },
            { "chp", "chipewyan" },
            { "cho", "choktaw" },
            { "chr", "cherokee" },
            { "ER", "Eritrea" },
            { "ES", "Spagn" },
            { "ET", "Etiopia" },
            { "EU", "Unaniezh Europa" },
            { "elx", "elameg" },
            { "chy", "cheyenne" },
            { "ady", "adygeieg" },
            { "aeb", "arabeg Tunizia" },
            { "FI", "Finland" },
            { "FJ", "Fidji" },
            { "FK", "Inizi Falkland" },
            { "FM", "Mikronezia" },
            { "FO", "Inizi Faero" },
            { "Taml", "tamilek" },
            { "FR", "Fra\u00f1s" },
            { "pcd", "pikardeg" },
            { "tkl", "tokelau" },
            { "grb", "grebo" },
            { "%%DAJNKO", "lizherenneg Dajnko" },
            { "rgn", "romagnoleg" },
            { "grc", "henc\u02bchresianeg" },
            { "GA", "Gabon" },
            { "vot", "votyakeg" },
            { "GB", "Rouantelezh-Unanet" },
            { "GD", "Grenada" },
            { "GE", "Jorjia" },
            { "GF", "Gwiana c\u02bchall" },
            { "GG", "Gwernenez" },
            { "GH", "Ghana" },
            { "GI", "Jibraltar" },
            { "afh", "afrihili" },
            { "GL", "Greunland" },
            { "enm", "krennsaozneg" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Gwadeloup" },
            { "GQ", "Ginea ar C\u02bcheheder" },
            { "GR", "Gres" },
            { "GS", "Inizi Georgia ar Su hag Inizi Sandwich ar Su" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "pdc", "alamaneg Pennsylvania" },
            { "GW", "Ginea-Bissau" },
            { "tli", "tinglit" },
            { "tlh", "klingon" },
            { "GY", "Guyana" },
            { "ckb", "kurdeg sorani" },
            { "zxx", "diyezh" },
            { "de_AT", "alamaneg Aostria" },
            { "Vaii", metaValue_vai },
            { "HK", "Hong Kong RMD Sina" },
            { "HM", "Inizi Heard ha McDonald" },
            { "HN", "Honduras" },
            { "HR", "Kroatia" },
            { "agq", "aghem" },
            { "gsw", "alamaneg Suis" },
            { "HT", "Haiti" },
            { "HU", "Hungaria" },
            { "tmh", "tamacheg" },
            { "IC", "Inizi Kanariez" },
            { "nan", "sinaeg Min Nan" },
            { "ID", "Indonezia" },
            { "peo", "henberseg" },
            { "IE", "Iwerzhon" },
            { "nap", "napolitaneg" },
            { "%%NDYUKA", "rannyezh Ndyuka" },
            { "IL", "Israel" },
            { "IM", "Enez Vanav" },
            { "IN", "India" },
            { "IO", "Tiriad breizhveurat Meurvor Indez" },
            { "IQ", "Iraq" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italia" },
            { "Zmth", "notadur jedoniel" },
            { "vro", "voroeg" },
            { "%%POSIX", "POSIX" },
            { "JE", "Jerzenez" },
            { "Beng", metaValue_bn },
            { "JM", "Jamaika" },
            { "JO", "Jordania" },
            { "%%1606NICT", metaValue_frm },
            { "JP", "Japan" },
            { "ain", "ainoueg" },
            { "%%KOCIEWIE", "Kociewie" },
            { "tog", "nyasa tonga" },
            { "de_CH", "alamaneg uhel Suis" },
            { "KE", "Kenya" },
            { "419", "Amerika Latin" },
            { "KG", "Kyrgyzstan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Komorez" },
            { "KN", "Saint Kitts ha Nevis" },
            { "Knda", "kannada" },
            { "fr_CA", "galleg Kanada" },
            { "KP", "Korea an Norzh" },
            { "KR", "Korea ar Su" },
            { "fr_CH", "galleg Suis" },
            { "KW", "Koweit" },
            { "tpi", "tok pisin" },
            { "KY", "Inizi Cayman" },
            { "KZ", "Kazakstan" },
            { "Cyrl", "kirillek" },
            { "LA", "Laos" },
            { "LB", "Liban" },
            { "LC", "Saint Lucia" },
            { "phn", "fenikianeg" },
            { "Cyrs", "kirillek henslavonek" },
            { "%%LUNA1918", "reizhskrivadur rusianek goude 1917" },
            { "nds", "alamaneg izel" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "akk", "akadeg" },
            { "cop", "kopteg" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Lituania" },
            { "LU", "Luksembourg" },
            { "LV", "Latvia" },
            { "Kana", "katakana" },
            { "LY", "Libia" },
            { "lad", "ladino" },
            { "akz", "alabamaeg" },
            { "%%LAUKIKA", "sanskriteg klasel" },
            { "lah", "lahnda" },
            { "Thaa", "thaana" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint Martin" },
            { "lam", "lamba" },
            { "MG", "Madagaskar" },
            { "Thai", metaValue_th },
            { "MH", "Inizi Marshall" },
            { "ale", "aleouteg" },
            { "MK", "Makedonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birmania)" },
            { "MN", "Mongolia" },
            { "new", "newari" },
            { "MO", "Macau RMD Sina" },
            { "aln", "gegeg" },
            { "MP", "Inizi Mariana an Norzh" },
            { "MQ", "Martinik" },
            { "MR", "Maouritania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Moris" },
            { "alt", "altaieg ar Su" },
            { "MV", "Maldivez" },
            { "MW", "Malawi" },
            { "MX", "Mec\u02bchiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mozambik" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Nevez" },
            { "%%WADEGILE", "romanekadur Wade-Giles" },
            { "tru", "turoyoeg" },
            { "%%UCRCOR", "kerneveureg unvan reizhet" },
            { "NE", "Niger" },
            { "NF", "Enez Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Izelvroio\u00f9" },
            { "NO", "Norvegia" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "rof", "rombo" },
            { "tsi", "tsimshian" },
            { "NZ", "Zeland-Nevez" },
            { "rom", "romanieg" },
            { "crh", "turkeg Krimea" },
            { "ang", "hensaozneg" },
            { "OM", "Oman" },
            { "%%PETR1708", "reizhskrivadur rusianek 1708 P\u00ear I" },
            { "anp", "angika" },
            { "Xpeo", "persek kozh" },
            { "PA", "Panam\u00e1" },
            { "csb", "kachoubeg" },
            { "en_GB", "saozneg Breizh-Veur" },
            { "PE", "Perou" },
            { "PF", "Polinezia C\u02bchall" },
            { "PG", "Papoua Ginea-Nevez" },
            { "PH", "Filipinez" },
            { "PK", "Pakistan" },
            { "PL", "Polonia" },
            { "ewo", "ewondo" },
            { "PM", "Sant-P\u00ear-ha-Mikelon" },
            { "PN", "Enez Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Tiriado\u00f9 Palestina" },
            { "Bali", "balinek" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "nia", "nias" },
            { "PY", "Paraguay" },
            { "tum", "tumbuka" },
            { "Hebr", "hebraek" },
            { "QA", "Qatar" },
            { "%%SCOTLAND", "saozneg standart skos" },
            { "jam", "kreoleg Jamaika" },
            { "pms", "piemonteg" },
            { "niu", "niue" },
            { "QO", "Oseania diabell" },
            { "lez", "lezgi" },
            { "%%FONUPA", "lizherenneg fonetek ouralek" },
            { "tvl", "tuvalu" },
            { "001", "Bed" },
            { "002", "Afrika" },
            { "njo", "aoeg" },
            { "003", "Norzhamerika" },
            { "RE", "Ar Re\u00fcnion" },
            { "005", "Suamerika" },
            { "lfn", "lingua franca nova" },
            { "pnt", "ponteg" },
            { "009", "Oseania" },
            { "%%SURSILV", "rannyezh roma\u00f1chek sursilvan" },
            { "RO", "Roumania" },
            { "RS", "Serbia" },
            { "RU", "Rusia" },
            { "RW", "Rwanda" },
            { "%%METELKO", "lizherenneg Metelko" },
            { "Ugar", "ougaritek" },
            { "SA", "Arabia Saoudat" },
            { "pon", "pohnpei" },
            { "SB", "Inizi Salomon" },
            { "011", "Afrika ar C\u02bchorn\u00f4g" },
            { "SC", "Sechelez" },
            { "SD", "Soudan" },
            { "013", "Kreizamerika" },
            { "SE", "Sveden" },
            { "014", "Afrika ar Reter" },
            { "arc", "arameeg" },
            { "015", "Afrika an Norzh" },
            { "SG", "Singapour" },
            { "SH", "Saint-Helena" },
            { "017", "Afrika ar C\u02bchreiz" },
            { "SI", "Slovenia" },
            { "018", "Afrika ar Su" },
            { "SJ", "Svalbard" },
            { "019", "Amerikao\u00f9" },
            { "SK", "Slovakia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "arn", "araoukaneg" },
            { "arp", "arapaho" },
            { "SR", "Surinam" },
            { "aro", "araona" },
            { "SS", "Susoudan" },
            { "ST", "S\u00e3o Tom\u00e9 ha Pr\u00edncipe" },
            { "arq", "arabeg Aljeria" },
            { "SV", "Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Siria" },
            { "yao", "yao" },
            { "SZ", "Swaziland" },
            { "arw", "arawakeg" },
            { "arz", "arabeg Egipt" },
            { "ary", "arabeg Maroko" },
            { "yap", "yapeg" },
            { "TA", "Tristan da Cunha" },
            { "asa", "asu" },
            { "021", "Amerika an Norzh" },
            { "TC", "Inizi Turks ha Caicos" },
            { "TD", "Tchad" },
            { "TF", "Douaro\u00f9 aostral Fra\u00f1s" },
            { "ase", "yezh sino\u00f9 Amerika" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadjikistan" },
            { "029", "Karib" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "%%BOONT", "boontling" },
            { "TN", "Tunizia" },
            { "TO", "Tonga" },
            { "%%NULIK", "volap\u00fck modern" },
            { "TR", "Turkia" },
            { "TT", "Trinidad ha Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "ast", "asturianeg" },
            { "TZ", "Tanzania" },
            { "Zzzz", "skritur dianav" },
            { "UA", "Ukraina" },
            { "lij", "ligurieg" },
            { "rup", "aroumaneg" },
            { "030", "Azia ar Reter" },
            { "tyv", "touva" },
            { "sw_CD", "swahili Kongo" },
            { "034", "Azia ar Su" },
            { "hai", "haida" },
            { "035", "Azia ar Gevred" },
            { "UG", "Ouganda" },
            { "hak", "sinaeg Hakka" },
            { "039", "Europa ar Su" },
            { "Sinh", "singhalek" },
            { "UM", "Inizi diabell ar Stado\u00f9-Unanet" },
            { "US", "Stado\u00f9-Unanet" },
            { "haw", "hawaieg" },
            { "%%1959ACAD", "belaruseg akademek" },
            { "UY", "Uruguay" },
            { "prg", "henbruseg" },
            { "UZ", "Ouzbekistan" },
            { "tzm", "tamazigteg Kreizatlas" },
            { "VA", "Vatikan" },
            { "pro", "henbrova\u00f1seg" },
            { "VC", "Sant Visant hag ar Grenadinez" },
            { "VE", "Venezuela" },
            { "VG", "Inizi Gwerc\u02bch Breizh-Veur" },
            { "VI", "Inizi Gwerc\u02bch ar Stado\u00f9-Unanet" },
            { "VN", "Vi\u00eat Nam" },
            { "VU", "Vanuatu" },
            { "nog", "nogay" },
            { "rwk", "rwa" },
            { "non", "hennorseg" },
            { "053", "Aostralazia" },
            { "%%AREVMDA", "armenianeg ar C\u02bchorn\u00f4g" },
            { "054", "Melanezia" },
            { "WF", "Wallis ha Futuna" },
            { "057", "Rannved Mikronezia" },
            { "nov", "novial" },
            { "%%HEPBURN", "romanekadur Hepburn" },
            { "wae", "walser" },
            { "WS", "Samoa" },
            { "wal", "walamo" },
            { "was", "washo" },
            { "war", "waray" },
            { "awa", "awadhi" },
            { "061", "Polinezia" },
            { "%%KSCOR", "kerneveureg standart" },
            { "XK", "Kosovo" },
            { "Gujr", metaValue_gu },
            { "Zxxx", "anskrivet" },
            { "YE", "Yemen" },
            { "fan", "fang" },
            { "%%ROZAJ", "resianeg" },
            { "%%SUTSILV", "rannyezh roma\u00f1chek sutsilvan" },
            { "fat", "fanti" },
            { "YT", "Mayotte" },
            { "ZA", "Suafrika" },
            { "Deva", "devanagari" },
            { "Hira", "hiragana" },
            { "ZM", "Zambia" },
            { "%%PINYIN", "romanekadur pinyin" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "Rannved dianav" },
            { "Runr", "runek" },
            { "lol", "mongo" },
            { "nso", "sotho an Norzh" },
            { "loz", "lozi" },
            { "hil", "hiligaynon" },
            { "dak", "dakota" },
            { "dar", "dargwa" },
            { "Maya", "hieroglifo\u00f9 mayaek" },
            { "Copt", "koptek" },
            { "nwc", "newari klasel" },
            { "udm", "oudmourteg" },
            { "Khmr", metaValue_km },
            { "sad", "sandawe" },
            { "sah", "yakouteg" },
            { "sam", "arameeg ar Samaritaned" },
            { "%%SCOUSE", "scouse" },
            { "sas", "sasak" },
            { "sat", "santali" },
            { "jpr", "yuzev-perseg" },
            { "Guru", "gurmukhi" },
            { "%%ALUKU", "rannyezh aloukou" },
            { "lua", "luba-lulua" },
            { "%%BISCAYAN", "rannyezh euskarek Bizkaia" },
            { "lui", "luiseno" },
            { "nyn", "nyankole" },
            { "nym", "nyamwezi" },
            { "lun", "lunda" },
            { "nyo", "nyoro" },
            { "luo", "luo" },
            { "fil", "filipineg" },
            { "hmn", "hmong" },
            { "del", "delaware" },
            { "lus", "lushai" },
            { "bal", "baloutchi" },
            { "ban", "balineg" },
            { "uga", "ougariteg" },
            { "fit", "finneg trao\u00f1ienn an Torne" },
            { "luy", "luyia" },
            { "bar", "bavarieg" },
            { "bas", "basaa" },
            { "jrb", "yuzev-arabeg" },
            { "es_ES", "spagnoleg Europa" },
            { "sco", "skoteg" },
            { "scn", "sikilieg" },
            { "aa", "afar" },
            { "ab", "abkhazeg" },
            { "ae", "avesteg" },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhareg" },
            { "an", "aragoneg" },
            { "Arab", "arabek" },
            { "%%SOLBA", "rannyezh Stolvizza/Solbica" },
            { "Jpan", "japanek" },
            { "ar", "arabeg" },
            { "as", "asameg" },
            { "sdc", "sasareseg" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "azerbaidjaneg" },
            { "%%OSOJS", "rannyezh Oseacco/Osojane" },
            { "%%UNIFON", "lizherenneg fonetek Unifon" },
            { "ba", "bachkir" },
            { "be", "belaruseg" },
            { "bg", "bulgareg" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", "tibetaneg" },
            { "dgr", "dogrib" },
            { "br", "brezhoneg" },
            { "bs", "bosneg" },
            { "Mymr", "myanmar" },
            { "ca", "katalaneg" },
            { "ce", "tchetcheneg" },
            { "ch", "chamorru" },
            { "%%REVISED", "reizhskrivadur reizhet" },
            { "co", "korseg" },
            { "Orya", metaValue_or },
            { "cr", "kri" },
            { "cs", "tchekeg" },
            { "cu", "slavoneg iliz" },
            { "cv", "tchouvatch" },
            { "cy", "kembraeg" },
            { "da", "daneg" },
            { "pt_PT", "portugaleg Europa" },
            { "de", "alamaneg" },
            { "bej", "bedawieg" },
            { "din", "dinka" },
            { "Bugi", "bougiek" },
            { "bem", "bemba" },
            { "sga", "heniwerzhoneg" },
            { "dv", "divehi" },
            { "es_419", "spagnoleg Amerika latin" },
            { "dz", "dzongkha" },
            { "bez", "bena" },
            { "lzh", "sinaeg lennegel" },
            { "ee", "ewe" },
            { "ro_MD", "moldoveg" },
            { "el", "gresianeg" },
            { "en", "saozneg" },
            { "eo", "esperanteg" },
            { "es", "spagnoleg" },
            { "et", "estoneg" },
            { "eu", "euskareg" },
            { "Hang", "hangeul" },
            { "shi", "tacheliteg" },
            { "hsb", "uhelsorabeg" },
            { "Hani", "han" },
            { "%%ULSTER", "rannyezh skotek Ulad" },
            { "shn", "shan" },
            { "fa", "perseg" },
            { "Hans", "eeunaet" },
            { "Hant", "hengounel" },
            { "shu", "arabeg Tchad" },
            { "hsn", "sinaeg Xian" },
            { "fi", "finneg" },
            { "fj", "fidjieg" },
            { "fon", "fon" },
            { "bgn", "baloutchi ar C\u02bchorn\u00f4g" },
            { "yue", "kantoneg" },
            { "fo", "faeroeg" },
            { "umb", "umbundu" },
            { "fr", "galleg" },
            { "sid", "sidamo" },
            { "fy", "frizeg ar C\u02bchorn\u00f4g" },
            { "ga", "iwerzhoneg" },
            { "gd", "skoseg" },
            { "gl", "galizeg" },
            { "gn", "guarani" },
            { "bho", "bhojpuri" },
            { "und", "yezh dianav" },
            { "gu", metaValue_gu },
            { "gv", "manaveg" },
            { "ha", "haousa" },
            { "he", "hebraeg" },
            { "hi", "hindi" },
            { "hup", "hupa" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "ho", "hiri motu" },
            { "hr", "kroateg" },
            { "ht", "haitieg" },
            { "hu", "hungareg" },
            { "hy", "armenianeg" },
            { "hz", "herero" },
            { "frc", "galleg cajun" },
            { "%%FONIPA", "lizherenneg fonetek etrebroadel" },
            { "ia", "interlingua" },
            { "id", "indonezeg" },
            { "ie", "interlingue" },
            { "ig", "igbo" },
            { "frm", metaValue_frm },
            { "ii", "yieg Sichuan" },
            { "%%RUMGR", "roma\u00f1cheg Grischun" },
            { "ik", "inupiaq" },
            { "fro", "henc\u02bchalleg" },
            { "frp", "arpitaneg" },
            { "io", "ido" },
            { "frs", "frizeg ar Reter" },
            { "frr", "frizeg an Norzh" },
            { "is", "islandeg" },
            { "it", "italianeg" },
            { "iu", "inuktitut" },
            { "%%HOGNORSK", "uhelnorvegeg" },
            { "Mlym", metaValue_ml },
            { "ja", "japaneg" },
            { "doi", "dogri" },
            { "sma", "s\u00e1mi ar Su" },
            { "jv", "javaneg" },
            { "%%BAUDDHA", "sanskriteg hiron boudaat" },
            { "smj", "s\u00e1mi Lule\u00e5" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "smn", "s\u00e1mi Inari" },
            { "ka", "jorjianeg" },
            { "wuu", "sinaeg Wu" },
            { "sms", "s\u00e1mi Skolt" },
            { "kg", "kongo" },
            { "Goth", "gotek" },
            { "ki", "kikuyu" },
            { "mas", "masai" },
            { "kj", "kwanyama" },
            { "kk", "kazak" },
            { "km", metaValue_km },
            { "kn", "kanareg" },
            { "ko", "koreaneg" },
            { "kr", "kanouri" },
            { "ks", "kashmiri" },
            { "Avst", "avestek" },
            { "ku", "kurdeg" },
            { "kw", "kerneveureg" },
            { "ky", "kirgiz" },
            { "snk", "soninke" },
            { "la", metaValue_la },
            { "lb", "luksembourgeg" },
            { "lg", "ganda" },
            { "li", "limbourgeg" },
            { "Tibt", "tibetanek" },
            { "ln", "lingala" },
            { "fur", "frioulaneg" },
            { "lo", "laoseg" },
            { "lt", "lituaneg" },
            { "lu", "luba-katanga" },
            { "lv", "latvieg" },
            { "sog", "sogdieg" },
            { "mg", "malgacheg" },
            { "mh", "marshall" },
            { "mi", "maori" },
            { "mk", "makedoneg" },
            { "ml", metaValue_ml },
            { "mn", "mongoleg" },
            { "mr", "marathi" },
            { "ms", "malayseg" },
            { "mt", "malteg" },
            { "my", "birmaneg" },
            { "Armn", "armenianek" },
            { "mdf", "moksha" },
            { "dsb", "izelsorabeg" },
            { "Armi", "arameek impalaerel" },
            { "na", "naurueg" },
            { "nb", "norvegeg bokm\u00e5l" },
            { "nd", "ndebele an Norzh" },
            { "ne", "nepaleg" },
            { "ng", "ndonga" },
            { "mdr", "mandar" },
            { "nl", "nederlandeg" },
            { "nn", "norvegeg nynorsk" },
            { "no", "norvegeg" },
            { "nr", "ndebele ar Su" },
            { "nv", "navac\u02bcho" },
            { "kaa", "karakalpak" },
            { "ny", "nyanja" },
            { "kac", "kachin" },
            { "kab", "kabileg" },
            { "%%POLYTON", "gresianeg liestonel" },
            { "oc", "okitaneg" },
            { "kam", "kamba" },
            { "men", "mende" },
            { "%%EMODENG", "saozneg rakvodern" },
            { "oj", "ojibwa" },
            { "or", metaValue_or },
            { "os", "oseteg" },
            { "%%ALALC97", "romanekadur ALA-LC 1997" },
            { "kbd", "kabardeg" },
            { "mfe", "moriseg" },
            { "pa", "punjabi" },
            { "srr", "serer" },
            { "%%LIPAW", "rannyezh resianek Lipovaz" },
            { "pi", "pali" },
            { "pl", "poloneg" },
            { "dum", "nederlandeg krenn" },
            { "%%VALLADER", "rannyezh roma\u00f1chek Vallader" },
            { "ps", "pachto" },
            { "pt", "portugaleg" },
            { "mga", "krenniwerzhoneg" },
            { "pt_BR", "portugaleg Brazil" },
            { "%%BOHORIC", "lizherenneg Bohori\u010d" },
            { "bra", "braj" },
            { "%%JAUER", "rannyezh roma\u00f1chek Jauer" },
            { "Laoo", "laosek" },
            { "%%SURMIRAN", "rannyezh roma\u00f1chek surmiran" },
            { "brh", "brahweg" },
            { "qu", "kechuaeg" },
            { "zap", "zapoteg" },
            { "brx", "bodo" },
            { "%%VAIDIKA", "sanskriteg vedek" },
            { "Ethi", "etiopek" },
            { "%%JYUTPING", "romanekadur kantonek Jyutping" },
            { "rm", "roma\u00f1cheg" },
            { "rn", "rundi" },
            { "ro", "roumaneg" },
            { "%%SAAHO", "saho" },
            { "ru", "rusianeg" },
            { "bss", "akoose" },
            { "rw", "kinyarwanda" },
            { "zbl", "Bliss" },
            { "kea", "kabuverdianu" },
            { "en_AU", "saozneg Aostralia" },
            { "sa", "sanskriteg" },
            { "%%UCCOR", "kerneveureg unvan" },
            { "sc", "sardeg" },
            { "sd", "sindhi" },
            { "se", "s\u00e1mi an Norzh" },
            { "sg", "sango" },
            { "sh", "serb-kroateg" },
            { "si", "singhaleg" },
            { "sux", "sumereg" },
            { "sk", "slovakeg" },
            { "sl", "sloveneg" },
            { "sm", "samoan" },
            { "sn", "shona" },
            { "so", "somali" },
            { "sq", "albaneg" },
            { "sr", "serbeg" },
            { "ss", "swati" },
            { "st", "sotho ar Su" },
            { "Java", "javanek" },
            { "su", "sundaneg" },
            { "%%NEDIS", "rannyezh Natisone" },
            { "sv", "svedeg" },
            { "sw", "swahili" },
            { "ibb", "ibibio" },
            { "iba", "iban" },
            { "ta", "tamileg" },
            { "142", "Azia" },
            { "bua", "bouriat" },
            { "143", "Azia ar C\u02bchreiz" },
            { "te", metaValue_te },
            { "145", "Azia ar C\u02bchorn\u00f4g" },
            { "tg", "tadjik" },
            { "th", metaValue_th },
            { "ti", "tigrigna" },
            { "bug", "bugi" },
            { "en_CA", "saozneg Kanada" },
            { "tk", "turkmeneg" },
            { "tl", metaValue_tl },
            { "tn", "tswana" },
            { "to", "tonga" },
            { "tr", "turkeg" },
            { "ts", "tsonga" },
            { "swb", "komoreg" },
            { "tt", "tatar" },
            { "dyu", "dyula" },
            { "tw", "twi" },
            { "ty", "tahitianeg" },
            { "%%BISKE", "rannyezh San Giorgio/Bila" },
            { "150", "Europa" },
            { "151", "Europa ar Reter" },
            { "154", "Europa an Norzh" },
            { "155", "Europa ar C\u02bchorn\u00f4g" },
            { "ug", "ouigoureg" },
            { "Ital", "henitalek" },
            { "Kore", "koreanek" },
            { "Zyyy", "boutin" },
            { "uk", "ukraineg" },
            { "zea", "zelandeg" },
            { "ur", "ourdou" },
            { "%%1994", "reizhskrivadur resianek skoueriekaet" },
            { "xal", "kalmouk" },
            { "zen", "zenaga" },
            { "uz", "ouzbekeg" },
            { "kha", "khasi" },
            { "%%1996", "reizhskrivadur alamanek 1996" },
            { "nds_NL", "saksoneg izel" },
            { "ve", "venda" },
            { "vi", "vietnameg" },
            { "kho", "khotaneg" },
            { "%%TARASK", "belaruseg Taraskievica" },
            { "vo", "volap\u00fck" },
            { "syc", "sirieg klasel" },
            { "qug", "kichuaeg Chimborazo" },
            { "gaa", "ga" },
            { "wa", "walloneg" },
            { "gag", "gagaouzeg" },
            { "syr", "sirieg" },
            { "Grek", "gresianek" },
            { "gan", "sinaeg Gan" },
            { "wo", "wolof" },
            { "zgh", "tamacheg Maroko standart" },
            { "ar_001", "arabeg modern" },
            { "%%FONXSAMP", "treuzskrivadur X-SAMPA" },
            { "gay", "gayo" },
            { "Mong", "mongolek" },
            { "mnc", "manchou" },
            { "szl", "silezieg" },
            { "Hluw", "hieroglifo\u00f9 Anatolia" },
            { "gba", "gbaya" },
            { "mni", "manipuri" },
            { "Latn", metaValue_la },
            { "Latg", "latin gouezelek" },
            { "xh", "xhosa" },
            { "byn", "blin" },
            { "%%PAMAKA", "rannyezh Pamaka" },
            { "osa", "osage" },
            { "moh", "mohawk" },
            { "%%1694ACAD", "galleg rakvodern" },
            { "yi", "yiddish" },
            { "Syrc", "siriek" },
            { "yo", "yorouba" },
            { "es_MX", "spagnoleg Mec\u02bchiko" },
            { "Syrj", "siriek ar C\u2019horn\u00f4g" },
            { "ota", "turkeg otoman" },
            { "Syre", "siriek Estrangel\u0101" },
            { "vai", metaValue_vai },
            { "za", "zhuang" },
            { "zh", "sinaeg" },
            { "Bopo", "bopomofo" },
            { "zu", "zouloueg" },
            { "%%MONOTON", "gresianeg untonel" },
            { "Geor", "jorjianek" },
            { "kmb", "kimbundu" },
            { "gez", "gezeg" },
            { "mrj", "marieg ar C\u02bchorn\u00f4g" },
            { "Syrn", "siriek ar Reter" },
            { "Tglg", metaValue_tl },
            { "%%ITIHASA", "sanskriteg itih\u00e2sa" },
            { "ebu", "embu" },
            { "Egyp", "hieroglifo\u00f9 egiptek" },
            { "zh_Hans", "sinaeg eeunaet" },
            { "kok", "konkani" },
            { "%%1901", "reizhskrivadur alamanek hengounel" },
            { "kos", "kosrae" },
            { "vec", "venezieg" },
            { "zh_Hant", "sinaeg hengounel" },
            { "Sund", "sundanek" },
            { "vep", "vepseg" },
            { "kpe", "kpelle" },
            { "%%VALENCIA", "valensianeg" },
            { "%%BAKU1926", "lizherenneg latin turkek unvan" },
            { "mul", "yezho\u00f9 lies" },
            { "%%PUTER", "rannyezh roma\u00f1chek Puter" },
            { "cad", "caddo" },
            { "mus", "muskogi" },
            { "Glag", "glagolitek" },
            { "gil", "gilberteg" },
            { "%%KKCOR", "kerneveureg kumun" },
            { "car", "karibeg" },
            { "krc", "karatchay-balkar" },
            { "inh", "ingoucheg" },
            { "krl", "karelieg" },
            { "efi", "efik" },
            { "tcy", "touloueg" },
            { "kru", "kurukh" },
            { "Telu", metaValue_te },
        };
        return data;
    }
}
