/*
 * Copyright (c) 2012, 2017, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ta extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CAT",
               "Central African Summer Time",
               "CAST",
               "Central Africa Time",
               "CAT",
            };
        final String[] Moscow = new String[] {
               "\u0bae\u0bbe\u0bb8\u0bcd\u0b95\u0bcb \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MSK",
               "\u0bae\u0bbe\u0bb8\u0bcd\u0b95\u0bcb \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MSD",
               "\u0bae\u0bbe\u0bb8\u0bcd\u0b95\u0bcb \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MT",
            };
        final String[] Japan = new String[] {
               "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "JST",
               "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "JDT",
               "\u0b9c\u0baa\u0bcd\u0baa\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "JT",
            };
        final String[] Pakistan = new String[] {
               "\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PKT",
               "\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PKST",
               "\u0baa\u0bbe\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PKT",
            };
        final String[] Taipei = new String[] {
               "\u0ba4\u0bc8\u0baa\u0bc7 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CST",
               "\u0ba4\u0bc8\u0baa\u0bc7 \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CDT",
               "\u0ba4\u0bc8\u0baa\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CT",
            };
        final String[] Hovd = new String[] {
               "\u0bb9\u0bcb\u0bb5\u0bcd\u0ba4\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HOVT",
               "\u0bb9\u0bcb\u0bb5\u0bcd\u0ba4\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HOVST",
               "\u0bb9\u0bcb\u0bb5\u0bcd\u0ba4\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HOVT",
            };
        final String[] Magadan = new String[] {
               "\u0bae\u0b95\u0ba4\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MAGT",
               "\u0bae\u0b95\u0ba4\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MAGST",
               "\u0bae\u0b95\u0ba4\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MAGT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACWST",
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACWDT",
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACWT",
            };
        final String[] Europe_Central = new String[] {
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CET",
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CEST",
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CET",
            };
        final String[] Sakhalin = new String[] {
               "\u0b9a\u0b95\u0bb2\u0bbf\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAKT",
               "\u0b9a\u0b95\u0bb2\u0bbf\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAKST",
               "\u0b9a\u0b95\u0bb2\u0bbf\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAKT",
            };
        final String[] Paraguay = new String[] {
               "\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bc7 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PYT",
               "\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bc7 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PYST",
               "\u0baa\u0bb0\u0bbe\u0b95\u0bc1\u0bb5\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PYT",
            };
        final String[] Acre = new String[] {
               "\u0b85\u0b95\u0bcd\u0bb0\u0bc7 \u0ba4\u0bb0 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACT",
               "\u0b85\u0b95\u0bcd\u0bb0\u0bc7 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACST",
               "\u0b85\u0b95\u0bcd\u0bb0\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACT",
            };
        final String[] Malaysia = new String[] {
               "\u0bae\u0bb2\u0bc7\u0bb7\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MYT",
               "Malaysia Summer Time",
               "MYST",
               "Malaysia Time",
               "MYT",
            };
        final String[] America_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EST",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EDT",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ET",
            };
        final String[] Lord_Howe = new String[] {
               "\u0bb2\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd \u0bb9\u0bcb\u0bb5\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "LHST",
               "\u0bb2\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd \u0bb9\u0bcb\u0bb5\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "LHDT",
               "\u0bb2\u0bbe\u0bb0\u0bcd\u0b9f\u0bcd \u0bb9\u0bcb\u0bb5\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "LHT",
            };
        final String[] New_Zealand = new String[] {
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NZST",
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NZDT",
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b9a\u0bbf\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NZT",
            };
        final String[] Indian_Ocean = new String[] {
               "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf\u0baa\u0bcd \u0baa\u0bc6\u0bb0\u0bc1\u0b99\u0bcd\u0b95\u0b9f\u0bb2\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IOT",
               "Indian Ocean Territory Summer Time",
               "IOST",
               "Indian Ocean Territory Time",
               "IOT",
            };
        final String[] Yakutsk = new String[] {
               "\u0baf\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YAKT",
               "\u0baf\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YAKST",
               "\u0baf\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YAKT",
            };
        final String[] Mauritius = new String[] {
               "\u0bae\u0bca\u0bb0\u0bbf\u0bb7\u0bbf\u0baf\u0bb8\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MUT",
               "\u0bae\u0bca\u0bb0\u0bbf\u0bb7\u0bbf\u0baf\u0bb8\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MUST",
               "\u0bae\u0bca\u0bb0\u0bbf\u0bb7\u0bbf\u0baf\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MUT",
            };
        final String[] Africa_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EAT",
               "Eastern African Summer Time",
               "EAST",
               "Eastern Africa Time",
               "EAT",
            };
        final String[] East_Timor = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0ba4\u0bbf\u0bae\u0bcb\u0bb0\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TLT",
               "Timor-Leste Summer Time",
               "TLST",
               "Timor-Leste Time",
               "TLT",
            };
        final String[] Solomon = new String[] {
               "\u0b9a\u0bbe\u0bb2\u0bae\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SBT",
               "Solomon Is. Summer Time",
               "SBST",
               "Solomon Is. Time",
               "SBT",
            };
        final String[] Kosrae = new String[] {
               "\u0b95\u0bcb\u0bb8\u0bcd\u0bb0\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KOST",
               "Kosrae Summer Time",
               "KOSST",
               "Kosrae Time",
               "KOST",
            };
        final String[] Marshall_Islands = new String[] {
               "\u0bae\u0bbe\u0bb0\u0bcd\u0bb7\u0bb2\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MHT",
               "Marshall Islands Summer Time",
               "MHST",
               "Marshall Islands Time",
               "MHT",
            };
        final String[] Europe_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EET",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EEST",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EET",
            };
        final String[] Newfoundland = new String[] {
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b83\u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NST",
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b83\u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NDT",
               "\u0ba8\u0bbf\u0baf\u0bc2\u0b83\u0baa\u0bb5\u0bc1\u0ba3\u0bcd\u0b9f\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NT",
            };
        final String[] Afghanistan = new String[] {
               "\u0b86\u0b83\u0baa\u0bcd\u0b95\u0bbe\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AFT",
               "Afghanistan Summer Time",
               "AFST",
               "Afghanistan Time",
               "AFT",
            };
        final String[] Hong_Kong = new String[] {
               "\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HKT",
               "\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HKST",
               "\u0bb9\u0bbe\u0b99\u0bcd\u0b95\u0bbe\u0b99\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HKT",
            };
        final String[] Argentina_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ART",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ARST",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ART",
            };
        final String[] Atlantic = new String[] {
               "\u0b85\u0b9f\u0bcd\u0bb2\u0bbe\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AST",
               "\u0b85\u0b9f\u0bcd\u0bb2\u0bbe\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ADT",
               "\u0b85\u0b9f\u0bcd\u0bb2\u0bbe\u0ba3\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AT",
            };
        final String[] Ponape = new String[] {
               "\u0baa\u0bcb\u0ba9\u0bbe\u0baa\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PONT",
               "Pohnpei Summer Time",
               "PONST",
               "Ponape Time",
               "PONT",
            };
        final String[] Bolivia = new String[] {
               "\u0baa\u0bca\u0bb2\u0bbf\u0bb5\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BOT",
               "Bolivia Summer Time",
               "BOST",
               "Bolivia Time",
               "BOT",
            };
        final String[] Pierre_Miquelon = new String[] {
               "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbf\u0baf\u0bb0\u0bbf & \u0bae\u0bbf\u0b95\u0bcd\u0b95\u0bc1\u0baf\u0bbf\u0bb2\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PMST",
               "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbf\u0baf\u0bb0\u0bbf & \u0bae\u0bbf\u0b95\u0bcd\u0b95\u0bc1\u0baf\u0bbf\u0bb2\u0bbe\u0ba9\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PMDT",
               "\u0b9a\u0bc6\u0baf\u0bbf\u0ba9\u0bcd\u0b9f\u0bcd \u0baa\u0bbf\u0baf\u0bb0\u0bbf & \u0bae\u0bbf\u0b95\u0bcd\u0b95\u0bc1\u0baf\u0bbf\u0bb2\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PMT",
            };
        final String[] Indochina = new String[] {
               "\u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0b9a\u0bc0\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ICT",
               "Indochina Summer Time",
               "ICST",
               "Indochina Time",
               "ICT",
            };
        final String[] Yekaterinburg = new String[] {
               "\u0baf\u0bc7\u0b95\u0bbe\u0b9f\u0bc6\u0bb0\u0bbf\u0ba9\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YEKT",
               "\u0baf\u0bc7\u0b95\u0bbe\u0b9f\u0bc6\u0bb0\u0bbf\u0ba9\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YEKST",
               "\u0baf\u0bc7\u0b95\u0bbe\u0b9f\u0bc6\u0bb0\u0bbf\u0ba9\u0bcd\u0baa\u0bb0\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "YEKT",
            };
        final String[] Maldives = new String[] {
               "\u0bae\u0bbe\u0bb2\u0ba4\u0bcd\u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MVT",
               "Maldives Summer Time",
               "MVST",
               "Maldives Time",
               "MVT",
            };
        final String[] Tahiti = new String[] {
               "\u0ba4\u0bb9\u0bbf\u0ba4\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TAHT",
               "Tahiti Summer Time",
               "TAHST",
               "Tahiti Time",
               "TAHT",
            };
        final String[] Israel = new String[] {
               "\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IST",
               "\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IDT",
               "\u0b87\u0bb8\u0bcd\u0bb0\u0bc7\u0bb2\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IT",
            };
        final String[] Indonesia_Central = new String[] {
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0b9a\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WITA",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "WITA",
            };
        final String[] Wallis = new String[] {
               "\u0bb5\u0bbe\u0bb2\u0bbf\u0bb8\u0bcd \u0bae\u0bb1\u0bcd\u0bb1\u0bc1\u0bae\u0bcd \u0b83\u0baa\u0bcd\u0baf\u0bc2\u0b9f\u0bc1\u0ba9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WFT",
               "Wallis & Futuna Summer Time",
               "WFST",
               "Wallis & Futuna Time",
               "WFT",
            };
        final String[] Africa_Southern = new String[] {
               "\u0ba4\u0bc6\u0ba9\u0bcd \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAST",
               "South Africa Summer Time",
               "SAST",
               "South Africa Time",
               "SAT",
            };
        final String[] Syowa = new String[] {
               "\u0bb8\u0bcd\u0baf\u0bcb\u0bb5\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SYOT",
               "Syowa Summer Time",
               "SYOST",
               "Syowa Time",
               "SYOT",
            };
        final String[] Line_Islands = new String[] {
               "\u0bb2\u0bc8\u0ba9\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "LINT",
               "Line Is. Summer Time",
               "LINST",
               "Line Is. Time",
               "LINT",
            };
        final String[] Uzbekistan = new String[] {
               "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UZT",
               "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UZST",
               "\u0b89\u0bb8\u0bcd\u0baa\u0bc6\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UZT",
            };
        final String[] Omsk = new String[] {
               "\u0b93\u0bae\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "OMST",
               "\u0b93\u0bae\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "OMSST",
               "\u0b93\u0bae\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "OMST",
            };
        final String[] Seychelles = new String[] {
               "\u0b9a\u0bc0\u0b9a\u0bc6\u0bb2\u0bcd\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SCT",
               "Seychelles Summer Time",
               "SCST",
               "Seychelles Time",
               "SCT",
            };
        final String[] Uruguay = new String[] {
               "\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UYT",
               "\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UYST",
               "\u0b89\u0bb0\u0bc1\u0b95\u0bc1\u0bb5\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "UYT",
            };
        final String[] Nepal = new String[] {
               "\u0ba8\u0bc7\u0baa\u0bbe\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NPT",
               "Nepal Summer Time",
               "NPST",
               "Nepal Time",
               "NPT",
            };
        final String[] Mongolia = new String[] {
               "\u0b89\u0bb2\u0ba9\u0bcd \u0baa\u0bbe\u0b9f\u0bb0\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ULAT",
               "\u0b89\u0bb2\u0ba9\u0bcd \u0baa\u0bbe\u0b9f\u0bb0\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ULAST",
               "\u0b89\u0bb2\u0ba9\u0bcd \u0baa\u0bbe\u0b9f\u0bb0\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ULAT",
            };
        final String[] America_Central = new String[] {
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CST",
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CDT",
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CT",
            };
        final String[] Truk = new String[] {
               "\u0b9a\u0bc1\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHUT",
               "Chuuk Summer Time",
               "CHUST",
               "Chuuk Time",
               "CHUT",
            };
        final String[] Niue = new String[] {
               "\u0ba8\u0bbf\u0baf\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NUT",
               "Niue Summer Time",
               "NUST",
               "Niue Time",
               "NUT",
            };
        final String[] Wake = new String[] {
               "\u0bb5\u0bc7\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WAKT",
               "Wake Summer Time",
               "WAKST",
               "Wake Time",
               "WAKT",
            };
        final String[] Falkland = new String[] {
               "\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FKT",
               "\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FKST",
               "\u0b83\u0baa\u0bbe\u0b95\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FKT",
            };
        final String[] Vanuatu = new String[] {
               "\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VUT",
               "\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VUST",
               "\u0bb5\u0ba9\u0bc1\u0bb5\u0bbe\u0b9f\u0bcd\u0b9f\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VUT",
            };
        final String[] Novosibirsk = new String[] {
               "\u0ba8\u0bcb\u0bb5\u0bcb\u0b9a\u0bbf\u0baa\u0bbf\u0bb0\u0bbf\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NOVT",
               "\u0ba8\u0bcb\u0bb5\u0bcb\u0b9a\u0bbf\u0baa\u0bbf\u0bb0\u0bbf\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NOVST",
               "\u0ba8\u0bcb\u0bb5\u0bcb\u0b9a\u0bbf\u0baa\u0bbf\u0bb0\u0bbf\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NOVT",
            };
        final String[] Singapore = new String[] {
               "\u0b9a\u0bbf\u0b99\u0bcd\u0b95\u0baa\u0bcd\u0baa\u0bc2\u0bb0\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SRET",
               "Srednekolymsk Daylight Time",
               "SREDT",
               "Srednekolymsk Time",
               "SRET",
            };
        final String[] Azores = new String[] {
               "\u0b85\u0b9a\u0bcb\u0bb0\u0bb8\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZOT",
               "\u0b85\u0b9a\u0bcb\u0bb0\u0bcd\u0bb8\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZOST",
               "\u0b85\u0b9a\u0bcb\u0bb0\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZOT",
            };
        final String[] Apia = new String[] {
               "\u0b8f\u0baa\u0bbf\u0baf\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WSST",
               "\u0b8f\u0baa\u0bbf\u0baf\u0bbe \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WSDT",
               "\u0b8f\u0baa\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WST",
            };
        final String[] Bhutan = new String[] {
               "\u0baa\u0bc2\u0b9f\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BTT",
               "Bhutan Summer Time",
               "BTST",
               "Bhutan Time",
               "BTT",
            };
        final String[] Suriname = new String[] {
               "\u0b9a\u0bc1\u0bb0\u0bbf\u0ba9\u0bbe\u0bae\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SRT",
               "Suriname Summer Time",
               "SRST",
               "Suriname Time",
               "SRT",
            };
        final String[] Nauru = new String[] {
               "\u0ba8\u0bb5\u0bcd\u0bb0\u0bc2 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NRT",
               "Nauru Summer Time",
               "NRST",
               "Nauru Time",
               "NRT",
            };
        final String[] Krasnoyarsk = new String[] {
               "\u0b95\u0bcd\u0bb0\u0bb8\u0bcd\u0ba9\u0bcb\u0baf\u0bbe\u0bb0\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KRAT",
               "\u0b95\u0bcd\u0bb0\u0bb8\u0bcd\u0ba9\u0bcb\u0baf\u0bbe\u0bb0\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KRAST",
               "\u0b95\u0bcd\u0bb0\u0bb8\u0bcd\u0ba9\u0bcb\u0baf\u0bbe\u0bb0\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KRAT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b95\u0b9c\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AQTT",
               "Aqtau Summer Time",
               "AQTST",
               "Aqtau Time",
               "AQTT",
            };
        final String[] Myanmar = new String[] {
               "\u0bae\u0bbf\u0baf\u0bbe\u0ba9\u0bcd\u0bae\u0bb0\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MMT",
               "Myanmar Summer Time",
               "MMST",
               "Myanmar Time",
               "MMT",
            };
        final String[] Christmas = new String[] {
               "\u0b95\u0bbf\u0bb1\u0bbf\u0bb8\u0bcd\u0ba4\u0bc1\u0bae\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CXT",
               "Christmas Island Summer Time",
               "CXST",
               "Christmas Island Time",
               "CIT",
            };
        final String[] Amazon = new String[] {
               "\u0b85\u0bae\u0bc7\u0b9a\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMT",
               "\u0b85\u0bae\u0bc7\u0b9a\u0bbe\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMST",
               "\u0b85\u0bae\u0bc7\u0b9a\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b95\u0b9c\u0b95\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ALMT",
               "Alma-Ata Summer Time",
               "ALMST",
               "Alma-Ata Time",
               "ALMT",
            };
        final String[] Fiji = new String[] {
               "\u0b83\u0baa\u0bbf\u0b9c\u0bbf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FJT",
               "\u0b83\u0baa\u0bbf\u0b9c\u0bbf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FJST",
               "\u0b83\u0baa\u0bbf\u0b9c\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FJT",
            };
        final String[] Reunion = new String[] {
               "\u0bb0\u0bc0\u0baf\u0bc2\u0ba9\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "RET",
               "Reunion Summer Time",
               "REST",
               "Reunion Time",
               "RET",
            };
        final String[] Cocos = new String[] {
               "\u0b95\u0bcb\u0b95\u0bcb\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CCT",
               "Cocos Islands Summer Time",
               "CCST",
               "Cocos Islands Time",
               "CCT",
            };
        final String[] Chatham = new String[] {
               "\u0b9a\u0ba4\u0bcd\u0ba4\u0bbe\u0bae\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHAST",
               "\u0b9a\u0ba4\u0bcd\u0ba4\u0bbe\u0bae\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHADT",
               "\u0b9a\u0ba4\u0bcd\u0ba4\u0bbe\u0bae\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHAT",
            };
        final String[] Vostok = new String[] {
               "\u0bb5\u0bcb\u0bb8\u0bcd\u0b9f\u0bcb\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VOST",
               "Vostok Summer Time",
               "VOSST",
               "Vostok Time",
               "VOST",
            };
        final String[] Argentina = new String[] {
               "\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ART",
               "\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ARST",
               "\u0b85\u0bb0\u0bcd\u0b9c\u0bc6\u0ba9\u0bcd\u0b9f\u0bbf\u0ba9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ART",
            };
        final String[] Gambier = new String[] {
               "\u0b95\u0bc7\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bb0\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GAMT",
               "Gambier Summer Time",
               "GAMST",
               "Gambier Time",
               "GAMT",
            };
        final String[] Kamchatka = new String[] {
               "\u0baa\u0bc6\u0b9f\u0bcd\u0bb0\u0bcb\u0baa\u0bb5\u0bcd\u0bb2\u0bcb\u0bb5\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bae\u0bcd\u0b9a\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bbf \u0ba4\u0bb0 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PETT",
               "\u0baa\u0bc6\u0b9f\u0bcd\u0bb0\u0bcb\u0baa\u0bb5\u0bcd\u0bb2\u0bcb\u0bb5\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bae\u0bcd\u0b9a\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bbf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PETST",
               "\u0baa\u0bc6\u0b9f\u0bcd\u0bb0\u0bcb\u0baa\u0bb5\u0bcd\u0bb2\u0bcb\u0bb5\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bae\u0bcd\u0b9a\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PETT",
            };
        final String[] Tuvalu = new String[] {
               "\u0ba4\u0bc1\u0bb5\u0bbe\u0bb2\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TVT",
               "Tuvalu Summer Time",
               "TVST",
               "Tuvalu Time",
               "TVT",
            };
        final String[] Galapagos = new String[] {
               "\u0b95\u0bb2\u0baa\u0b95\u0bcb\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GALT",
               "Galapagos Summer Time",
               "GALST",
               "Galapagos Time",
               "GALT",
            };
        final String[] Macquarie = new String[] {
               "\u0bae\u0bbe\u0b95\u0bcd\u0b95\u0bbf\u0baf\u0bc2\u0bb0\u0bbf \u0ba4\u0bc0\u0bb5\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MIST",
               "Macquarie Island Daylight Time",
               "MIDT",
               "Macquarie Island Time",
               "MIST",
            };
        final String[] Venezuela = new String[] {
               "\u0bb5\u0bc6\u0ba9\u0bbf\u0b9a\u0bc1\u0bb2\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VET",
               "Venezuela Summer Time",
               "VEST",
               "Venezuela Time",
               "VET",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "\u0bb9\u0bb5\u0bbe\u0baf\u0bcd-\u0b85\u0bb2\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HAST",
               "\u0bb9\u0bb5\u0bbe\u0baf\u0bcd-\u0b85\u0bb2\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HADT",
               "\u0bb9\u0bb5\u0bbe\u0baf\u0bcd-\u0b85\u0bb2\u0bc7\u0bb7\u0bbf\u0baf\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "HAT",
            };
        final String[] Australia_Central = new String[] {
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACST",
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACDT",
               "\u0bae\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ACT",
            };
        final String[] America_Pacific = new String[] {
               "\u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PST",
               "\u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PDT",
               "\u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PT",
            };
        final String[] Phoenix_Islands = new String[] {
               "\u0b83\u0baa\u0bcb\u0ba9\u0bbf\u0b95\u0bcd\u0bb8\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PHOT",
               "Phoenix Is. Summer Time",
               "PHOST",
               "Phoenix Is. Time",
               "PHOT",
            };
        final String[] Turkmenistan = new String[] {
               "\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TMT",
               "\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TMST",
               "\u0ba4\u0bc1\u0bb0\u0bcd\u0b95\u0bcd\u0bae\u0bc6\u0ba9\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TMT",
            };
        final String[] Europe_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WET",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WEST",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WET",
            };
        final String[] Cape_Verde = new String[] {
               "\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CVT",
               "\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CVST",
               "\u0b95\u0bc7\u0baa\u0bcd \u0bb5\u0bc6\u0bb0\u0bcd\u0b9f\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CVT",
            };
        final String[] Norfolk = new String[] {
               "\u0ba8\u0bcb\u0bb0\u0bcd\u0b83\u0baa\u0bcb\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NFT",
               "Norfolk Summer Time",
               "NFST",
               "Norfolk Time",
               "NFT",
            };
        final String[] Guyana = new String[] {
               "\u0b95\u0baf\u0bbe\u0ba9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GYT",
               "Guyana Summer Time",
               "GYST",
               "Guyana Time",
               "GYT",
            };
        final String[] Pitcairn = new String[] {
               "\u0baa\u0bbf\u0b9f\u0bcd\u0b95\u0bc6\u0baf\u0bcd\u0bb0\u0bcd\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PST",
               "Pitcairn Daylight Time",
               "PDT",
               "Pitcairn Time",
               "PT",
            };
        final String[] Rothera = new String[] {
               "\u0bb0\u0bcb\u0ba4\u0bc7\u0bb0\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ROTT",
               "Rothera Summer Time",
               "ROTST",
               "Rothera Time",
               "ROTT",
            };
        final String[] Samoa = new String[] {
               "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SST",
               "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SDT",
               "\u0b9a\u0bae\u0bcb\u0bb5\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ST",
            };
        final String[] Palau = new String[] {
               "\u0baa\u0bbe\u0bb2\u0bb5\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PWT",
               "Palau Summer Time",
               "PWST",
               "Palau Time",
               "PWT",
            };
        final String[] Europe_Further_Eastern = new String[] {
               "\u0ba4\u0bc2\u0bb0-\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b90\u0bb0\u0bcb\u0baa\u0bcd\u0baa\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MSK",
               "Moscow Daylight Time",
               "MSD",
               "Moscow Time",
               "MT",
            };
        final String[] Azerbaijan = new String[] {
               "\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZT",
               "\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZST",
               "\u0b85\u0b9a\u0bb0\u0bcd\u0baa\u0bc8\u0b9c\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AZT",
            };
        final String[] Mawson = new String[] {
               "\u0bae\u0bbe\u0b9a\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MAWT",
               "Mawson Summer Time",
               "MAWST",
               "Mawson Time",
               "MAWT",
            };
        final String[] Mexico_Pacific = new String[] {
               "\u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0ba9\u0bcd \u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MST",
               "\u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0ba9\u0bcd \u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MDT",
               "\u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0ba9\u0bcd \u0baa\u0b9a\u0bbf\u0baa\u0bbf\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MT",
            };
        final String[] Davis = new String[] {
               "\u0b9f\u0bc7\u0bb5\u0bbf\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "DAVT",
               "Davis Summer Time",
               "DAVST",
               "Davis Time",
               "DAVT",
            };
        final String[] Cuba = new String[] {
               "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CST",
               "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CDT",
               "\u0b95\u0bbf\u0baf\u0bc2\u0baa\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CT",
            };
        final String[] Africa_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WAT",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WAST",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b86\u0baa\u0bcd\u0baa\u0bbf\u0bb0\u0bbf\u0b95\u0bcd\u0b95 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WAT",
            };
        final String[] GMT = new String[] {
               "\u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb5\u0bbf\u0b9a\u0bcd \u0b9a\u0bb0\u0bbe\u0b9a\u0bb0\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
               "Greenwich Mean Time",
               "GMT",
            };
        final String[] Philippines = new String[] {
               "\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PHT",
               "\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PHST",
               "\u0baa\u0bbf\u0bb2\u0bbf\u0baa\u0bcd\u0baa\u0bc8\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PHT",
            };
        final String[] French_Southern = new String[] {
               "\u0b83\u0baa\u0bbf\u0bb0\u0b9e\u0bcd\u0b9a\u0bc1 \u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf & \u0b85\u0ba3\u0bcd\u0b9f\u0bbe\u0bb0\u0bcd\u0b9f\u0bbf\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TFT",
               "French Southern & Antarctic Lands Summer Time",
               "TFST",
               "French Southern & Antarctic Lands Time",
               "TFT",
            };
        final String[] South_Georgia = new String[] {
               "\u0ba4\u0bc6\u0bb1\u0bcd\u0b95\u0bc1 \u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GST",
               "South Georgia Daylight Time",
               "GDT",
               "South Georgia Time",
               "GT",
            };
        final String[] New_Caledonia = new String[] {
               "\u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bb2\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NCT",
               "\u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bb2\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NCST",
               "\u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bb2\u0bbf\u0b9f\u0bcb\u0ba9\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "NCT",
            };
        final String[] Brunei = new String[] {
               "\u0baa\u0bc1\u0bb0\u0bc1\u0ba9\u0bc7 \u0b9f\u0bb0\u0bc1\u0bb8\u0bcd\u0bb8\u0bb2\u0bbe\u0bae\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BNT",
               "Brunei Summer Time",
               "BNST",
               "Brunei Time",
               "BNT",
            };
        final String[] Iran = new String[] {
               "\u0b88\u0bb0\u0bbe\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRST",
               "\u0b88\u0bb0\u0bbe\u0ba9\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRDT",
               "\u0b88\u0bb0\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRT",
            };
        final String[] Easter = new String[] {
               "\u0b88\u0bb8\u0bcd\u0b9f\u0bb0\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EAST",
               "\u0b88\u0bb8\u0bcd\u0b9f\u0bb0\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EASST",
               "\u0b88\u0bb8\u0bcd\u0b9f\u0bb0\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EAST",
            };
        final String[] Mexico_Northwest = new String[] {
               "\u0bb5\u0b9f\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0bcb \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PST",
               "\u0bb5\u0b9f\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0bcb \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PDT",
               "\u0bb5\u0b9f\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0bae\u0bc6\u0b95\u0bcd\u0bb8\u0bbf\u0b95\u0bcb \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PT",
            };
        final String[] DumontDUrville = new String[] {
               "\u0b9f\u0bc1\u0bae\u0bcb\u0ba3\u0bcd\u0b9f\u0bcd-\u0b9f\u0bbf \u0b89\u0bb0\u0bcd\u0bb5\u0bbf\u0bb2\u0bcd\u0bb2\u0bc7 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "DDUT",
               "Dumont-d'Urville Summer Time",
               "DDUST",
               "Dumont-d'Urville Time",
               "DDUT",
            };
        final String[] Tajikistan = new String[] {
               "\u0ba4\u0b9c\u0bbf\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TJT",
               "Tajikistan Summer Time",
               "TJST",
               "Tajikistan Time",
               "TJT",
            };
        final String[] Tonga = new String[] {
               "\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TOT",
               "\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TOST",
               "\u0b9f\u0bcb\u0b99\u0bcd\u0b95\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TOT",
            };
        final String[] Bangladesh = new String[] {
               "\u0bb5\u0b99\u0bcd\u0b95\u0ba4\u0bc7\u0b9a \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BDT",
               "\u0bb5\u0b99\u0bcd\u0b95\u0ba4\u0bc7\u0b9a \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BDST",
               "\u0bb5\u0b99\u0bcd\u0b95\u0ba4\u0bc7\u0b9a \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BDT",
            };
        final String[] Peru = new String[] {
               "\u0baa\u0bc6\u0bb0\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PET",
               "\u0baa\u0bc6\u0bb0\u0bc1 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PEST",
               "\u0baa\u0bc6\u0bb0\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PET",
            };
        final String[] Greenland_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WGT",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WGST",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WGT",
            };
        final String[] Ecuador = new String[] {
               "\u0b88\u0b95\u0bcd\u0bb5\u0b9f\u0bbe\u0bb0\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ECT",
               "Ecuador Summer Time",
               "ECST",
               "Ecuador Time",
               "ECT",
            };
        final String[] Greenland_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EGT",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EGST",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0bc1 \u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb2\u0bbe\u0ba8\u0bcd\u0ba4\u0bc1 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "EGT",
            };
        final String[] Gulf = new String[] {
               "\u0bb5\u0bb3\u0bc8\u0b95\u0bc1\u0b9f\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GST",
               "Gulf Daylight Time",
               "GDT",
               "Gulf Time",
               "GT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0b9a\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WIT",
               "East Indonesia Summer Time",
               "EIST",
               "East Indonesia Time",
               "WIT",
            };
        final String[] Korea = new String[] {
               "\u0b95\u0bca\u0bb0\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KST",
               "\u0b95\u0bca\u0bb0\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KDT",
               "\u0b95\u0bca\u0bb0\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KT",
            };
        final String[] Australia_Western = new String[] {
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AWST",
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AWDT",
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AWT",
            };
        final String[] Kyrgystan = new String[] {
               "\u0b95\u0bbf\u0bb0\u0bcd\u0b95\u0bbf\u0bb8\u0bcd\u0ba4\u0bbe\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "KGT",
               "Kirgizstan Summer Time",
               "KGST",
               "Kirgizstan Time",
               "KGT",
            };
        final String[] Indonesia_Western = new String[] {
               "\u0bae\u0bc7\u0bb1\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b87\u0ba8\u0bcd\u0ba4\u0bcb\u0ba9\u0bc7\u0b9a\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "WIB",
               "West Indonesia Summer Time",
               "WIST",
               "West Indonesia Time",
               "WIB",
            };
        final String[] Australia_Eastern = new String[] {
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AEST",
               "\u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf\u0ba9\u0bcd \u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AEDT",
               "\u0b95\u0bbf\u0bb4\u0b95\u0bcd\u0b95\u0ba4\u0bcd\u0ba4\u0bbf\u0baf \u0b86\u0bb8\u0bcd\u0ba4\u0bbf\u0bb0\u0bc7\u0bb2\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AET",
            };
        final String[] French_Guiana = new String[] {
               "\u0b83\u0baa\u0bbf\u0bb0\u0b9e\u0bcd\u0b9a\u0bc1 \u0b95\u0baf\u0bbe\u0ba9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GFT",
               "French Guiana Summer Time",
               "GFST",
               "French Guiana Time",
               "GFT",
            };
        final String[] Colombia = new String[] {
               "\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "COT",
               "\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "COST",
               "\u0b95\u0bca\u0bb2\u0bae\u0bcd\u0baa\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "COT",
            };
        final String[] Chile = new String[] {
               "\u0b9a\u0bbf\u0bb2\u0bbf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CLT",
               "\u0b9a\u0bbf\u0bb2\u0bbf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CLST",
               "\u0b9a\u0bbf\u0bb2\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CLT",
            };
        final String[] Gilbert_Islands = new String[] {
               "\u0b95\u0bbf\u0bb2\u0bcd\u0baa\u0bb0\u0bcd\u0b9f\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GILT",
               "Gilbert Is. Summer Time",
               "GILST",
               "Gilbert Is. Time",
               "GILT",
            };
        final String[] America_Mountain = new String[] {
               "\u0bae\u0bb5\u0bc1\u0ba9\u0bcd\u0b9f\u0bc8\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MST",
               "\u0bae\u0bb5\u0bc1\u0ba9\u0bcd\u0b9f\u0bc8\u0ba9\u0bcd \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MDT",
               "\u0bae\u0bb5\u0bc1\u0ba9\u0bcd\u0b9f\u0bc8\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MT",
            };
        final String[] Marquesas = new String[] {
               "\u0bae\u0bbe\u0bb0\u0bcd\u0b95\u0bbf\u0baf\u0bc2\u0b9a\u0bbe\u0bb8\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "MART",
               "Marquesas Summer Time",
               "MARST",
               "Marquesas Time",
               "MART",
            };
        final String[] Arabian = new String[] {
               "\u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AST",
               "\u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ADT",
               "\u0b85\u0bb0\u0bc7\u0baa\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AT",
            };
        final String[] Alaska = new String[] {
               "\u0b85\u0bb2\u0bbe\u0bb8\u0bcd\u0b95\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AKST",
               "\u0b85\u0bb2\u0bbe\u0bb8\u0bcd\u0b95\u0bbe \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AKDT",
               "\u0b85\u0bb2\u0bbe\u0bb8\u0bcd\u0b95\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AKT",
            };
        final String[] Vladivostok = new String[] {
               "\u0bb5\u0bbf\u0bb3\u0bbe\u0b9f\u0bbf\u0bb5\u0bcb\u0bb8\u0bcd\u0b9f\u0bcb\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VLAT",
               "\u0bb5\u0bbf\u0bb3\u0bbe\u0b9f\u0bbf\u0bb5\u0bcb\u0bb8\u0bcd\u0b9f\u0bcb\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VLAST",
               "\u0bb5\u0bbf\u0bb3\u0bbe\u0b9f\u0bbf\u0bb5\u0bcb\u0bb8\u0bcd\u0b9f\u0bcb\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "VLAT",
            };
        final String[] Chamorro = new String[] {
               "\u0b9a\u0bbe\u0bae\u0bcb\u0bb0\u0bcb \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "ChST",
               "Chamorro Daylight Time",
               "ChDT",
               "Chamorro Time",
               "ChT",
            };
        final String[] Irkutsk = new String[] {
               "\u0b87\u0bb0\u0bcd\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRKT",
               "\u0b87\u0bb0\u0bcd\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRKST",
               "\u0b87\u0bb0\u0bcd\u0b95\u0bc1\u0b9f\u0bcd\u0bb8\u0bcd\u0b95\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IRKT",
            };
        final String[] Georgia = new String[] {
               "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GET",
               "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GEST",
               "\u0b9c\u0bbe\u0bb0\u0bcd\u0b9c\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "GET",
            };
        final String[] Tokelau = new String[] {
               "\u0b9f\u0bcb\u0b95\u0bcd\u0b95\u0bc6\u0bb2\u0bbe\u0bb5\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "TKT",
               "Tokelau Summer Time",
               "TKST",
               "Tokelau Time",
               "TKT",
            };
        final String[] Papua_New_Guinea = new String[] {
               "\u0baa\u0baa\u0bc1\u0bb5\u0bbe \u0ba8\u0bbf\u0baf\u0bc2 \u0b95\u0bbf\u0ba9\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "PGT",
               "Papua New Guinea Summer Time",
               "PGST",
               "Papua New Guinea Time",
               "PGT",
            };
        final String[] Noronha = new String[] {
               "\u0baa\u0bc6\u0bb0\u0bcd\u0ba9\u0bbe\u0ba9\u0bcd\u0b9f\u0bcb \u0b9f\u0bbf \u0ba8\u0bcb\u0bb0\u0bcb\u0ba9\u0bcd\u0bb9\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FNT",
               "\u0baa\u0bc6\u0bb0\u0bcd\u0ba9\u0bbe\u0ba9\u0bcd\u0b9f\u0bcb \u0b9f\u0bbf \u0ba8\u0bcb\u0bb0\u0bcb\u0ba9\u0bcd\u0bb9\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FNST",
               "\u0baa\u0bc6\u0bb0\u0bcd\u0ba9\u0bbe\u0ba3\u0bcd\u0b9f\u0bcb \u0b9f\u0bbf \u0ba8\u0bcb\u0bb0\u0ba9\u0bcd\u0bb9\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "FNT",
            };
        final String[] Choibalsan = new String[] {
               "\u0b9a\u0bcb\u0baf\u0bcd\u0baa\u0bbe\u0bb2\u0bcd\u0b9a\u0ba9\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHOT",
               "\u0b9a\u0bcb\u0baf\u0bcd\u0baa\u0bbe\u0bb2\u0bcd\u0b9a\u0ba9\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHOST",
               "\u0b9a\u0bcb\u0baf\u0bcd\u0baa\u0bbe\u0bb2\u0bcd\u0b9a\u0ba9\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CHOT",
            };
        final String[] Brasilia = new String[] {
               "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0bbe \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BRT",
               "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BRST",
               "\u0baa\u0bbf\u0bb0\u0bc7\u0b9a\u0bbf\u0bb2\u0bbf\u0baf\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "BRT",
            };
        final String[] China = new String[] {
               "\u0b9a\u0bc0\u0ba9 \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CST",
               "\u0b9a\u0bc0\u0ba9 \u0baa\u0b95\u0bb2\u0bca\u0bb3\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CDT",
               "\u0b9a\u0bc0\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CT",
            };
        final String[] Armenia = new String[] {
               "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMT",
               "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMST",
               "\u0b86\u0bb0\u0bcd\u0bae\u0bc7\u0ba9\u0bbf\u0baf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "AMT",
            };
        final String[] Samara = new String[] {
               "\u0b9a\u0bae\u0bb0\u0bbe \u0ba4\u0bb0 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAMT",
               "\u0b9a\u0bae\u0bb0\u0bbe \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAMST",
               "\u0b9a\u0bae\u0bb0\u0bbe \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "SAMT",
            };
        final String[] India = new String[] {
               "\u0b87\u0ba8\u0bcd\u0ba4\u0bbf\u0baf \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "IST",
               "India Daylight Time",
               "IDT",
               "India Time",
               "IT",
            };
        final String[] Cook = new String[] {
               "\u0b95\u0bc1\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CKT",
               "\u0b95\u0bc1\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0b85\u0bb0\u0bc8 \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CKHST",
               "\u0b95\u0bc1\u0b95\u0bcd \u0ba4\u0bc0\u0bb5\u0bc1\u0b95\u0bb3\u0bcd \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
               "CKT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "America/El_Salvador", America_Central },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "America/Guatemala", America_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "\u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb5\u0bbf\u0b9a\u0bcd \u0b9a\u0bb0\u0bbe\u0b9a\u0bb0\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
                    "GMT",
                    "\u0baa\u0bbf\u0bb0\u0bbf\u0b9f\u0bcd\u0b9f\u0bbf\u0bb7\u0bcd \u0b95\u0bcb\u0b9f\u0bc8 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "America/Belize", America_Central },
            { "America/Panama", America_Eastern },
            { "America/Managua", America_Central },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Jersey", GMT },
            { "America/Tegucigalpa", America_Central },
            { "Europe/Istanbul", Europe_Eastern },
            { "America/Eirunepe", Acre },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Guernsey", GMT },
            { "America/Grand_Turk", Atlantic },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "America/Araguaina", Brasilia },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Port_Moresby", Papua_New_Guinea },
            { "Antarctica/Syowa", Syowa },
            { "Indian/Reunion", Reunion },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Western },
            { "Asia/Karachi", Pakistan },
            { "Africa/Mogadishu", Africa_Eastern },
            { "Australia/Perth", Australia_Western },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/Davis", Davis },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "Africa/Malabo", Africa_Western },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "Africa/Lagos", Africa_Western },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "America/Regina", America_Central },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/St_Thomas", Atlantic },
            { "Europe/Zurich", Europe_Central },
            { "America/Anguilla", Atlantic },
            { "Asia/Dili", East_Timor },
            { "Africa/Bamako", GMT },
            { "Pacific/Wallis", Wallis },
            { "Europe/Gibraltar", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "Asia/Choibalsan", Choibalsan },
            { "Asia/Omsk", Omsk },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Dhaka", Bangladesh },
            { "America/Barbados", Atlantic },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Curacao", Atlantic },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "America/Guayaquil", Ecuador },
            { "America/Martinique", Atlantic },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rankin_Inlet", America_Central },
            { "Pacific/Ponape", Ponape },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Europe/Zagreb", Europe_Central },
            { "America/Port_of_Spain", Atlantic },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "Pacific/Bougainville", New_Zealand },
            { "Africa/Sao_Tome", GMT },
            { "Indian/Chagos", Indian_Ocean },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "Pacific/Fiji", Fiji },
            { "America/Rainy_River", America_Central },
            { "Indian/Maldives", Maldives },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "America/Juneau", Alaska },
            { "America/Indiana/Vevay", America_Eastern },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "America/Noronha", Noronha },
            { "America/Swift_Current", America_Central },
            { "Australia/Adelaide", Australia_Central },
            { "America/Metlakatla", Alaska },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/Mawson", Mawson },
            { "America/Kralendijk", Atlantic },
            { "Antarctica/Troll", GMT },
            { "Europe/Samara", Samara },
            { "Indian/Christmas", Christmas },
            { "America/Antigua", Atlantic },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "America/Moncton", Atlantic },
            { "Africa/Gaborone", Africa_Central },
            { "America/St_Vincent", Atlantic },
            { "Asia/Gaza", Europe_Eastern },
            { "PST8PDT", America_Pacific },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Yakutat", Alaska },
            { "Antarctica/Casey", Australia_Western },
            { "Europe/Copenhagen", Europe_Central },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "Pacific/Pitcairn", Pitcairn },
            { "America/Mazatlan", Mexico_Pacific },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "America/Dominica", Atlantic },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "America/Santarem", Brasilia },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Wake", Wake },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Costa_Rica", America_Central },
            { "America/Dawson", America_Pacific },
            { "Europe/Amsterdam", Europe_Central },
            { "America/Indiana/Knox", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "Africa/Accra", GMT },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Europe/Dublin",
                new String[] {
                    "\u0b95\u0bbf\u0bb0\u0bc0\u0ba9\u0bcd\u0bb5\u0bbf\u0b9a\u0bcd \u0b9a\u0bb0\u0bbe\u0b9a\u0bb0\u0bbf \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
                    "GMT",
                    "\u0b90\u0bb0\u0bbf\u0bb7\u0bcd \u0ba8\u0bbf\u0bb2\u0bc8\u0baf\u0bbe\u0ba9 \u0ba8\u0bc7\u0bb0\u0bae\u0bcd",
                    "GMT",
                    "Greenwich Mean Time",
                    "GMT",
                }
            },
            { "Pacific/Truk", Truk },
            { "MST7MDT", America_Mountain },
            { "America/Monterrey", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/Center", America_Central },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "Europe/San_Marino", Europe_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Pacific/Saipan", Chamorro },
            { "Africa/Douala", Africa_Western },
            { "America/Chihuahua", Mexico_Pacific },
            { "America/Ojinaga", America_Mountain },
            { "Asia/Hovd", Hovd },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Damascus", Europe_Eastern },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "Asia/Taipei", Taipei },
            { "Asia/Manila", Philippines },
            { "Asia/Bangkok", Indochina },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "Antarctica/Palmer", Chile },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Creston", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "Antarctica/Vostok", Vostok },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Vientiane", Indochina },
            { "Pacific/Kiritimati", Line_Islands },
            { "America/Matamoros", America_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "Asia/Riyadh", Arabian },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/Oslo", Europe_Central },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "CST6CDT", America_Central },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "America/Menominee", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Pacific/Norfolk", Norfolk },
            { "America/Resolute", America_Central },
            { "Pacific/Tarawa", Gilbert_Islands },
            { "Africa/Kampala", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "Africa/Bujumbura", Africa_Central },
            { "America/Santo_Domingo", Atlantic },
            { "Europe/Minsk", Europe_Further_Eastern },
            { "Pacific/Auckland", New_Zealand },
            { "America/Glace_Bay", Atlantic },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Port-au-Prince", America_Eastern },
            { "America/St_Barthelemy", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Cancun", America_Eastern },
            { "Africa/Maseru", Africa_Southern },
            { "Pacific/Kosrae", Kosrae },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "America/St_Lucia", Atlantic },
            { "Europe/Madrid", Europe_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Montserrat", Atlantic },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "America/Lower_Princes", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Africa/Blantyre", Africa_Central },
            { "America/Rio_Branco", Acre },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "America/Thule", Atlantic },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Tortola", Atlantic },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "Asia/Kamchatka", Kamchatka },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Eastern },
            { "Africa/Johannesburg", Africa_Southern },
            { "Africa/Bangui", Africa_Western },
            { "Europe/Belgrade", Europe_Central },
            { "Africa/Bissau", GMT },
            { "Asia/Tehran", Iran },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "America/Bahia", Brasilia },
            { "America/Goose_Bay", Atlantic },
            { "America/Pangnirtung", America_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Africa/Niamey", Africa_Western },
            { "America/Whitehorse", America_Pacific },
            { "Pacific/Noumea", New_Caledonia },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Makassar", Indonesia_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Boa_Vista", Amazon },
            { "America/Grenada", Atlantic },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "America/Merida", America_Central },
            { "America/St_Kitts", Atlantic },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "Asia/Srednekolymsk", Singapore },
            { "America/North_Dakota/New_Salem", America_Central },
            { "Asia/Anadyr", Magadan },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Winnipeg", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "Asia/Amman", Europe_Eastern },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "Australia/Lindeman", Australia_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
        };
        return data;
    }
}
