/*
 * Decompiled with CFR 0.152.
 */
package net.sf.bt747.j2se.system;

import bt747.sys.interfaces.BT747Date;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public final class J2SEDate
implements BT747Date {
    private final Calendar cal = Calendar.getInstance(GMT_ZONE);
    private static final SimpleDateFormat FORMAT_YYYYMMDD = new SimpleDateFormat("yyyy/MM/dd");
    private static final SimpleDateFormat FORMAT_DDMMYYYY = new SimpleDateFormat("dd/MM/yyyy");
    private static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");

    public J2SEDate() {
        this.cal.set(13, 0);
        this.cal.set(11, 0);
        this.cal.set(12, 0);
        this.cal.set(14, 0);
    }

    public J2SEDate(int n, int n2, int n3) {
        this.cal.set(n3, n2 - 1, n, 0, 0, 0);
    }

    public J2SEDate(String string, byte by) {
        SimpleDateFormat simpleDateFormat = by == 1 ? FORMAT_YYYYMMDD : FORMAT_DDMMYYYY;
        simpleDateFormat.setTimeZone(GMT_ZONE);
        try {
            this.cal.setTime(simpleDateFormat.parse(string));
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public final void advance(int n) {
        this.cal.add(5, n);
    }

    public final int dateToUTCepoch1970() {
        return (int)(this.cal.getTimeInMillis() / 1000L);
    }

    public final String getDateString() {
        return FORMAT_DDMMYYYY.format(this.cal.getTime());
    }

    public final int getYear() {
        return this.cal.get(1);
    }

    public final int getMonth() {
        return this.cal.get(2);
    }

    public final int getDay() {
        return this.cal.get(5);
    }

    static {
        FORMAT_DDMMYYYY.setTimeZone(GMT_ZONE);
    }
}

