/*
 * Decompiled with CFR 0.152.
 */
package org.gennbo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.Stack;
import javajs.util.PT;
import javajs.util.SB;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gennbo.NBOConfig;
import org.gennbo.NBODialog;
import org.gennbo.NBOFileAcceptor;
import org.gennbo.NBOFileHandler;
import org.gennbo.NBORequest;
import org.gennbo.NBOUtil;
import org.jmol.util.Elements;
import org.jmol.viewer.Viewer;

class NBOModel
implements NBOFileAcceptor {
    protected NBODialog dialog;
    private Viewer vwr;
    private static final int MODEL_ACTION_ALTER = 0;
    private static final int MODEL_ACTION_CLIP = 1;
    private static final int MODEL_ACTION_FUSE = 2;
    private static final int MODEL_ACTION_LINK = 3;
    private static final int MODEL_ACTION_MUTATE = 4;
    private static final int MODEL_ACTION_SWITCH = 5;
    private static final int MODEL_ACTION_TWIST = 6;
    private static final int MODEL_ACTION_VALUE = 7;
    private static final int MODEL_ACTION_3CHB = 8;
    private static final int MODEL_ACTION_MAX = 9;
    private static final int MODEL_ACTION_REBOND = 9;
    private static final int MODEL_ACTION_SYMMETRY = 10;
    private static final int MODEL_ACTION_HBOND = 11;
    static final int MODE_MODEL_EDIT = 21;
    static final int MODE_MODEL_NEW = 31;
    static final int MODE_MODEL_SAVE = 41;
    static final int MODE_MODEL_TO_NBO = 51;
    static final int MODE_MODEL_UNDO_REDO = 61;
    static final String[] MODEL_ACTIONS = new String[]{"Alter", "Clip", "Fuse", "Link", "Mutate", "Switch", "Twist", "Value", "3chb", "Rebond", "Symmetry?", "H-Bonds"};
    private static final String[] EDIT_INFO = new String[]{"Edit nuclear charge, bond length, bond angle, or dihedral angle", "Remove bond between two atoms", "Delete monovalent atoms and replace with bond", "Add bond between two atoms", "Replace atom with a new substituent-group", "Switch location of two groups", "Perform rigid torsional twist about dihedral angle", "Value of nuclear charge, bond length, bond angle, and dihedral angle", "Create 3-center linkage between two atoms and a ligand", "Change bonding symmetry around transition metal", "Display point-group symmetry of current model", "Show NBOPro6-derived hydrogen bonds"};
    private static final int BOX_COUNT_4 = 4;
    private static final int BOX_COUNT_2 = 2;
    private static final int BOX_COUNT_1 = 1;
    private static final int MAX_HISTORY = 5;
    private NBOFileHandler saveFileHandler;
    private Box innerEditBox;
    private JTextField jtNIHInput;
    private JTextField jtLineFormula;
    private JTextField txtCurrVal;
    private JComboBox<String> jcSymOps;
    private JButton btnRebond;
    private JButton jbClear;
    private JLabel atomsLabel;
    private Box editBox;
    private Box editHeaderBox;
    private Box inputBox;
    private Box inputHeaderBox;
    private Box saveBox;
    private Box saveHeaderBox;
    private JTextField[] atomNumBoxes;
    private JLabel valueLabel = new JLabel("");
    protected JTextField editValueTf;
    protected JButton jbApply;
    protected JComboBox<String> jComboSave;
    protected JComboBox<String> jComboOpen;
    protected JButton undo;
    protected JButton redo;
    protected Stack<String> undoStack;
    protected Stack<String> redoStack;
    private int actionID;
    private int boxCount;
    private boolean notFromNBO;
    private boolean resetOnAtomClick;
    private Box innerLinkOptionBox;
    private JRadioButton radLinkBond;
    private static final String[][] REBOND_LISTS = new String[][]{{"td", "c3v", "c4v"}, {"c4vo", "c4vi"}, {"c3vo", "c3vi", "c5vo", "c5vi"}};
    ActionListener redoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBOModel.this.redoStack.pop();
            if (NBOModel.this.redoStack.isEmpty()) {
                NBOModel.this.redo.setEnabled(false);
            }
            NBOModel.this.loadModelToNBO(curr, true);
            NBOModel.this.dialog.logCmd("Redo");
        }
    };
    ActionListener undoAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String curr = NBOModel.this.undoStack.pop();
            if (NBOModel.this.undoStack.isEmpty()) {
                NBOModel.this.undo.setEnabled(false);
                return;
            }
            String tmp = NBOModel.this.undoStack.pop();
            NBOModel.this.loadModelToNBO(tmp, true);
            NBOModel.this.redoStack.push(curr);
            if (NBOModel.this.redoStack.size() > 5) {
                NBOModel.this.redoStack.removeElementAt(5);
            }
            NBOModel.this.dialog.logCmd("Undo");
        }
    };
    private boolean showSelectedOnFileLoad;
    private int currentRebondSymOp;
    private String measures = "";

    protected NBOModel(NBODialog dialog) {
        this.dialog = dialog;
        this.vwr = dialog.vwr;
    }

    protected void setModelNotFromNBO() {
        this.notFromNBO = true;
    }

    private void showComponents(boolean tf) {
        this.editHeaderBox.setVisible(tf);
        this.editBox.setVisible(tf);
        this.innerLinkOptionBox.setVisible(false);
        this.saveHeaderBox.setVisible(tf);
        this.saveBox.setVisible(tf);
    }

    void modelSetSaveParametersFromInput(NBOFileHandler nboFileHandler, String dir, String name, String ext) {
        if (this.saveFileHandler != null && nboFileHandler != this.saveFileHandler) {
            this.saveFileHandler.setTextFields(dir, name, PT.isOneOf(ext, ";adf;cfi;gms;jag;mm2;mnd;mol;mp;nw;orc;pqs;qc;vfi;xyz;gau;g09;com;") ? ext : "");
        }
    }

    protected JPanel buildModelPanel() {
        this.resetVariables();
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        this.inputHeaderBox = NBOUtil.createTitleBox(" Input Model ", nBODialog.new NBODialog.HelpBtn("model_input_intro_help.htm"));
        panel.add(this.inputHeaderBox);
        this.inputBox = this.getInputBox();
        panel.add(this.inputBox);
        this.editHeaderBox = this.getEditHeader();
        panel.add(this.editHeaderBox).setVisible(false);
        this.editBox = this.getEditComponent();
        panel.add(this.editBox).setVisible(false);
        NBODialog nBODialog2 = this.dialog;
        nBODialog2.getClass();
        this.saveHeaderBox = NBOUtil.createTitleBox(" Save Model ", nBODialog2.new NBODialog.HelpBtn("model_save_intro_help.htm"));
        panel.add(this.saveHeaderBox).setVisible(false);
        this.saveBox = this.getSaveBox();
        this.saveFileHandler = new NBOFileHandler("", 5, this.dialog, this);
        this.saveBox.add(this.saveFileHandler);
        panel.add(this.saveBox).setVisible(false);
        panel.add(Box.createGlue());
        if (this.vwr.ms.ac > 0) {
            this.loadModelToNBO(null, false);
        }
        return panel;
    }

    private void resetVariables() {
        this.actionID = 0;
        this.boxCount = 0;
        this.notFromNBO = false;
        this.showSelectedOnFileLoad = false;
        this.resetOnAtomClick = true;
    }

    private Box getEditHeader() {
        Box topBox = Box.createHorizontalBox();
        this.undo = new JButton("<HTML>&#8592Undo</HTML>");
        this.redo = new JButton("<HTML>Redo&#8594</HTML>");
        this.undoStack = new Stack();
        this.redoStack = new Stack();
        this.redo.addActionListener(this.redoAction);
        this.undo.addActionListener(this.undoAction);
        topBox.add(this.undo);
        topBox.add(this.redo);
        NBODialog nBODialog = this.dialog;
        nBODialog.getClass();
        topBox.add(nBODialog.new NBODialog.HelpBtn("model_edit_intro_help.htm"));
        return NBOUtil.createTitleBox(" Edit Model ", topBox);
    }

    private Box getInputBox() {
        Box inputBox = NBOUtil.createBorderBox(true);
        inputBox.setMaximumSize(new Dimension(360, 140));
        inputBox.setPreferredSize(new Dimension(360, 140));
        inputBox.setMinimumSize(new Dimension(360, 140));
        JPanel p2 = new JPanel(new GridLayout(3, 2));
        p2.setMaximumSize(new Dimension(360, 90));
        p2.setPreferredSize(new Dimension(360, 90));
        p2.setMinimumSize(new Dimension(360, 90));
        JRadioButton jrJmolIn = new JRadioButton("NIH/PubChem/PDB");
        jrJmolIn.setFont(NBOConfig.monoFont);
        JRadioButton jrLineIn = new JRadioButton("Line Formula");
        jrLineIn.setFont(NBOConfig.monoFont);
        jrLineIn.setSelected(true);
        JRadioButton jrFileIn = new JRadioButton("File Input");
        jrFileIn.setFont(NBOConfig.monoFont);
        ButtonGroup rg = new ButtonGroup();
        rg.add(jrJmolIn);
        rg.add(jrLineIn);
        rg.add(jrFileIn);
        this.jtNIHInput = new JTextField();
        this.createInput(this.jtNIHInput, jrJmolIn);
        this.jtLineFormula = new JTextField();
        this.createInput(this.jtLineFormula, jrLineIn);
        this.jtNIHInput.setFont(NBOConfig.userInputFont);
        this.jtLineFormula.setFont(NBOConfig.userInputFont);
        this.jtLineFormula.add(new JLabel("line formula"));
        this.jComboOpen = new JComboBox<String>(NBOFileHandler.MODEL_OPEN_OPTIONS);
        this.jComboOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doComboUseAction(NBOModel.this.jComboOpen.getSelectedIndex() > 0 ? NBOModel.this.jComboOpen.getSelectedItem().toString() : null);
            }
        });
        p2.add(jrLineIn);
        p2.add(this.jtLineFormula);
        p2.add(jrJmolIn);
        p2.add(this.jtNIHInput);
        p2.add(jrFileIn);
        p2.add(this.jComboOpen);
        this.jComboOpen.setSelectedIndex(1);
        this.addFocusListeners(this.jComboOpen, jrFileIn);
        inputBox.add(p2);
        this.dialog.getNewInputFileHandler(1, this);
        this.addFocusListeners(this.dialog.inputFileHandler.tfDir, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.tfExt, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.tfName, jrFileIn);
        this.addFocusListeners(this.dialog.inputFileHandler.btnBrowse, jrFileIn);
        inputBox.add(this.dialog.inputFileHandler);
        inputBox.add(Box.createGlue());
        return inputBox;
    }

    protected void doComboUseAction(String item) {
        if (this.dialog.inputFileHandler == null) {
            return;
        }
        if (item == null) {
            this.dialog.inputFileHandler.tfExt.setText("");
        } else {
            item = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
            this.dialog.inputFileHandler.tfExt.setText(item);
        }
    }

    private Box getEditComponent() {
        Box editBox = NBOUtil.createBorderBox(false);
        Box actionBox = Box.createVerticalBox();
        JRadioButton[] jrModelActions = new JRadioButton[9];
        ButtonGroup rg = new ButtonGroup();
        for (int i = 0; i < 9; ++i) {
            jrModelActions[i] = new JRadioButton(MODEL_ACTIONS[i]);
            jrModelActions[i].setToolTipText(EDIT_INFO[i]);
            actionBox.add(jrModelActions[i]);
            rg.add(jrModelActions[i]);
            final int op = i;
            jrModelActions[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBOModel.this.doModelAction(op);
                }
            });
        }
        editBox.add(actionBox);
        Box rightBox = Box.createVerticalBox();
        this.createInnerEditBox();
        rightBox.add(this.innerEditBox);
        Box lowBox = Box.createHorizontalBox();
        JButton sym = new JButton(MODEL_ACTIONS[10]);
        sym.setToolTipText(EDIT_INFO[10]);
        sym.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doGetSymmetry();
            }
        });
        lowBox.add(sym);
        this.btnRebond = new JButton(MODEL_ACTIONS[9]);
        this.btnRebond.setEnabled(false);
        this.btnRebond.setToolTipText(EDIT_INFO[9]);
        this.btnRebond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doModelAction(9);
            }
        });
        lowBox.add(this.btnRebond);
        JButton hbond = new JButton(MODEL_ACTIONS[11]);
        hbond.setToolTipText(EDIT_INFO[11]);
        hbond.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doGetHBonds();
            }
        });
        lowBox.add(hbond);
        rightBox.add(lowBox);
        editBox.add(rightBox);
        return editBox;
    }

    private void createInnerEditBox() {
        this.innerEditBox = Box.createVerticalBox();
        this.innerEditBox.setBorder(BorderFactory.createLoweredBevelBorder());
        this.innerEditBox.setMaximumSize(new Dimension(275, 200));
        this.innerEditBox.setAlignmentX(0.5f);
        this.innerEditBox.setVisible(false);
        Box atBox = Box.createHorizontalBox();
        this.atomsLabel = new JLabel("");
        atBox.add(this.atomsLabel);
        this.atomNumBoxes = new JTextField[4];
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i] = new JTextField();
            this.atomNumBoxes[i].setFont(NBOConfig.userInputFont);
            this.atomNumBoxes[i].setMaximumSize(new Dimension(50, 50));
            atBox.add(this.atomNumBoxes[i]).setVisible(false);
            final int num = i;
            this.atomNumBoxes[i].addKeyListener(new KeyListener(){

                @Override
                public void keyTyped(KeyEvent e) {
                }

                @Override
                public void keyPressed(KeyEvent e) {
                }

                @Override
                public void keyReleased(KeyEvent e) {
                    NBOModel.this.editValueTf.setText("");
                    NBOModel.this.editValueTf.setEnabled(NBOModel.this.modelEditGetSelected().length() > 0);
                }
            });
            this.atomNumBoxes[i].addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent arg0) {
                    NBOModel.this.doAtomNumBoxFocus(true, num);
                }

                @Override
                public void focusLost(FocusEvent arg0) {
                    NBOModel.this.doAtomNumBoxFocus(false, 0);
                }
            });
            this.atomNumBoxes[i].addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NBOModel.this.doSetAtomBoxesFromSelection(null, false);
                }
            });
        }
        this.innerEditBox.add(atBox);
        Box box = Box.createHorizontalBox();
        box.add(new JLabel("Symmetry Type: "));
        this.jcSymOps = new JComboBox();
        this.jcSymOps.addItem("<Select Transition Metal>");
        this.jcSymOps.setMaximumSize(new Dimension(180, 40));
        this.jcSymOps.setEnabled(false);
        box.add(this.jcSymOps);
        box.setVisible(false);
        this.innerEditBox.add(box);
        this.txtCurrVal = new JTextField("pick atoms...");
        this.txtCurrVal.setFont(NBOConfig.titleFont);
        this.txtCurrVal.setBackground(new Color(220, 220, 220));
        this.txtCurrVal.setMinimumSize(new Dimension(250, 40));
        this.txtCurrVal.setPreferredSize(new Dimension(250, 40));
        this.txtCurrVal.setMaximumSize(new Dimension(250, 40));
        this.txtCurrVal.setHorizontalAlignment(0);
        this.innerEditBox.add(this.txtCurrVal).setVisible(false);
        this.valueLabel = new JLabel();
        this.valueLabel.setAlignmentX(0.5f);
        this.innerEditBox.add(this.valueLabel).setVisible(false);
        this.editValueTf = new JTextField("Select atoms...");
        this.editValueTf.setVisible(false);
        this.editValueTf.setMaximumSize(new Dimension(200, 30));
        this.editValueTf.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doEditValueTextField();
            }
        });
        this.editValueTf.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent arg0) {
            }

            @Override
            public void insertUpdate(DocumentEvent arg0) {
                if (!NBOModel.this.editValueTf.getText().equals("") && !NBOModel.this.editValueTf.getText().contains("Select")) {
                    NBOModel.this.jbApply.setEnabled(true);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent arg0) {
                if (NBOModel.this.editValueTf.getText().equals("")) {
                    NBOModel.this.jbApply.setEnabled(false);
                }
            }
        });
        this.innerEditBox.add(this.editValueTf).setVisible(false);
        this.innerLinkOptionBox = Box.createHorizontalBox();
        this.radLinkBond = new JRadioButton("Bond");
        this.radLinkBond.setSelected(true);
        JRadioButton radLinkDotted = new JRadioButton("Dotted");
        this.innerLinkOptionBox.add(this.radLinkBond);
        this.innerLinkOptionBox.add(radLinkDotted);
        ButtonGroup g = new ButtonGroup();
        g.add(this.radLinkBond);
        g.add(radLinkDotted);
        this.innerEditBox.add(this.innerLinkOptionBox).setVisible(false);
        Box lowBox = Box.createHorizontalBox();
        this.jbClear = new JButton("Clear Selected");
        this.jbClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.clearSelected(true);
            }
        });
        this.jbApply = new JButton("Apply");
        this.jbApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doApply();
            }
        });
        lowBox.add(this.jbClear).setVisible(false);
        lowBox.add(this.jbApply).setVisible(false);
        this.innerEditBox.add(lowBox);
    }

    protected void doLinkDotted() {
        String atomList = this.modelEditGetSelected();
        String[] atoms = PT.getTokens(atomList);
        if (atoms.length == 2) {
            this.processHBonds("1 " + atomList);
        }
    }

    protected void doAtomNumBoxFocus(boolean isGained, int num) {
        System.out.println("atomnumbfocus" + isGained + " " + num);
        if (!isGained) {
            int atnum = PT.parseInt(this.atomNumBoxes[num].getText());
            if (atnum > this.vwr.ms.ac || atnum < 1) {
                this.atomNumBoxes[num].setText("");
            } else {
                this.doSetAtomBoxesFromSelection(null, false);
            }
        } else if (num == this.boxCount - 1) {
            this.jbApply.setEnabled(this.modelEditGetSelected().length() > 0);
        }
    }

    protected void doApply() {
        this.postActionToNBO(this.actionID);
    }

    protected void doEditValueTextField() {
        this.postActionToNBO(this.actionID);
    }

    protected void updateSelected(boolean doPost, boolean setFocus) {
        String selected = this.modelEditGetSelected();
        String script = "measure delete;";
        int cnt = selected.split(" ").length;
        this.editValueTf.setEnabled(cnt > 0);
        this.editValueTf.setText("");
        if (this.editValueTf.isVisible()) {
            this.editValueTf.requestFocus();
        }
        switch (this.boxCount) {
            case 4: {
                String desc = "";
                if (cnt > 1) {
                    script = script + "measure " + selected + " \" \";";
                }
                switch (cnt) {
                    case 0: {
                        this.txtCurrVal.setText("pick atoms...");
                        break;
                    }
                    case 1: {
                        desc = this.actionID == 0 ? "atomic number or symbol" : "atomic number";
                        break;
                    }
                    case 2: {
                        desc = "distance";
                        break;
                    }
                    case 3: 
                    case 4: {
                        desc = cnt == 3 ? "angle" : "dihedral angle";
                    }
                }
                this.valueLabel.setText("(" + desc + ")");
                this.valueLabel.setVisible(cnt > 0);
                break;
            }
            case 2: {
                if (cnt != 2) break;
                this.jbApply.setEnabled(true);
                if (this.editValueTf.isVisible()) {
                    this.editValueTf.requestFocus();
                    break;
                }
                if (!setFocus) break;
                this.atomNumBoxes[1].requestFocus();
                break;
            }
            case 1: {
                if (cnt != 1 || this.actionID != 9) break;
                this.jcSymOps.removeAllItems();
                this.jcSymOps.setEnabled(true);
                int atomNumber = PT.parseInt(this.atomNumBoxes[0].getText());
                if (atomNumber < 1) {
                    return;
                }
                int val = this.vwr.ms.at[atomNumber - 1].getValence();
                this.jbApply.setEnabled(true);
                String[] symlist = NBOModel.getRebondSymList(val);
                if (symlist != null) {
                    for (int i = 0; i < symlist.length; ++i) {
                        this.jcSymOps.addItem(symlist[i]);
                    }
                    if (this.currentRebondSymOp > 0) {
                        this.jcSymOps.setSelectedIndex(this.currentRebondSymOp);
                    }
                    this.currentRebondSymOp = 0;
                    break;
                }
                this.jcSymOps.addItem("<Select Transition Metal>");
                this.jcSymOps.setEnabled(false);
                this.jbApply.setEnabled(false);
            }
        }
        if (this.actionID == 0 || this.actionID == 6 && cnt == 4) {
            this.postActionToNBO(7);
        }
        if (this.actionID == 3) {
            script = "";
        }
        this.dialog.runScriptQueued(script);
        this.editValueTf.setText("");
        this.editValueTf.setEnabled(selected.length() > 0);
        this.dialog.showSelected(selected);
        if (this.actionID == 7 || doPost) {
            this.postActionToNBO(this.actionID);
        }
    }

    private static String[] getRebondSymList(int val) {
        return val - 4 < REBOND_LISTS.length ? REBOND_LISTS[val - 4] : null;
    }

    protected String modelEditGetSelected() {
        String s = "";
        for (int j = 0; j < this.boxCount; ++j) {
            s = s + this.atomNumBoxes[j].getText().trim() + " ";
        }
        return PT.rep(s.trim(), "  ", " ").trim();
    }

    private Box getSaveBox() {
        Box sBox = NBOUtil.createBorderBox(true);
        this.jComboSave = new JComboBox<String>(NBOFileHandler.MODEL_SAVE_OPTIONS);
        this.jComboSave.setFont(NBOConfig.monoFont);
        this.jComboSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NBOModel.this.jComboSave.getSelectedIndex() > 0) {
                    NBOModel.this.doComboSaveAction(NBOModel.this.jComboSave.getSelectedItem().toString());
                }
            }
        });
        sBox.add(this.jComboSave);
        return sBox;
    }

    protected void doComboSaveAction(String item) {
        String ext = item.substring(item.indexOf("[") + 2, item.indexOf("]"));
        this.saveFileHandler.tfExt.setText(ext);
    }

    private void createInput(final JTextField field, JRadioButton radio) {
        field.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NBOModel.this.doLoadtModelFromTextBox(field);
            }
        });
        this.addFocusListeners(field, radio);
    }

    private void addFocusListeners(final JComponent field, final JRadioButton radio) {
        field.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                radio.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
        radio.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent arg0) {
                field.requestFocus();
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    protected void doModelAction(int action) {
        this.actionID = action;
        this.dialog.runScriptQueued("set refreshing true; measurements delete");
        this.clearSelected(true);
        if (action != 3) {
            if (action != 1) {
                this.measures = "";
            }
            this.innerLinkOptionBox.setVisible(false);
        }
        switch (action) {
            case 4: {
                this.boxCount = 1;
                this.setEditBox("Radical name or line formula...");
                break;
            }
            case 9: {
                this.boxCount = 1;
                this.setEditBox(null);
                break;
            }
            case 3: {
                this.innerLinkOptionBox.setVisible(true);
            }
            case 1: 
            case 2: 
            case 5: 
            case 8: {
                this.boxCount = 2;
                this.setEditBox(null);
                break;
            }
            case 0: 
            case 6: 
            case 7: {
                this.boxCount = 4;
                this.setEditBox(null);
            }
        }
    }

    private void setEditBox(String label) {
        if (label == null) {
            label = "Select atom" + (this.boxCount > 1 ? "s" : "") + "...";
        }
        this.jbApply.setEnabled(false);
        for (int i = 0; i < 4; ++i) {
            this.atomNumBoxes[i].setVisible(i < this.boxCount);
        }
        this.atomsLabel.setText(this.boxCount == 0 ? "" : "Atom" + (this.boxCount > 1 ? "s" : "") + ":");
        this.editValueTf.setText(label);
        this.editValueTf.setEnabled(false);
        this.jcSymOps.getParent().setVisible(this.actionID == 9);
        switch (this.actionID) {
            case 0: 
            case 4: 
            case 6: 
            case 8: {
                this.editValueTf.setVisible(true);
                break;
            }
            default: {
                this.editValueTf.setVisible(false);
            }
        }
        this.txtCurrVal.setVisible(this.boxCount == 4);
        this.valueLabel.setVisible(true);
        this.jbApply.setVisible(this.actionID != 7);
        this.jbClear.setVisible(true);
        this.innerEditBox.repaint();
        this.innerEditBox.revalidate();
    }

    protected void clearSelected(boolean andShow) {
        for (int i = 0; i < this.boxCount; ++i) {
            this.atomNumBoxes[i].setText("");
        }
        if (this.txtCurrVal != null) {
            this.txtCurrVal.setText("");
        }
        if (this.valueLabel != null) {
            this.valueLabel.setText(" ");
        }
        if (this.editValueTf != null) {
            this.editValueTf.setText("Select atoms...");
            this.editValueTf.setEnabled(false);
            this.jbApply.setEnabled(false);
        }
        if (andShow) {
            this.updateSelected(false, true);
        }
    }

    protected void postActionToNBO(int actionID) {
        if (actionID == 3 && !this.radLinkBond.isSelected()) {
            this.doLinkDotted();
            return;
        }
        SB sb = new SB();
        String selected = this.modelEditGetSelected();
        String cmd = MODEL_ACTIONS[actionID].toLowerCase() + " " + selected + " ";
        String val = this.editValueTf.getText().trim();
        if (actionID == 0 && PT.parseInt(val) == Integer.MIN_VALUE) {
            if (val.length() == 0) {
                return;
            }
            val = "" + Elements.elementNumberFromSymbol(val, true);
        }
        if (this.boxCount == 4 || this.boxCount == 1) {
            cmd = cmd + val;
        } else if (actionID == 8) {
            if (!val.startsWith(":")) {
                cmd = cmd + ":";
            }
            cmd = cmd + val;
        }
        if (actionID == 9) {
            this.currentRebondSymOp = this.jcSymOps.getSelectedIndex();
            cmd = cmd + this.jcSymOps.getItemAt(this.currentRebondSymOp);
        }
        NBOUtil.postAddCmd(sb, cmd);
        this.dialog.logCmd(cmd);
        this.jbApply.setEnabled(false);
        this.resetOnAtomClick = actionID != 7;
        this.postNBO(sb, actionID, actionID == 7 ? "Checking value" : "Editing model", null, null);
    }

    protected void doGetSymmetry() {
        String cmd = "symmetry";
        this.dialog.logCmd(cmd);
        this.postNBO(NBOUtil.postAddCmd(new SB(), cmd), 10, "Checking Symmetry", null, null);
    }

    protected void doGetHBonds() {
        String cmd = "hbond";
        this.dialog.logCmd(cmd);
        this.postNBO(NBOUtil.postAddCmd(new SB(), cmd), 11, "Getting Hydrogen Bonds", null, null);
    }

    protected void doLoadtModelFromTextBox(JTextField textBox) {
        String model = textBox.getText().trim();
        if (model.length() == 0) {
            return;
        }
        String s = "";
        this.dialog.inputFileHandler.setTextFields(null, "", "");
        this.saveFileHandler.setTextFields(null, "", "");
        this.clearSelected(false);
        if (textBox == this.jtNIHInput) {
            if (model.startsWith("!")) {
                this.dialog.runScriptQueued(model.substring(1));
                return;
            }
            this.dialog.modelOrigin = 1;
            this.notFromNBO = true;
            if ("$:=".indexOf(model.charAt(0)) < 0) {
                model = "$" + model;
            }
            if (model.startsWith("=")) {
                switch (model.length()) {
                    case 5: {
                        break;
                    }
                    case 4: {
                        model = "=" + model;
                        break;
                    }
                    default: {
                        if (model.indexOf("/") >= 0) break;
                        this.dialog.logError("PDB codes must be of the form XXX for ligands and XXXX for standard PDB entries.");
                    }
                }
            }
            this.jtLineFormula.setText("");
            this.saveFileHandler.setTextFields(null, model, "mol");
            this.dialog.logCmd("get " + model);
            this.dialog.iAmLoading = true;
            if (this.dialog.loadModelFileNow(model) == null) {
                if ((model = (model.charAt(0) == ':' ? "$" : ":") + model.substring(1)).startsWith("$=")) {
                    this.dialog.logError("RCSB does not recognize ligand code " + model.substring(2) + ".");
                    this.dialog.iAmLoading = false;
                    return;
                }
                this.dialog.logCmd("get " + model);
                if (this.dialog.loadModelFileNow(model) == null) {
                    this.dialog.logError("Neither NIH/CIR nor PubChem have recognize this identifier.");
                    this.notFromNBO = false;
                    this.dialog.iAmLoading = false;
                }
            }
        } else {
            this.dialog.modelOrigin = 2;
            SB sb = new SB();
            this.jtNIHInput.setText("");
            s = "show " + model;
            this.saveFileHandler.setTextFields(null, "line", "mol");
            NBOUtil.postAddCmd(sb, s);
            this.dialog.logCmd(s);
            this.postNBO(sb, 31, "model from line input...", null, null);
        }
    }

    protected void loadModelToNBO(String s, boolean undoRedo) {
        boolean alsoLoadJmol = true;
        if (s == null) {
            s = this.dialog.getCFIData();
            alsoLoadJmol = false;
        }
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", this.dialog.nboService.getServerPath(null) + "/");
        NBOUtil.postAddGlobalC(sb, "ESS", "c");
        NBOUtil.postAddGlobalC(sb, "FNAME", "jmol_outfile");
        NBOUtil.postAddGlobalC(sb, "IN_EXT", "cfi");
        NBOUtil.postAddCmd(sb, "use");
        this.postNBO(sb, undoRedo ? 61 : 51, (alsoLoadJmol ? "Loading" : "Sending") + " model to NB", "jmol_outfile.cfi", s);
    }

    protected void loadModelFromNBO(String path, String fname, String ext) {
        if (PT.isOneOf(ext, ";xyz;mol;")) {
            this.notFromNBO = true;
            this.dialog.runScriptQueued("set refreshing false");
            this.dialog.loadModelFileQueued(new File(path + "\\" + fname + "." + ext), false);
            this.dialog.runScriptQueued("set refreshing true");
            return;
        }
        String ess = NBOFileHandler.getEss(ext, null);
        SB sb = new SB();
        if (this.jtNIHInput != null) {
            this.jtNIHInput.setText("");
            this.jtLineFormula.setText("");
        }
        this.dialog.modelOrigin = 3;
        NBOUtil.postAddGlobalC(sb, "PATH", path);
        NBOUtil.postAddGlobalC(sb, "ESS", ess);
        NBOUtil.postAddGlobalC(sb, "FNAME", fname);
        NBOUtil.postAddGlobalC(sb, "IN_EXT", ext.toLowerCase());
        NBOUtil.postAddCmd(sb, "use");
        this.clearSelected(false);
        this.dialog.logCmd("use." + ess + " " + fname + "." + ext);
        this.postNBO(sb, 31, "Loading model from NBO...", null, null);
    }

    protected void saveModel(String path, String fname, String ext) {
        if (PT.isOneOf(ext, ";xyz;mol;")) {
            String s = this.vwr.getModelExtract("1.1", false, false, ext.toUpperCase());
            String ret = this.vwr.writeTextFile(path + "\\" + fname + "." + ext, s);
            this.dialog.logValue(ret);
            return;
        }
        String ess = NBOFileHandler.getEss(ext, (String)this.jComboSave.getSelectedItem());
        SB sb = new SB();
        NBOUtil.postAddGlobalC(sb, "PATH", path);
        NBOUtil.postAddGlobalC(sb, "ESS", ess);
        NBOUtil.postAddGlobalC(sb, "FNAME", fname);
        NBOUtil.postAddGlobalC(sb, "OUT_EXT", ext);
        NBOUtil.postAddCmd(sb, "save");
        this.postNBO(sb, 41, "Saving model...", null, null);
        this.dialog.logCmd("save." + ess + " " + fname);
        this.dialog.logValue("--Model Saved--<br>" + path + "\\" + fname + "." + ext);
    }

    protected void notifyPick(int[] picked) {
        this.dialog.runScriptQueued("measure delete;" + (this.resetOnAtomClick ? "select none" : ""));
        if (this.resetOnAtomClick) {
            this.clearSelected(false);
        }
        this.resetOnAtomClick = false;
        if (this.boxCount == 0) {
            return;
        }
        String selected = " " + this.modelEditGetSelected() + " ";
        int at1 = picked[0];
        int at2 = picked[1];
        if (at2 == Integer.MIN_VALUE) {
            boolean isSelected = this.vwr.bsA().get(at1 - 1);
            if (isSelected) {
                selected = PT.rep(selected, " " + at1 + " ", " ").trim();
            } else {
                if (PT.getTokens(selected).length >= this.boxCount) {
                    this.clearSelected(true);
                    selected = "";
                }
                selected = selected + " " + at1;
            }
            this.doSetAtomBoxesFromSelection(selected, true);
        } else {
            if (this.boxCount != 2) {
                return;
            }
            this.clearSelected(true);
            this.notifyPick(new int[]{at1, Integer.MIN_VALUE});
            this.notifyPick(new int[]{at2, Integer.MIN_VALUE});
        }
    }

    protected void doSetAtomBoxesFromSelection(String selected, boolean setFocus) {
        if (selected == null) {
            selected = this.modelEditGetSelected();
        }
        String[] split = PT.getTokens(selected);
        for (int i = 0; i < this.atomNumBoxes.length; ++i) {
            this.atomNumBoxes[i].setText(i >= split.length ? "" : "  " + split[i]);
        }
        this.updateSelected(false, setFocus);
    }

    private void setCurrentValue(String sval) {
        this.txtCurrVal.setText(sval.length() == 0 ? "pick atoms..." : "current value: " + sval);
    }

    protected void notifyFileLoaded() {
        String fileContents = this.dialog.getCFIData();
        if (this.notFromNBO) {
            this.notFromNBO = false;
            this.loadModelToNBO(fileContents, false);
            return;
        }
        this.dialog.runScriptQueued(";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;");
        this.dialog.doSetStructure(null);
        this.showComponents(true);
        this.innerEditBox.setVisible(true);
        if (this.vwr.ms.ac > 0 && fileContents != null) {
            this.undoStack.push(fileContents);
            if (this.undoStack.size() > 5) {
                this.undoStack.removeElementAt(0);
            }
        }
        this.undo.setEnabled(this.undoStack.size() > 1);
        this.redo.setEnabled(!this.redoStack.isEmpty());
        this.btnRebond.setEnabled(this.dialog.evaluateJmolString("{transitionMetal}").length() > 4);
        if (this.actionID == 4) {
            this.doModelAction(this.actionID);
        }
        if (this.showSelectedOnFileLoad) {
            this.updateSelected(false, true);
            this.showSelectedOnFileLoad = false;
        } else {
            this.dialog.runScriptQueued("select none; select on;refresh");
        }
    }

    private void postNBO(SB sb, final int mode, String statusMessage, String fileName, String fileData) {
        final NBORequest req = new NBORequest();
        req.set(1, new Runnable(){

            @Override
            public void run() {
                NBOModel.this.processNBO(mode, req);
            }
        }, false, statusMessage, "m_cmd.txt", sb.toString(), fileName, fileData);
        this.dialog.nboService.postToNBO(req);
    }

    protected void processNBO(int mode, NBORequest req) {
        String s = req.getReply();
        boolean doClear = true;
        switch (mode) {
            case 0: {
                this.dialog.runScriptQueued("z = show('zoom');set refreshing false;x = {*}.xyz.all;load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";compare {*} @x rotate translate 0;script inline @z;set refreshing true");
                break;
            }
            case 6: 
            case 9: {
                doClear = false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 21: 
            case 31: {
                if (s.length() == 0) {
                    this.dialog.logError("Return message from NBOServe was empty.");
                    return;
                }
                s = s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;";
                s = ";load " + s;
                if (doClear) {
                    this.clearSelected(false);
                } else {
                    this.showSelectedOnFileLoad = true;
                }
                this.dialog.loadModelDataQueued(s);
                break;
            }
            case 41: {
                break;
            }
            case 51: {
                s = "load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true;";
                this.dialog.loadModelDataQueued(s);
                break;
            }
            case 61: {
                this.dialog.loadModelDataQueued(s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;");
                break;
            }
            case 7: {
                String sval = s.trim();
                this.dialog.logValue(sval);
                this.setCurrentValue(sval);
                break;
            }
            case 11: {
                this.measures = "";
                this.processHBonds(s);
                break;
            }
            case 10: {
                String symmetry = s.substring(0, s.indexOf("\n"));
                this.dialog.logValue(symmetry);
                s = s.substring(s.indexOf("\n") + 1);
                s = "set refreshing false;load " + s + ";set fontscaling true;select _H; font label 10 arial plain 0.025;select !_H;font label 10 arial bold 0.025;select none;" + ";set refreshing true";
                this.showSelectedOnFileLoad = true;
                this.dialog.loadModelDataQueued(s);
            }
        }
    }

    private void processHBonds(String s) {
        float[] atomList = PT.parseFloatArray(s);
        if (atomList.length == 0 || atomList[0] == 0.0f) {
            return;
        }
        String script = "";
        for (int i = atomList.length % 2; i < atomList.length; i += 2) {
            int a1 = (int)atomList[i];
            int a2 = (int)atomList[i + 1];
            String a1a2 = " @" + a1 + " @" + a2;
            script = script + "measure ID m" + ("" + Math.random()).substring(2) + a1a2 + " radius 0.1 ' ';";
            this.dialog.logValue(this.dialog.evaluateJmolString("@" + a1 + ".atomName + " + "'-' + @" + a2 + ".atomName + ' d='+ distance(" + a1a2 + ")"));
        }
        this.measures = this.measures + script;
        this.dialog.runScriptQueued(this.measures);
    }

    @Override
    public void acceptFile(int mode, String dir, String name, String ext, String labelText) {
        this.setOpenSaveExtensionCombo(mode, ext, labelText);
        switch (mode) {
            case 1: {
                this.loadModelFromNBO(dir, name, ext);
                break;
            }
            case 5: {
                this.saveModel(dir, name, ext);
            }
        }
    }

    private void setOpenSaveExtensionCombo(int mode, String ext, String labelText) {
        if (labelText == null) {
            labelText = "[." + ext + "]";
        }
        JComboBox<String> combo = mode == 1 ? this.jComboOpen : this.jComboSave;
        int n = combo.getModel().getSize();
        for (int i = 0; i < n; ++i) {
            String label = combo.getItemAt(i);
            if (label.indexOf(labelText) < 0) continue;
            combo.setSelectedIndex(i);
            return;
        }
    }

    @Override
    public String getDefaultFilterOption() {
        String option = this.jComboSave.getSelectedIndex() < 1 ? "cfi" : this.jComboSave.getSelectedItem().toString();
        int pt = option.indexOf("[");
        if (pt >= 0) {
            option = option.substring(0, pt).trim();
        }
        return option;
    }
}

