/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class ChangesetDataSet {
    private final Map<PrimitiveId, HistoryOsmPrimitive> primitives = new HashMap<PrimitiveId, HistoryOsmPrimitive>();
    private final Map<PrimitiveId, ChangesetModificationType> modificationTypes = new HashMap<PrimitiveId, ChangesetModificationType>();

    public void put(HistoryOsmPrimitive primitive, ChangesetModificationType cmt) {
        CheckParameterUtil.ensureParameterNotNull(primitive, "primitive");
        CheckParameterUtil.ensureParameterNotNull((Object)cmt, "cmt");
        this.primitives.put(primitive.getPrimitiveId(), primitive);
        this.modificationTypes.put(primitive.getPrimitiveId(), cmt);
    }

    public boolean contains(PrimitiveId id) {
        if (id == null) {
            return false;
        }
        return this.primitives.containsKey(id);
    }

    public ChangesetModificationType getModificationType(PrimitiveId id) {
        if (!this.contains(id)) {
            return null;
        }
        return this.modificationTypes.get(id);
    }

    public boolean isCreated(PrimitiveId id) {
        if (!this.contains(id)) {
            return false;
        }
        return ChangesetModificationType.CREATED.equals((Object)this.getModificationType(id));
    }

    public boolean isUpdated(PrimitiveId id) {
        if (!this.contains(id)) {
            return false;
        }
        return ChangesetModificationType.UPDATED.equals((Object)this.getModificationType(id));
    }

    public boolean isDeleted(PrimitiveId id) {
        if (!this.contains(id)) {
            return false;
        }
        return ChangesetModificationType.DELETED.equals((Object)this.getModificationType(id));
    }

    public Set<HistoryOsmPrimitive> getPrimitivesByModificationType(ChangesetModificationType cmt) {
        CheckParameterUtil.ensureParameterNotNull((Object)cmt, "cmt");
        return this.modificationTypes.entrySet().stream().filter(entry -> ((ChangesetModificationType)((Object)((Object)entry.getValue()))).equals((Object)cmt)).map(entry -> this.primitives.get(entry.getKey())).collect(Collectors.toSet());
    }

    public int size() {
        return this.primitives.size();
    }

    public HistoryOsmPrimitive getPrimitive(PrimitiveId id) {
        if (id == null) {
            return null;
        }
        return this.primitives.get(id);
    }

    public Iterator<ChangesetDataSetEntry> iterator() {
        return new DefaultIterator();
    }

    private class DefaultIterator
    implements Iterator<ChangesetDataSetEntry> {
        private final Iterator<Map.Entry<PrimitiveId, ChangesetModificationType>> typeIterator;

        DefaultIterator() {
            this.typeIterator = ChangesetDataSet.this.modificationTypes.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.typeIterator.hasNext();
        }

        @Override
        public ChangesetDataSetEntry next() {
            Map.Entry<PrimitiveId, ChangesetModificationType> next = this.typeIterator.next();
            return new DefaultChangesetDataSetEntry(next.getValue(), (HistoryOsmPrimitive)ChangesetDataSet.this.primitives.get(next.getKey()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class DefaultChangesetDataSetEntry
    implements ChangesetDataSetEntry {
        private final ChangesetModificationType modificationType;
        private final HistoryOsmPrimitive primitive;

        DefaultChangesetDataSetEntry(ChangesetModificationType modificationType, HistoryOsmPrimitive primitive) {
            this.modificationType = modificationType;
            this.primitive = primitive;
        }

        @Override
        public ChangesetModificationType getModificationType() {
            return this.modificationType;
        }

        @Override
        public HistoryOsmPrimitive getPrimitive() {
            return this.primitive;
        }
    }

    public static interface ChangesetDataSetEntry {
        public ChangesetModificationType getModificationType();

        public HistoryOsmPrimitive getPrimitive();
    }

    public static enum ChangesetModificationType {
        CREATED,
        UPDATED,
        DELETED;

    }
}

