/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;

public class SideButton
extends JButton
implements Destroyable {
    private transient PropertyChangeListener propertyChangeListener;

    public SideButton(Action action) {
        super(action);
        ImageResource icon = (ImageResource)action.getValue("ImageResource");
        if (icon == null) {
            throw new IllegalArgumentException("No icon provided");
        }
        this.setIcon(icon.getImageIconBounded(ImageProvider.ImageSizes.SIDEBUTTON.getImageDimension()));
        this.doStyle();
    }

    public SideButton(Action action, boolean usename) {
        this(action);
        if (!usename) {
            this.setText(null);
        }
    }

    public SideButton(Action action, String imagename) {
        super(action);
        this.setIcon(ImageProvider.get("dialogs", imagename, ImageProvider.ImageSizes.SIDEBUTTON));
        this.doStyle();
    }

    private void doStyle() {
        this.setLayout(new BorderLayout());
        this.setIconTextGap(2);
        this.setMargin(new Insets(0, 0, 0, 0));
    }

    public BasicArrowButton createArrow(ActionListener listener) {
        this.setMargin(new Insets(0, 0, 0, 0));
        BasicArrowButton arrowButton = new BasicArrowButton(5, null, null, Color.BLACK, null);
        arrowButton.setBorder(BorderFactory.createEmptyBorder());
        this.add((Component)arrowButton, "East");
        arrowButton.addActionListener(listener);
        return arrowButton;
    }

    @Override
    public void destroy() {
        Action action = this.getAction();
        if (action instanceof Destroyable) {
            ((Destroyable)((Object)action)).destroy();
        }
        if (action != null) {
            if (this.propertyChangeListener != null) {
                action.removePropertyChangeListener(this.propertyChangeListener);
            }
            this.setAction(null);
        }
    }
}

