/*
 * Decompiled with CFR 0.152.
 */
package org.joni.ast;

import org.jcodings.CodeRange;
import org.jcodings.Encoding;
import org.jcodings.IntHolder;
import org.joni.BitSet;
import org.joni.CodeRangeBuffer;
import org.joni.ScanEnvironment;
import org.joni.ast.Node;
import org.joni.exception.InternalException;
import org.joni.exception.SyntaxException;
import org.joni.exception.ValueException;

public final class CClassNode
extends Node {
    private static final int FLAG_NCCLASS_NOT = 1;
    private int flags;
    public final BitSet bs = new BitSet();
    public CodeRangeBuffer mbuf;

    public CClassNode() {
        super(1);
    }

    public void clear() {
        this.bs.clear();
        this.flags = 0;
        this.mbuf = null;
    }

    public String getName() {
        return "Character Class";
    }

    public String toString(int level2) {
        StringBuilder value2 = new StringBuilder();
        value2.append("\n  flags: " + this.flagsToString());
        value2.append("\n  bs: " + CClassNode.pad(this.bs, level2 + 1));
        value2.append("\n  mbuf: " + CClassNode.pad(this.mbuf, level2 + 1));
        return value2.toString();
    }

    public String flagsToString() {
        StringBuilder flags2 = new StringBuilder();
        if (this.isNot()) {
            flags2.append("NOT ");
        }
        return flags2.toString();
    }

    public boolean isEmpty() {
        return this.mbuf == null && this.bs.isEmpty();
    }

    void addCodeRangeToBuf(ScanEnvironment env, int from, int to) {
        this.addCodeRangeToBuf(env, from, to, true);
    }

    void addCodeRangeToBuf(ScanEnvironment env, int from, int to, boolean checkDup) {
        this.mbuf = CodeRangeBuffer.addCodeRangeToBuff(this.mbuf, env, from, to, checkDup);
    }

    public void addCodeRange(ScanEnvironment env, int from, int to) {
        this.addCodeRange(env, from, to, true);
    }

    public void addCodeRange(ScanEnvironment env, int from, int to, boolean checkDup) {
        this.mbuf = CodeRangeBuffer.addCodeRange(this.mbuf, env, from, to, checkDup);
    }

    void addAllMultiByteRange(ScanEnvironment env) {
        this.mbuf = CodeRangeBuffer.addAllMultiByteRange(env, this.mbuf);
    }

    public void clearNotFlag(ScanEnvironment env) {
        if (this.isNot()) {
            this.bs.invert();
            if (!env.enc.isSingleByte()) {
                this.mbuf = CodeRangeBuffer.notCodeRangeBuff(env, this.mbuf);
            }
            this.clearNot();
        }
    }

    public int isOneChar() {
        if (this.isNot()) {
            return -1;
        }
        int c = -1;
        if (this.mbuf != null) {
            int[] range = this.mbuf.getCodeRange();
            c = range[1];
            if (range[0] == 1 && c == range[2]) {
                if (c < 256 && this.bs.at(c)) {
                    c = -1;
                }
            } else {
                return -1;
            }
        }
        for (int i2 = 0; i2 < 8; ++i2) {
            int b1 = this.bs.bits[i2];
            if (b1 == 0) continue;
            if ((b1 & b1 - 1) == 0 && c == -1) {
                c = 32 * i2 + Integer.bitCount(b1 - 1);
                continue;
            }
            return -1;
        }
        return c;
    }

    public void and(CClassNode other, ScanEnvironment env) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.and(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        CodeRangeBuffer pbuf = null;
        if (!env.enc.isSingleByte()) {
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(env, buf1, false, buf2, false);
            } else {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, not1, buf2, not2, env);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(env, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void or(CClassNode other, ScanEnvironment env) {
        boolean not1 = this.isNot();
        BitSet bsr1 = this.bs;
        CodeRangeBuffer buf1 = this.mbuf;
        boolean not2 = other.isNot();
        BitSet bsr2 = other.bs;
        CodeRangeBuffer buf2 = other.mbuf;
        if (not1) {
            BitSet bs1 = new BitSet();
            bsr1.invertTo(bs1);
            bsr1 = bs1;
        }
        if (not2) {
            BitSet bs2 = new BitSet();
            bsr2.invertTo(bs2);
            bsr2 = bs2;
        }
        bsr1.or(bsr2);
        if (bsr1 != this.bs) {
            this.bs.copy(bsr1);
            bsr1 = this.bs;
        }
        if (not1) {
            this.bs.invert();
        }
        if (!env.enc.isSingleByte()) {
            CodeRangeBuffer pbuf = null;
            if (not1 && not2) {
                pbuf = CodeRangeBuffer.andCodeRangeBuff(buf1, false, buf2, false, env);
            } else {
                pbuf = CodeRangeBuffer.orCodeRangeBuff(env, buf1, not1, buf2, not2);
                if (not1) {
                    pbuf = CodeRangeBuffer.notCodeRangeBuff(env, pbuf);
                }
            }
            this.mbuf = pbuf;
        }
    }

    public void addCTypeByRange(int ctype, boolean not, ScanEnvironment env, int sbOut, int[] mbr) {
        int n = mbr[0];
        if (!not) {
            int i2;
            for (i2 = 0; i2 < n; ++i2) {
                for (int j = CClassNode.CR_FROM(mbr, i2); j <= CClassNode.CR_TO(mbr, i2); ++j) {
                    if (j >= sbOut) {
                        if (j > CClassNode.CR_FROM(mbr, i2)) {
                            this.addCodeRangeToBuf(env, j, CClassNode.CR_TO(mbr, i2));
                            ++i2;
                        }
                        while (i2 < n) {
                            this.addCodeRangeToBuf(env, CClassNode.CR_FROM(mbr, i2), CClassNode.CR_TO(mbr, i2));
                            ++i2;
                        }
                        return;
                    }
                    this.bs.set(env, j);
                }
            }
            while (i2 < n) {
                this.addCodeRangeToBuf(env, CClassNode.CR_FROM(mbr, i2), CClassNode.CR_TO(mbr, i2));
                ++i2;
            }
        } else {
            int j;
            int i3;
            int prev = 0;
            for (i3 = 0; i3 < n; ++i3) {
                for (j = prev; j < CClassNode.CR_FROM(mbr, i3); ++j) {
                    if (j >= sbOut) {
                        prev = sbOut;
                        for (i3 = 0; i3 < n; ++i3) {
                            if (prev < CClassNode.CR_FROM(mbr, i3)) {
                                this.addCodeRangeToBuf(env, prev, CClassNode.CR_FROM(mbr, i3) - 1);
                            }
                            prev = CClassNode.CR_TO(mbr, i3) + 1;
                        }
                        if (prev < Integer.MAX_VALUE) {
                            this.addCodeRangeToBuf(env, prev, Integer.MAX_VALUE);
                        }
                        return;
                    }
                    this.bs.set(env, j);
                }
                prev = CClassNode.CR_TO(mbr, i3) + 1;
            }
            for (j = prev; j < sbOut; ++j) {
                this.bs.set(env, j);
            }
            prev = sbOut;
            for (i3 = 0; i3 < n; ++i3) {
                if (prev < CClassNode.CR_FROM(mbr, i3)) {
                    this.addCodeRangeToBuf(env, prev, CClassNode.CR_FROM(mbr, i3) - 1);
                }
                prev = CClassNode.CR_TO(mbr, i3) + 1;
            }
            if (prev < Integer.MAX_VALUE) {
                this.addCodeRangeToBuf(env, prev, Integer.MAX_VALUE);
            }
        }
    }

    private static int CR_FROM(int[] range, int i2) {
        return range[i2 * 2 + 1];
    }

    private static int CR_TO(int[] range, int i2) {
        return range[i2 * 2 + 2];
    }

    public void addCType(int ctype, boolean not, boolean asciiRange, ScanEnvironment env, IntHolder sbOut) {
        Encoding enc = env.enc;
        int[] ranges = enc.ctypeCodeRange(ctype, sbOut);
        if (ranges != null) {
            if (asciiRange) {
                CClassNode ccWork = new CClassNode();
                ccWork.addCTypeByRange(ctype, not, env, sbOut.value, ranges);
                if (not) {
                    ccWork.addCodeRangeToBuf(env, 128, Integer.MAX_VALUE, false);
                } else {
                    CClassNode ccAscii = new CClassNode();
                    if (enc.minLength() > 1) {
                        ccAscii.addCodeRangeToBuf(env, 0, 127);
                    } else {
                        ccAscii.bs.setRange(env, 0, 127);
                    }
                    ccWork.and(ccAscii, env);
                }
                this.or(ccWork, env);
            } else {
                this.addCTypeByRange(ctype, not, env, sbOut.value, ranges);
            }
            return;
        }
        int maxCode = asciiRange ? 128 : 256;
        switch (ctype) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype)) continue;
                        this.bs.set(env, c);
                    }
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(env, c);
                }
                break;
            }
            case 5: 
            case 7: {
                if (not) {
                    for (int c = 0; c < 256; ++c) {
                        if (enc.isCodeCType(c, ctype) && c < maxCode) continue;
                        this.bs.set(env, c);
                    }
                    if (!asciiRange) break;
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < maxCode; ++c) {
                    if (!enc.isCodeCType(c, ctype)) continue;
                    this.bs.set(env, c);
                }
                if (asciiRange) break;
                this.addAllMultiByteRange(env);
                break;
            }
            case 12: {
                if (!not) {
                    for (int c = 0; c < maxCode; ++c) {
                        if (!enc.isSbWord(c)) continue;
                        this.bs.set(env, c);
                    }
                    if (asciiRange) break;
                    this.addAllMultiByteRange(env);
                    break;
                }
                for (int c = 0; c < 256; ++c) {
                    if (enc.codeToMbcLength(c) <= 0 || enc.isWord(c) || c >= maxCode) continue;
                    this.bs.set(env, c);
                }
                if (!asciiRange) break;
                this.addAllMultiByteRange(env);
                break;
            }
            default: {
                throw new InternalException("internal parser error (bug)");
            }
        }
    }

    public void nextStateClass(CCStateArg arg2, CClassNode ascCC, ScanEnvironment env) {
        if (arg2.state == CCSTATE.RANGE) {
            throw new SyntaxException("char-class value at end of range");
        }
        if (arg2.state == CCSTATE.VALUE && arg2.type != CCVALTYPE.CLASS) {
            if (arg2.type == CCVALTYPE.SB) {
                this.bs.set(env, arg2.from);
                if (ascCC != null) {
                    ascCC.bs.set(arg2.from);
                }
            } else if (arg2.type == CCVALTYPE.CODE_POINT) {
                this.addCodeRange(env, arg2.from, arg2.from);
                if (ascCC != null) {
                    ascCC.addCodeRange(env, arg2.from, arg2.from, false);
                }
            }
        }
        arg2.state = CCSTATE.VALUE;
        arg2.type = CCVALTYPE.CLASS;
    }

    public void nextStateValue(CCStateArg arg2, CClassNode ascCc, ScanEnvironment env) {
        switch (arg2.state) {
            case VALUE: {
                if (arg2.type == CCVALTYPE.SB) {
                    this.bs.set(env, arg2.from);
                    if (ascCc == null) break;
                    ascCc.bs.set(arg2.from);
                    break;
                }
                if (arg2.type != CCVALTYPE.CODE_POINT) break;
                this.addCodeRange(env, arg2.from, arg2.from);
                if (ascCc == null) break;
                ascCc.addCodeRange(env, arg2.from, arg2.from, false);
                break;
            }
            case RANGE: {
                if (arg2.inType == arg2.type) {
                    if (arg2.inType == CCVALTYPE.SB) {
                        if (arg2.from > 255 || arg2.to > 255) {
                            throw new ValueException("invalid code point value");
                        }
                        if (arg2.from > arg2.to) {
                            if (env.syntax.allowEmptyRangeInCC()) {
                                arg2.state = CCSTATE.COMPLETE;
                                break;
                            }
                            throw new ValueException("empty range in char class");
                        }
                        this.bs.setRange(env, arg2.from, arg2.to);
                        if (ascCc != null) {
                            ascCc.bs.setRange(null, arg2.from, arg2.to);
                        }
                    } else {
                        this.addCodeRange(env, arg2.from, arg2.to);
                        if (ascCc != null) {
                            ascCc.addCodeRange(env, arg2.from, arg2.to, false);
                        }
                    }
                } else {
                    if (arg2.from > arg2.to) {
                        if (env.syntax.allowEmptyRangeInCC()) {
                            arg2.state = CCSTATE.COMPLETE;
                            break;
                        }
                        throw new ValueException("empty range in char class");
                    }
                    this.bs.setRange(env, arg2.from, arg2.to < 255 ? arg2.to : 255);
                    this.addCodeRange(env, arg2.from, arg2.to);
                    if (ascCc != null) {
                        ascCc.bs.setRange(null, arg2.from, arg2.to < 255 ? arg2.to : 255);
                        ascCc.addCodeRange(env, arg2.from, arg2.to, false);
                    }
                }
                arg2.state = CCSTATE.COMPLETE;
                break;
            }
            case COMPLETE: 
            case START: {
                arg2.state = CCSTATE.VALUE;
                break;
            }
        }
        arg2.fromIsRaw = arg2.toIsRaw;
        arg2.from = arg2.to;
        arg2.type = arg2.inType;
    }

    boolean isCodeInCCLength(int encLength, int code) {
        boolean found = encLength > 1 || code >= 256 ? (this.mbuf == null ? false : CodeRange.isInCodeRange(this.mbuf.getCodeRange(), code)) : this.bs.at(code);
        if (this.isNot()) {
            return !found;
        }
        return found;
    }

    public boolean isCodeInCC(Encoding enc, int code) {
        int len = enc.minLength() > 1 ? 2 : enc.codeToMbcLength(code);
        return this.isCodeInCCLength(len, code);
    }

    public void setNot() {
        this.flags |= 1;
    }

    public void clearNot() {
        this.flags &= 0xFFFFFFFE;
    }

    public boolean isNot() {
        return (this.flags & 1) != 0;
    }

    public static final class CCStateArg {
        public int from;
        public int to;
        public boolean fromIsRaw;
        public boolean toIsRaw;
        public CCVALTYPE inType;
        public CCVALTYPE type;
        public CCSTATE state;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CCSTATE {
        VALUE,
        RANGE,
        COMPLETE,
        START;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CCVALTYPE {
        SB,
        CODE_POINT,
        CLASS;

    }
}

