/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.containers;

import com.intellij.openapi.util.Condition;
import com.intellij.reference.SoftReference;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class UnsafeWeakList<T>
extends AbstractCollection<T> {
    protected final List<MyReference<T>> myList;
    private final ReferenceQueue<T> myQueue = new ReferenceQueue();
    private int myAlive;
    private int modCount;
    private static final Function<MyReference<Object>, Object> DEREF = new Function<MyReference<Object>, Object>(){

        @Override
        public Object fun(MyReference<Object> reference) {
            return SoftReference.dereference(reference);
        }
    };
    private static final Condition<MyReference<Object>> NOT_NULL = new Condition<MyReference<Object>>(){

        @Override
        public boolean value(MyReference<Object> reference) {
            return SoftReference.dereference(reference) != null;
        }
    };

    public UnsafeWeakList() {
        this.myList = new ArrayList<MyReference<T>>();
    }

    boolean processQueue() {
        MyReference reference;
        boolean processed = false;
        while ((reference = (MyReference)this.myQueue.poll()) != null) {
            int index2 = reference.index;
            if (index2 < this.myList.size() && reference == this.myList.get(index2)) {
                this.nullizeAt(index2);
            }
            processed = true;
        }
        if (this.myAlive < this.myList.size() / 2) {
            this.reduceCapacity();
        }
        return processed;
    }

    private void nullizeAt(int index2) {
        this.myList.set(index2, null);
        --this.myAlive;
    }

    private void reduceCapacity() {
        int toSaveAlive = 0;
        for (int i = 0; i < this.myList.size(); ++i) {
            MyReference<T> reference = this.myList.get(i);
            if (reference == null) continue;
            Object t = reference.get();
            if (t == null) {
                --this.myAlive;
                continue;
            }
            if (toSaveAlive != i) {
                this.myList.set(toSaveAlive, new MyReference(toSaveAlive, t, this.myQueue));
            }
            ++toSaveAlive;
        }
        if (toSaveAlive != this.myList.size()) {
            this.myList.subList(toSaveAlive, this.myList.size()).clear();
            ++this.modCount;
        }
        this.myAlive = toSaveAlive;
    }

    private void append(@NotNull T element) {
        if (element == null) {
            UnsafeWeakList.$$$reportNull$$$0(0);
        }
        this.myList.add(new MyReference(this.myList.size(), element, this.myQueue));
        ++this.myAlive;
        ++this.modCount;
    }

    @Override
    public boolean add(@NotNull T element) {
        if (element == null) {
            UnsafeWeakList.$$$reportNull$$$0(1);
        }
        this.processQueue();
        this.append(element);
        return true;
    }

    @Override
    public void clear() {
        this.processQueue();
        this.myList.clear();
        this.myAlive = 0;
        ++this.modCount;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        MyIterator myIterator = new MyIterator();
        if (myIterator == null) {
            UnsafeWeakList.$$$reportNull$$$0(3);
        }
        return myIterator;
    }

    @Override
    public boolean remove(@NotNull Object o) {
        if (o == null) {
            UnsafeWeakList.$$$reportNull$$$0(4);
        }
        this.processQueue();
        for (int i = 0; i < this.myList.size(); ++i) {
            Object t = SoftReference.dereference(this.myList.get(i));
            if (t == null || !t.equals(o)) continue;
            this.nullizeAt(i);
            ++this.modCount;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            UnsafeWeakList.$$$reportNull$$$0(5);
        }
        this.processQueue();
        return super.addAll(c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            UnsafeWeakList.$$$reportNull$$$0(6);
        }
        this.processQueue();
        return super.removeAll(c);
    }

    private static <X> Function<MyReference<X>, X> deref() {
        return DEREF;
    }

    @NotNull
    public List<T> toStrongList() {
        List list2 = ContainerUtil.mapNotNull(this.myList, UnsafeWeakList.deref());
        if (list2 == null) {
            UnsafeWeakList.$$$reportNull$$$0(7);
        }
        return list2;
    }

    @Override
    @Deprecated
    public int size() {
        UnsafeWeakList.throwNotAllowedException();
        return -1;
    }

    private static void throwNotAllowedException() {
        throw new IncorrectOperationException("index/size-based operations in UnsafeWeakList are not supported because they don't make sense in the presence of weak references. Use .iterator() (which retains its elements to avoid sudden GC) instead.");
    }

    @Override
    public boolean isEmpty() {
        if (this.myList.isEmpty()) {
            return true;
        }
        Condition<MyReference<T>> notNull = UnsafeWeakList.notNull();
        return ContainerUtil.find(this.myList, notNull) == null;
    }

    private static <T> Condition<MyReference<T>> notNull() {
        return NOT_NULL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/containers/UnsafeWeakList";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "toStrongList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIfAbsent";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyIterator
    implements Iterator<T> {
        private final int startModCount;
        private int curIndex;
        private T curElement;
        private int nextIndex = -1;
        private T nextElement;
        private boolean modified;

        private MyIterator() {
            this.startModCount = UnsafeWeakList.this.modCount;
            this.findNext();
        }

        private void findNext() {
            if (UnsafeWeakList.this.modCount != this.startModCount) {
                throw new ConcurrentModificationException();
            }
            this.curIndex = this.nextIndex;
            this.curElement = this.nextElement;
            this.nextElement = null;
            this.nextIndex = -1;
            for (int i = this.curIndex + 1; i < UnsafeWeakList.this.myList.size(); ++i) {
                Object t = SoftReference.dereference(UnsafeWeakList.this.myList.get(i));
                if (t == null) continue;
                this.nextElement = t;
                this.nextIndex = i;
                break;
            }
            if (this.nextIndex == -1 && this.modified) {
                UnsafeWeakList.this.modCount++;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.findNext();
            return this.curElement;
        }

        @Override
        public void remove() {
            if (this.curElement == null) {
                throw new NoSuchElementException();
            }
            int index2 = this.curIndex;
            UnsafeWeakList.this.nullizeAt(index2);
            this.modified = true;
        }
    }

    private static class MyReference<T>
    extends WeakReference<T> {
        private final int index;

        private MyReference(int index2, T referent, ReferenceQueue<? super T> queue) {
            super(referent, queue);
            this.index = index2;
        }
    }
}

