/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.core.ui.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.coode.mdock.ComponentFactory;
import org.protege.editor.core.ui.view.View;
import org.protege.editor.core.ui.view.ViewComponent;
import org.protege.editor.core.ui.view.ViewComponentPlugin;
import org.protege.editor.core.ui.view.ViewComponentPluginAdapter;
import org.protege.editor.core.ui.view.ViewComponentPluginLoader;
import org.protege.editor.core.ui.workspace.Workspace;

public class ViewComponentFactory
implements ComponentFactory {
    private Workspace workspace;
    private ViewComponentPlugin emptyPlugin;

    public ViewComponentFactory(Workspace workspace) {
        this.workspace = workspace;
    }

    public JComponent createComponent(Map<String, String> properties) {
        String pluginId = properties.get("pluginId");
        ViewComponentPluginLoader loader = new ViewComponentPluginLoader(this.workspace);
        for (ViewComponentPlugin plugin : loader.getPlugins()) {
            if (!plugin.getId().equals(pluginId)) continue;
            return new View(plugin, this.workspace);
        }
        String msg = String.format("<html><body><div style='font-weight: bold; padding-bottom: 20px;'>This view could not be loaded because its content is provided by a view plugin that could not be found.</div><div style='padding-bottom: 20px;'>This problem may have been caused because the plugin is not installed or it may have been caused by incompatible changes to the plugin in question.</div><div>Please check that the relevant plugin is installed.  You can also try resetting the tab to its default state to see if this solves the issue.</div></body></html>", new Object[0]);
        return new View(this.getEmptyPlugin(pluginId, msg), this.workspace);
    }

    public ViewComponentPlugin getEmptyPlugin(final String pluginId, final String message) {
        if (this.emptyPlugin == null) {
            this.emptyPlugin = new ViewComponentPluginAdapter(){

                @Override
                public String getLabel() {
                    return pluginId;
                }

                @Override
                public Workspace getWorkspace() {
                    return ViewComponentFactory.this.workspace;
                }

                @Override
                public ViewComponent newInstance() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
                    return new ViewComponent(){

                        @Override
                        public void initialise() throws Exception {
                            this.setLayout(new BorderLayout());
                            JLabel msgLabel = new JLabel(message, 0);
                            msgLabel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
                            this.add((Component)msgLabel, "Center");
                        }

                        @Override
                        public void dispose() {
                        }
                    };
                }
            };
        }
        return this.emptyPlugin;
    }
}

