/*
 * Decompiled with CFR 0.152.
 */
package jogamp.opengl.util.glsl;

import com.jogamp.opengl.GL;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLArrayData;
import com.jogamp.opengl.GLException;
import com.jogamp.opengl.GLUniformData;
import com.jogamp.opengl.util.GLArrayDataServer;
import com.jogamp.opengl.util.PMVMatrix;
import com.jogamp.opengl.util.glsl.ShaderCode;
import com.jogamp.opengl.util.glsl.ShaderProgram;
import java.nio.FloatBuffer;

public class GLSLTextureRaster {
    private final boolean textureVertFlipped;
    private final int textureUnit;
    private ShaderProgram sp;
    private PMVMatrix pmvMatrix;
    private GLUniformData pmvMatrixUniform;
    private GLUniformData activeTexUniform;
    private GLArrayDataServer interleavedVBO;
    static final String shaderBasename = "texture01_xxx";
    static final String shaderSrcPath = "../../shader";
    static final String shaderBinPath = "../../shader/bin";
    private static final float[] s_quadVertices = new float[]{-1.0f, -1.0f, 0.0f, 1.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, 1.0f, 0.0f};
    private static final float[] s_quadTexCoords00 = new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f};
    private static final float[] s_quadTexCoords01 = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};

    public GLSLTextureRaster(int n, boolean bl) {
        this.textureVertFlipped = bl;
        this.textureUnit = n;
    }

    public int getTextureUnit() {
        return this.textureUnit;
    }

    public void init(GL2ES2 gL2ES2) {
        ShaderCode shaderCode = ShaderCode.create((GL2ES2)gL2ES2, (int)35633, this.getClass(), (String)shaderSrcPath, (String)shaderBinPath, (String)shaderBasename, (boolean)true);
        ShaderCode shaderCode2 = ShaderCode.create((GL2ES2)gL2ES2, (int)35632, this.getClass(), (String)shaderSrcPath, (String)shaderBinPath, (String)shaderBasename, (boolean)true);
        shaderCode.defaultShaderCustomization(gL2ES2, true, true);
        shaderCode2.defaultShaderCustomization(gL2ES2, true, true);
        this.sp = new ShaderProgram();
        this.sp.add(shaderCode);
        this.sp.add(shaderCode2);
        if (!this.sp.link(gL2ES2, System.err)) {
            throw new GLException("Couldn't link program: " + this.sp);
        }
        this.sp.useProgram(gL2ES2, true);
        this.pmvMatrix = new PMVMatrix();
        this.pmvMatrix.glMatrixMode(5889);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrix.glMatrixMode(5888);
        this.pmvMatrix.glLoadIdentity();
        this.pmvMatrixUniform = new GLUniformData("mgl_PMVMatrix", 4, 4, this.pmvMatrix.glGetPMvMatrixf());
        if (this.pmvMatrixUniform.setLocation(gL2ES2, this.sp.program()) < 0) {
            throw new GLException("Couldn't locate " + this.pmvMatrixUniform + " in shader: " + this.sp);
        }
        gL2ES2.glUniform(this.pmvMatrixUniform);
        this.activeTexUniform = new GLUniformData("mgl_Texture0", this.textureUnit);
        if (this.activeTexUniform.setLocation(gL2ES2, this.sp.program()) < 0) {
            throw new GLException("Couldn't locate " + this.activeTexUniform + " in shader: " + this.sp);
        }
        gL2ES2.glUniform(this.activeTexUniform);
        float[] fArray = this.textureVertFlipped ? s_quadTexCoords01 : s_quadTexCoords00;
        this.interleavedVBO = GLArrayDataServer.createGLSLInterleaved((int)5, (int)5126, (boolean)false, (int)8, (int)35044);
        GLArrayData gLArrayData = this.interleavedVBO.addGLSLSubArray("mgl_Vertex", 3, 34962);
        if (gLArrayData.setLocation(gL2ES2, this.sp.program()) < 0) {
            throw new GLException("Couldn't locate " + gLArrayData + " in shader: " + this.sp);
        }
        GLArrayData gLArrayData2 = this.interleavedVBO.addGLSLSubArray("mgl_MultiTexCoord", 2, 34962);
        if (gLArrayData2.setLocation(gL2ES2, this.sp.program()) < 0) {
            throw new GLException("Couldn't locate " + gLArrayData2 + " in shader: " + this.sp);
        }
        FloatBuffer floatBuffer = (FloatBuffer)this.interleavedVBO.getBuffer();
        for (int i = 0; i < 4; ++i) {
            floatBuffer.put(s_quadVertices, i * 3, 3);
            floatBuffer.put(fArray, i * 2, 2);
        }
        this.interleavedVBO.seal((GL)gL2ES2, true);
        this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
        this.sp.useProgram(gL2ES2, false);
    }

    public void reshape(GL2ES2 gL2ES2, int n, int n2, int n3, int n4) {
        if (null != this.sp) {
            this.pmvMatrix.glMatrixMode(5889);
            this.pmvMatrix.glLoadIdentity();
            this.pmvMatrix.glOrthof(-1.0f, 1.0f, -1.0f, 1.0f, 0.0f, 10.0f);
            this.pmvMatrix.glMatrixMode(5888);
            this.pmvMatrix.glLoadIdentity();
            this.sp.useProgram(gL2ES2, true);
            gL2ES2.glUniform(this.pmvMatrixUniform);
            this.sp.useProgram(gL2ES2, false);
        }
    }

    public void dispose(GL2ES2 gL2ES2) {
        if (null != this.pmvMatrixUniform) {
            this.pmvMatrixUniform = null;
        }
        this.pmvMatrix = null;
        if (null != this.interleavedVBO) {
            this.interleavedVBO.destroy((GL)gL2ES2);
            this.interleavedVBO = null;
        }
        if (null != this.sp) {
            this.sp.destroy(gL2ES2);
            this.sp = null;
        }
    }

    public void display(GL2ES2 gL2ES2) {
        if (null != this.sp) {
            this.sp.useProgram(gL2ES2, true);
            this.interleavedVBO.enableBuffer((GL)gL2ES2, true);
            gL2ES2.glDrawArrays(5, 0, 4);
            this.interleavedVBO.enableBuffer((GL)gL2ES2, false);
            this.sp.useProgram(gL2ES2, false);
        }
    }
}

