// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Glacier2_Session_h__
#define __Glacier2_Session_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Ice/BuiltinSequences.h>
#include <Ice/Identity.h>
#include <Glacier2/SSLInfo.h>
#include <IceUtil/UndefSysMacros.h>
#include <Glacier2/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef GLACIER2_API
#   if defined(ICE_STATIC_LIBS)
#       define GLACIER2_API /**/
#   elif defined(GLACIER2_API_EXPORTS)
#       define GLACIER2_API ICE_DECLSPEC_EXPORT
#   else
#       define GLACIER2_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Glacier2
{

class Session;
class SessionPrx;
class StringSet;
class StringSetPrx;
class IdentitySet;
class IdentitySetPrx;
class SessionControl;
class SessionControlPrx;
class SessionManager;
class SessionManagerPrx;
class SSLSessionManager;
class SSLSessionManagerPrx;

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) CannotCreateSessionException : public ::Ice::UserExceptionHelper<CannotCreateSessionException, ::Ice::UserException>
{
public:

    ICE_MEMBER(GLACIER2_API) virtual ~CannotCreateSessionException();

    CannotCreateSessionException(const CannotCreateSessionException&) = default;

    CannotCreateSessionException() = default;

    CannotCreateSessionException(const ::std::string& iceP_reason) :
        reason(::std::move(iceP_reason))
    {
    }

    std::tuple<const ::std::string&> ice_tuple() const
    {
        return std::tie(reason);
    }

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

    ::std::string reason;

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::SlicedData> ice_getSlicedData() const override;

    ICE_MEMBER(GLACIER2_API) virtual void _write(::Ice::OutputStream*) const override;
    ICE_MEMBER(GLACIER2_API) virtual void _read(::Ice::InputStream*) override;

    ::std::shared_ptr<::Ice::SlicedData> _slicedData;
};

static CannotCreateSessionException _iceS_CannotCreateSessionException_init;

}

namespace Glacier2
{

class GLACIER2_API Session : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void destroy(const ::Ice::Current&) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API StringSet : public virtual ::Ice::Object
{
public:

    using ProxyType = StringSetPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void add(::Ice::StringSeq, const ::Ice::Current&) = 0;
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void remove(::Ice::StringSeq, const ::Ice::Current&) = 0;
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq get(const ::Ice::Current&) = 0;
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API IdentitySet : public virtual ::Ice::Object
{
public:

    using ProxyType = IdentitySetPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual void add(::Ice::IdentitySeq, const ::Ice::Current&) = 0;
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void remove(::Ice::IdentitySeq, const ::Ice::Current&) = 0;
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::IdentitySeq get(const ::Ice::Current&) = 0;
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API SessionControl : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionControlPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::Glacier2::StringSetPrx> categories(const ::Ice::Current&) = 0;
    bool _iceD_categories(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::Glacier2::StringSetPrx> adapterIds(const ::Ice::Current&) = 0;
    bool _iceD_adapterIds(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::std::shared_ptr<::Glacier2::IdentitySetPrx> identities(const ::Ice::Current&) = 0;
    bool _iceD_identities(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual int getSessionTimeout(const ::Ice::Current&) = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroy(const ::Ice::Current&) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API SessionManager : public virtual ::Ice::Object
{
public:

    using ProxyType = SessionManagerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::Glacier2::SessionPrx> create(::std::string, ::std::shared_ptr<::Glacier2::SessionControlPrx>, const ::Ice::Current&) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

class GLACIER2_API SSLSessionManager : public virtual ::Ice::Object
{
public:

    using ProxyType = SSLSessionManagerPrx;

    virtual bool ice_isA(::std::string, const ::Ice::Current&) const override;
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current&) const override;
    virtual ::std::string ice_id(const ::Ice::Current&) const override;

    static const ::std::string& ice_staticId();

    virtual ::std::shared_ptr<::Glacier2::SessionPrx> create(::Glacier2::SSLInfo, ::std::shared_ptr<::Glacier2::SessionControlPrx>, const ::Ice::Current&) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
};

}

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) SessionPrx : public virtual ::Ice::Proxy<SessionPrx, ::Ice::ObjectPrx>
{
public:

    void destroy(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::SessionPrx::_iceI_destroy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::SessionPrx::_iceI_destroy, context);
    }

    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::SessionPrx::_iceI_destroy, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    SessionPrx() = default;
    friend ::std::shared_ptr<SessionPrx> IceInternal::createProxy<SessionPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) StringSetPrx : public virtual ::Ice::Proxy<StringSetPrx, ::Ice::ObjectPrx>
{
public:

    void add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::StringSetPrx::_iceI_add, iceP_additions, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addAsync(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::StringSetPrx::_iceI_add, iceP_additions, context);
    }

    ::std::function<void()>
    addAsync(const ::Ice::StringSeq& iceP_additions,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::StringSetPrx::_iceI_add, iceP_additions, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);

    void remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::StringSetPrx::_iceI_remove, iceP_deletions, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto removeAsync(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::StringSetPrx::_iceI_remove, iceP_deletions, context);
    }

    ::std::function<void()>
    removeAsync(const ::Ice::StringSeq& iceP_deletions,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::StringSetPrx::_iceI_remove, iceP_deletions, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::StringSeq&, const ::Ice::Context&);

    ::Ice::StringSeq get(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::StringSeq>(true, this, &Glacier2::StringSetPrx::_iceI_get, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::StringSeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::StringSeq, P>(false, this, &Glacier2::StringSetPrx::_iceI_get, context);
    }

    ::std::function<void()>
    getAsync(::std::function<void(::Ice::StringSeq)> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::StringSeq>(response, ex, sent, this, &Glacier2::StringSetPrx::_iceI_get, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::StringSeq>>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    StringSetPrx() = default;
    friend ::std::shared_ptr<StringSetPrx> IceInternal::createProxy<StringSetPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) IdentitySetPrx : public virtual ::Ice::Proxy<IdentitySetPrx, ::Ice::ObjectPrx>
{
public:

    void add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::IdentitySetPrx::_iceI_add, iceP_additions, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto addAsync(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::IdentitySetPrx::_iceI_add, iceP_additions, context);
    }

    ::std::function<void()>
    addAsync(const ::Ice::IdentitySeq& iceP_additions,
             ::std::function<void()> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::IdentitySetPrx::_iceI_add, iceP_additions, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_add(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::IdentitySeq&, const ::Ice::Context&);

    void remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::IdentitySetPrx::_iceI_remove, iceP_deletions, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto removeAsync(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::IdentitySetPrx::_iceI_remove, iceP_deletions, context);
    }

    ::std::function<void()>
    removeAsync(const ::Ice::IdentitySeq& iceP_deletions,
                ::std::function<void()> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::IdentitySetPrx::_iceI_remove, iceP_deletions, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_remove(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::IdentitySeq&, const ::Ice::Context&);

    ::Ice::IdentitySeq get(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq>(true, this, &Glacier2::IdentitySetPrx::_iceI_get, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::Ice::IdentitySeq>>().get_future())
    {
        return _makePromiseOutgoing<::Ice::IdentitySeq, P>(false, this, &Glacier2::IdentitySetPrx::_iceI_get, context);
    }

    ::std::function<void()>
    getAsync(::std::function<void(::Ice::IdentitySeq)> response,
             ::std::function<void(::std::exception_ptr)> ex = nullptr,
             ::std::function<void(bool)> sent = nullptr,
             const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::Ice::IdentitySeq>(response, ex, sent, this, &Glacier2::IdentitySetPrx::_iceI_get, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_get(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::Ice::IdentitySeq>>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    IdentitySetPrx() = default;
    friend ::std::shared_ptr<IdentitySetPrx> IceInternal::createProxy<IdentitySetPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) SessionControlPrx : public virtual ::Ice::Proxy<SessionControlPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Glacier2::StringSetPrx> categories(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(true, this, &Glacier2::SessionControlPrx::_iceI_categories, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto categoriesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::StringSetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>, P>(false, this, &Glacier2::SessionControlPrx::_iceI_categories, context);
    }

    ::std::function<void()>
    categoriesAsync(::std::function<void(::std::shared_ptr<::Glacier2::StringSetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(response, ex, sent, this, &Glacier2::SessionControlPrx::_iceI_categories, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_categories(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Glacier2::StringSetPrx> adapterIds(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(true, this, &Glacier2::SessionControlPrx::_iceI_adapterIds, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto adapterIdsAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::StringSetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>, P>(false, this, &Glacier2::SessionControlPrx::_iceI_adapterIds, context);
    }

    ::std::function<void()>
    adapterIdsAsync(::std::function<void(::std::shared_ptr<::Glacier2::StringSetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::StringSetPrx>>(response, ex, sent, this, &Glacier2::SessionControlPrx::_iceI_adapterIds, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_adapterIds(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::StringSetPrx>>>&, const ::Ice::Context&);

    ::std::shared_ptr<::Glacier2::IdentitySetPrx> identities(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>>(true, this, &Glacier2::SessionControlPrx::_iceI_identities, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto identitiesAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::IdentitySetPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>, P>(false, this, &Glacier2::SessionControlPrx::_iceI_identities, context);
    }

    ::std::function<void()>
    identitiesAsync(::std::function<void(::std::shared_ptr<::Glacier2::IdentitySetPrx>)> response,
                    ::std::function<void(::std::exception_ptr)> ex = nullptr,
                    ::std::function<void(bool)> sent = nullptr,
                    const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::IdentitySetPrx>>(response, ex, sent, this, &Glacier2::SessionControlPrx::_iceI_identities, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_identities(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::IdentitySetPrx>>>&, const ::Ice::Context&);

    int getSessionTimeout(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<int>(true, this, &Glacier2::SessionControlPrx::_iceI_getSessionTimeout, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto getSessionTimeoutAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<int>>().get_future())
    {
        return _makePromiseOutgoing<int, P>(false, this, &Glacier2::SessionControlPrx::_iceI_getSessionTimeout, context);
    }

    ::std::function<void()>
    getSessionTimeoutAsync(::std::function<void(int)> response,
                           ::std::function<void(::std::exception_ptr)> ex = nullptr,
                           ::std::function<void(bool)> sent = nullptr,
                           const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<int>(response, ex, sent, this, &Glacier2::SessionControlPrx::_iceI_getSessionTimeout, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_getSessionTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<int>>&, const ::Ice::Context&);

    void destroy(const ::Ice::Context& context = Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &Glacier2::SessionControlPrx::_iceI_destroy, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto destroyAsync(const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &Glacier2::SessionControlPrx::_iceI_destroy, context);
    }

    ::std::function<void()>
    destroyAsync(::std::function<void()> response,
                 ::std::function<void(::std::exception_ptr)> ex = nullptr,
                 ::std::function<void(bool)> sent = nullptr,
                 const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &Glacier2::SessionControlPrx::_iceI_destroy, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_destroy(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    SessionControlPrx() = default;
    friend ::std::shared_ptr<SessionControlPrx> IceInternal::createProxy<SessionControlPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) SessionManagerPrx : public virtual ::Ice::Proxy<SessionManagerPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Glacier2::SessionPrx> create(const ::std::string& iceP_userId, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &Glacier2::SessionManagerPrx::_iceI_create, iceP_userId, iceP_control, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createAsync(const ::std::string& iceP_userId, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &Glacier2::SessionManagerPrx::_iceI_create, iceP_userId, iceP_control, context);
    }

    ::std::function<void()>
    createAsync(const ::std::string& iceP_userId, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control,
                ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::SessionManagerPrx::_iceI_create, iceP_userId, iceP_control, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::std::string&, const ::std::shared_ptr<::Glacier2::SessionControlPrx>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    SessionManagerPrx() = default;
    friend ::std::shared_ptr<SessionManagerPrx> IceInternal::createProxy<SessionManagerPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

class ICE_CLASS(GLACIER2_API) SSLSessionManagerPrx : public virtual ::Ice::Proxy<SSLSessionManagerPrx, ::Ice::ObjectPrx>
{
public:

    ::std::shared_ptr<::Glacier2::SessionPrx> create(const ::Glacier2::SSLInfo& iceP_info, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control, const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(true, this, &Glacier2::SSLSessionManagerPrx::_iceI_create, iceP_info, iceP_control, context).get();
    }

    template<template<typename> class P = ::std::promise>
    auto createAsync(const ::Glacier2::SSLInfo& iceP_info, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control, const ::Ice::Context& context = Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Glacier2::SessionPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>, P>(false, this, &Glacier2::SSLSessionManagerPrx::_iceI_create, iceP_info, iceP_control, context);
    }

    ::std::function<void()>
    createAsync(const ::Glacier2::SSLInfo& iceP_info, const ::std::shared_ptr<::Glacier2::SessionControlPrx>& iceP_control,
                ::std::function<void(::std::shared_ptr<::Glacier2::SessionPrx>)> response,
                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                ::std::function<void(bool)> sent = nullptr,
                const ::Ice::Context& context = Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Glacier2::SessionPrx>>(response, ex, sent, this, &Glacier2::SSLSessionManagerPrx::_iceI_create, iceP_info, iceP_control, context);
    }

    ICE_MEMBER(GLACIER2_API) void _iceI_create(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Glacier2::SessionPrx>>>&, const ::Glacier2::SSLInfo&, const ::std::shared_ptr<::Glacier2::SessionControlPrx>&, const ::Ice::Context&);

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    SSLSessionManagerPrx() = default;
    friend ::std::shared_ptr<SSLSessionManagerPrx> IceInternal::createProxy<SSLSessionManagerPrx>();

    ICE_MEMBER(GLACIER2_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
};

}

namespace Ice
{

template<typename S>
struct StreamReader<::Glacier2::CannotCreateSessionException, S>
{
    static void read(S* istr, ::Glacier2::CannotCreateSessionException& v)
    {
        istr->readAll(v.reason);
    }
};

}

namespace Glacier2
{

using SessionPtr = ::std::shared_ptr<Session>;
using SessionPrxPtr = ::std::shared_ptr<SessionPrx>;

using StringSetPtr = ::std::shared_ptr<StringSet>;
using StringSetPrxPtr = ::std::shared_ptr<StringSetPrx>;

using IdentitySetPtr = ::std::shared_ptr<IdentitySet>;
using IdentitySetPrxPtr = ::std::shared_ptr<IdentitySetPrx>;

using SessionControlPtr = ::std::shared_ptr<SessionControl>;
using SessionControlPrxPtr = ::std::shared_ptr<SessionControlPrx>;

using SessionManagerPtr = ::std::shared_ptr<SessionManager>;
using SessionManagerPrxPtr = ::std::shared_ptr<SessionManagerPrx>;

using SSLSessionManagerPtr = ::std::shared_ptr<SSLSessionManager>;
using SSLSessionManagerPrxPtr = ::std::shared_ptr<SSLSessionManagerPrx>;

}

#else // C++98 mapping

namespace IceProxy
{

namespace Glacier2
{

class Session;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Session>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::Session*);

class StringSet;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::StringSet>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::StringSet*);

class IdentitySet;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::IdentitySet>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::IdentitySet*);

class SessionControl;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionControl>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::SessionControl*);

class SessionManager;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionManager>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::SessionManager*);

class SSLSessionManager;
GLACIER2_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLSessionManager>&);
GLACIER2_API ::IceProxy::Ice::Object* upCast(::IceProxy::Glacier2::SSLSessionManager*);

}

}

namespace Glacier2
{

class Session;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::Session*);
typedef ::IceInternal::Handle< ::Glacier2::Session> SessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::Session> SessionPrx;
typedef SessionPrx SessionPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SessionPtr&, const ::Ice::ObjectPtr&);

class StringSet;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::StringSet*);
typedef ::IceInternal::Handle< ::Glacier2::StringSet> StringSetPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::StringSet> StringSetPrx;
typedef StringSetPrx StringSetPrxPtr;
GLACIER2_API void _icePatchObjectPtr(StringSetPtr&, const ::Ice::ObjectPtr&);

class IdentitySet;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::IdentitySet*);
typedef ::IceInternal::Handle< ::Glacier2::IdentitySet> IdentitySetPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::IdentitySet> IdentitySetPrx;
typedef IdentitySetPrx IdentitySetPrxPtr;
GLACIER2_API void _icePatchObjectPtr(IdentitySetPtr&, const ::Ice::ObjectPtr&);

class SessionControl;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::SessionControl*);
typedef ::IceInternal::Handle< ::Glacier2::SessionControl> SessionControlPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionControl> SessionControlPrx;
typedef SessionControlPrx SessionControlPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SessionControlPtr&, const ::Ice::ObjectPtr&);

class SessionManager;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::SessionManager*);
typedef ::IceInternal::Handle< ::Glacier2::SessionManager> SessionManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SessionManager> SessionManagerPrx;
typedef SessionManagerPrx SessionManagerPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SessionManagerPtr&, const ::Ice::ObjectPtr&);

class SSLSessionManager;
GLACIER2_API ::Ice::Object* upCast(::Glacier2::SSLSessionManager*);
typedef ::IceInternal::Handle< ::Glacier2::SSLSessionManager> SSLSessionManagerPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Glacier2::SSLSessionManager> SSLSessionManagerPrx;
typedef SSLSessionManagerPrx SSLSessionManagerPrxPtr;
GLACIER2_API void _icePatchObjectPtr(SSLSessionManagerPtr&, const ::Ice::ObjectPtr&);

}

namespace Glacier2
{

class GLACIER2_API CannotCreateSessionException : public ::Ice::UserException
{
public:

    CannotCreateSessionException() {}
    explicit CannotCreateSessionException(const ::std::string&);
    virtual ~CannotCreateSessionException() throw();

    virtual ::std::string ice_id() const;
    virtual CannotCreateSessionException* ice_clone() const;
    virtual void ice_throw() const;

    ::std::string reason;

    virtual ::Ice::SlicedDataPtr ice_getSlicedData() const;

    virtual void _write(::Ice::OutputStream*) const;
    virtual void _read(::Ice::InputStream*);
    using ::Ice::UserException::_write;
    using ::Ice::UserException::_read;

protected:

    virtual void _writeImpl(::Ice::OutputStream*) const;
    virtual void _readImpl(::Ice::InputStream*);

    ::Ice::SlicedDataPtr _slicedData;
};

static CannotCreateSessionException _iceS_CannotCreateSessionException_init;

}

namespace Glacier2
{

class Callback_Session_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_destroy_Base> Callback_Session_destroyPtr;

class Callback_StringSet_add_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_add_Base> Callback_StringSet_addPtr;

class Callback_StringSet_remove_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_remove_Base> Callback_StringSet_removePtr;

class Callback_StringSet_get_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_StringSet_get_Base> Callback_StringSet_getPtr;

class Callback_IdentitySet_add_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_add_Base> Callback_IdentitySet_addPtr;

class Callback_IdentitySet_remove_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_remove_Base> Callback_IdentitySet_removePtr;

class Callback_IdentitySet_get_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_IdentitySet_get_Base> Callback_IdentitySet_getPtr;

class Callback_SessionControl_categories_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_categories_Base> Callback_SessionControl_categoriesPtr;

class Callback_SessionControl_adapterIds_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_adapterIds_Base> Callback_SessionControl_adapterIdsPtr;

class Callback_SessionControl_identities_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_identities_Base> Callback_SessionControl_identitiesPtr;

class Callback_SessionControl_getSessionTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_getSessionTimeout_Base> Callback_SessionControl_getSessionTimeoutPtr;

class Callback_SessionControl_destroy_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionControl_destroy_Base> Callback_SessionControl_destroyPtr;

class Callback_SessionManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SessionManager_create_Base> Callback_SessionManager_createPtr;

class Callback_SSLSessionManager_create_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_SSLSessionManager_create_Base> Callback_SSLSessionManager_createPtr;

}

namespace IceProxy
{

namespace Glacier2
{

class ICE_CLASS(GLACIER2_API) Session : public virtual ::Ice::Proxy<Session, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Glacier2::Callback_Session_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Glacier2::Callback_Session_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_destroy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) StringSet : public virtual ::Ice::Proxy<StringSet, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) void add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_add(_iceI_begin_add(iceP_additions, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_add(iceP_additions, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& iceP_additions, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& iceP_additions, const ::Glacier2::Callback_StringSet_addPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::StringSeq& iceP_additions, const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_addPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_add(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_add(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) void remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_remove(_iceI_begin_remove(iceP_deletions, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_remove(iceP_deletions, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Glacier2::Callback_StringSet_removePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::StringSeq& iceP_deletions, const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_removePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_remove(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_remove(const ::Ice::StringSeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Ice::StringSeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_get(_iceI_begin_get(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_get(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Glacier2::Callback_StringSet_getPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Glacier2::Callback_StringSet_getPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Ice::StringSeq end_get(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_get(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) IdentitySet : public virtual ::Ice::Proxy<IdentitySet, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) void add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_add(_iceI_begin_add(iceP_additions, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_add(iceP_additions, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Glacier2::Callback_IdentitySet_addPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_add(const ::Ice::IdentitySeq& iceP_additions, const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_addPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_add(iceP_additions, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_add(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_add(const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) void remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_remove(_iceI_begin_remove(iceP_deletions, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_remove(iceP_deletions, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Glacier2::Callback_IdentitySet_removePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_remove(const ::Ice::IdentitySeq& iceP_deletions, const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_removePtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_remove(iceP_deletions, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_remove(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_remove(const ::Ice::IdentitySeq&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Ice::IdentitySeq get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_get(_iceI_begin_get(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_get(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Glacier2::Callback_IdentitySet_getPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_get(const ::Ice::Context& context, const ::Glacier2::Callback_IdentitySet_getPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_get(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Ice::IdentitySeq end_get(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_get(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) SessionControl : public virtual ::Ice::Proxy<SessionControl, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx categories(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_categories(_iceI_begin_categories(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_categories(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_categories(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_categories(const ::Glacier2::Callback_SessionControl_categoriesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_categories(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_categoriesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_categories(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx end_categories(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_categories(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx adapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_adapterIds(_iceI_begin_adapterIds(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_adapterIds(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterIds(const ::Glacier2::Callback_SessionControl_adapterIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_adapterIds(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_adapterIdsPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_adapterIds(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::StringSetPrx end_adapterIds(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_adapterIds(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::IdentitySetPrx identities(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_identities(_iceI_begin_identities(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_identities(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_identities(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_identities(const ::Glacier2::Callback_SessionControl_identitiesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_identities(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_identitiesPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_identities(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::IdentitySetPrx end_identities(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_identities(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) ::Ice::Int getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getSessionTimeout(_iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getSessionTimeout(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Glacier2::Callback_SessionControl_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_getSessionTimeout(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_getSessionTimeoutPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getSessionTimeout(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Ice::Int end_getSessionTimeout(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_getSessionTimeout(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) void destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_destroy(_iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_destroy(context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Glacier2::Callback_SessionControl_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_destroy(const ::Ice::Context& context, const ::Glacier2::Callback_SessionControl_destroyPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_destroy(context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) void end_destroy(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_destroy(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) SessionManager : public virtual ::Ice::Proxy<SessionManager, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(iceP_userId, iceP_control, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(iceP_userId, iceP_control, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_userId, iceP_control, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_userId, iceP_control, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Glacier2::Callback_SessionManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_userId, iceP_control, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::std::string& iceP_userId, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::Glacier2::Callback_SessionManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_userId, iceP_control, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_create(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::std::string&, const ::Glacier2::SessionControlPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

class ICE_CLASS(GLACIER2_API) SSLSessionManager : public virtual ::Ice::Proxy<SSLSessionManager, ::IceProxy::Ice::Object>
{
public:

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_create(_iceI_begin_create(iceP_info, iceP_control, context, ::IceInternal::dummyCallback, 0, true));
    }

    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_create(iceP_info, iceP_control, context, ::IceInternal::dummyCallback, 0);
    }

    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_info, iceP_control, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::Ice::CallbackPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_info, iceP_control, context, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Glacier2::Callback_SSLSessionManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_info, iceP_control, ::Ice::noExplicitContext, del, cookie);
    }

    ::Ice::AsyncResultPtr begin_create(const ::Glacier2::SSLInfo& iceP_info, const ::Glacier2::SessionControlPrx& iceP_control, const ::Ice::Context& context, const ::Glacier2::Callback_SSLSessionManager_createPtr& del, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_create(iceP_info, iceP_control, context, del, cookie);
    }

    ICE_MEMBER(GLACIER2_API) ::Glacier2::SessionPrx end_create(const ::Ice::AsyncResultPtr&);

private:

    ICE_MEMBER(GLACIER2_API) ::Ice::AsyncResultPtr _iceI_begin_create(const ::Glacier2::SSLInfo&, const ::Glacier2::SessionControlPrx&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    ICE_MEMBER(GLACIER2_API) static const ::std::string& ice_staticId();

protected:

    ICE_MEMBER(GLACIER2_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
};

}

}

namespace Glacier2
{

class GLACIER2_API Session : public virtual ::Ice::Object
{
public:

    typedef SessionPrx ProxyType;
    typedef SessionPtr PointerType;

    virtual ~Session();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void destroy(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API StringSet : public virtual ::Ice::Object
{
public:

    typedef StringSetPrx ProxyType;
    typedef StringSetPtr PointerType;

    virtual ~StringSet();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void add(const ::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void remove(const ::Ice::StringSeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::StringSeq get(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const StringSet& lhs, const StringSet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const StringSet& lhs, const StringSet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API IdentitySet : public virtual ::Ice::Object
{
public:

    typedef IdentitySetPrx ProxyType;
    typedef IdentitySetPtr PointerType;

    virtual ~IdentitySet();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual void add(const ::Ice::IdentitySeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_add(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void remove(const ::Ice::IdentitySeq&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_remove(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::IdentitySeq get(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_get(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const IdentitySet& lhs, const IdentitySet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const IdentitySet& lhs, const IdentitySet& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API SessionControl : public virtual ::Ice::Object
{
public:

    typedef SessionControlPrx ProxyType;
    typedef SessionControlPtr PointerType;

    virtual ~SessionControl();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Glacier2::StringSetPrx categories(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_categories(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Glacier2::StringSetPrx adapterIds(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_adapterIds(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Glacier2::IdentitySetPrx identities(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_identities(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual ::Ice::Int getSessionTimeout(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_getSessionTimeout(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual void destroy(const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_destroy(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const SessionControl& lhs, const SessionControl& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SessionControl& lhs, const SessionControl& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API SessionManager : public virtual ::Ice::Object
{
public:

    typedef SessionManagerPrx ProxyType;
    typedef SessionManagerPtr PointerType;

    virtual ~SessionManager();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Glacier2::SessionPrx create(const ::std::string&, const ::Glacier2::SessionControlPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const SessionManager& lhs, const SessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SessionManager& lhs, const SessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

class GLACIER2_API SSLSessionManager : public virtual ::Ice::Object
{
public:

    typedef SSLSessionManagerPrx ProxyType;
    typedef SSLSessionManagerPtr PointerType;

    virtual ~SSLSessionManager();

    virtual bool ice_isA(const ::std::string&, const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& = ::Ice::emptyCurrent) const;
    virtual const ::std::string& ice_id(const ::Ice::Current& = ::Ice::emptyCurrent) const;

    static const ::std::string& ice_staticId();

    virtual ::Glacier2::SessionPrx create(const ::Glacier2::SSLInfo&, const ::Glacier2::SessionControlPrx&, const ::Ice::Current& = ::Ice::emptyCurrent) = 0;
    bool _iceD_create(::IceInternal::Incoming&, const ::Ice::Current&);

    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);

protected:

    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
};

inline bool operator==(const SSLSessionManager& lhs, const SSLSessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const SSLSessionManager& lhs, const SSLSessionManager& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}

}

namespace Ice
{

template<>
struct StreamableTraits< ::Glacier2::CannotCreateSessionException>
{
    static const StreamHelperCategory helper = StreamHelperCategoryUserException;
};

template<typename S>
struct StreamWriter< ::Glacier2::CannotCreateSessionException, S>
{
    static void write(S* ostr, const ::Glacier2::CannotCreateSessionException& v)
    {
        ostr->write(v.reason);
    }
};

template<typename S>
struct StreamReader< ::Glacier2::CannotCreateSessionException, S>
{
    static void read(S* istr, ::Glacier2::CannotCreateSessionException& v)
    {
        istr->read(v.reason);
    }
};

}

namespace Glacier2
{

template<class T>
class CallbackNC_Session_destroy : public Callback_Session_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_destroy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_Session_destroy : public Callback_Session_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_Session_destroyPtr
newCallback_Session_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_StringSet_add : public Callback_StringSet_add_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_StringSet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_add<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_StringSet_add : public Callback_StringSet_add_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_StringSet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_addPtr
newCallback_StringSet_add(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_add<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_StringSet_remove : public Callback_StringSet_remove_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_StringSet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_remove<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_StringSet_remove : public Callback_StringSet_remove_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_StringSet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_removePtr
newCallback_StringSet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_remove<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_StringSet_get : public Callback_StringSet_get_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::StringSeq&);

    CallbackNC_StringSet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::StringSetPrx proxy = ::Glacier2::StringSetPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_StringSet_getPtr
newCallback_StringSet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_get<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_StringSet_getPtr
newCallback_StringSet_get(T* instance, void (T::*cb)(const ::Ice::StringSeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_StringSet_get<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_StringSet_get : public Callback_StringSet_get_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::StringSeq&, const CT&);

    Callback_StringSet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::StringSetPrx proxy = ::Glacier2::StringSetPrx::uncheckedCast(result->getProxy());
        ::Ice::StringSeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_StringSet_getPtr
newCallback_StringSet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_get<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_StringSet_getPtr
newCallback_StringSet_get(T* instance, void (T::*cb)(const ::Ice::StringSeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_StringSet_get<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_IdentitySet_add : public Callback_IdentitySet_add_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_IdentitySet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_add<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_IdentitySet_add : public Callback_IdentitySet_add_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_IdentitySet_add(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_addPtr
newCallback_IdentitySet_add(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_add<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_IdentitySet_remove : public Callback_IdentitySet_remove_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_IdentitySet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_remove<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_IdentitySet_remove : public Callback_IdentitySet_remove_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_IdentitySet_remove(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_removePtr
newCallback_IdentitySet_remove(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_remove<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_IdentitySet_get : public Callback_IdentitySet_get_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&);

    CallbackNC_IdentitySet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::IdentitySetPrx proxy = ::Glacier2::IdentitySetPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_get<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_IdentitySet_get<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_IdentitySet_get : public Callback_IdentitySet_get_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::IdentitySeq&, const CT&);

    Callback_IdentitySet_get(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::IdentitySetPrx proxy = ::Glacier2::IdentitySetPrx::uncheckedCast(result->getProxy());
        ::Ice::IdentitySeq ret;
        try
        {
            ret = proxy->end_get(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_get<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_IdentitySet_getPtr
newCallback_IdentitySet_get(T* instance, void (T::*cb)(const ::Ice::IdentitySeq&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_IdentitySet_get<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SessionControl_categories : public Callback_SessionControl_categories_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::StringSetPrx&);

    CallbackNC_SessionControl_categories(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::StringSetPrx ret;
        try
        {
            ret = proxy->end_categories(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_categories<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(T* instance, void (T::*cb)(const ::Glacier2::StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_categories<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionControl_categories : public Callback_SessionControl_categories_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::StringSetPrx&, const CT&);

    Callback_SessionControl_categories(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::StringSetPrx ret;
        try
        {
            ret = proxy->end_categories(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_categories<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_categoriesPtr
newCallback_SessionControl_categories(T* instance, void (T::*cb)(const ::Glacier2::StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_categories<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SessionControl_adapterIds : public Callback_SessionControl_adapterIds_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::StringSetPrx&);

    CallbackNC_SessionControl_adapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::StringSetPrx ret;
        try
        {
            ret = proxy->end_adapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_adapterIds<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(T* instance, void (T::*cb)(const ::Glacier2::StringSetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_adapterIds<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionControl_adapterIds : public Callback_SessionControl_adapterIds_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::StringSetPrx&, const CT&);

    Callback_SessionControl_adapterIds(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::StringSetPrx ret;
        try
        {
            ret = proxy->end_adapterIds(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_adapterIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_adapterIdsPtr
newCallback_SessionControl_adapterIds(T* instance, void (T::*cb)(const ::Glacier2::StringSetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_adapterIds<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SessionControl_identities : public Callback_SessionControl_identities_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::IdentitySetPrx&);

    CallbackNC_SessionControl_identities(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::IdentitySetPrx ret;
        try
        {
            ret = proxy->end_identities(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::IdentitySetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_identities<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(T* instance, void (T::*cb)(const ::Glacier2::IdentitySetPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_identities<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionControl_identities : public Callback_SessionControl_identities_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::IdentitySetPrx&, const CT&);

    Callback_SessionControl_identities(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Glacier2::IdentitySetPrx ret;
        try
        {
            ret = proxy->end_identities(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::IdentitySetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_identities<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_identitiesPtr
newCallback_SessionControl_identities(T* instance, void (T::*cb)(const ::Glacier2::IdentitySetPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_identities<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SessionControl_getSessionTimeout : public Callback_SessionControl_getSessionTimeout_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(::Ice::Int);

    CallbackNC_SessionControl_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_getSessionTimeout<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionControl_getSessionTimeout : public Callback_SessionControl_getSessionTimeout_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(::Ice::Int, const CT&);

    Callback_SessionControl_getSessionTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionControlPrx proxy = ::Glacier2::SessionControlPrx::uncheckedCast(result->getProxy());
        ::Ice::Int ret;
        try
        {
            ret = proxy->end_getSessionTimeout(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_getSessionTimeoutPtr
newCallback_SessionControl_getSessionTimeout(T* instance, void (T::*cb)(::Ice::Int, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_getSessionTimeout<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SessionControl_destroy : public Callback_SessionControl_destroy_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_SessionControl_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, 0, excb, sentcb);
}

template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionControl_destroy<T>(instance, 0, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionControl_destroy : public Callback_SessionControl_destroy_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_SessionControl_destroy(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionControl_destroyPtr
newCallback_SessionControl_destroy(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionControl_destroy<T, CT>(instance, 0, excb, sentcb);
}

template<class T>
class CallbackNC_SessionManager_create : public Callback_SessionManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&);

    CallbackNC_SessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionManagerPrx proxy = ::Glacier2::SessionManagerPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SessionManager_createPtr
newCallback_SessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionManager_create<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SessionManager_createPtr
newCallback_SessionManager_create(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SessionManager_create<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SessionManager_create : public Callback_SessionManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&, const CT&);

    Callback_SessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SessionManagerPrx proxy = ::Glacier2::SessionManagerPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SessionManager_createPtr
newCallback_SessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SessionManager_createPtr
newCallback_SessionManager_create(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

template<class T>
class CallbackNC_SSLSessionManager_create : public Callback_SSLSessionManager_create_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&);

    CallbackNC_SSLSessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SSLSessionManagerPrx proxy = ::Glacier2::SSLSessionManagerPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }

private:

    Response _response;
};

template<class T> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLSessionManager_create<T>(instance, cb, excb, sentcb);
}

template<class T> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_SSLSessionManager_create<T>(instance, cb, excb, sentcb);
}

template<class T, typename CT>
class Callback_SSLSessionManager_create : public Callback_SSLSessionManager_create_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Glacier2::SessionPrx&, const CT&);

    Callback_SSLSessionManager_create(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        ::Glacier2::SSLSessionManagerPrx proxy = ::Glacier2::SSLSessionManagerPrx::uncheckedCast(result->getProxy());
        ::Glacier2::SessionPrx ret;
        try
        {
            ret = proxy->end_create(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }

private:

    Response _response;
};

template<class T, typename CT> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLSessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

template<class T, typename CT> Callback_SSLSessionManager_createPtr
newCallback_SSLSessionManager_create(T* instance, void (T::*cb)(const ::Glacier2::SessionPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_SSLSessionManager_create<T, CT>(instance, cb, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
