// **********************************************************************
//
// Copyright (c) 2003-2017 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.0
//
// <auto-generated>
//
// Generated from file `Identity.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_Identity_h__
#define __Ice_Identity_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 0
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

struct Identity
{
    ::std::string name;
    ::std::string category;

    std::tuple<const ::std::string&, const ::std::string&> ice_tuple() const
    {
        return std::tie(name, category);
    }
};

using ObjectDict = ::std::map<::Ice::Identity, ::std::shared_ptr<::Ice::Object>>;

using IdentitySeq = ::std::vector<::Ice::Identity>;

using Ice::operator<;
using Ice::operator<=;
using Ice::operator>;
using Ice::operator>=;
using Ice::operator==;
using Ice::operator!=;

}

namespace Ice
{

template<>
struct StreamableTraits<::Ice::Identity>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamReader<::Ice::Identity, S>
{
    static void read(S* istr, ::Ice::Identity& v)
    {
        istr->readAll(v.name, v.category);
    }
};

}

#else // C++98 mapping

namespace Ice
{

struct Identity
{
    ::std::string name;
    ::std::string category;

    bool operator==(const Identity& rhs_) const
    {
        if(this == &rhs_)
        {
            return true;
        }
        if(name != rhs_.name)
        {
            return false;
        }
        if(category != rhs_.category)
        {
            return false;
        }
        return true;
    }

    bool operator<(const Identity& rhs_) const
    {
        if(this == &rhs_)
        {
            return false;
        }
        if(name < rhs_.name)
        {
            return true;
        }
        else if(rhs_.name < name)
        {
            return false;
        }
        if(category < rhs_.category)
        {
            return true;
        }
        else if(rhs_.category < category)
        {
            return false;
        }
        return false;
    }

    bool operator!=(const Identity& rhs_) const
    {
        return !operator==(rhs_);
    }
    bool operator<=(const Identity& rhs_) const
    {
        return operator<(rhs_) || operator==(rhs_);
    }
    bool operator>(const Identity& rhs_) const
    {
        return !operator<(rhs_) && !operator==(rhs_);
    }
    bool operator>=(const Identity& rhs_) const
    {
        return !operator<(rhs_);
    }
};

typedef ::std::map< ::Ice::Identity, ::Ice::ObjectPtr> ObjectDict;

typedef ::std::vector< ::Ice::Identity> IdentitySeq;

}

namespace Ice
{

template<>
struct StreamableTraits< ::Ice::Identity>
{
    static const StreamHelperCategory helper = StreamHelperCategoryStruct;
    static const int minWireSize = 2;
    static const bool fixedLength = false;
};

template<typename S>
struct StreamWriter< ::Ice::Identity, S>
{
    static void write(S* ostr, const ::Ice::Identity& v)
    {
        ostr->write(v.name);
        ostr->write(v.category);
    }
};

template<typename S>
struct StreamReader< ::Ice::Identity, S>
{
    static void read(S* istr, ::Ice::Identity& v)
    {
        istr->read(v.name);
        istr->read(v.category);
    }
};

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
