/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.v4.codegen.target;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.antlr.v4.codegen.CodeGenerator;
import org.antlr.v4.codegen.Target;
import org.antlr.v4.codegen.UnicodeEscapes;
import org.antlr.v4.tool.Grammar;
import org.antlr.v4.tool.ast.GrammarAST;
import org.stringtemplate.v4.ST;
import org.stringtemplate.v4.STGroup;
import org.stringtemplate.v4.StringRenderer;

public class GoTarget
extends Target {
    private static final String[] goKeywords = new String[]{"break", "default", "func", "interface", "select", "case", "defer", "go", "map", "struct", "chan", "else", "goto", "package", "switch", "const", "fallthrough", "if", "range", "type", "continue", "for", "import", "return", "var"};
    private static final String[] goPredeclaredIdentifiers = new String[]{"bool", "byte", "complex64", "complex128", "error", "float32", "float64", "int", ",int8", "int16", "int32", "int64", "rune", "string", "uint", "uint8", "uint16", "uint32", "uint64", "uintptr", "true", "false", "iota", "nil", "append", "cap", "close", "complex", "copy", "delete", "imag", "len", "make", "new", "panic", "print", "println", "real", "recover"};
    private static final String[] goRuleContextInterfaceMethods = new String[]{"Accept", "GetAltNumber", "GetBaseRuleContext", "GetChild", "GetChildCount", "GetChildren", "GetInvokingState", "GetParent", "GetPayload", "GetRuleContext", "GetRuleIndex", "GetSourceInterval", "GetText", "IsEmpty", "SetAltNumber", "SetInvokingState", "SetParent", "String"};
    private final Set<String> badWords = new HashSet<String>(goKeywords.length + goPredeclaredIdentifiers.length + goRuleContextInterfaceMethods.length + 3);
    private static final boolean DO_GOFMT = !Boolean.parseBoolean(System.getenv("ANTLR_GO_DISABLE_GOFMT")) && !Boolean.parseBoolean(System.getProperty("antlr.go.disable-gofmt"));

    public GoTarget(CodeGenerator gen) {
        super(gen, "Go");
    }

    @Override
    public String getVersion() {
        return "4.7.1";
    }

    public Set<String> getBadWords() {
        if (this.badWords.isEmpty()) {
            this.addBadWords();
        }
        return this.badWords;
    }

    protected void addBadWords() {
        this.badWords.addAll(Arrays.asList(goKeywords));
        this.badWords.addAll(Arrays.asList(goPredeclaredIdentifiers));
        this.badWords.addAll(Arrays.asList(goRuleContextInterfaceMethods));
        this.badWords.add("rule");
        this.badWords.add("parserRule");
        this.badWords.add("action");
    }

    @Override
    protected void genFile(Grammar g, ST outputFileST, String fileName) {
        super.genFile(g, outputFileST, fileName);
        if (DO_GOFMT && !fileName.startsWith(".") && fileName.endsWith(".go")) {
            this.gofmt(new File(this.getCodeGenerator().tool.getOutputDirectory(g.fileName), fileName));
        }
    }

    private void gofmt(File fileName) {
        try {
            ProcessBuilder gofmtBuilder = new ProcessBuilder("gofmt", "-w", "-s", fileName.getPath());
            gofmtBuilder.redirectErrorStream(true);
            Process gofmt = gofmtBuilder.start();
            InputStream stdout = gofmt.getInputStream();
            byte[] buf = new byte[1024];
            int l = 0;
            while (l > -1) {
                l = stdout.read(buf);
            }
            gofmt.waitFor();
        }
        catch (IOException gofmtBuilder) {
        }
        catch (InterruptedException forward) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public String encodeIntAsCharEscape(int v) {
        return Integer.toString(v);
    }

    @Override
    public int getSerializedATNSegmentLimit() {
        return 29;
    }

    @Override
    public int getInlineTestSetWordSize() {
        return 32;
    }

    @Override
    protected boolean visibleGrammarSymbolCausesIssueInGeneratedCode(GrammarAST idNode) {
        return this.getBadWords().contains(idNode.getText());
    }

    @Override
    protected STGroup loadTemplates() {
        STGroup result = super.loadTemplates();
        result.registerRenderer(String.class, new JavaStringRenderer(), true);
        return result;
    }

    @Override
    public String getRecognizerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g != null);
        switch (g.getType()) {
            case 44: {
                String name = g.name.endsWith("Parser") ? g.name.substring(0, g.name.length() - 6) : g.name;
                return name.toLowerCase() + "_parser.go";
            }
            case 31: {
                String name = g.name.endsWith("Lexer") ? g.name.substring(0, g.name.length() - 5) : g.name;
                return name.toLowerCase() + "_lexer.go";
            }
            case 81: {
                return g.name.toLowerCase() + "_parser.go";
            }
        }
        return "INVALID_FILE_NAME";
    }

    @Override
    public String getListenerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_listener.go";
    }

    @Override
    public String getVisitorFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_visitor.go";
    }

    @Override
    public String getBaseListenerFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_base_listener.go";
    }

    @Override
    public String getBaseVisitorFileName(boolean header) {
        CodeGenerator gen = this.getCodeGenerator();
        Grammar g = gen.g;
        assert (g.name != null);
        return g.name.toLowerCase() + "_base_visitor.go";
    }

    @Override
    protected void appendUnicodeEscapedCodePoint(int codePoint, StringBuilder sb) {
        UnicodeEscapes.appendPythonStyleEscapedCodePoint(codePoint, sb);
    }

    protected static class JavaStringRenderer
    extends StringRenderer {
        protected JavaStringRenderer() {
        }

        @Override
        public String toString(Object o, String formatString, Locale locale) {
            if ("java-escape".equals(formatString)) {
                return ((String)o).replace("\\u", "\\u005Cu");
            }
            return super.toString(o, formatString, locale);
        }
    }
}

