/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor.repository;

import java.io.File;
import java.util.List;
import net.sourceforge.glsof.common.io.PreferencesRepository;
import net.sourceforge.glsof.common.model.Preferences;

public class FileMonitorPreferencesRepository
extends PreferencesRepository {
    private static Preferences _currentPreferences;

    public FileMonitorPreferencesRepository(File baseDir) {
        super(baseDir);
    }

    public static Preferences getCurrentPreferences() {
        return _currentPreferences;
    }

    public void load(String preferences) {
        if (this.fileExists(preferences)) {
            _currentPreferences = this.read(preferences);
        }
    }

    public void loadIfCurrentPreferenceName(String preferences) {
        if (this.isCurrentPreferencesName(preferences)) {
            this.load(preferences);
        }
    }

    public void delete(String preferences) {
        this.remove(preferences);
        if (this.isCurrentPreferencesName(preferences)) {
            _currentPreferences = null;
        }
    }

    public void updateColumns(List<Boolean> views) {
        if (_currentPreferences != null) {
            _currentPreferences.setColumns(views);
            this.save(_currentPreferences);
        }
    }

    public String copyPreferenceFrom(String oldName) {
        String newName;
        int i = 0;
        while (this.fileExists(newName = oldName + "(" + ++i + ")")) {
        }
        this.copy(oldName, newName);
        return newName;
    }

    @Override
    public boolean rename(String newName, String oldName) {
        if (newName.isEmpty() || this.fileExists(newName)) {
            return false;
        }
        boolean rename = super.rename(oldName, newName);
        if (rename && _currentPreferences.getName().equals(oldName)) {
            _currentPreferences = this.read(newName);
        }
        return rename;
    }

    public List<Boolean> loadColumns(String preferences) {
        _currentPreferences = this.read(preferences);
        return _currentPreferences.getColumns();
    }

    private boolean isCurrentPreferencesName(String preferences) {
        return _currentPreferences != null && _currentPreferences.getName().equals(preferences);
    }
}

