/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.server;

import java.lang.reflect.Method;
import org.netbeans.lib.profiler.global.Platform;
import org.netbeans.lib.profiler.server.ProfilerRuntime;
import org.netbeans.lib.profiler.server.ThreadInfo;
import org.netbeans.lib.profiler.server.system.Timers;

public class ProfilerRuntimeCPU
extends ProfilerRuntime {
    private static final boolean DEBUG = false;
    private static int nProfiledThreadsLimit;
    protected static int nProfiledThreadsAllowed;
    protected static boolean enableFirstTimeMethodInvoke;
    protected static volatile boolean recursiveInstrumentationDisabled;
    protected static boolean absoluteTimerOn;
    protected static boolean threadCPUTimerOn;
    protected static boolean waitTrackingEnabled;
    protected static boolean sleepTrackingEnabled;
    protected static boolean[] instrMethodInvoked;
    private static boolean javaLangReflectMethodInvokeInterceptEnabled;
    private static Method getRequestedSessionIdMethod;
    private static Method getMethodMethod;
    private static Method getServletPathMethod;

    public static long getAbsTimeStampInCollectedFormat() {
        return Timers.getCurrentTimeInCounts() & 0xFFFFFFFFFFFFFFL;
    }

    public static void setInstrMethodsInvoked(boolean[] blArray) {
        instrMethodInvoked = blArray;
    }

    public static void setJavaLangReflectMethodInvokeInterceptEnabled(boolean bl) {
        javaLangReflectMethodInvokeInterceptEnabled = bl;
    }

    public static void setNProfiledThreadsLimit(int n) {
        nProfiledThreadsLimit = nProfiledThreadsAllowed = n;
    }

    public static void setWaitAndSleepTracking(boolean bl, boolean bl2) {
        waitTrackingEnabled = bl;
        sleepTrackingEnabled = bl2;
    }

    public static void setTimerTypes(boolean bl, boolean bl2) {
        if (bl2 != threadCPUTimerOn && Platform.isSolaris()) {
            Timers.enableMicrostateAccounting((boolean)bl2);
        }
        absoluteTimerOn = bl;
        threadCPUTimerOn = bl2;
    }

    public static void enableFirstTimeMethodInvoke(boolean bl) {
        enableFirstTimeMethodInvoke = bl;
    }

    public static void createThreadInfoForCurrentThread() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        threadInfo.initialize();
        threadInfo.useEventBuffer();
        threadInfo.inCallGraph = false;
    }

    public static void handleJavaLangReflectMethodInvoke(Method method) {
        if (!javaLangReflectMethodInvokeInterceptEnabled) {
            return;
        }
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        if (threadInfo.inProfilingRuntimeMethod > 0) {
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        externalActionsHandler.handleReflectiveInvoke(method);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void handleServletDoMethod(Object object) {
        if (recursiveInstrumentationDisabled) {
            return;
        }
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized()) {
            System.out.println("No thread for servlet request");
            return;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        ProfilerRuntimeCPU.servletDoMethodHook(threadInfo, object);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static void resetProfilerCollectors() {
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    public static void resumeCurrentThreadTimer() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return;
        }
        ProfilerRuntimeCPU.writeAdjustTimeEvent(threadInfo, threadInfo.absEntryTime, threadInfo.threadEntryTime);
        --threadInfo.inProfilingRuntimeMethod;
    }

    public static ThreadInfo suspendCurrentThreadTimer() {
        ThreadInfo threadInfo = ThreadInfo.getThreadInfo();
        if (!threadInfo.isInitialized() || !threadInfo.inCallGraph) {
            return threadInfo;
        }
        ++threadInfo.inProfilingRuntimeMethod;
        threadInfo.absEntryTime = Timers.getCurrentTimeInCounts();
        if (threadCPUTimerOn) {
            threadInfo.threadEntryTime = Timers.getThreadCPUTimeInNanos();
        }
        return threadInfo;
    }

    protected static void clearDataStructures() {
        ProfilerRuntime.clearDataStructures();
        nProfiledThreadsAllowed = nProfiledThreadsLimit;
    }

    protected static long currentTimeInCounts() {
        return Timers.getCurrentTimeInCounts();
    }

    protected static void enableProfiling(boolean bl) {
        recursiveInstrumentationDisabled = !bl;
    }

    protected static long monitorEntryCPU(ThreadInfo threadInfo, Object object, ThreadInfo threadInfo2) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)22, threadInfo, object, threadInfo2);
        }
        return -1L;
    }

    protected static long monitorExitCPU(ThreadInfo threadInfo, Object object) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)23, threadInfo, object);
        }
        return -1L;
    }

    protected static long sleepEntryCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)24, threadInfo);
        }
        return -1L;
    }

    protected static long sleepExitCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !sleepTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)25, threadInfo);
        }
        return -1L;
    }

    protected static long waitEntryCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)20, threadInfo);
        }
        return -1L;
    }

    protected static long waitExitCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)21, threadInfo);
        }
        return -1L;
    }

    protected static long parkEntryCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)26, threadInfo);
        }
        return -1L;
    }

    protected static long parkExitCPU(ThreadInfo threadInfo) {
        if (recursiveInstrumentationDisabled || !waitTrackingEnabled) {
            return -1L;
        }
        if (threadInfo.isInitialized() && threadInfo.inCallGraph) {
            return ProfilerRuntimeCPU.writeWaitTimeEvent((byte)27, threadInfo);
        }
        return -1L;
    }

    protected static void firstTimeMethodInvoke(ThreadInfo threadInfo, char c) {
        if (enableFirstTimeMethodInvoke) {
            long l = Timers.getCurrentTimeInCounts();
            long l2 = threadCPUTimerOn ? Timers.getThreadCPUTimeInNanos() : 0L;
            externalActionsHandler.handleFirstTimeMethodInvoke(c);
            ProfilerRuntimeCPU.writeAdjustTimeEvent(threadInfo, l, l2);
        }
    }

    static void writeServletDoMethod(ThreadInfo threadInfo, String string, String string2, String string3) {
        int n = threadInfo.evBufPos;
        int n2 = 2 + string2.length() * 2 + 4;
        if (n + n2 > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        int n3 = -1;
        int n4 = -1;
        if ("GET".equals(string)) {
            n3 = 1;
        } else if ("POST".equals(string)) {
            n3 = 2;
        } else if ("PUT".equals(string)) {
            n3 = 3;
        } else if ("DELETE".equals(string)) {
            n3 = 4;
        }
        if (string3 != null) {
            n4 = string3.hashCode();
        }
        byArray[n++] = 30;
        byArray[n++] = n3;
        byte[] byArray2 = string2.getBytes();
        int n5 = byArray2.length;
        byArray[n++] = (byte)(n5 >> 8 & 0xFF);
        byArray[n++] = (byte)(n5 & 0xFF);
        System.arraycopy(byArray2, 0, byArray, n, n5);
        n += n5;
        byArray[n++] = (byte)(n4 >> 24 & 0xFF);
        byArray[n++] = (byte)(n4 >> 16 & 0xFF);
        byArray[n++] = (byte)(n4 >> 8 & 0xFF);
        byArray[n++] = (byte)(n4 & 0xFF);
        threadInfo.evBufPos = n;
    }

    static void writeTimeStampedEvent(byte by, ThreadInfo threadInfo, char c) {
        long l;
        int n = threadInfo.evBufPos;
        if (n > ThreadInfo.evBufPosThreshold) {
            ProfilerRuntimeCPU.copyLocalBuffer(threadInfo);
            n = threadInfo.evBufPos;
        }
        byte[] byArray = threadInfo.evBuf;
        if (!threadInfo.isInitialized()) {
            return;
        }
        byArray[n++] = by;
        byArray[n++] = (byte)(c >> 8 & 0xFF);
        byArray[n++] = (byte)(c & 0xFF);
        if (absoluteTimerOn) {
            l = Timers.getCurrentTimeInCounts();
            byArray[n++] = (byte)(l >> 48 & 0xFFL);
            byArray[n++] = (byte)(l >> 40 & 0xFFL);
            byArray[n++] = (byte)(l >> 32 & 0xFFL);
            byArray[n++] = (byte)(l >> 24 & 0xFFL);
            byArray[n++] = (byte)(l >> 16 & 0xFFL);
            byArray[n++] = (byte)(l >> 8 & 0xFFL);
            byArray[n++] = (byte)(l & 0xFFL);
        }
        if (threadCPUTimerOn) {
            l = Timers.getThreadCPUTimeInNanos();
            byArray[n++] = (byte)(l >> 48 & 0xFFL);
            byArray[n++] = (byte)(l >> 40 & 0xFFL);
            byArray[n++] = (byte)(l >> 32 & 0xFFL);
            byArray[n++] = (byte)(l >> 24 & 0xFFL);
            byArray[n++] = (byte)(l >> 16 & 0xFFL);
            byArray[n++] = (byte)(l >> 8 & 0xFFL);
            byArray[n++] = (byte)(l & 0xFFL);
        }
        threadInfo.evBufPos = n;
    }

    static long writeWaitTimeEvent(byte by, ThreadInfo threadInfo) {
        return ProfilerRuntimeCPU.writeWaitTimeEvent(by, threadInfo, null);
    }

    private static void servletDoMethodHook(ThreadInfo threadInfo, Object object) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (getRequestedSessionIdMethod == null) {
            try {
                Class<?> clazz = object.getClass();
                getRequestedSessionIdMethod = clazz.getMethod("getRequestedSessionId", null);
                getMethodMethod = clazz.getMethod("getMethod", null);
                getServletPathMethod = clazz.getMethod("getServletPath", null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
        try {
            string3 = (String)getRequestedSessionIdMethod.invoke(object, null);
            string2 = (String)getMethodMethod.invoke(object, null);
            string = (String)getServletPathMethod.invoke(object, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        ProfilerRuntimeCPU.writeServletDoMethod(threadInfo, string2, string, string3);
    }

    static {
        recursiveInstrumentationDisabled = false;
        javaLangReflectMethodInvokeInterceptEnabled = false;
    }
}

