/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.swing.Icon;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.data.conflict.Conflict;
import org.openstreetmap.josm.data.conflict.ConflictCollection;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.NodeData;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.PrimitiveData;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationData;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Storage;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.WayData;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class PurgeCommand
extends Command {
    protected List<OsmPrimitive> toPurge;
    protected Storage<PrimitiveData> makeIncompleteData;
    protected Map<PrimitiveId, PrimitiveData> makeIncompleteDataByPrimId;
    protected final ConflictCollection purgedConflicts = new ConflictCollection();

    public PurgeCommand(DataSet data, Collection<OsmPrimitive> toPurge, Collection<OsmPrimitive> makeIncomplete) {
        super(data);
        this.init(toPurge, makeIncomplete);
    }

    private void init(Collection<OsmPrimitive> toPurge, Collection<OsmPrimitive> makeIncomplete) {
        this.toPurge = PurgeCommand.topoSort(toPurge);
        this.saveIncomplete(makeIncomplete);
    }

    protected final void saveIncomplete(Collection<OsmPrimitive> makeIncomplete) {
        this.makeIncompleteData = new Storage<PrimitiveId>(new Storage.PrimitiveIdHash());
        this.makeIncompleteDataByPrimId = this.makeIncompleteData.foreignKey(new Storage.PrimitiveIdHash());
        for (OsmPrimitive osm : makeIncomplete) {
            this.makeIncompleteData.add(osm.save());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean executeCommand() {
        this.getAffectedDataSet().beginUpdate();
        try {
            this.purgedConflicts.get().clear();
            this.getAffectedDataSet().clearSelection(this.toPurge);
            for (int i = this.toPurge.size() - 1; i >= 0; --i) {
                OsmPrimitive osm = this.toPurge.get(i);
                if (this.makeIncompleteDataByPrimId.containsKey(osm)) {
                    PrimitiveData empty;
                    switch (osm.getType()) {
                        case NODE: {
                            empty = new NodeData();
                            break;
                        }
                        case WAY: {
                            empty = new WayData();
                            break;
                        }
                        case RELATION: {
                            empty = new RelationData();
                            break;
                        }
                        default: {
                            throw new AssertionError();
                        }
                    }
                    empty.setId(osm.getUniqueId());
                    empty.setIncomplete(true);
                    osm.load(empty);
                    continue;
                }
                this.getAffectedDataSet().removePrimitive((PrimitiveId)osm);
                Conflict<?> conflict = this.getAffectedDataSet().getConflicts().getConflictForMy(osm);
                if (conflict == null) continue;
                this.purgedConflicts.add(conflict);
                this.getAffectedDataSet().getConflicts().remove(conflict);
            }
            this.getAffectedDataSet().clearMappaintCache();
        }
        finally {
            this.getAffectedDataSet().endUpdate();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void undoCommand() {
        if (this.getAffectedDataSet() == null) {
            return;
        }
        this.getAffectedDataSet().beginUpdate();
        try {
            for (OsmPrimitive osm : this.toPurge) {
                PrimitiveData data = this.makeIncompleteDataByPrimId.get(osm);
                if (data != null) {
                    if (this.getAffectedDataSet().getPrimitiveById(osm) != osm) {
                        throw new AssertionError((Object)String.format("Primitive %s has been made incomplete when purging, but it cannot be found on undo.", osm));
                    }
                    osm.load(data);
                    continue;
                }
                if (this.getAffectedDataSet().getPrimitiveById(osm) != null) {
                    throw new AssertionError((Object)String.format("Primitive %s was removed when purging, but is still there on undo", osm));
                }
                this.getAffectedDataSet().addPrimitive(osm);
            }
            for (Conflict conflict : this.purgedConflicts) {
                this.getAffectedDataSet().getConflicts().add(conflict);
            }
            this.getAffectedDataSet().clearMappaintCache();
        }
        finally {
            this.getAffectedDataSet().endUpdate();
        }
    }

    public static List<OsmPrimitive> topoSort(Collection<OsmPrimitive> sel) {
        OsmPrimitive u;
        HashSet<OsmPrimitive> in = new HashSet<OsmPrimitive>(sel);
        ArrayList<OsmPrimitive> out = new ArrayList<OsmPrimitive>(in.size());
        HashSet<Node> remainingNodes = new HashSet<Node>(in.size());
        Iterator it = in.iterator();
        block0: while (it.hasNext()) {
            u = (OsmPrimitive)it.next();
            if (!(u instanceof Node)) continue;
            Node n = (Node)u;
            for (OsmPrimitive osmPrimitive : n.getReferrers()) {
                if (!(osmPrimitive instanceof Way) || !in.contains(osmPrimitive)) continue;
                it.remove();
                remainingNodes.add(n);
                continue block0;
            }
            it.remove();
            out.add(n);
        }
        it = in.iterator();
        while (it.hasNext()) {
            u = (OsmPrimitive)it.next();
            if (!(u instanceof Way)) continue;
            Iterator w = (Way)u;
            it.remove();
            for (Node node : ((Way)((Object)w)).getNodes()) {
                if (!remainingNodes.contains(node)) continue;
                remainingNodes.remove(node);
                out.add(node);
            }
            out.add((OsmPrimitive)((Object)w));
        }
        if (!remainingNodes.isEmpty()) {
            throw new AssertionError((Object)"topo sort algorithm failed (nodes remaining)");
        }
        HashSet<OsmPrimitive> inR = in;
        HashMap<Relation, Integer> numChilds = new HashMap<Relation, Integer>();
        for (Relation relation : inR) {
            numChilds.put(relation, 0);
        }
        for (Relation relation : inR) {
            for (OsmPrimitive parent : relation.getReferrers()) {
                if (!(parent instanceof Relation)) {
                    throw new AssertionError();
                }
                Integer i = (Integer)numChilds.get(parent);
                if (i == null) continue;
                numChilds.put((Relation)parent, i + 1);
            }
        }
        HashSet<Relation> childlessR = new HashSet<Relation>();
        for (Relation relation : inR) {
            if (!((Integer)numChilds.get(relation)).equals(0)) continue;
            childlessR.add(relation);
        }
        ArrayList<Relation> arrayList = new ArrayList<Relation>(inR.size());
        while (!childlessR.isEmpty()) {
            Iterator iterator = childlessR.iterator();
            Relation next = (Relation)iterator.next();
            iterator.remove();
            arrayList.add(next);
            for (OsmPrimitive parentPrim : next.getReferrers()) {
                Relation parent = (Relation)parentPrim;
                Integer i = (Integer)numChilds.get(parent);
                if (i == null) continue;
                numChilds.put(parent, i - 1);
                if (i - 1 != 0) continue;
                childlessR.add(parent);
            }
        }
        if (arrayList.size() != inR.size()) {
            throw new AssertionError((Object)"topo sort algorithm failed");
        }
        out.addAll(arrayList);
        return out;
    }

    @Override
    public String getDescriptionText() {
        return I18n.trn("Purged {0} object", "Purged {0} objects", this.toPurge.size(), this.toPurge.size());
    }

    @Override
    public Icon getDescriptionIcon() {
        return ImageProvider.get("data", "purge");
    }

    @Override
    public Collection<? extends OsmPrimitive> getParticipatingPrimitives() {
        return this.toPurge;
    }

    @Override
    public void fillModifiedData(Collection<OsmPrimitive> modified, Collection<OsmPrimitive> deleted, Collection<OsmPrimitive> added) {
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.toPurge, this.makeIncompleteData, this.makeIncompleteDataByPrimId, this.purgedConflicts, this.getAffectedDataSet());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        if (!super.equals(obj)) {
            return false;
        }
        PurgeCommand that = (PurgeCommand)obj;
        return Objects.equals(this.toPurge, that.toPurge) && Objects.equals(this.makeIncompleteData, that.makeIncompleteData) && Objects.equals(this.makeIncompleteDataByPrimId, that.makeIncompleteDataByPrimId) && Objects.equals(this.purgedConflicts, that.purgedConflicts);
    }

    /*
     * WARNING - void declaration
     */
    public static PurgeCommand build(Collection<OsmPrimitive> sel, List<OsmPrimitive> toPurgeAdditionally) {
        HashSet<OsmPrimitive> toPurge = new HashSet<OsmPrimitive>(sel);
        HashSet<OsmPrimitive> toPurgeChecked = new HashSet<OsmPrimitive>();
        HashSet<OsmPrimitive> toPurgeRecursive = new HashSet<OsmPrimitive>();
        while (!toPurge.isEmpty()) {
            for (OsmPrimitive osmPrimitive : toPurge) {
                for (OsmPrimitive osmPrimitive2 : osmPrimitive.getReferrers()) {
                    if (toPurge.contains(osmPrimitive2) || toPurgeChecked.contains(osmPrimitive2) || toPurgeRecursive.contains(osmPrimitive2) || !(osmPrimitive2 instanceof Way) && (!(osmPrimitive2 instanceof Relation) || !osmPrimitive.isNew())) continue;
                    if (toPurgeAdditionally != null) {
                        toPurgeAdditionally.add(osmPrimitive2);
                    }
                    toPurgeRecursive.add(osmPrimitive2);
                }
                toPurgeChecked.add(osmPrimitive);
            }
            toPurge = toPurgeRecursive;
            toPurgeRecursive = new HashSet();
        }
        HashSet<OsmPrimitive> makeIncomplete = new HashSet<OsmPrimitive>();
        block3: for (OsmPrimitive osmPrimitive : toPurgeChecked) {
            if (osmPrimitive.isNew()) continue;
            for (OsmPrimitive parent : osmPrimitive.getReferrers()) {
                if (!(parent instanceof Relation) || toPurgeChecked.contains(parent)) continue;
                makeIncomplete.add(osmPrimitive);
                continue block3;
            }
        }
        if (Config.getPref().getBoolean("purge.add_untagged_waynodes", true)) {
            HashSet<Node> hashSet = new HashSet<Node>();
            for (OsmPrimitive osmPrimitive : toPurgeChecked) {
                if (!(osmPrimitive instanceof Way)) continue;
                Way w = (Way)osmPrimitive;
                block6: for (Node n : w.getNodes()) {
                    if (n.isTagged() || toPurgeChecked.contains(n)) continue;
                    for (OsmPrimitive ref : n.getReferrers()) {
                        if (ref == w || toPurgeChecked.contains(ref)) continue;
                        continue block6;
                    }
                    hashSet.add(n);
                }
            }
            toPurgeChecked.addAll(hashSet);
            if (toPurgeAdditionally != null) {
                toPurgeAdditionally.addAll(hashSet);
            }
        }
        if (Config.getPref().getBoolean("purge.add_relations_with_only_incomplete_members", true)) {
            void var8_27;
            HashSet<Relation> hashSet = new HashSet<Relation>();
            for (OsmPrimitive osmPrimitive : toPurgeChecked) {
                for (OsmPrimitive parent : osmPrimitive.getReferrers()) {
                    if (!(parent instanceof Relation) || toPurgeChecked.contains(parent) || !PurgeCommand.hasOnlyIncompleteMembers((Relation)parent, toPurgeChecked, hashSet)) continue;
                    hashSet.add((Relation)parent);
                }
            }
            ArrayList<Relation> arrayList = new ArrayList<Relation>(hashSet);
            boolean bl = false;
            while (var8_27 < arrayList.size()) {
                for (OsmPrimitive parent : ((Relation)arrayList.get((int)var8_27)).getReferrers()) {
                    if (toPurgeChecked.contains(parent) || !PurgeCommand.hasOnlyIncompleteMembers((Relation)parent, toPurgeChecked, arrayList)) continue;
                    arrayList.add((Relation)parent);
                }
                ++var8_27;
            }
            HashSet hashSet2 = new HashSet(arrayList);
            toPurgeChecked.addAll(hashSet2);
            if (toPurgeAdditionally != null) {
                toPurgeAdditionally.addAll(hashSet2);
            }
        }
        return new PurgeCommand(((OsmPrimitive)toPurgeChecked.iterator().next()).getDataSet(), toPurgeChecked, makeIncomplete);
    }

    private static boolean hasOnlyIncompleteMembers(Relation r, Collection<OsmPrimitive> toPurge, Collection<? extends OsmPrimitive> moreToPurge) {
        for (RelationMember m : r.getMembers()) {
            if (m.getMember().isIncomplete() || toPurge.contains(m.getMember()) || moreToPurge.contains(m.getMember())) continue;
            return false;
        }
        return true;
    }
}

