/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.osm;

import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.coor.conversion.CoordinateFormatManager;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.IRelation;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.NameFormatterHook;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmUtils;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.history.HistoryNameFormatter;
import org.openstreetmap.josm.data.osm.history.HistoryNode;
import org.openstreetmap.josm.data.osm.history.HistoryOsmPrimitive;
import org.openstreetmap.josm.data.osm.history.HistoryRelation;
import org.openstreetmap.josm.data.osm.history.HistoryWay;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresetNameTemplateList;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.AlphanumComparator;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Utils;

public class DefaultNameFormatter
implements NameFormatter,
HistoryNameFormatter {
    private static DefaultNameFormatter instance;
    private static final List<NameFormatterHook> formatHooks;
    private static final String[] DEFAULT_NAMING_TAGS_FOR_RELATIONS;
    private static List<String> namingTagsForRelations;
    private final Comparator<Node> nodeComparator = (n1, n2) -> this.format((Node)n1).compareTo(this.format((Node)n2));
    private final Comparator<Way> wayComparator = (w1, w2) -> this.format((Way)w1).compareTo(this.format((Way)w2));
    private final Comparator<Relation> relationComparator = (r1, r2) -> {
        int comp3;
        TaggingPreset preset1 = TaggingPresetNameTemplateList.getInstance().findPresetTemplate((OsmPrimitive)r1);
        TaggingPreset preset2 = TaggingPresetNameTemplateList.getInstance().findPresetTemplate((OsmPrimitive)r2);
        if (preset1 != null || preset2 != null) {
            String name11 = DefaultNameFormatter.formatRelationNameAndType(r1, new StringBuilder(), preset1).toString();
            String name21 = DefaultNameFormatter.formatRelationNameAndType(r2, new StringBuilder(), preset2).toString();
            int comp1 = AlphanumComparator.getInstance().compare(name11, name21);
            if (comp1 != 0) {
                return comp1;
            }
        } else {
            String type1 = DefaultNameFormatter.getRelationTypeName(r1);
            String type2 = DefaultNameFormatter.getRelationTypeName(r2);
            int comp2 = AlphanumComparator.getInstance().compare(type1, type2);
            if (comp2 != 0) {
                return comp2;
            }
            String name12 = DefaultNameFormatter.getRelationName(r1);
            String name22 = DefaultNameFormatter.getRelationName(r2);
            comp2 = AlphanumComparator.getInstance().compare(name12, name22);
            if (comp2 != 0) {
                return comp2;
            }
        }
        if ((comp3 = Integer.compare(r1.getMembersCount(), r2.getMembersCount())) != 0) {
            return comp3;
        }
        comp3 = Boolean.compare(r1.hasIncompleteMembers(), r2.hasIncompleteMembers());
        if (comp3 != 0) {
            return comp3;
        }
        return Long.compare(r1.getUniqueId(), r2.getUniqueId());
    };

    public static synchronized DefaultNameFormatter getInstance() {
        if (instance == null) {
            instance = new DefaultNameFormatter();
        }
        return instance;
    }

    public static void registerFormatHook(NameFormatterHook hook) {
        if (hook == null) {
            return;
        }
        if (!formatHooks.contains(hook)) {
            formatHooks.add(0, hook);
        }
    }

    public static void unregisterFormatHook(NameFormatterHook hook) {
        if (hook == null) {
            return;
        }
        if (formatHooks.contains(hook)) {
            formatHooks.remove(hook);
        }
    }

    public static synchronized List<String> getNamingtagsForRelations() {
        if (namingTagsForRelations == null) {
            namingTagsForRelations = new ArrayList<String>(Config.getPref().getList("relation.nameOrder", Arrays.asList(DEFAULT_NAMING_TAGS_FOR_RELATIONS)));
        }
        return namingTagsForRelations;
    }

    protected void decorateNameWithId(StringBuilder name, IPrimitive primitive) {
        if (Config.getPref().getBoolean("osm-primitives.showid")) {
            if (Config.getPref().getBoolean("osm-primitives.showid.new-primitives")) {
                name.append(I18n.tr(" [id: {0}]", primitive.getUniqueId()));
            } else {
                name.append(I18n.tr(" [id: {0}]", primitive.getId()));
            }
        }
    }

    public String format(OsmPrimitive osm) {
        if (osm instanceof Node) {
            return this.format((Node)osm);
        }
        if (osm instanceof Way) {
            return this.format((Way)osm);
        }
        if (osm instanceof Relation) {
            return this.format((Relation)osm);
        }
        return null;
    }

    @Override
    public String format(Node node) {
        StringBuilder name = new StringBuilder();
        if (node.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(node);
            if (preset == null) {
                String n = Config.getPref().getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
                if (n == null) {
                    String s = node.get("addr:housename");
                    if (s != null) {
                        n = I18n.tr("House {0}", s);
                    }
                    if (n == null && (s = node.get("addr:housenumber")) != null) {
                        String t = node.get("addr:street");
                        n = t != null ? I18n.tr("House number {0} at {1}", s, t) : I18n.tr("House number {0}", s);
                    }
                }
                if (n == null) {
                    n = node.isNew() ? I18n.tr("node", new Object[0]) : Long.toString(node.getId());
                }
                name.append(n);
            } else {
                preset.nameTemplate.appendText(name, node);
            }
            if (node.isLatLonKnown() && Config.getPref().getBoolean("osm-primitives.showcoor")) {
                name.append(" \u200e(").append(CoordinateFormatManager.getDefaultFormat().latToString(node)).append(", ").append(CoordinateFormatManager.getDefaultFormat().lonToString(node)).append(')');
            }
        }
        this.decorateNameWithId(name, node);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(node, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    @Override
    public Comparator<Node> getNodeComparator() {
        return this.nodeComparator;
    }

    @Override
    public String format(Way way) {
        StringBuilder name = new StringBuilder();
        char mark = ComponentOrientation.getOrientation(Locale.getDefault()).isLeftToRight() ? (char)'\u200e' : '\u200f';
        name.append(mark);
        if (way.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(way);
            if (preset == null) {
                String n = Config.getPref().getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
                if (n == null) {
                    n = way.get("ref");
                }
                if (n == null) {
                    String string = way.hasKey("highway") ? I18n.tr("highway", new Object[0]) : (way.hasKey("railway") ? I18n.tr("railway", new Object[0]) : (way.hasKey("waterway") ? I18n.tr("waterway", new Object[0]) : (n = way.hasKey("landuse") ? I18n.tr("landuse", new Object[0]) : null)));
                }
                if (n == null) {
                    String s = way.get("addr:housename");
                    if (s != null) {
                        n = I18n.tr("House {0}", s);
                    }
                    if (n == null && (s = way.get("addr:housenumber")) != null) {
                        String t = way.get("addr:street");
                        n = t != null ? I18n.tr("House number {0} at {1}", s, t) : I18n.tr("House number {0}", s);
                    }
                }
                if (n == null && way.hasKey("building")) {
                    n = I18n.tr("building", new Object[0]);
                }
                if (n == null || n.isEmpty()) {
                    n = String.valueOf(way.getId());
                }
                name.append(n);
            } else {
                preset.nameTemplate.appendText(name, way);
            }
            int nodesNo = way.getRealNodesCount();
            String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
            name.append(mark).append(" (").append(nodes).append(')');
        }
        this.decorateNameWithId(name, way);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(way, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    @Override
    public Comparator<Way> getWayComparator() {
        return this.wayComparator;
    }

    @Override
    public String format(Relation relation) {
        StringBuilder name = new StringBuilder();
        if (relation.isIncomplete()) {
            name.append(I18n.tr("incomplete", new Object[0]));
        } else {
            TaggingPreset preset = TaggingPresetNameTemplateList.getInstance().findPresetTemplate(relation);
            DefaultNameFormatter.formatRelationNameAndType(relation, name, preset);
            int mbno = relation.getMembersCount();
            name.append(I18n.trn("{0} member", "{0} members", mbno, mbno));
            if (relation.hasIncompleteMembers()) {
                name.append(", ").append(I18n.tr("incomplete", new Object[0]));
            }
            name.append(')');
        }
        this.decorateNameWithId(name, relation);
        String result = name.toString();
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkFormat(relation, result);
            if (hookResult == null) continue;
            return hookResult;
        }
        return result;
    }

    private static StringBuilder formatRelationNameAndType(Relation relation, StringBuilder result, TaggingPreset preset) {
        if (preset == null) {
            result.append(DefaultNameFormatter.getRelationTypeName(relation));
            String relationName = DefaultNameFormatter.getRelationName(relation);
            relationName = relationName == null ? Long.toString(relation.getId()) : '\"' + relationName + '\"';
            result.append(" (").append(relationName).append(", ");
        } else {
            preset.nameTemplate.appendText(result, relation);
            result.append('(');
        }
        return result;
    }

    @Override
    public Comparator<Relation> getRelationComparator() {
        return this.relationComparator;
    }

    private static String getRelationTypeName(IRelation relation) {
        String adminLevel;
        String name = I18n.trc("Relation type", relation.get("type"));
        if (name == null) {
            String string = name = relation.hasKey("public_transport") ? I18n.tr("public transport", new Object[0]) : null;
        }
        if (name == null) {
            String building = relation.get("building");
            if (OsmUtils.isTrue(building)) {
                name = I18n.tr("building", new Object[0]);
            } else if (building != null) {
                name = I18n.tr(building, new Object[0]);
            }
        }
        if (name == null) {
            name = I18n.trc("Place type", relation.get("place"));
        }
        if (name == null) {
            name = I18n.tr("relation", new Object[0]);
        }
        if ((adminLevel = relation.get("admin_level")) != null) {
            name = name + '[' + adminLevel + ']';
        }
        for (NameFormatterHook hook : formatHooks) {
            String hookResult = hook.checkRelationTypeName(relation, name);
            if (hookResult == null) continue;
            return hookResult;
        }
        return name;
    }

    private static String getNameTagValue(IRelation relation, String nameTag) {
        if ("name".equals(nameTag)) {
            if (Config.getPref().getBoolean("osm-primitives.localize-name", true)) {
                return relation.getLocalName();
            }
            return relation.getName();
        }
        if (":LocationCode".equals(nameTag)) {
            for (String m : relation.keySet()) {
                if (!m.endsWith(nameTag)) continue;
                return relation.get(m);
            }
            return null;
        }
        if (nameTag.startsWith("?") && OsmUtils.isTrue(relation.get(nameTag.substring(1)))) {
            return I18n.tr(nameTag.substring(1), new Object[0]);
        }
        if (nameTag.startsWith("?") && OsmUtils.isFalse(relation.get(nameTag.substring(1)))) {
            return null;
        }
        if (nameTag.startsWith("?")) {
            return I18n.trcLazy(nameTag, I18n.escape(relation.get(nameTag.substring(1))));
        }
        return I18n.trcLazy(nameTag, I18n.escape(relation.get(nameTag)));
    }

    private static String getRelationName(IRelation relation) {
        for (String n : DefaultNameFormatter.getNamingtagsForRelations()) {
            String nameTag = DefaultNameFormatter.getNameTagValue(relation, n);
            if (nameTag == null) continue;
            return nameTag;
        }
        return null;
    }

    @Override
    public String format(Changeset changeset) {
        return I18n.tr("Changeset {0}", changeset.getId());
    }

    public String buildDefaultToolTip(IPrimitive primitive) {
        return DefaultNameFormatter.buildDefaultToolTip(primitive.getId(), primitive.getKeys());
    }

    private static String buildDefaultToolTip(long id, Map<String, String> tags) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("<html><strong>id</strong>=").append(id).append("<br>");
        ArrayList<String> keyList = new ArrayList<String>(tags.keySet());
        Collections.sort(keyList);
        for (int i = 0; i < keyList.size(); ++i) {
            if (i > 0) {
                sb.append("<br>");
            }
            String key = (String)keyList.get(i);
            sb.append("<strong>").append(Utils.escapeReservedCharactersHTML(key)).append("</strong>=");
            String value = tags.get(key);
            while (!value.isEmpty()) {
                sb.append(Utils.escapeReservedCharactersHTML(value.substring(0, Math.min(50, value.length()))));
                if (value.length() > 50) {
                    sb.append("<br>");
                    value = value.substring(50);
                    continue;
                }
                value = "";
            }
        }
        sb.append("</html>");
        return sb.toString();
    }

    protected void decorateNameWithId(StringBuilder name, HistoryOsmPrimitive primitive) {
        if (Config.getPref().getBoolean("osm-primitives.showid")) {
            name.append(I18n.tr(" [id: {0}]", primitive.getId()));
        }
    }

    @Override
    public String format(HistoryNode node) {
        StringBuilder sb = new StringBuilder();
        String name = Config.getPref().getBoolean("osm-primitives.localize-name", true) ? node.getLocalName() : node.getName();
        if (name == null) {
            sb.append(node.getId());
        } else {
            sb.append(name);
        }
        LatLon coord = node.getCoords();
        if (coord != null) {
            sb.append(" (").append(CoordinateFormatManager.getDefaultFormat().latToString(coord)).append(", ").append(CoordinateFormatManager.getDefaultFormat().lonToString(coord)).append(')');
        }
        this.decorateNameWithId(sb, node);
        return sb.toString();
    }

    @Override
    public String format(HistoryWay way) {
        StringBuilder sb = new StringBuilder();
        String name = Config.getPref().getBoolean("osm-primitives.localize-name", true) ? way.getLocalName() : way.getName();
        if (name != null) {
            sb.append(name);
        }
        if (sb.length() == 0 && way.get("ref") != null) {
            sb.append(way.get("ref"));
        }
        if (sb.length() == 0) {
            sb.append(way.hasKey("highway") ? I18n.tr("highway", new Object[0]) : (way.hasKey("railway") ? I18n.tr("railway", new Object[0]) : (way.hasKey("waterway") ? I18n.tr("waterway", new Object[0]) : (way.hasKey("landuse") ? I18n.tr("landuse", new Object[0]) : ""))));
        }
        int nodesNo = way.isClosed() ? way.getNumNodes() - 1 : way.getNumNodes();
        String nodes = I18n.trn("{0} node", "{0} nodes", nodesNo, nodesNo);
        if (sb.length() == 0) {
            sb.append(way.getId());
        }
        sb.append(sb.length() > 0 ? " (" + nodes + ')' : nodes);
        this.decorateNameWithId(sb, way);
        return sb.toString();
    }

    @Override
    public String format(HistoryRelation relation) {
        StringBuilder sb = new StringBuilder();
        String type = relation.get("type");
        if (type != null) {
            sb.append(type);
        } else {
            sb.append(I18n.tr("relation", new Object[0]));
        }
        sb.append(" (");
        String nameTag = null;
        HashSet<String> namingTags = new HashSet<String>(DefaultNameFormatter.getNamingtagsForRelations());
        for (String n : relation.getTags().keySet()) {
            if (namingTags.contains(n.trim()) && (nameTag = Config.getPref().getBoolean("osm-primitives.localize-name", true) ? relation.getLocalName() : relation.getName()) == null) {
                nameTag = relation.get(n);
            }
            if (nameTag == null) continue;
            break;
        }
        if (nameTag == null) {
            sb.append(Long.toString(relation.getId())).append(", ");
        } else {
            sb.append('\"').append(nameTag).append("\", ");
        }
        int mbno = relation.getNumMembers();
        sb.append(I18n.trn("{0} member", "{0} members", mbno, mbno)).append(')');
        this.decorateNameWithId(sb, relation);
        return sb.toString();
    }

    public String buildDefaultToolTip(HistoryOsmPrimitive primitive) {
        return DefaultNameFormatter.buildDefaultToolTip(primitive.getId(), primitive.getTags());
    }

    public String formatAsHtmlUnorderedList(Collection<? extends OsmPrimitive> primitives, int maxElements) {
        Collection displayNames = primitives.stream().map(x -> x.getDisplayName(this)).collect(Collectors.toList());
        return Utils.joinAsHtmlUnorderedList(Utils.limit(displayNames, maxElements, "..."));
    }

    public String formatAsHtmlUnorderedList(OsmPrimitive primitive) {
        return this.formatAsHtmlUnorderedList(Collections.singletonList(primitive), 1);
    }

    static {
        formatHooks = new LinkedList<NameFormatterHook>();
        DEFAULT_NAMING_TAGS_FOR_RELATIONS = new String[]{"name", "ref", "restriction", "landuse", "natural", "leisure", "amenity", "public_transport", ":LocationCode", "note", "?building"};
    }
}

