/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifiableCodeBlock;
import com.intellij.psi.impl.source.tree.LazyParseablePsiElement;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPsiUtil;
import org.jetbrains.kotlin.psi.KtVisitor;

public class KtLambdaExpression
extends LazyParseablePsiElement
implements PsiModifiableCodeBlock,
KtExpression {
    public KtLambdaExpression(CharSequence text2) {
        super(KtNodeTypes.LAMBDA_EXPRESSION, text2);
    }

    @Override
    public <R, D> R accept(@NotNull KtVisitor<R, D> visitor2, D data) {
        return visitor2.visitLambdaExpression(this, data);
    }

    @NotNull
    public KtFunctionLiteral getFunctionLiteral() {
        return this.findChildByType(KtNodeTypes.FUNCTION_LITERAL).getPsi(KtFunctionLiteral.class);
    }

    @NotNull
    public List<KtParameter> getValueParameters() {
        return this.getFunctionLiteral().getValueParameters();
    }

    @Nullable
    public KtBlockExpression getBodyExpression() {
        return this.getFunctionLiteral().getBodyExpression();
    }

    public boolean hasDeclaredReturnType() {
        return this.getFunctionLiteral().getTypeReference() != null;
    }

    @NotNull
    public KtElement asElement() {
        return this;
    }

    @NotNull
    public ASTNode getLeftCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(KtTokens.LBRACE);
    }

    @Nullable
    public ASTNode getRightCurlyBrace() {
        return this.getFunctionLiteral().getNode().findChildByType(KtTokens.RBRACE);
    }

    @Override
    @NotNull
    public KtFile getContainingKtFile() {
        PsiFile file2 = this.getContainingFile();
        assert (file2 instanceof KtFile) : "KtElement not inside KtFile: " + file2 + " " + file2.getText();
        return (KtFile)file2;
    }

    @Override
    public <D> void acceptChildren(@NotNull KtVisitor<Void, D> visitor2, D data) {
        KtPsiUtil.visitChildren(this, visitor2, data);
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 instanceof KtVisitor) {
            this.accept((KtVisitor)visitor2, null);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    public String toString() {
        return this.getNode().getElementType().toString();
    }

    @Override
    @NotNull
    public KtElement getPsiOrParent() {
        return this;
    }

    @Override
    public boolean shouldChangeModificationCount(PsiElement place) {
        return false;
    }
}

