/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.repository.legacy.resolver.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.artifact.repository.RepositoryRequest;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataManager;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.SnapshotArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.repository.legacy.WagonManager;
import org.apache.maven.repository.legacy.resolver.transform.ArtifactTransformation;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractVersionTransformation
extends AbstractLogEnabled
implements ArtifactTransformation {
    @Requirement
    protected RepositoryMetadataManager repositoryMetadataManager;
    @Requirement
    protected WagonManager wagonManager;

    @Override
    public void transformForResolve(Artifact artifact, List<ArtifactRepository> remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        this.transformForResolve(artifact, (RepositoryRequest)request);
    }

    protected String resolveVersion(Artifact artifact, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) throws RepositoryMetadataResolutionException {
        DefaultRepositoryRequest request = new DefaultRepositoryRequest();
        request.setLocalRepository(localRepository);
        request.setRemoteRepositories(remoteRepositories);
        return this.resolveVersion(artifact, (RepositoryRequest)request);
    }

    protected String resolveVersion(Artifact artifact, RepositoryRequest request) throws RepositoryMetadataResolutionException {
        Object metadata = !artifact.isSnapshot() || "LATEST".equals(artifact.getBaseVersion()) ? new ArtifactRepositoryMetadata(artifact) : new SnapshotArtifactRepositoryMetadata(artifact);
        this.repositoryMetadataManager.resolve((RepositoryMetadata)metadata, request);
        artifact.addMetadata((ArtifactMetadata)metadata);
        Metadata repoMetadata = metadata.getMetadata();
        String version = null;
        if (repoMetadata != null && repoMetadata.getVersioning() != null) {
            version = this.constructVersion(repoMetadata.getVersioning(), artifact.getBaseVersion());
        }
        if (version == null) {
            version = artifact.getBaseVersion();
        }
        if (this.getLogger().isDebugEnabled()) {
            if (!version.equals(artifact.getBaseVersion())) {
                String message = artifact.getArtifactId() + ": resolved to version " + version;
                message = artifact.getRepository() != null ? message + " from repository " + artifact.getRepository().getId() : message + " from local repository";
                this.getLogger().debug(message);
            } else {
                this.getLogger().debug(artifact.getArtifactId() + ": using locally installed snapshot");
            }
        }
        return version;
    }

    protected abstract String constructVersion(Versioning var1, String var2);
}

