/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.spi.ProjectUtilitiesProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class ProjectUtilities {
    public static Lookup.Provider getMainProject() {
        return ProjectUtilities.provider().getMainProject();
    }

    public static Lookup.Provider[] getOpenedProjects() {
        return ProjectUtilities.provider().getOpenedProjects();
    }

    public static String getDisplayName(Lookup.Provider provider) {
        return ProjectUtilities.provider().getDisplayName(provider);
    }

    public static FileObject getProjectDirectory(Lookup.Provider provider) {
        return ProjectUtilities.provider().getProjectDirectory(provider);
    }

    public static Icon getIcon(Lookup.Provider provider) {
        return ProjectUtilities.provider().getIcon(provider);
    }

    public static boolean hasSubprojects(Lookup.Provider provider) {
        return ProjectUtilities.provider().hasSubprojects(provider);
    }

    public static void fetchSubprojects(Lookup.Provider provider, Set<Lookup.Provider> set) {
        ProjectUtilities.provider().fetchSubprojects(provider, set);
    }

    public static Lookup.Provider getProject(FileObject fileObject) {
        return ProjectUtilities.provider().getProject(fileObject);
    }

    public static void addOpenProjectsListener(ChangeListener changeListener) {
        ProjectUtilities.provider().addOpenProjectsListener(changeListener);
    }

    public static void removeOpenProjectsListener(ChangeListener changeListener) {
        ProjectUtilities.provider().removeOpenProjectsListener(changeListener);
    }

    public static Lookup.Provider[] getSortedProjects(Lookup.Provider[] providerArray) {
        List<Lookup.Provider> list = Arrays.asList(providerArray);
        Collections.sort(list, new Comparator(){

            public int compare(Object object, Object object2) {
                Lookup.Provider provider = (Lookup.Provider)object;
                Lookup.Provider provider2 = (Lookup.Provider)object2;
                return ProjectUtilities.getDisplayName(provider).toLowerCase().compareTo(ProjectUtilities.getDisplayName(provider2).toLowerCase());
            }
        });
        list.toArray(providerArray);
        return providerArray;
    }

    private static ProjectUtilitiesProvider provider() {
        return (ProjectUtilitiesProvider)Lookup.getDefault().lookup(ProjectUtilitiesProvider.class);
    }
}

