/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.state.DefaultNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.FileContentSnapshot;
import org.gradle.api.internal.changedetection.state.FileSnapshot;
import org.gradle.api.internal.changedetection.state.IgnoredPathFileSnapshot;
import org.gradle.api.internal.changedetection.state.IndexedNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.NonNormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.NormalizedFileSnapshot;
import org.gradle.api.internal.changedetection.state.PathNormalizationStrategy;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.internal.file.FileType;
import org.gradle.util.GUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum InputPathNormalizationStrategy implements PathNormalizationStrategy
{
    ABSOLUTE{

        public boolean isPathAbsolute() {
            return true;
        }

        @Nonnull
        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            return new NonNormalizedFileSnapshot(fileSnapshot.getPath(), fileSnapshot.getContent());
        }
    }
    ,
    RELATIVE{

        public boolean isPathAbsolute() {
            return false;
        }

        @Nonnull
        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.isRoot() && fileSnapshot.getType() == FileType.Directory) {
                return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
            }
            return 2.getRelativeSnapshot(fileSnapshot, stringInterner);
        }
    }
    ,
    NAME_ONLY{

        public boolean isPathAbsolute() {
            return false;
        }

        @Nonnull
        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.isRoot() && fileSnapshot.getType() == FileType.Directory) {
                return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
            }
            return 3.getRelativeSnapshot(fileSnapshot, fileSnapshot.getName(), stringInterner);
        }
    }
    ,
    NONE{

        public boolean isPathAbsolute() {
            return false;
        }

        @Nullable
        public NormalizedFileSnapshot getNormalizedSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
            if (fileSnapshot.getType() == FileType.Directory) {
                return null;
            }
            return new IgnoredPathFileSnapshot(fileSnapshot.getContent());
        }
    };


    public static InputPathNormalizationStrategy valueOf(PathSensitivity pathSensitivity) {
        switch (pathSensitivity) {
            case ABSOLUTE: {
                return ABSOLUTE;
            }
            case RELATIVE: {
                return RELATIVE;
            }
            case NAME_ONLY: {
                return NAME_ONLY;
            }
            case NONE: {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown path usage: " + pathSensitivity);
    }

    @VisibleForTesting
    static NormalizedFileSnapshot getRelativeSnapshot(FileSnapshot fileSnapshot, StringInterner stringInterner) {
        return InputPathNormalizationStrategy.getRelativeSnapshot(fileSnapshot, (CharSequence)fileSnapshot.getRelativePath(), stringInterner);
    }

    static NormalizedFileSnapshot getRelativeSnapshot(FileSnapshot fileSnapshot, CharSequence normalizedPath, StringInterner stringInterner) {
        String absolutePath = fileSnapshot.getPath();
        FileContentSnapshot contentSnapshot = fileSnapshot.getContent();
        if (InputPathNormalizationStrategy.lineSeparatorsMatch(absolutePath, normalizedPath)) {
            return new IndexedNormalizedFileSnapshot(absolutePath, absolutePath.length() - normalizedPath.length(), contentSnapshot);
        }
        return new DefaultNormalizedFileSnapshot(stringInterner.intern(normalizedPath.toString()), contentSnapshot);
    }

    private static boolean lineSeparatorsMatch(String absolutePath, CharSequence normalizedPath) {
        return GUtil.endsWith((CharSequence)absolutePath, (CharSequence)normalizedPath);
    }
}

