/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.properties;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.tasks.PropertySpecFactory;
import org.gradle.api.internal.tasks.TaskValidationContext;
import org.gradle.api.internal.tasks.ValidationAction;
import org.gradle.api.internal.tasks.properties.AbstractNestedPropertyContext;
import org.gradle.api.internal.tasks.properties.BeanNode;
import org.gradle.api.internal.tasks.properties.NestedPropertyContext;
import org.gradle.api.internal.tasks.properties.PropertyMetadata;
import org.gradle.api.internal.tasks.properties.PropertyMetadataStore;
import org.gradle.api.internal.tasks.properties.PropertyValue;
import org.gradle.api.internal.tasks.properties.PropertyValueVisitor;
import org.gradle.api.internal.tasks.properties.PropertyVisitor;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.internal.tasks.properties.TypeMetadata;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.Optional;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.gradle.util.DeferredUtil;
import org.gradle.util.DeprecationLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullApi
public class DefaultPropertyWalker
implements PropertyWalker {
    private final PropertyMetadataStore propertyMetadataStore;

    public DefaultPropertyWalker(PropertyMetadataStore propertyMetadataStore) {
        this.propertyMetadataStore = propertyMetadataStore;
    }

    @Override
    public void visitProperties(PropertySpecFactory specFactory, PropertyVisitor visitor, Object bean) {
        ArrayDeque<NestedBeanContext> queue = new ArrayDeque<NestedBeanContext>();
        queue.add(new NestedBeanContext(new BeanNode(null, bean), queue, null));
        while (!queue.isEmpty()) {
            NestedBeanContext context = (NestedBeanContext)queue.remove();
            BeanNode node = context.getCurrentNode();
            DefaultPropertyWalker.visitProperties(node, visitor, specFactory, context, this.propertyMetadataStore.getTypeMetadata(node.getBeanClass()));
        }
    }

    private static void visitProperties(BeanNode node, PropertyVisitor visitor, PropertySpecFactory specFactory, NestedPropertyContext<BeanNode> propertyContext, TypeMetadata typeMetadata) {
        for (PropertyMetadata propertyMetadata : typeMetadata.getPropertiesMetadata()) {
            PropertyValueVisitor propertyValueVisitor = propertyMetadata.getPropertyValueVisitor();
            if (propertyValueVisitor == null) continue;
            String propertyName = node.getQualifiedPropertyName(propertyMetadata.getFieldName());
            Object bean = node.getBean();
            DefaultPropertyValue propertyValue = new DefaultPropertyValue(propertyName, propertyMetadata.getAnnotations(), bean, propertyMetadata.getMethod());
            propertyValueVisitor.visitPropertyValue(propertyValue, visitor, specFactory, propertyContext);
        }
    }

    private static class ParentBeanNodeList {
        private final ParentBeanNodeList parent;
        private final BeanNode node;

        public ParentBeanNodeList(@Nullable ParentBeanNodeList parent, BeanNode node) {
            this.parent = parent;
            this.node = node;
        }

        public void checkCycles(BeanNode childNode) {
            Preconditions.checkState((this.node.getBean() != childNode.getBean() ? 1 : 0) != 0, (String)"Cycles between nested beans are not allowed. Cycle detected between: '%s' and '%s'.", (Object[])new Object[]{this.node, childNode});
            if (this.parent != null) {
                this.parent.checkCycles(childNode);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NestedBeanContext
    extends AbstractNestedPropertyContext<BeanNode> {
        private final BeanNode currentNode;
        private final Queue<NestedBeanContext> queue;
        private final ParentBeanNodeList parentNodes;

        public NestedBeanContext(BeanNode currentNode, @Nullable Queue<NestedBeanContext> queue, ParentBeanNodeList parentNodes) {
            super(DefaultPropertyWalker.this.propertyMetadataStore);
            this.currentNode = currentNode;
            this.queue = queue;
            this.parentNodes = parentNodes;
            if (parentNodes != null) {
                parentNodes.checkCycles(currentNode);
            }
        }

        @Override
        public void addNested(BeanNode node) {
            this.queue.add(new NestedBeanContext(node, this.queue, new ParentBeanNodeList(this.parentNodes, this.currentNode)));
        }

        public BeanNode getCurrentNode() {
            return this.currentNode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DefaultPropertyValue
    implements PropertyValue {
        private final String propertyName;
        private final List<Annotation> annotations;
        private final Object bean;
        private final Method method;
        private final Supplier<Object> valueSupplier = Suppliers.memoize((Supplier)new Supplier<Object>(){

            @Nullable
            public Object get() {
                Object value = DeprecationLogger.whileDisabled((Factory)new Factory<Object>(){

                    public Object create() {
                        try {
                            return DefaultPropertyValue.this.method.invoke(DefaultPropertyValue.this.bean, new Object[0]);
                        }
                        catch (InvocationTargetException e) {
                            throw UncheckedException.throwAsUncheckedException((Throwable)e.getCause());
                        }
                        catch (Exception e) {
                            throw new GradleException(String.format("Could not call %s.%s() on %s", DefaultPropertyValue.this.method.getDeclaringClass().getSimpleName(), DefaultPropertyValue.this.method.getName(), DefaultPropertyValue.this.bean), (Throwable)e);
                        }
                    }
                });
                return value instanceof Provider ? ((Provider)value).getOrNull() : value;
            }
        });

        public DefaultPropertyValue(String propertyName, List<Annotation> annotations, Object bean, Method method) {
            this.propertyName = propertyName;
            this.annotations = ImmutableList.copyOf(annotations);
            this.bean = bean;
            this.method = method;
            method.setAccessible(true);
        }

        @Override
        public String getPropertyName() {
            return this.propertyName;
        }

        @Override
        public boolean isAnnotationPresent(Class<? extends Annotation> annotationType) {
            return this.getAnnotation(annotationType) != null;
        }

        @Override
        @Nullable
        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            for (Annotation annotation : this.annotations) {
                if (!annotationType.equals(annotation.annotationType())) continue;
                return (A)((Annotation)annotationType.cast(annotation));
            }
            return null;
        }

        @Override
        public boolean isOptional() {
            return this.isAnnotationPresent(Optional.class);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.valueSupplier.get();
        }

        @Override
        @Nullable
        public Object call() {
            return this.getValue();
        }

        @Override
        public void validate(String propertyName, boolean optional, ValidationAction valueValidator, TaskValidationContext context) {
            Object unpacked = DeferredUtil.unpack(this.getValue());
            if (unpacked == null) {
                if (!optional) {
                    context.recordValidationMessage(TaskValidationContext.Severity.ERROR, String.format("No value has been specified for property '%s'.", propertyName));
                }
            } else {
                valueValidator.validate(propertyName, unpacked, context, TaskValidationContext.Severity.ERROR);
            }
        }
    }
}

