/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch.jdk7;

import com.google.common.base.Throwables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchService;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.internal.filewatch.FileWatcher;
import org.gradle.internal.filewatch.FileWatcherEvent;
import org.gradle.internal.filewatch.FileWatcherListener;
import org.gradle.internal.filewatch.jdk7.WatchServicePoller;
import org.gradle.internal.filewatch.jdk7.WatchServiceRegistrar;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WatchServiceFileWatcherBacking {
    private static final Logger LOGGER = LoggerFactory.getLogger(WatchServiceFileWatcherBacking.class);
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicBoolean running = new AtomicBoolean();
    private final AtomicBoolean stopped = new AtomicBoolean();
    private final AtomicReference<SoftReference<Thread>> pollerThreadReference = new AtomicReference();
    private final Action<? super Throwable> onError;
    private final WatchServiceRegistrar watchServiceRegistrar;
    private final WatchService watchService;
    private final WatchServicePoller poller;
    private final FileWatcher fileWatcher = new FileWatcher(){

        public boolean isRunning() {
            return WatchServiceFileWatcherBacking.this.running.get();
        }

        public void watch(FileSystemSubset fileSystemSubset) throws IOException {
            WatchServiceFileWatcherBacking.this.watchServiceRegistrar.watch(fileSystemSubset);
        }

        public void stop() {
            WatchServiceFileWatcherBacking.this.stop();
        }
    };

    WatchServiceFileWatcherBacking(Action<? super Throwable> onError, FileWatcherListener listener, WatchService watchService, FileSystem fileSystem) throws IOException {
        this(onError, listener, watchService, new WatchServiceRegistrar(watchService, listener, fileSystem));
    }

    WatchServiceFileWatcherBacking(Action<? super Throwable> onError, FileWatcherListener listener, WatchService watchService, WatchServiceRegistrar watchServiceRegistrar) throws IOException {
        this.onError = onError;
        this.watchServiceRegistrar = watchServiceRegistrar;
        this.watchService = watchService;
        this.poller = new WatchServicePoller(watchService);
    }

    public FileWatcher start(ListeningExecutorService executorService) {
        if (this.started.compareAndSet(false, true)) {
            ListenableFuture runLoopFuture = executorService.submit(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    if (!WatchServiceFileWatcherBacking.this.stopped.get()) {
                        WatchServiceFileWatcherBacking.this.pollerThreadReference.set(new SoftReference<Thread>(Thread.currentThread()));
                        WatchServiceFileWatcherBacking.this.running.set(true);
                        try {
                            try {
                                WatchServiceFileWatcherBacking.this.pumpEvents();
                            }
                            catch (InterruptedException interruptedException) {
                            }
                            catch (Throwable t) {
                                if (!(Throwables.getRootCause((Throwable)t) instanceof InterruptedException)) {
                                    WatchServiceFileWatcherBacking.this.stop();
                                    WatchServiceFileWatcherBacking.this.onError.execute((Object)t);
                                }
                            }
                        }
                        finally {
                            WatchServiceFileWatcherBacking.this.stop();
                        }
                    }
                }
            });
            Futures.addCallback((ListenableFuture)runLoopFuture, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(Object result) {
                    WatchServiceFileWatcherBacking.this.running.set(false);
                }

                public void onFailure(Throwable t) {
                    WatchServiceFileWatcherBacking.this.running.set(false);
                }
            });
            return this.fileWatcher;
        }
        throw new IllegalStateException("file watcher is started");
    }

    private void pumpEvents() throws InterruptedException {
        while (this.isRunning()) {
            try {
                List<FileWatcherEvent> events = this.poller.takeEvents();
                if (events == null) continue;
                this.deliverEvents(events);
            }
            catch (ClosedWatchServiceException e) {
                LOGGER.debug("Received ClosedWatchServiceException, stopping");
                this.stop();
            }
        }
    }

    private void deliverEvents(List<FileWatcherEvent> events) {
        for (FileWatcherEvent event : events) {
            if (!this.isRunning()) {
                LOGGER.debug("File watching isn't running, breaking out of event delivery.");
                break;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Received file system event: {}", (Object)event);
            }
            this.watchServiceRegistrar.onChange(this.fileWatcher, event);
        }
    }

    private boolean isRunning() {
        return this.running.get() && !Thread.currentThread().isInterrupted();
    }

    private void stop() {
        if (this.stopped.compareAndSet(false, true) && this.running.compareAndSet(true, false)) {
            LOGGER.debug("Stopping file watching");
            this.interruptPollerThread();
            try {
                this.watchService.close();
            }
            catch (IOException iOException) {
            }
            catch (ClosedWatchServiceException closedWatchServiceException) {
                // empty catch block
            }
        }
    }

    private void interruptPollerThread() {
        Thread pollerThread;
        SoftReference threadSoftReference = this.pollerThreadReference.getAndSet(null);
        if (threadSoftReference != null && (pollerThread = (Thread)threadSoftReference.get()) != null && pollerThread != Thread.currentThread()) {
            LOGGER.debug("Interrupting poller thread '{}'", (Object)pollerThread.getName());
            pollerThread.interrupt();
        }
    }
}

