/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model;

import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.VersionConstraint;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableVersionConstraint;
import org.gradle.api.internal.artifacts.dependencies.DefaultImmutableVersionConstraint;

public class DefaultModuleComponentSelector
implements ModuleComponentSelector {
    private final String group;
    private final String module;
    private final ImmutableVersionConstraint versionConstraint;

    private DefaultModuleComponentSelector(String group, String module, ImmutableVersionConstraint version) {
        assert (group != null) : "group cannot be null";
        assert (module != null) : "module cannot be null";
        assert (version != null) : "version cannot be null";
        this.group = group;
        this.module = module;
        this.versionConstraint = version;
    }

    public String getDisplayName() {
        StringBuilder builder = new StringBuilder(this.group.length() + this.module.length() + this.versionConstraint.getPreferredVersion().length() + 2);
        builder.append(this.group);
        builder.append(":");
        builder.append(this.module);
        if (this.versionConstraint.getPreferredVersion().length() > 0) {
            builder.append(":");
            builder.append(this.versionConstraint.getPreferredVersion());
        }
        if (this.versionConstraint.getBranch() != null) {
            builder.append(" (branch: ");
            builder.append(this.versionConstraint.getBranch());
            builder.append(")");
        }
        return builder.toString();
    }

    public String getGroup() {
        return this.group;
    }

    public String getModule() {
        return this.module;
    }

    public String getVersion() {
        return this.versionConstraint.getPreferredVersion();
    }

    public VersionConstraint getVersionConstraint() {
        return this.versionConstraint;
    }

    public boolean matchesStrictly(ComponentIdentifier identifier) {
        assert (identifier != null) : "identifier cannot be null";
        if (identifier instanceof ModuleComponentIdentifier) {
            ModuleComponentIdentifier moduleComponentIdentifier = (ModuleComponentIdentifier)identifier;
            return this.module.equals(moduleComponentIdentifier.getModule()) && this.group.equals(moduleComponentIdentifier.getGroup()) && this.versionConstraint.getPreferredVersion().equals(moduleComponentIdentifier.getVersion());
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultModuleComponentSelector that = (DefaultModuleComponentSelector)o;
        if (!this.group.equals(that.group)) {
            return false;
        }
        if (!this.module.equals(that.module)) {
            return false;
        }
        return this.versionConstraint.equals(that.versionConstraint);
    }

    public int hashCode() {
        int result = this.group.hashCode();
        result = 31 * result + this.module.hashCode();
        result = 31 * result + this.versionConstraint.hashCode();
        return result;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static ModuleComponentSelector newSelector(String group, String name, VersionConstraint version) {
        return new DefaultModuleComponentSelector(group, name, DefaultImmutableVersionConstraint.of(version));
    }

    public static ModuleComponentSelector newSelector(String group, String name, String version) {
        return new DefaultModuleComponentSelector(group, name, DefaultImmutableVersionConstraint.of(version));
    }

    public static ModuleComponentSelector newSelector(ModuleVersionSelector selector) {
        return new DefaultModuleComponentSelector(selector.getGroup(), selector.getName(), DefaultImmutableVersionConstraint.of(selector.getVersion()));
    }
}

