/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.builtins;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.descriptors.impl.EmptyPackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.impl.MutableClassDescriptor;
import org.jetbrains.kotlin.descriptors.impl.TypeParameterDescriptorImpl;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.ErrorUtils;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.KotlinTypeFactory;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u000e\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\n"}, d2={"FAKE_CONTINUATION_CLASS_DESCRIPTOR", "Lorg/jetbrains/kotlin/descriptors/impl/MutableClassDescriptor;", "getFAKE_CONTINUATION_CLASS_DESCRIPTOR", "()Lorg/jetbrains/kotlin/descriptors/impl/MutableClassDescriptor;", "transformRuntimeFunctionTypeToSuspendFunction", "Lorg/jetbrains/kotlin/types/SimpleType;", "funType", "Lorg/jetbrains/kotlin/types/KotlinType;", "transformSuspendFunctionToRuntimeFunctionType", "suspendFunType", "descriptors"})
public final class SuspendFunctionTypesKt {
    @NotNull
    private static final MutableClassDescriptor FAKE_CONTINUATION_CLASS_DESCRIPTOR;

    @NotNull
    public static final MutableClassDescriptor getFAKE_CONTINUATION_CLASS_DESCRIPTOR() {
        return FAKE_CONTINUATION_CLASS_DESCRIPTOR;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SimpleType transformSuspendFunctionToRuntimeFunctionType(@NotNull KotlinType suspendFunType) {
        void var3_4;
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)suspendFunType, (String)"suspendFunType");
        boolean bl = FunctionTypesKt.isSuspendFunctionType(suspendFunType);
        if (_Assertions.ENABLED && !bl) {
            String string = "This type should be suspend function type: " + suspendFunType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Iterable iterable = FunctionTypesKt.getValueParameterTypesFromFunctionType(suspendFunType);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(suspendFunType);
        Annotations annotations2 = suspendFunType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(suspendFunType);
        void $i$a$1$assert = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType2 = p1.getType();
            collection.add(kotlinType2);
        }
        collection = (List)var3_4;
        Collection collection2 = collection;
        Annotations annotations3 = Annotations.Companion.getEMPTY();
        TypeConstructor typeConstructor2 = FAKE_CONTINUATION_CLASS_DESCRIPTOR.getTypeConstructor();
        Intrinsics.checkExpressionValueIsNotNull((Object)typeConstructor2, (String)"FAKE_CONTINUATION_CLASS_DESCRIPTOR.typeConstructor");
        List list2 = CollectionsKt.plus((Collection)collection2, (Object)KotlinTypeFactory.simpleType(annotations3, typeConstructor2, CollectionsKt.listOf((Object)TypeUtilsKt.asTypeProjection(FunctionTypesKt.getReturnTypeFromFunctionType(suspendFunType))), false));
        SimpleType simpleType2 = TypeUtilsKt.getBuiltIns(suspendFunType).getNullableAnyType();
        Intrinsics.checkExpressionValueIsNotNull((Object)simpleType2, (String)"suspendFunType.builtIns.nullableAnyType");
        return FunctionTypesKt.createFunctionType$default(kotlinBuiltIns, annotations2, kotlinType, list2, null, simpleType2, false, 64, null).makeNullableAsSpecified(suspendFunType.isMarkedNullable());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final SimpleType transformRuntimeFunctionTypeToSuspendFunction(@NotNull KotlinType funType) {
        Collection<KotlinType> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)funType, (String)"funType");
        boolean bl = FunctionTypesKt.isFunctionType(funType);
        if (_Assertions.ENABLED && !bl) {
            String string = "This type should be function type: " + funType;
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Object object = (TypeProjection)CollectionsKt.lastOrNull(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType));
        if (object == null || (object = object.getType()) == null) {
            return null;
        }
        Object continuationArgumentType = object;
        ClassifierDescriptor classifierDescriptor = ((KotlinType)continuationArgumentType).getConstructor().getDeclarationDescriptor();
        if (Intrinsics.areEqual((Object)(classifierDescriptor != null ? DescriptorUtilsKt.getFqNameSafe(classifierDescriptor) : null), (Object)DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME) ^ true || ((KotlinType)continuationArgumentType).getArguments().size() != 1) {
            return null;
        }
        KotlinType suspendReturnType = ((TypeProjection)CollectionsKt.single(((KotlinType)continuationArgumentType).getArguments())).getType();
        Iterable iterable = CollectionsKt.dropLast(FunctionTypesKt.getValueParameterTypesFromFunctionType(funType), (int)1);
        KotlinType kotlinType = FunctionTypesKt.getReceiverTypeFromFunctionType(funType);
        Annotations annotations2 = funType.getAnnotations();
        KotlinBuiltIns kotlinBuiltIns = TypeUtilsKt.getBuiltIns(funType);
        void var4_9 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void p1;
            TypeProjection typeProjection = (TypeProjection)item$iv$iv;
            collection = destination$iv$iv;
            KotlinType kotlinType2 = p1.getType();
            collection.add(kotlinType2);
        }
        collection = (List)destination$iv$iv;
        KotlinType kotlinType3 = suspendReturnType;
        Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType3, (String)"suspendReturnType");
        return FunctionTypesKt.createFunctionType(kotlinBuiltIns, annotations2, kotlinType, (List<? extends KotlinType>)collection, null, kotlinType3, true).makeNullableAsSpecified(funType.isMarkedNullable());
    }

    static {
        MutableClassDescriptor mutableClassDescriptor;
        ModuleDescriptor moduleDescriptor = ErrorUtils.getErrorModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)moduleDescriptor, (String)"ErrorUtils.getErrorModule()");
        FqName fqName2 = DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME;
        Intrinsics.checkExpressionValueIsNotNull((Object)fqName2, (String)"DescriptorUtils.COROUTINES_PACKAGE_FQ_NAME");
        MutableClassDescriptor $receiver = mutableClassDescriptor = new MutableClassDescriptor(new EmptyPackageFragmentDescriptor(moduleDescriptor, fqName2), ClassKind.INTERFACE, false, false, DescriptorUtils.CONTINUATION_INTERFACE_FQ_NAME.shortName(), SourceElement.NO_SOURCE);
        $receiver.setModality(Modality.ABSTRACT);
        $receiver.setVisibility(Visibilities.PUBLIC);
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound($receiver, Annotations.Companion.getEMPTY(), false, Variance.IN_VARIANCE, Name.identifier("T"), 0);
        MutableClassDescriptor mutableClassDescriptor2 = $receiver;
        TypeParameterDescriptor p1 = typeParameterDescriptor;
        List list2 = CollectionsKt.listOf((Object)p1);
        mutableClassDescriptor2.setTypeParameterDescriptors(list2);
        $receiver.createTypeConstructor();
        FAKE_CONTINUATION_CLASS_DESCRIPTOR = mutableClassDescriptor;
    }
}

