/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.lang.impl;

import java.util.BitSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesAndCommentsBinder;
import org.jetbrains.kotlin.com.intellij.lang.WhitespacesBinders;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderImpl;
import org.jetbrains.kotlin.gnu.trove.TIntHashSet;
import org.jetbrains.kotlin.gnu.trove.TIntObjectHashMap;

final class MarkerOptionalData
extends BitSet {
    private final TIntObjectHashMap<Throwable> myDebugAllocationPositions = new TIntObjectHashMap();
    private final TIntObjectHashMap<String> myDoneErrors = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myLeftBinders = new TIntObjectHashMap();
    private final TIntObjectHashMap<WhitespacesAndCommentsBinder> myRightBinders = new TIntObjectHashMap();
    private final TIntHashSet myCollapsed = new TIntHashSet();

    MarkerOptionalData() {
    }

    void clean(int markerId) {
        if (this.get(markerId)) {
            this.set(markerId, false);
            this.myLeftBinders.remove(markerId);
            this.myRightBinders.remove(markerId);
            this.myDoneErrors.remove(markerId);
            this.myCollapsed.remove(markerId);
            this.myDebugAllocationPositions.remove(markerId);
        }
    }

    @Nullable
    String getDoneError(int markerId) {
        return this.myDoneErrors.get(markerId);
    }

    boolean isCollapsed(int markerId) {
        return this.myCollapsed.contains(markerId);
    }

    void setErrorMessage(int markerId, String message) {
        this.markAsHavingOptionalData(markerId);
        this.myDoneErrors.put(markerId, message);
    }

    void markCollapsed(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myCollapsed.add(markerId);
    }

    private void markAsHavingOptionalData(int markerId) {
        this.set(markerId);
    }

    void notifyAllocated(int markerId) {
        this.markAsHavingOptionalData(markerId);
        this.myDebugAllocationPositions.put(markerId, new Throwable("Created at the following trace."));
    }

    Throwable getAllocationTrace(PsiBuilderImpl.StartMarker marker) {
        return this.myDebugAllocationPositions.get(marker.markerId);
    }

    WhitespacesAndCommentsBinder getBinder(int markerId, boolean right) {
        WhitespacesAndCommentsBinder binder = this.getBinderMap(right).get(markerId);
        return binder != null ? binder : MarkerOptionalData.getDefaultBinder(right);
    }

    void assignBinder(int markerId, @NotNull WhitespacesAndCommentsBinder binder, boolean right) {
        if (binder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binder", "org/jetbrains/kotlin/com/intellij/lang/impl/MarkerOptionalData", "assignBinder"));
        }
        TIntObjectHashMap<WhitespacesAndCommentsBinder> map2 = this.getBinderMap(right);
        if (binder != MarkerOptionalData.getDefaultBinder(right)) {
            this.markAsHavingOptionalData(markerId);
            map2.put(markerId, binder);
        } else {
            map2.remove(markerId);
        }
    }

    private static WhitespacesAndCommentsBinder getDefaultBinder(boolean right) {
        return right ? WhitespacesBinders.DEFAULT_RIGHT_BINDER : WhitespacesBinders.DEFAULT_LEFT_BINDER;
    }

    private TIntObjectHashMap<WhitespacesAndCommentsBinder> getBinderMap(boolean right) {
        return right ? this.myRightBinders : this.myLeftBinders;
    }
}

