/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl.source;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.psi.JavaTokenType;
import org.jetbrains.kotlin.com.intellij.psi.impl.PsiImplUtil;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.CompositeElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.JavaElementType;
import org.jetbrains.kotlin.com.intellij.psi.tree.IElementType;

public class PackageAccessibilityStatementElement
extends CompositeElement {
    public PackageAccessibilityStatementElement(@NotNull IElementType type2) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "<init>"));
        }
        super(type2);
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "deleteChildInternal"));
        }
        if (child.getElementType() == JavaElementType.MODULE_REFERENCE) {
            ASTNode comma = PackageAccessibilityStatementElement.findNearestComma(child);
            if (comma != null) {
                super.deleteChildInternal(comma);
            } else {
                ASTNode toKeyword = this.findChildByType(JavaTokenType.TO_KEYWORD);
                if (toKeyword != null) {
                    super.deleteChildInternal(toKeyword);
                }
            }
        }
        super.deleteChildInternal(child);
    }

    @Nullable
    private static ASTNode findNearestComma(@NotNull ASTNode child) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/kotlin/com/intellij/psi/impl/source/PackageAccessibilityStatementElement", "findNearestComma"));
        }
        ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
        if (next != null && next.getElementType() == JavaTokenType.COMMA) {
            return next;
        }
        ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
        if (prev != null && prev.getElementType() == JavaTokenType.COMMA) {
            return prev;
        }
        return null;
    }
}

