/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.checkers;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.resolve.calls.checkers.CallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.CallCheckerContext;
import org.jetbrains.kotlin.resolve.calls.checkers.DslScopeViolationCallChecker;
import org.jetbrains.kotlin.resolve.calls.checkers.DslScopeViolationCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.resolvedCallUtil.ResolvedCallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.resolve.scopes.utils.ScopeUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SpecialTypesKt;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J,\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0011\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/checkers/DslScopeViolationCallChecker;", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallChecker;", "()V", "check", "", "resolvedCall", "Lorg/jetbrains/kotlin/resolve/calls/model/ResolvedCall;", "reportOn", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/jetbrains/kotlin/resolve/calls/checkers/CallCheckerContext;", "checkCallImplicitReceiver", "callImplicitReceiver", "Lorg/jetbrains/kotlin/resolve/scopes/receivers/ReceiverValue;", "extractDslMarkerFqNames", "", "Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/types/KotlinType;", "frontend"})
public final class DslScopeViolationCallChecker
implements CallChecker {
    public static final DslScopeViolationCallChecker INSTANCE;

    @Override
    public void check(@NotNull ResolvedCall<?> resolvedCall2, @NotNull PsiElement reportOn, @NotNull CallCheckerContext context) {
        Intrinsics.checkParameterIsNotNull(resolvedCall2, (String)"resolvedCall");
        Intrinsics.checkParameterIsNotNull((Object)reportOn, (String)"reportOn");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (!context.getLanguageVersionSettings().supportsFeature(LanguageFeature.DslMarkersSupport)) {
            return;
        }
        Collection<ReceiverValue> callImplicitReceivers = ResolvedCallUtilKt.getImplicitReceivers(resolvedCall2);
        for (ReceiverValue callImplicitReceiver : callImplicitReceivers) {
            this.checkCallImplicitReceiver(callImplicitReceiver, resolvedCall2, reportOn, context);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkCallImplicitReceiver(ReceiverValue callImplicitReceiver, ResolvedCall<?> resolvedCall2, PsiElement reportOn, CallCheckerContext context) {
        Object v4;
        block8: {
            List receiversUntilOneFromTheCall2 = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.mapNotNull(ScopeUtilsKt.getParentsWithSelf(context.getScope()), (Function1)checkCallImplicitReceiver.receiversUntilOneFromTheCall.1.INSTANCE), (Function1)((Function1)new Function1<ReceiverValue, Boolean>(callImplicitReceiver){
                final /* synthetic */ ReceiverValue $callImplicitReceiver;

                public final boolean invoke(@NotNull ReceiverValue it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return Intrinsics.areEqual((Object)it, (Object)this.$callImplicitReceiver) ^ true;
                }
                {
                    this.$callImplicitReceiver = receiverValue;
                    super(1);
                }
            })));
            if (receiversUntilOneFromTheCall2.isEmpty()) {
                return;
            }
            KotlinType kotlinType = callImplicitReceiver.getType();
            Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType, (String)"callImplicitReceiver.type");
            Set<FqName> callDslMarkers = this.extractDslMarkerFqNames(kotlinType);
            if (callDslMarkers.isEmpty()) {
                return;
            }
            Iterable $receiver$iv = receiversUntilOneFromTheCall2;
            for (Object element$iv : $receiver$iv) {
                boolean bl;
                block7: {
                    void $receiver$iv2;
                    ReceiverValue receiver;
                    ReceiverValue receiverValue = receiver = (ReceiverValue)element$iv;
                    Intrinsics.checkExpressionValueIsNotNull((Object)receiverValue, (String)"receiver");
                    KotlinType kotlinType2 = receiverValue.getType();
                    Intrinsics.checkExpressionValueIsNotNull((Object)kotlinType2, (String)"receiver.type");
                    Iterable iterable = INSTANCE.extractDslMarkerFqNames(kotlinType2);
                    Set<FqName> set = callDslMarkers;
                    if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $receiver$iv2) {
                            FqName p1 = (FqName)element$iv2;
                            if (!set.contains(p1)) continue;
                            bl = true;
                            break block7;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v4 = element$iv;
                break block8;
            }
            v4 = null;
        }
        ReceiverValue closestAnotherReceiverWithSameDslMarker = v4;
        if (closestAnotherReceiverWithSameDslMarker != null) {
            context.getTrace().report(Errors.DSL_SCOPE_VIOLATION.on(reportOn, (CallableDescriptor)resolvedCall2.getResultingDescriptor()));
        }
    }

    @NotNull
    public final Set<FqName> extractDslMarkerFqNames(@NotNull KotlinType $receiver) {
        Set result2;
        block4: {
            Object object;
            Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
            result2 = new LinkedHashSet();
            result2.addAll(DslScopeViolationCallCheckerKt.access$extractDslMarkerFqNames($receiver.getAnnotations()));
            Object object2 = SpecialTypesKt.getAbbreviation($receiver);
            if (object2 != null && (object2 = ((KotlinType)object2).getConstructor()) != null && (object2 = object2.getDeclarationDescriptor()) != null) {
                Object object3;
                Object $receiver2 = object3 = object2;
                result2.addAll(DslScopeViolationCallCheckerKt.access$extractDslMarkerFqNames($receiver2.getAnnotations()));
                Object $receiver$iv = $receiver2;
                Object object4 = $receiver$iv;
                if (!(object4 instanceof TypeAliasDescriptor)) {
                    object4 = null;
                }
                TypeAliasDescriptor typeAliasDescriptor = (TypeAliasDescriptor)object4;
                if (typeAliasDescriptor != null) {
                    Object $receiver3 = $receiver$iv = typeAliasDescriptor;
                    result2.addAll((Collection)INSTANCE.extractDslMarkerFqNames($receiver3.getUnderlyingType()));
                }
            }
            if ((object = $receiver.getConstructor().getDeclarationDescriptor()) == null || (object = DescriptorUtilsKt.getAllSuperClassifiers((ClassifierDescriptor)object)) == null || (object = SequencesKt.asIterable(object)) == null) break block4;
            Object $receiver$iv = object;
            Iterator iterator2 = $receiver$iv.iterator();
            while (iterator2.hasNext()) {
                Object element$iv = iterator2.next();
                ClassifierDescriptor it = (ClassifierDescriptor)element$iv;
                Iterable list$iv = DslScopeViolationCallCheckerKt.access$extractDslMarkerFqNames(it.getAnnotations());
                CollectionsKt.addAll((Collection)result2, (Iterable)list$iv);
            }
            Set cfr_ignored_0 = (Set)((Collection)result2);
        }
        return result2;
    }

    private DslScopeViolationCallChecker() {
    }

    static {
        DslScopeViolationCallChecker dslScopeViolationCallChecker;
        INSTANCE = dslScopeViolationCallChecker = new DslScopeViolationCallChecker();
    }
}

