/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.util;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.GradleException;
import org.gradle.internal.IoActions;
import org.gradle.internal.UncheckedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GradleVersion
implements Comparable<GradleVersion> {
    public static final String URL = "http://www.gradle.org";
    private static final Pattern VERSION_PATTERN = Pattern.compile("((\\d+)(\\.\\d+)+)(-(\\p{Alpha}+)-(\\d+[a-z]?))?(-(SNAPSHOT|\\d{14}([-+]\\d{4})?))?");
    private static final int STAGE_MILESTONE = 0;
    private final String version;
    private final int majorPart;
    private final String buildTime;
    private final String commitId;
    private final Long snapshot;
    private final String versionPart;
    private final Stage stage;
    private static final GradleVersion CURRENT;
    public static final String RESOURCE_NAME = "/org/gradle/build-receipt.properties";

    public static GradleVersion current() {
        return CURRENT;
    }

    public static GradleVersion version(String version) throws IllegalArgumentException {
        return new GradleVersion(version, null, null);
    }

    private GradleVersion(String version, String buildTime, String commitId) {
        this.version = version;
        this.commitId = commitId;
        this.buildTime = buildTime;
        Matcher matcher = VERSION_PATTERN.matcher(version);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Gradle version string (examples: '1.0', '1.0-rc-1')", version));
        }
        this.versionPart = matcher.group(1);
        this.majorPart = Integer.parseInt(matcher.group(2), 10);
        if (matcher.group(4) != null) {
            int stageNumber = matcher.group(5).equals("milestone") ? 0 : (matcher.group(5).equals("preview") ? 2 : (matcher.group(5).equals("rc") ? 3 : 1));
            String stageString = matcher.group(6);
            this.stage = new Stage(stageNumber, stageString);
        } else {
            this.stage = null;
        }
        if ("snapshot".equals(matcher.group(5))) {
            this.snapshot = 0L;
        } else if (matcher.group(8) == null) {
            this.snapshot = null;
        } else if ("SNAPSHOT".equals(matcher.group(8))) {
            this.snapshot = 0L;
        } else {
            try {
                if (matcher.group(9) != null) {
                    this.snapshot = new SimpleDateFormat("yyyyMMddHHmmssZ").parse(matcher.group(8)).getTime();
                } else {
                    SimpleDateFormat format = new SimpleDateFormat("yyyyMMddHHmmss");
                    format.setTimeZone(TimeZone.getTimeZone("UTC"));
                    this.snapshot = format.parse(matcher.group(8)).getTime();
                }
            }
            catch (ParseException e) {
                throw UncheckedException.throwAsUncheckedException(e);
            }
        }
    }

    public String toString() {
        return "Gradle " + this.version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getBuildTime() {
        return this.buildTime;
    }

    public String getRevision() {
        return this.commitId;
    }

    public boolean isSnapshot() {
        return this.snapshot != null;
    }

    public GradleVersion getBaseVersion() {
        if (this.stage == null && this.snapshot == null) {
            return this;
        }
        return GradleVersion.version(this.versionPart);
    }

    public GradleVersion getNextMajor() {
        if (this.stage != null && this.stage.stage == 0) {
            return GradleVersion.version(this.majorPart + ".0");
        }
        return GradleVersion.version(this.majorPart + 1 + ".0");
    }

    @Override
    public int compareTo(GradleVersion gradleVersion) {
        int diff;
        String[] majorVersionParts = this.versionPart.split("\\.");
        String[] otherMajorVersionParts = gradleVersion.versionPart.split("\\.");
        for (int i = 0; i < majorVersionParts.length && i < otherMajorVersionParts.length; ++i) {
            int otherPart;
            int part = Integer.parseInt(majorVersionParts[i]);
            if (part > (otherPart = Integer.parseInt(otherMajorVersionParts[i]))) {
                return 1;
            }
            if (otherPart <= part) continue;
            return -1;
        }
        if (majorVersionParts.length > otherMajorVersionParts.length) {
            return 1;
        }
        if (majorVersionParts.length < otherMajorVersionParts.length) {
            return -1;
        }
        if (this.stage != null && gradleVersion.stage != null && (diff = this.stage.compareTo(gradleVersion.stage)) != 0) {
            return diff;
        }
        if (this.stage == null && gradleVersion.stage != null) {
            return 1;
        }
        if (this.stage != null && gradleVersion.stage == null) {
            return -1;
        }
        if (this.snapshot != null && gradleVersion.snapshot != null) {
            return this.snapshot.compareTo(gradleVersion.snapshot);
        }
        if (this.snapshot == null && gradleVersion.snapshot != null) {
            return 1;
        }
        if (this.snapshot != null && gradleVersion.snapshot == null) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GradleVersion other = (GradleVersion)o;
        return this.version.equals(other.version);
    }

    public int hashCode() {
        return this.version.hashCode();
    }

    public boolean isValid() {
        return this.versionPart != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        URL resource = GradleVersion.class.getResource(RESOURCE_NAME);
        if (resource == null) {
            throw new GradleException(String.format("Resource '%s' not found.", RESOURCE_NAME));
        }
        InputStream inputStream = null;
        try {
            URLConnection connection = resource.openConnection();
            connection.setUseCaches(false);
            inputStream = connection.getInputStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            String version = properties.get("versionNumber").toString();
            String buildTimestamp = properties.get("buildTimestampIso").toString();
            String commitId = properties.get("commitId").toString();
            CURRENT = new GradleVersion(version, "unknown".equals(buildTimestamp) ? null : buildTimestamp, commitId);
            if (inputStream == null) return;
        }
        catch (Exception e) {
            try {
                throw new GradleException(String.format("Could not load version details from resource '%s'.", resource), e);
            }
            catch (Throwable throwable) {
                if (inputStream == null) throw throwable;
                IoActions.uncheckedClose(inputStream);
                throw throwable;
            }
        }
        IoActions.uncheckedClose(inputStream);
        return;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Stage
    implements Comparable<Stage> {
        final int stage;
        final int number;
        final Character patchNo;

        Stage(int stage, String number) {
            this.stage = stage;
            Matcher m = Pattern.compile("(\\d+)([a-z])?").matcher(number);
            try {
                m.matches();
                this.number = Integer.parseInt(m.group(1));
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid stage small number: " + number, e);
            }
            this.patchNo = m.groupCount() == 2 && m.group(2) != null ? Character.valueOf(m.group(2).charAt(0)) : Character.valueOf('_');
        }

        @Override
        public int compareTo(Stage other) {
            if (this.stage > other.stage) {
                return 1;
            }
            if (this.stage < other.stage) {
                return -1;
            }
            if (this.number > other.number) {
                return 1;
            }
            if (this.number < other.number) {
                return -1;
            }
            if (this.patchNo.charValue() > other.patchNo.charValue()) {
                return 1;
            }
            if (this.patchNo.charValue() < other.patchNo.charValue()) {
                return -1;
            }
            return 0;
        }
    }
}

