/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.junitplatform;

import org.gradle.api.internal.tasks.testing.DefaultTestDescriptor;
import org.gradle.api.internal.tasks.testing.TestDescriptorInternal;
import org.gradle.api.internal.tasks.testing.TestResultProcessor;
import org.gradle.api.internal.tasks.testing.junit.GenericJUnitTestEventAdapter;
import org.gradle.api.internal.tasks.testing.junit.TestClassExecutionListener;
import org.gradle.api.internal.tasks.testing.junitplatform.VintageTestNameAdapter;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.time.Clock;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.descriptor.ClassSource;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;

public class JUnitPlatformTestExecutionListener
implements TestExecutionListener {
    private final GenericJUnitTestEventAdapter<String> adapter;
    private final IdGenerator<?> idGenerator;
    private final TestClassExecutionListener executionListener;
    private final CurrentRunningTestClass currentRunningTestClass;
    private TestPlan currentTestPlan;

    public JUnitPlatformTestExecutionListener(TestResultProcessor resultProcessor, Clock clock, IdGenerator<?> idGenerator, TestClassExecutionListener executionListener) {
        this.adapter = new GenericJUnitTestEventAdapter(resultProcessor, clock);
        this.idGenerator = idGenerator;
        this.executionListener = executionListener;
        this.currentRunningTestClass = new CurrentRunningTestClass();
    }

    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.currentTestPlan = testPlan;
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        this.currentTestPlan = null;
    }

    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (this.isLeafTest(testIdentifier)) {
            this.adapter.testIgnored(this.getDescriptor(testIdentifier));
        } else if (this.isClass(testIdentifier)) {
            this.reportTestClassStarted(testIdentifier);
            this.currentTestPlan.getChildren(testIdentifier).forEach(child -> this.executionSkipped((TestIdentifier)child, reason));
            this.reportTestClassFinished(testIdentifier);
        }
    }

    public void executionStarted(TestIdentifier testIdentifier) {
        if (this.isClass(testIdentifier)) {
            this.reportTestClassStarted(testIdentifier);
        }
        if (this.isLeafTest(testIdentifier)) {
            this.adapter.testStarted((Object)testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier));
        }
    }

    private boolean isLeafTest(TestIdentifier identifier) {
        return identifier.isTest() && !VintageTestNameAdapter.isVintageDynamicTestClass(identifier);
    }

    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.isLeafTestOrFailedContainer(testIdentifier, testExecutionResult)) {
            if (!this.isLeafTest(testIdentifier)) {
                this.adapter.testStarted((Object)testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier));
            }
            switch (testExecutionResult.getStatus()) {
                case SUCCESSFUL: {
                    this.adapter.testFinished((Object)testIdentifier.getUniqueId());
                    break;
                }
                case FAILED: {
                    this.adapter.testFailure((Object)testIdentifier.getUniqueId(), this.getDescriptor(testIdentifier), (Throwable)testExecutionResult.getThrowable().get());
                    this.adapter.testFinished((Object)testIdentifier.getUniqueId());
                    break;
                }
                case ABORTED: {
                    this.adapter.testAssumptionFailure((Object)testIdentifier.getUniqueId());
                    this.adapter.testFinished((Object)testIdentifier.getUniqueId());
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Invalid Status: " + testExecutionResult.getStatus()));
                }
            }
        }
        if (this.isClass(testIdentifier)) {
            this.reportTestClassFinished(testIdentifier);
        }
    }

    private void reportTestClassStarted(TestIdentifier testIdentifier) {
        this.currentRunningTestClass.start(this.className(testIdentifier));
    }

    private void reportTestClassFinished(TestIdentifier testIdentifier) {
        this.currentRunningTestClass.end(this.className(testIdentifier));
    }

    private boolean isLeafTestOrFailedContainer(TestIdentifier testIdentifier, TestExecutionResult result) {
        return this.isLeafTest(testIdentifier) || this.isFailedContainer(testIdentifier, result);
    }

    private boolean isFailedContainer(TestIdentifier testIdentifier, TestExecutionResult result) {
        return result.getStatus() != TestExecutionResult.Status.SUCCESSFUL && testIdentifier.isContainer();
    }

    private TestDescriptorInternal getDescriptor(TestIdentifier test) {
        if (this.isMethod(test)) {
            return new DefaultTestDescriptor(this.idGenerator.generateId(), this.className(test), test.getDisplayName());
        }
        if (VintageTestNameAdapter.isVintageDynamicLeafTest(test)) {
            UniqueId uniqueId = UniqueId.parse((String)test.getUniqueId());
            return new DefaultTestDescriptor(this.idGenerator.generateId(), VintageTestNameAdapter.vintageDynamicClassName(uniqueId), VintageTestNameAdapter.vintageDynamicMethodName(uniqueId));
        }
        if (this.isClass(test) || VintageTestNameAdapter.isVintageDynamicTestClass(test)) {
            return new DefaultTestDescriptor(this.idGenerator.generateId(), this.className(test), "classMethod");
        }
        return new DefaultTestDescriptor(this.idGenerator.generateId(), this.className(test), test.getDisplayName());
    }

    private boolean isMethod(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof MethodSource;
    }

    private boolean isClass(TestIdentifier test) {
        return test.getSource().isPresent() && test.getSource().get() instanceof ClassSource;
    }

    private String className(TestIdentifier testIdentifier) {
        if (this.isClass(testIdentifier)) {
            return ((ClassSource)ClassSource.class.cast(testIdentifier.getSource().get())).getClassName();
        }
        while (testIdentifier.getParentId().isPresent()) {
            if (!this.isClass(testIdentifier = this.currentTestPlan.getTestIdentifier((String)testIdentifier.getParentId().get()))) continue;
            return ((ClassSource)ClassSource.class.cast(testIdentifier.getSource().get())).getClassName();
        }
        return "UnknownClass";
    }

    private class CurrentRunningTestClass {
        private String name;
        private int count;

        private CurrentRunningTestClass() {
        }

        private void start(String className) {
            if (this.name == null) {
                this.name = className;
                JUnitPlatformTestExecutionListener.this.executionListener.testClassStarted(className);
                this.count = 1;
            } else if (className.equals(this.name)) {
                ++this.count;
            }
        }

        private void end(String className) {
            if (className.equals(this.name)) {
                --this.count;
                if (this.count == 0) {
                    JUnitPlatformTestExecutionListener.this.executionListener.testClassFinished(null);
                    this.name = null;
                }
            }
        }
    }
}

