/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.collections.MinimalFileSet;
import org.gradle.api.internal.tasks.AbstractTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.internal.tasks.compile.processing.DefaultProcessorPath;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.compile.CompileOptions;
import org.gradle.util.DeprecationLogger;

public class AnnotationProcessorPathFactory {
    public static final String COMPILE_CLASSPATH_DEPRECATION_MESSAGE = "Putting annotation processors on the compile classpath";
    public static final String PROCESSOR_PATH_DEPRECATION_MESSAGE = "Specifying the processor path in the CompilerOptions compilerArgs property";
    private final FileCollectionFactory fileCollectionFactory;
    private final AnnotationProcessorDetector annotationProcessorDetector;

    public AnnotationProcessorPathFactory(FileCollectionFactory fileCollectionFactory, AnnotationProcessorDetector annotationProcessorDetector) {
        this.fileCollectionFactory = fileCollectionFactory;
        this.annotationProcessorDetector = annotationProcessorDetector;
    }

    public FileCollection getEffectiveAnnotationProcessorClasspath(CompileOptions compileOptions, FileCollection compileClasspath) {
        if (compileOptions.getCompilerArgs().contains("-proc:none")) {
            return this.fileCollectionFactory.empty("annotation processor path");
        }
        FileCollection annotationProcessorPath = compileOptions.getAnnotationProcessorPath();
        if (annotationProcessorPath != null && !(annotationProcessorPath instanceof DefaultProcessorPath)) {
            return annotationProcessorPath;
        }
        FileCollection processorPathFromCompilerArguments = this.getProcessorPathFromCompilerArguments(compileOptions);
        if (processorPathFromCompilerArguments != null) {
            return processorPathFromCompilerArguments;
        }
        if (compileClasspath == null) {
            return annotationProcessorPath;
        }
        return this.getProcessorPathWithCompileClasspathFallback(compileOptions, compileClasspath, annotationProcessorPath);
    }

    private FileCollection getProcessorPathFromCompilerArguments(CompileOptions compileOptions) {
        final FileCollection annotationProcessorPath = compileOptions.getAnnotationProcessorPath();
        int pos = compileOptions.getCompilerArgs().indexOf("-processorpath");
        if (pos < 0) {
            return null;
        }
        if (pos == compileOptions.getCompilerArgs().size() - 1) {
            throw new InvalidUserDataException("No path provided for compiler argument -processorpath in requested compiler args: " + Joiner.on((String)" ").join(compileOptions.getCompilerArgs()));
        }
        final String processorpath = compileOptions.getCompilerArgs().get(pos + 1);
        if (annotationProcessorPath == null) {
            return this.fileCollectionFactory.fixed("annotation processor path", AnnotationProcessorPathFactory.extractProcessorPath(processorpath));
        }
        return this.fileCollectionFactory.create((TaskDependency)new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                context.add((Object)annotationProcessorPath);
            }
        }, new MinimalFileSet(){

            public Set<File> getFiles() {
                if (!annotationProcessorPath.isEmpty()) {
                    return annotationProcessorPath.getFiles();
                }
                return AnnotationProcessorPathFactory.extractProcessorPath(processorpath);
            }

            public final String getDisplayName() {
                return "annotation processor path";
            }
        });
    }

    private static Set<File> extractProcessorPath(String processorpath) {
        DeprecationLogger.nagUserOfDeprecated((String)PROCESSOR_PATH_DEPRECATION_MESSAGE, (String)"Instead, use the CompilerOptions.annotationProcessorPath property directly");
        LinkedHashSet<File> files = new LinkedHashSet<File>();
        for (String path : Splitter.on((char)File.pathSeparatorChar).splitToList((CharSequence)processorpath)) {
            files.add(new File(path));
        }
        return files;
    }

    private FileCollection getProcessorPathWithCompileClasspathFallback(CompileOptions compileOptions, final FileCollection compileClasspath, final FileCollection annotationProcessorPath) {
        final boolean hasExplicitProcessor = AnnotationProcessorPathFactory.checkExplicitProcessorOption(compileOptions);
        return this.fileCollectionFactory.create((TaskDependency)new AbstractTaskDependency(){

            public void visitDependencies(TaskDependencyResolveContext context) {
                if (annotationProcessorPath != null) {
                    context.add((Object)annotationProcessorPath);
                }
                context.add((Object)compileClasspath);
            }
        }, new MinimalFileSet(){

            public Set<File> getFiles() {
                if (annotationProcessorPath != null && !annotationProcessorPath.isEmpty()) {
                    return annotationProcessorPath.getFiles();
                }
                if (hasExplicitProcessor) {
                    return compileClasspath.getFiles();
                }
                if (!AnnotationProcessorPathFactory.this.annotationProcessorDetector.detectProcessors((Iterable<File>)compileClasspath).isEmpty()) {
                    DeprecationLogger.nagUserOfDeprecated((String)AnnotationProcessorPathFactory.COMPILE_CLASSPATH_DEPRECATION_MESSAGE, (String)"Please add them to the processor path instead. If these processors were unintentionally leaked on the compile classpath, use the -proc:none compiler option to ignore them.");
                    return compileClasspath.getFiles();
                }
                return Collections.emptySet();
            }

            public final String getDisplayName() {
                return "annotation processor path";
            }
        });
    }

    private static boolean checkExplicitProcessorOption(CompileOptions compileOptions) {
        boolean hasExplicitProcessor = false;
        int pos = compileOptions.getCompilerArgs().indexOf("-processor");
        if (pos >= 0) {
            if (pos == compileOptions.getCompilerArgs().size() - 1) {
                throw new InvalidUserDataException("No processor specified for compiler argument -processor in requested compiler args: " + Joiner.on((String)" ").join(compileOptions.getCompilerArgs()));
            }
            hasExplicitProcessor = true;
        }
        return hasExplicitProcessor;
    }
}

