/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.core;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.kotlin.com.intellij.openapi.roots.PackageIndex;
import org.jetbrains.kotlin.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.kotlin.com.intellij.util.CollectionQuery;
import org.jetbrains.kotlin.com.intellij.util.Query;

public class CorePackageIndex
extends PackageIndex {
    private static final Logger LOG = Logger.getInstance("#com.intellij.core.CorePackageIndex");
    private final List<VirtualFile> myClasspath = new ArrayList<VirtualFile>();

    private List<VirtualFile> roots() {
        return this.myClasspath;
    }

    private List<VirtualFile> findDirectoriesByPackageName(String packageName) {
        ArrayList<VirtualFile> result2 = new ArrayList<VirtualFile>();
        String dirName = packageName.replace(".", "/");
        for (VirtualFile root2 : this.roots()) {
            VirtualFile classDir = root2.findFileByRelativePath(dirName);
            if (classDir == null) continue;
            result2.add(classDir);
        }
        return result2;
    }

    @Override
    @NotNull
    public Query<VirtualFile> getDirsByPackageName(@NotNull String packageName, boolean includeLibrarySources) {
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/kotlin/com/intellij/core/CorePackageIndex", "getDirsByPackageName"));
        }
        CollectionQuery<VirtualFile> collectionQuery = new CollectionQuery<VirtualFile>(this.findDirectoriesByPackageName(packageName));
        if (collectionQuery == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/core/CorePackageIndex", "getDirsByPackageName"));
        }
        return collectionQuery;
    }

    public void addToClasspath(VirtualFile root2) {
        this.myClasspath.add(root2);
    }
}

