/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.impl;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.project.Project;
import org.jetbrains.kotlin.com.intellij.openapi.util.Factory;
import org.jetbrains.kotlin.com.intellij.openapi.util.Key;
import org.jetbrains.kotlin.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import org.jetbrains.kotlin.com.intellij.psi.PsiCompiledElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiConstantEvaluationHelper;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiLiteralExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiPrefixExpression;
import org.jetbrains.kotlin.com.intellij.psi.PsiVariable;
import org.jetbrains.kotlin.com.intellij.psi.impl.ConstantExpressionVisitor;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValue;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValueProvider;
import org.jetbrains.kotlin.com.intellij.psi.util.CachedValuesManager;
import org.jetbrains.kotlin.com.intellij.psi.util.PsiModificationTracker;
import org.jetbrains.kotlin.com.intellij.util.ConcurrencyUtil;
import org.jetbrains.kotlin.com.intellij.util.ObjectUtils;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public class JavaConstantExpressionEvaluator
extends JavaRecursiveElementWalkingVisitor {
    private final Factory<ConcurrentMap<PsiElement, Object>> myMapFactory;
    private final Project myProject;
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY");
    private static final Key<CachedValue<ConcurrentMap<PsiElement, Object>>> CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY = Key.create("CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY");
    private static final Object NO_VALUE = ObjectUtils.NULL;
    private final ConstantExpressionVisitor myConstantExpressionVisitor;
    private static final CachedValueProvider<ConcurrentMap<PsiElement, Object>> PROVIDER = () -> {
        ConcurrentMap value = ContainerUtil.createConcurrentSoftMap();
        return CachedValueProvider.Result.create(value, PsiModificationTracker.MODIFICATION_COUNT);
    };

    private JavaConstantExpressionEvaluator(Set<PsiVariable> visitedVars, final boolean throwExceptionOnOverflow, @NotNull Project project, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaConstantExpressionEvaluator", "<init>"));
        }
        this.myMapFactory = auxEvaluator == null ? new Factory<ConcurrentMap<PsiElement, Object>>(){

            @Override
            public ConcurrentMap<PsiElement, Object> create() {
                Key key = throwExceptionOnOverflow ? CONSTANT_VALUE_WITH_OVERFLOW_MAP_KEY : CONSTANT_VALUE_WO_OVERFLOW_MAP_KEY;
                return (ConcurrentMap)CachedValuesManager.getManager(JavaConstantExpressionEvaluator.this.myProject).getCachedValue(JavaConstantExpressionEvaluator.this.myProject, key, PROVIDER, false);
            }
        } : () -> auxEvaluator.getCacheMap(throwExceptionOnOverflow);
        this.myProject = project;
        this.myConstantExpressionVisitor = new ConstantExpressionVisitor(visitedVars, throwExceptionOnOverflow, auxEvaluator);
    }

    @Override
    protected void elementFinished(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaConstantExpressionEvaluator", "elementFinished"));
        }
        Object value = this.getCached(element);
        if (value == null) {
            Object result2 = this.myConstantExpressionVisitor.handle(element);
            this.cache(element, result2);
        } else {
            this.myConstantExpressionVisitor.store(element, value == NO_VALUE ? null : value);
        }
    }

    @Override
    public void visitElement(PsiElement element) {
        Object value = this.getCached(element);
        if (value == null) {
            super.visitElement(element);
        } else {
            this.myConstantExpressionVisitor.store(element, value == NO_VALUE ? null : value);
        }
    }

    private Object getCached(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaConstantExpressionEvaluator", "getCached"));
        }
        return this.map().get(element);
    }

    private Object cache(@NotNull PsiElement element, @Nullable Object value) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaConstantExpressionEvaluator", "cache"));
        }
        value = ConcurrencyUtil.cacheOrGet(this.map(), element, value == null ? NO_VALUE : value);
        if (value == NO_VALUE) {
            value = null;
        }
        return value;
    }

    @NotNull
    private ConcurrentMap<PsiElement, Object> map() {
        ConcurrentMap<PsiElement, Object> concurrentMap = this.myMapFactory.create();
        if (concurrentMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/psi/impl/JavaConstantExpressionEvaluator", "map"));
        }
        return concurrentMap;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, visitedVars, throwExceptionOnOverflow, null);
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, @Nullable Set<PsiVariable> visitedVars, boolean throwExceptionOnOverflow, PsiConstantEvaluationHelper.AuxEvaluator auxEvaluator) {
        if (expression2 == null) {
            return null;
        }
        if (expression2 instanceof PsiLiteralExpression) {
            return ((PsiLiteralExpression)expression2).getValue();
        }
        JavaConstantExpressionEvaluator evaluator = new JavaConstantExpressionEvaluator(visitedVars, throwExceptionOnOverflow, expression2.getProject(), auxEvaluator);
        if (expression2 instanceof PsiCompiledElement) {
            if (expression2 instanceof PsiPrefixExpression) {
                PsiExpression operand = ((PsiPrefixExpression)expression2).getOperand();
                if (operand == null) {
                    return null;
                }
                Object value = evaluator.myConstantExpressionVisitor.handle(operand);
                evaluator.myConstantExpressionVisitor.store(operand, value);
            }
            return evaluator.myConstantExpressionVisitor.handle(expression2);
        }
        expression2.accept(evaluator);
        Object cached = evaluator.getCached(expression2);
        return cached == NO_VALUE ? null : cached;
    }

    public static Object computeConstantExpression(@Nullable PsiExpression expression2, boolean throwExceptionOnOverflow) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expression2, null, throwExceptionOnOverflow);
    }
}

