/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.load.kotlin.JvmMetadataVersion;
import org.jetbrains.kotlin.load.kotlin.ModuleMappingKt;
import org.jetbrains.kotlin.load.kotlin.PackageParts;
import org.jetbrains.kotlin.protobuf.ProtocolStringList;
import org.jetbrains.kotlin.serialization.deserialization.DeserializationConfiguration;
import org.jetbrains.kotlin.serialization.jvm.JvmPackageTable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \r2\u00020\u0001:\u0001\rB#\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\u0004J\b\u0010\f\u001a\u00020\u0004H\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "", "packageFqName2Parts", "", "", "Lorg/jetbrains/kotlin/load/kotlin/PackageParts;", "debugName", "(Ljava/util/Map;Ljava/lang/String;)V", "getPackageFqName2Parts", "()Ljava/util/Map;", "findPackageParts", "packageFqName", "toString", "Companion", "descriptors.jvm"})
public final class ModuleMapping {
    @NotNull
    private final Map<String, PackageParts> packageFqName2Parts;
    private final String debugName;
    @JvmField
    @NotNull
    public static final String MAPPING_FILE_EXT = "kotlin_module";
    @JvmField
    @NotNull
    public static final ModuleMapping EMPTY;
    @JvmField
    @NotNull
    public static final ModuleMapping CORRUPTED;
    public static final Companion Companion;

    @Nullable
    public final PackageParts findPackageParts(@NotNull String packageFqName) {
        Intrinsics.checkParameterIsNotNull((Object)packageFqName, (String)"packageFqName");
        return this.packageFqName2Parts.get(packageFqName);
    }

    @NotNull
    public String toString() {
        return this.debugName;
    }

    @NotNull
    public final Map<String, PackageParts> getPackageFqName2Parts() {
        return this.packageFqName2Parts;
    }

    private ModuleMapping(Map<String, PackageParts> packageFqName2Parts, String debugName) {
        this.packageFqName2Parts = packageFqName2Parts;
        this.debugName = debugName;
    }

    static {
        Companion = new Companion(null);
        MAPPING_FILE_EXT = MAPPING_FILE_EXT;
        EMPTY = new ModuleMapping(MapsKt.emptyMap(), "EMPTY");
        CORRUPTED = new ModuleMapping(MapsKt.emptyMap(), "CORRUPTED");
    }

    public /* synthetic */ ModuleMapping(@NotNull Map packageFqName2Parts, @NotNull String debugName, DefaultConstructorMarker $constructor_marker) {
        this(packageFqName2Parts, debugName);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\b\u001a\u00020\u00042\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rR\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping$Companion;", "", "()V", "CORRUPTED", "Lorg/jetbrains/kotlin/load/kotlin/ModuleMapping;", "EMPTY", "MAPPING_FILE_EXT", "", "create", "bytes", "", "debugName", "configuration", "Lorg/jetbrains/kotlin/serialization/deserialization/DeserializationConfiguration;", "descriptors.jvm"})
    public static final class Companion {
        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModuleMapping create(@Nullable byte[] bytes, @NotNull String debugName, @NotNull DeserializationConfiguration configuration) {
            int[] size$iv22;
            Intrinsics.checkParameterIsNotNull((Object)debugName, (String)"debugName");
            Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
            if (bytes == null) {
                return EMPTY;
            }
            DataInputStream stream2 = new DataInputStream(new ByteArrayInputStream(bytes));
            try {
                int size$iv22 = stream2.readInt();
                int[] result$iv = new int[size$iv22];
                int n = 0;
                int n2 = result$iv.length;
                while (n < n2) {
                    int n3;
                    void i$iv;
                    void var10_14 = i$iv;
                    void var24_17 = i$iv++;
                    int[] nArray = result$iv;
                    nArray[var24_17] = n3 = stream2.readInt();
                }
                size$iv22 = result$iv;
            }
            catch (IOException e) {
                return CORRUPTED;
            }
            int[] versionNumber = size$iv22;
            JvmMetadataVersion version = new JvmMetadataVersion(Arrays.copyOf(versionNumber, versionNumber.length));
            if (configuration.getSkipMetadataVersionCheck() || version.isCompatible()) {
                Object packageParts;
                JvmPackageTable.PackageTable packageTable = JvmPackageTable.PackageTable.parseFrom(stream2);
                if (packageTable == null) {
                    return EMPTY;
                }
                JvmPackageTable.PackageTable table = packageTable;
                LinkedHashMap result2 = new LinkedHashMap();
                Iterator<JvmPackageTable.PackageParts> iterator2 = table.getPackagePartsList().iterator();
                while (iterator2.hasNext()) {
                    String partShortName;
                    Object object;
                    IndexedValue $receiver$iv2;
                    JvmPackageTable.PackageParts proto;
                    JvmPackageTable.PackageParts packageParts2 = proto = iterator2.next();
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageParts2, (String)"proto");
                    String packageFqName = packageParts2.getPackageFqName();
                    Map map2 = result2;
                    String string = packageFqName;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"packageFqName");
                    Iterator key$iv = string;
                    Object value$iv = $receiver$iv2.get(key$iv);
                    if (value$iv == null) {
                        PackageParts answer$iv = new PackageParts(packageFqName);
                        $receiver$iv2.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    packageParts = (PackageParts)object;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex((Iterable)protocolStringList)) {
                        String string2;
                        String facadeShortName;
                        String string3;
                        ProtocolStringList protocolStringList2;
                        Integer multifileFacadeId;
                        int index2 = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        List<Integer> list2 = proto.getMultifileFacadeShortNameIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list2, (String)"proto.multifileFacadeShortNameIdList");
                        Integer n = (Integer)CollectionsKt.getOrNull(list2, (int)index2);
                        Integer n4 = multifileFacadeId = n != null ? Integer.valueOf(n - 1) : null;
                        if (multifileFacadeId != null) {
                            Integer n5;
                            Intrinsics.checkExpressionValueIsNotNull((Object)proto.getMultifileFacadeShortNameList(), (String)"proto.multifileFacadeShortNameList");
                            int p1 = ((Number)n5).intValue();
                            string3 = (String)CollectionsKt.getOrNull((List)protocolStringList2, (int)p1);
                        } else {
                            string3 = facadeShortName = null;
                        }
                        if (facadeShortName != null) {
                            ProtocolStringList it = protocolStringList2;
                            string2 = ModuleMappingKt.access$internalNameOf(packageFqName, (String)((Object)it));
                        } else {
                            string2 = null;
                        }
                        String facadeInternalName = string2;
                        String string4 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(packageFqName, string4), facadeInternalName);
                    }
                    if (!configuration.isJvmPackageNameSupported()) continue;
                    ProtocolStringList protocolStringList3 = proto.getClassWithJvmPackageNameShortNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList3, (String)"proto.classWithJvmPackageNameShortNameList");
                    for (IndexedValue $receiver$iv2 : CollectionsKt.withIndex((Iterable)protocolStringList3)) {
                        String jvmPackageName;
                        int index3 = $receiver$iv2.component1();
                        partShortName = (String)$receiver$iv2.component2();
                        List<Integer> list3 = proto.getClassWithJvmPackageNamePackageIdList();
                        Intrinsics.checkExpressionValueIsNotNull(list3, (String)"proto.classWithJvmPackageNamePackageIdList");
                        Integer n = (Integer)CollectionsKt.getOrNull(list3, (int)index3);
                        if (n == null) {
                            List<Integer> list4 = proto.getClassWithJvmPackageNamePackageIdList();
                            Intrinsics.checkExpressionValueIsNotNull(list4, (String)"proto.classWithJvmPackageNamePackageIdList");
                            n = (Integer)CollectionsKt.lastOrNull(list4);
                        }
                        if (n == null) {
                            continue;
                        }
                        int packageId = n;
                        ProtocolStringList protocolStringList4 = table.getJvmPackageNameList();
                        Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList4, (String)"table.jvmPackageNameList");
                        if ((String)CollectionsKt.getOrNull((List)protocolStringList4, (int)packageId) == null) {
                            continue;
                        }
                        String string5 = partShortName;
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"partShortName");
                        ((PackageParts)packageParts).addPart(ModuleMappingKt.access$internalNameOf(jvmPackageName, string5), null);
                    }
                }
                for (JvmPackageTable.PackageParts proto : table.getMetadataPartsList()) {
                    Object object;
                    String key$iv;
                    Iterable $receiver$iv;
                    packageParts = result2;
                    JvmPackageTable.PackageParts packageParts3 = proto;
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3, (String)"proto");
                    Intrinsics.checkExpressionValueIsNotNull((Object)packageParts3.getPackageFqName(), (String)"proto.packageFqName");
                    Object value$iv = $receiver$iv.get(key$iv);
                    if (value$iv == null) {
                        String string = proto.getPackageFqName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"proto.packageFqName");
                        PackageParts answer$iv = new PackageParts(string);
                        $receiver$iv.put(key$iv, answer$iv);
                        object = answer$iv;
                    } else {
                        object = value$iv;
                    }
                    PackageParts packageParts4 = (PackageParts)object;
                    ProtocolStringList protocolStringList = proto.getShortClassNameList();
                    Intrinsics.checkExpressionValueIsNotNull((Object)protocolStringList, (String)"proto.shortClassNameList");
                    $receiver$iv = protocolStringList;
                    for (Object element$iv : $receiver$iv) {
                        String p1 = (String)element$iv;
                        packageParts4.addMetadataPart(p1);
                    }
                }
                return new ModuleMapping(result2, debugName, null);
            }
            return EMPTY;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

