/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.cli;

import java.util.HashMap;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.cli.AbstractCommandLineConverter;
import org.gradle.cli.CommandLineArgumentException;
import org.gradle.cli.CommandLineParser;
import org.gradle.cli.ParsedCommandLine;
import org.gradle.cli.SystemPropertiesCommandLineConverter;
import org.gradle.initialization.DefaultCommandLineConverter;
import org.gradle.initialization.LayoutCommandLineConverter;
import org.gradle.initialization.layout.BuildLayoutFactory;
import org.gradle.launcher.cli.Parameters;
import org.gradle.launcher.cli.converter.DaemonCommandLineConverter;
import org.gradle.launcher.cli.converter.LayoutToPropertiesConverter;
import org.gradle.launcher.cli.converter.PropertiesToDaemonParametersConverter;
import org.gradle.launcher.cli.converter.PropertiesToStartParameterConverter;
import org.gradle.launcher.daemon.configuration.DaemonParameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametersConverter
extends AbstractCommandLineConverter<Parameters> {
    private final LayoutCommandLineConverter layoutConverter;
    private final SystemPropertiesCommandLineConverter propertiesConverter;
    private final LayoutToPropertiesConverter layoutToPropertiesConverter;
    private final PropertiesToStartParameterConverter propertiesToStartParameterConverter;
    private final DefaultCommandLineConverter commandLineConverter;
    private final DaemonCommandLineConverter daemonConverter;
    private final PropertiesToDaemonParametersConverter propertiesToDaemonParametersConverter;

    ParametersConverter(LayoutCommandLineConverter layoutConverter, SystemPropertiesCommandLineConverter propertiesConverter, LayoutToPropertiesConverter layoutToPropertiesConverter, PropertiesToStartParameterConverter propertiesToStartParameterConverter, DefaultCommandLineConverter commandLineConverter, DaemonCommandLineConverter daemonConverter, PropertiesToDaemonParametersConverter propertiesToDaemonParametersConverter) {
        this.layoutConverter = layoutConverter;
        this.propertiesConverter = propertiesConverter;
        this.layoutToPropertiesConverter = layoutToPropertiesConverter;
        this.propertiesToStartParameterConverter = propertiesToStartParameterConverter;
        this.commandLineConverter = commandLineConverter;
        this.daemonConverter = daemonConverter;
        this.propertiesToDaemonParametersConverter = propertiesToDaemonParametersConverter;
    }

    public ParametersConverter(BuildLayoutFactory buildLayoutFactory) {
        this(new LayoutCommandLineConverter(), new SystemPropertiesCommandLineConverter(), new LayoutToPropertiesConverter(buildLayoutFactory), new PropertiesToStartParameterConverter(), new DefaultCommandLineConverter(), new DaemonCommandLineConverter(), new PropertiesToDaemonParametersConverter());
    }

    public Parameters convert(ParsedCommandLine args, Parameters target) throws CommandLineArgumentException {
        this.layoutConverter.convert(args, target.getLayout());
        HashMap<String, String> properties = new HashMap<String, String>();
        this.layoutToPropertiesConverter.convert(target.getLayout(), properties);
        this.propertiesConverter.convert(args, properties);
        this.propertiesToStartParameterConverter.convert(properties, (StartParameterInternal)target.getStartParameter());
        this.commandLineConverter.convert(args, (StartParameterInternal)target.getStartParameter());
        DaemonParameters daemonParameters = new DaemonParameters(target.getLayout(), target.getStartParameter().getSystemPropertiesArgs());
        this.propertiesToDaemonParametersConverter.convert(properties, daemonParameters);
        this.daemonConverter.convert(args, daemonParameters);
        target.setDaemonParameters(daemonParameters);
        return target;
    }

    public void configure(CommandLineParser parser) {
        this.commandLineConverter.configure(parser);
        this.daemonConverter.configure(parser);
    }
}

