/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.loaders.cfg.multiview;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.hibernate.loaders.cfg.HibernateCfgDataObject;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.BrowseFolders;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.ClassCachePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.ClassCachesTableModel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.SecurityTablePanel;
import org.netbeans.modules.hibernate.loaders.cfg.multiview.Util;
import org.netbeans.modules.xml.multiview.ui.DefaultTablePanel;
import org.netbeans.modules.xml.multiview.ui.EditDialog;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ClassCachesTablePanel
extends DefaultTablePanel {
    private ClassCachesTableModel model;
    private HibernateCfgDataObject configDataObject;

    public ClassCachesTablePanel(HibernateCfgDataObject dObj, final ClassCachesTableModel model) {
        super((AbstractTableModel)model);
        this.model = model;
        this.configDataObject = dObj;
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClassCachesTablePanel.this.configDataObject.modelUpdatedFromUI();
                int row = ClassCachesTablePanel.this.getTable().getSelectedRow();
                model.removeRow(row);
            }
        });
        this.editButton.addActionListener(new TableActionListener(false));
        this.addButton.addActionListener(new TableActionListener(true));
    }

    private class TableActionListener
    implements ActionListener {
        private boolean add;

        TableActionListener(boolean add) {
            this.add = add;
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            int row = this.add ? -1 : ClassCachesTablePanel.this.getTable().getSelectedRow();
            final ClassCachePanel dialogPanel = new ClassCachePanel();
            if (!this.add) {
                String className = (String)ClassCachesTablePanel.this.model.getValueAt(row, 0);
                String region = (String)ClassCachesTablePanel.this.model.getValueAt(row, 1);
                String usage = (String)ClassCachesTablePanel.this.model.getValueAt(row, 2);
                String include = (String)ClassCachesTablePanel.this.model.getValueAt(row, 3);
                dialogPanel.initValues(className, region, usage, include);
            }
            dialogPanel.addBrowseClassActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        SourceGroup[] groups = Util.getJavaSourceGroups(ClassCachesTablePanel.this.configDataObject);
                        FileObject fo = BrowseFolders.showDialog(groups);
                        if (fo != null) {
                            String className = Util.getResourcePath(groups, fo);
                            dialogPanel.getClassTextField().setText(className);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            EditDialog dialog = new EditDialog(dialogPanel, NbBundle.getMessage(SecurityTablePanel.class, (String)"LBL_Class_Cache"), this.add){

                protected String validate() {
                    String className = dialogPanel.getClassName();
                    if (className.length() == 0) {
                        return NbBundle.getMessage(SecurityTablePanel.class, (String)"TXT_Class_Empty");
                    }
                    return null;
                }
            };
            if (this.add) {
                dialog.setValid(false);
            }
            EditDialog.DocListener docListener = new EditDialog.DocListener(dialog);
            dialogPanel.getClassTextField().getDocument().addDocumentListener((DocumentListener)docListener);
            Dialog d = DialogDisplayer.getDefault().createDialog((DialogDescriptor)dialog);
            d.setVisible(true);
            dialogPanel.getClassTextField().getDocument().removeDocumentListener((DocumentListener)docListener);
            if (dialog.getValue().equals(EditDialog.OK_OPTION)) {
                ClassCachesTablePanel.this.configDataObject.modelUpdatedFromUI();
                String className = dialogPanel.getClassName();
                String region = dialogPanel.getRegion();
                String usage = dialogPanel.getUsage();
                String include = dialogPanel.getInclude();
                if (this.add) {
                    ClassCachesTablePanel.this.model.addRow(new String[]{className, region, usage, include});
                } else {
                    ClassCachesTablePanel.this.model.editRow(row, new String[]{className, region, usage, include});
                }
            }
        }
    }
}

