/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.refactoring;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.hibernate.mapping.model.Any;
import org.netbeans.modules.hibernate.mapping.model.Array;
import org.netbeans.modules.hibernate.mapping.model.Bag;
import org.netbeans.modules.hibernate.mapping.model.Component;
import org.netbeans.modules.hibernate.mapping.model.CompositeElement;
import org.netbeans.modules.hibernate.mapping.model.CompositeId;
import org.netbeans.modules.hibernate.mapping.model.CompositeIndex;
import org.netbeans.modules.hibernate.mapping.model.CompositeMapKey;
import org.netbeans.modules.hibernate.mapping.model.DynamicComponent;
import org.netbeans.modules.hibernate.mapping.model.HibernateMapping;
import org.netbeans.modules.hibernate.mapping.model.Id;
import org.netbeans.modules.hibernate.mapping.model.Idbag;
import org.netbeans.modules.hibernate.mapping.model.Join;
import org.netbeans.modules.hibernate.mapping.model.JoinedSubclass;
import org.netbeans.modules.hibernate.mapping.model.KeyManyToOne;
import org.netbeans.modules.hibernate.mapping.model.KeyProperty;
import org.netbeans.modules.hibernate.mapping.model.List;
import org.netbeans.modules.hibernate.mapping.model.ManyToOne;
import org.netbeans.modules.hibernate.mapping.model.Map;
import org.netbeans.modules.hibernate.mapping.model.MyClass;
import org.netbeans.modules.hibernate.mapping.model.NaturalId;
import org.netbeans.modules.hibernate.mapping.model.NestedCompositeElement;
import org.netbeans.modules.hibernate.mapping.model.OneToOne;
import org.netbeans.modules.hibernate.mapping.model.Properties;
import org.netbeans.modules.hibernate.mapping.model.Property;
import org.netbeans.modules.hibernate.mapping.model.Set;
import org.netbeans.modules.hibernate.mapping.model.Subclass;
import org.netbeans.modules.hibernate.mapping.model.Timestamp;
import org.netbeans.modules.hibernate.mapping.model.UnionSubclass;
import org.netbeans.modules.hibernate.mapping.model.Version;
import org.netbeans.modules.hibernate.refactoring.HibernateRefactoringUtil;
import org.netbeans.modules.hibernate.refactoring.RenameTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileObject;

public class JavaFieldRenameTransaction
extends RenameTransaction {
    private final String nameAttrib = "Name";
    private String className;

    public JavaFieldRenameTransaction(java.util.Set<FileObject> files, String className, String origFieldName, String newFieldName) {
        super(files, origFieldName, newFieldName);
        this.className = className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doChanges() {
        for (FileObject mappingFileObject : this.getToBeModifiedFiles()) {
            OutputStream outs = null;
            try {
                InputStream is = mappingFileObject.getInputStream();
                HibernateMapping hbMapping = null;
                try {
                    hbMapping = HibernateMapping.createGraph(is);
                }
                catch (RuntimeException ex) {
                    Logger.getLogger(JavaFieldRenameTransaction.class.getName()).log(Level.WARNING, "Failed to refactor in {0}, verify if xml document is well formed", mappingFileObject.getPath());
                }
                if (hbMapping == null) continue;
                HibernateRefactoringUtil.ChangeTracker rewriteTrack = new HibernateRefactoringUtil.ChangeTracker();
                hbMapping.addPropertyChangeListener(rewriteTrack);
                this.refactoringMyClasses(hbMapping.getMyClass());
                this.refactoringSubclasses(hbMapping.getSubclass());
                this.refactoringJoinedSubclasses(hbMapping.getJoinedSubclass());
                this.refactoringUnionSubclasses(hbMapping.getUnionSubclass());
                if (rewriteTrack.isChanged()) {
                    outs = mappingFileObject.getOutputStream();
                    hbMapping.write(outs);
                }
                hbMapping.removePropertyChangeListener(rewriteTrack);
            }
            catch (FileAlreadyLockedException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify(1, (Throwable)ex);
            }
            finally {
                try {
                    if (outs == null) continue;
                    outs.close();
                }
                catch (IOException ex) {
                    ErrorManager.getDefault().notify(1, (Throwable)ex);
                }
            }
        }
    }

    private void refactoringMyClasses(MyClass[] myClazz) {
        for (int ci = 0; ci < myClazz.length; ++ci) {
            MyClass myClzz = myClazz[ci];
            String clsName = myClzz.getAttributeValue("Name");
            if (clsName != null && clsName.equals(this.className)) {
                String timestamp;
                Timestamp tstamp;
                String versionName;
                Version ver;
                String idPropName;
                Id id = myClzz.getId();
                if (id != null && (idPropName = id.getAttributeValue("Name")) != null && idPropName.equals(this.origName)) {
                    id.setAttributeValue("Name", this.newName);
                }
                if ((ver = myClzz.getVersion()) != null && (versionName = ver.getAttributeValue("Name")) != null && versionName.equals(this.origName)) {
                    ver.setAttributeValue("Name", this.newName);
                }
                if ((tstamp = myClzz.getTimestamp()) != null && (timestamp = tstamp.getAttributeValue("Name")) != null && timestamp.equals(this.origName)) {
                    tstamp.setAttributeValue("Name", this.newName);
                }
                this.refactoringCompositeId(myClzz.getCompositeId());
                this.refactoringProperty(myClzz.getProperty2());
                this.refactoringJoins(myClzz.getJoin());
                this.refactoringNaturalId(myClzz.getNaturalId());
                this.refactoringMaps(myClzz.getMap());
                this.refactoringSets(myClzz.getSet());
                this.refactoringLists(myClzz.getList());
                this.refactoringArrays(myClzz.getArray());
                this.refactoringBags(myClzz.getBag());
                this.refactoringIdbags(myClzz.getIdbag());
                this.refactoringDynamicComponents(myClzz.getDynamicComponent());
                this.refactoringComponents(myClzz.getComponent());
                this.refactoringAnys(myClzz.getAny());
                this.refactoringManyToOnes(myClzz.getManyToOne());
                this.refactoringPropertiez(myClzz.getProperties());
                this.refactoringOneToOnes(myClzz.getOneToOne());
            }
            this.refactoringSubclasses(myClzz.getSubclass());
            this.refactoringJoinedSubclasses(myClzz.getJoinedSubclass());
            this.refactoringUnionSubclasses(myClzz.getUnionSubclass());
        }
    }

    private void refactoringSubclasses(Subclass[] subclazz) {
        for (int i = 0; i < subclazz.length; ++i) {
            String clsName = subclazz[i].getAttributeValue("Name");
            if (clsName != null && clsName.equals(this.className)) {
                this.refactoringProperty(subclazz[i].getProperty2());
                this.refactoringJoins(subclazz[i].getJoin());
                this.refactoringMaps(subclazz[i].getMap());
                this.refactoringDynamicComponents(subclazz[i].getDynamicComponent());
                this.refactoringComponents(subclazz[i].getComponent());
                this.refactoringSets(subclazz[i].getSet());
                this.refactoringLists(subclazz[i].getList());
                this.refactoringArrays(subclazz[i].getArray());
                this.refactoringBags(subclazz[i].getBag());
                this.refactoringIdbags(subclazz[i].getIdbag());
                this.refactoringAnys(subclazz[i].getAny());
                this.refactoringManyToOnes(subclazz[i].getManyToOne());
                this.refactoringOneToOnes(subclazz[i].getOneToOne());
            }
            this.refactoringSubclasses(subclazz[i].getSubclass());
        }
    }

    private void refactoringJoinedSubclasses(JoinedSubclass[] joinedSubclazz) {
        for (int i = 0; i < joinedSubclazz.length; ++i) {
            String clsName = joinedSubclazz[i].getAttributeValue("Name");
            if (clsName != null && clsName.equals(this.className)) {
                this.refactoringProperty(joinedSubclazz[i].getProperty2());
                this.refactoringMaps(joinedSubclazz[i].getMap());
                this.refactoringDynamicComponents(joinedSubclazz[i].getDynamicComponent());
                this.refactoringComponents(joinedSubclazz[i].getComponent());
                this.refactoringSets(joinedSubclazz[i].getSet());
                this.refactoringLists(joinedSubclazz[i].getList());
                this.refactoringArrays(joinedSubclazz[i].getArray());
                this.refactoringBags(joinedSubclazz[i].getBag());
                this.refactoringIdbags(joinedSubclazz[i].getIdbag());
                this.refactoringAnys(joinedSubclazz[i].getAny());
                this.refactoringManyToOnes(joinedSubclazz[i].getManyToOne());
                this.refactoringPropertiez(joinedSubclazz[i].getProperties());
                this.refactoringOneToOnes(joinedSubclazz[i].getOneToOne());
            }
            this.refactoringJoinedSubclasses(joinedSubclazz[i].getJoinedSubclass());
        }
    }

    private void refactoringUnionSubclasses(UnionSubclass[] unionSubclazz) {
        for (int i = 0; i < unionSubclazz.length; ++i) {
            String clsName = unionSubclazz[i].getAttributeValue("Name");
            if (clsName != null && clsName.equals(this.className)) {
                this.refactoringProperty(unionSubclazz[i].getProperty2());
                this.refactoringMaps(unionSubclazz[i].getMap());
                this.refactoringDynamicComponents(unionSubclazz[i].getDynamicComponent());
                this.refactoringComponents(unionSubclazz[i].getComponent());
                this.refactoringSets(unionSubclazz[i].getSet());
                this.refactoringLists(unionSubclazz[i].getList());
                this.refactoringArrays(unionSubclazz[i].getArray());
                this.refactoringBags(unionSubclazz[i].getBag());
                this.refactoringIdbags(unionSubclazz[i].getIdbag());
                this.refactoringAnys(unionSubclazz[i].getAny());
                this.refactoringManyToOnes(unionSubclazz[i].getManyToOne());
                this.refactoringPropertiez(unionSubclazz[i].getProperties());
                this.refactoringOneToOnes(unionSubclazz[i].getOneToOne());
            }
            this.refactoringUnionSubclasses(unionSubclazz[i].getUnionSubclass());
        }
    }

    private void refactoringCompositeId(CompositeId compositeId) {
        if (compositeId == null) {
            return;
        }
        if (compositeId != null) {
            String compositeIdPropName = compositeId.getAttributeValue("Name");
            if (compositeIdPropName != null && compositeIdPropName.equals(this.origName)) {
                compositeId.setAttributeValue("Name", this.newName);
            }
            this.refactoringKeyProperty(compositeId.getKeyProperty());
            this.refactoringKeyManyToOne(compositeId.getKeyManyToOne());
        }
    }

    private void refactoringKeyManyToOne(KeyManyToOne[] keyManyToOnes) {
        for (int i = 0; i < keyManyToOnes.length; ++i) {
            String name = keyManyToOnes[i].getAttributeValue("Name");
            if (name == null || !name.equals(this.origName)) continue;
            keyManyToOnes[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringMaps(Map[] maps) {
        for (int i = 0; i < maps.length; ++i) {
            CompositeIndex index;
            CompositeMapKey mKey;
            String mapName = maps[i].getAttributeValue("Name");
            if (mapName != null && mapName.equals(this.origName)) {
                maps[i].setAttributeValue("Name", this.newName);
            }
            if ((mKey = maps[i].getCompositeMapKey()) != null) {
                this.refactoringKeyProperty(mKey.getKeyProperty());
                this.refactoringKeyManyToOne(mKey.getKeyManyToOne());
            }
            if ((index = maps[i].getCompositeIndex()) != null) {
                this.refactoringKeyProperty(index.getKeyProperty());
                this.refactoringKeyManyToOne(index.getKeyManyToOne());
            }
            this.refactoringCompositeElement(maps[i].getCompositeElement());
        }
    }

    private void refactoringKeyProperty(KeyProperty[] keyProps) {
        for (int i = 0; i < keyProps.length; ++i) {
            String keyPropName = keyProps[i].getAttributeValue("Name");
            if (keyPropName == null || !keyPropName.equals(this.origName)) continue;
            keyProps[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringNaturalId(NaturalId nId) {
        if (nId == null) {
            return;
        }
        this.refactoringProperty(nId.getProperty2());
        this.refactoringAnys(nId.getAny());
        this.refactoringManyToOnes(nId.getManyToOne());
    }

    private void refactoringJoins(Join[] joins) {
        for (int i = 0; i < joins.length; ++i) {
            Join theJoin = joins[i];
            this.refactoringProperty(theJoin.getProperty2());
            this.refactoringAnys(theJoin.getAny());
            this.refactoringManyToOnes(theJoin.getManyToOne());
        }
    }

    private void refactoringProperty(Property[] clazzProps) {
        for (int pi = 0; pi < clazzProps.length; ++pi) {
            String propName = clazzProps[pi].getAttributeValue("Name");
            if (!propName.equals(this.origName)) continue;
            clazzProps[pi].setAttributeValue("Name", this.newName);
            break;
        }
    }

    private void refactoringComponents(Component[] hbModelComps) {
        for (int i = 0; i < hbModelComps.length; ++i) {
            Component thisComp = hbModelComps[i];
            this.refactoringMaps(thisComp.getMap());
            this.refactoringSets(thisComp.getSet());
            this.refactoringArrays(thisComp.getArray());
            this.refactoringBags(thisComp.getBag());
            this.refactoringAnys(thisComp.getAny());
            this.refactoringManyToOnes(thisComp.getManyToOne());
            this.refactoringOneToOnes(thisComp.getOneToOne());
        }
    }

    private void refactoringDynamicComponents(DynamicComponent[] hbModelDynComps) {
        for (int i = 0; i < hbModelDynComps.length; ++i) {
            DynamicComponent thisComp = hbModelDynComps[i];
            this.refactoringMaps(thisComp.getMap());
            this.refactoringSets(thisComp.getSet());
            this.refactoringArrays(thisComp.getArray());
            this.refactoringBags(thisComp.getBag());
            this.refactoringAnys(thisComp.getAny());
            this.refactoringManyToOnes(thisComp.getManyToOne());
            this.refactoringOneToOnes(thisComp.getOneToOne());
        }
    }

    private void refactoringSets(Set[] sets) {
        for (int i = 0; i < sets.length; ++i) {
            String nameValue = sets[i].getAttributeValue("Name");
            if (nameValue != null && nameValue.equals(this.origName)) {
                sets[i].setAttributeValue("Name", this.newName);
            }
            this.refactoringCompositeElement(sets[i].getCompositeElement());
        }
    }

    private void refactoringLists(List[] lists) {
        for (int i = 0; i < lists.length; ++i) {
            String nameValue = lists[i].getAttributeValue("Name");
            if (nameValue != null && nameValue.equals(this.origName)) {
                lists[i].setAttributeValue("Name", this.newName);
            }
            this.refactoringCompositeElement(lists[i].getCompositeElement());
        }
    }

    private void refactoringAnys(Any[] anys) {
        for (int i = 0; i < anys.length; ++i) {
            String name = anys[i].getAttributeValue("Name");
            if (name == null || !name.equals(this.origName)) continue;
            anys[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringManyToOnes(ManyToOne[] manyToOnes) {
        for (int i = 0; i < manyToOnes.length; ++i) {
            String name = manyToOnes[i].getAttributeValue("Name");
            if (name == null || !name.equals(this.origName)) continue;
            manyToOnes[i].setAttributeValue("Name", this.newName);
        }
    }

    private void refactoringArrays(Array[] arrays) {
        for (int i = 0; i < arrays.length; ++i) {
            this.refactoringCompositeElement(arrays[i].getCompositeElement());
        }
    }

    private void refactoringBags(Bag[] bags) {
        for (int i = 0; i < bags.length; ++i) {
            this.refactoringCompositeElement(bags[i].getCompositeElement());
        }
    }

    private void refactoringIdbags(Idbag[] idbags) {
        for (int i = 0; i > idbags.length; ++i) {
            this.refactoringCompositeElement(idbags[i].getCompositeElement());
        }
    }

    private void refactoringCompositeElement(CompositeElement compElem) {
        if (compElem == null) {
            return;
        }
        this.refactoringManyToOnes(compElem.getManyToOne());
        this.refactoringNestedCompositeElements(compElem.getNestedCompositeElement());
    }

    private void refactoringNestedCompositeElements(NestedCompositeElement[] elems) {
        for (int i = 0; i < elems.length; ++i) {
            this.refactoringManyToOnes(elems[i].getManyToOne());
        }
    }

    private void refactoringPropertiez(Properties[] propertiez) {
        for (int i = 0; i < propertiez.length; ++i) {
            this.refactoringProperty(propertiez[i].getProperty2());
            this.refactoringManyToOnes(propertiez[i].getManyToOne());
        }
    }

    private void refactoringOneToOnes(OneToOne[] oneToOnes) {
        for (int i = 0; i < oneToOnes.length; ++i) {
            String name = oneToOnes[i].getAttributeValue("Name");
            if (name == null || !name.equals(this.origName)) continue;
            oneToOnes[i].setAttributeValue("Name", this.newName);
        }
    }
}

