/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.amazon.ui;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.modules.cloud.amazon.serverplugin.AmazonJ2EEInstance;
import org.netbeans.modules.cloud.amazon.ui.RemoteServerPropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class AmazonJ2EEInstanceNode
extends AbstractNode {
    public static final String TOMCAT_ICON = "org/netbeans/modules/cloud/amazon/ui/resources/tomcat.png";
    private AmazonJ2EEInstance aij;
    private static final String RUNNING_ICON = "org/netbeans/modules/cloud/amazon/ui/resources/running.png";
    private static final String WAITING_ICON = "org/netbeans/modules/cloud/amazon/ui/resources/waiting.png";
    private static final String TERMINATED_ICON = "org/netbeans/modules/cloud/amazon/ui/resources/terminated.png";

    public AmazonJ2EEInstanceNode(AmazonJ2EEInstance aij) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{aij}));
        this.aij = aij;
        this.setName("");
        this.setDisplayName(aij.getDisplayName());
        this.setIconBaseWithExtension(TOMCAT_ICON);
    }

    void showServerType() {
        this.setDisplayName(this.aij.getEnvironmentName() + " [" + this.aij.getApplicationName() + "]" + " on " + this.aij.getContainerType());
    }

    public Image getIcon(int type) {
        return this.badgeIcon(super.getIcon(type));
    }

    public Image getOpenedIcon(int type) {
        return this.badgeIcon(super.getOpenedIcon(type));
    }

    private Image badgeIcon(Image origImg) {
        Image badge = null;
        switch (this.aij.getState()) {
            case UPDATING: 
            case LAUNCHING: 
            case TERMINATING: {
                badge = ImageUtilities.loadImage((String)WAITING_ICON);
                break;
            }
            case READY: {
                badge = ImageUtilities.loadImage((String)RUNNING_ICON);
                break;
            }
            case TERMINATED: {
                badge = ImageUtilities.loadImage((String)TERMINATED_ICON);
            }
        }
        return badge != null ? ImageUtilities.mergeImages((Image)origImg, (Image)badge, (int)15, (int)8) : origImg;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(RemoteServerPropertiesAction.class)};
    }
}

