/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.wsdlmodelext;

import java.io.FileWriter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.xml.namespace.QName;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.jaxwsruntimemodel.JavaWsdlMapper;
import org.netbeans.modules.websvc.wsitconf.WSITEditor;
import org.netbeans.modules.websvc.wsitconf.api.DesignerListenerProvider;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfileRegistry;
import org.netbeans.modules.websvc.wsitconf.spi.WsitProvider;
import org.netbeans.modules.websvc.wsitconf.ui.ComboConstants;
import org.netbeans.modules.websvc.wsitconf.ui.security.listmodels.ServiceProviderElement;
import org.netbeans.modules.websvc.wsitconf.util.AbstractTask;
import org.netbeans.modules.websvc.wsitconf.util.SourceUtils;
import org.netbeans.modules.websvc.wsitconf.util.UndoManagerHolder;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AddressingModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProfilesModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.ProprietarySecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMDeliveryAssurance;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.RMSequenceBinding;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.policy.PolicyReference;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.STSConfiguration;
import org.netbeans.modules.websvc.wsitmodelext.security.proprietary.service.ServiceProvider;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.retriever.catalog.Utilities;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.netbeans.modules.xml.wsdl.model.BindingFault;
import org.netbeans.modules.xml.wsdl.model.BindingInput;
import org.netbeans.modules.xml.wsdl.model.BindingOperation;
import org.netbeans.modules.xml.wsdl.model.BindingOutput;
import org.netbeans.modules.xml.wsdl.model.Definitions;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.Fault;
import org.netbeans.modules.xml.wsdl.model.Import;
import org.netbeans.modules.xml.wsdl.model.Input;
import org.netbeans.modules.xml.wsdl.model.Message;
import org.netbeans.modules.xml.wsdl.model.Operation;
import org.netbeans.modules.xml.wsdl.model.Output;
import org.netbeans.modules.xml.wsdl.model.Port;
import org.netbeans.modules.xml.wsdl.model.PortType;
import org.netbeans.modules.xml.wsdl.model.ReferenceableWSDLComponent;
import org.netbeans.modules.xml.wsdl.model.RequestResponseOperation;
import org.netbeans.modules.xml.wsdl.model.Types;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.netbeans.modules.xml.wsdl.model.WSDLComponentFactory;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.netbeans.modules.xml.wsdl.model.WSDLModelFactory;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.ModelSource;
import org.netbeans.modules.xml.xam.locator.CatalogModel;
import org.netbeans.modules.xml.xam.locator.CatalogModelException;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WSITModelSupport {
    public static final String CONFIG_WSDL_CLIENT_PREFIX = "wsit-client";
    public static final String CONFIG_WSDL_SERVICE_PREFIX = "wsit-";
    public static final String MAIN_CONFIG_EXTENSION = "xml";
    public static final String CONFIG_WSDL_EXTENSION = "xml";
    private static final Logger logger = Logger.getLogger(WSITModelSupport.class.getName());

    public static WSDLModel getModel(Node node, JaxWsModel jaxWsModel, UndoManagerHolder umHolder, boolean create, Collection<FileObject> createdFiles) throws MalformedURLException, Exception {
        WSDLModel model = null;
        Client client = (Client)node.getLookup().lookup(Client.class);
        Service service = (Service)node.getLookup().lookup(Service.class);
        if (client != null) {
            FileObject srcRoot = (FileObject)node.getLookup().lookup(FileObject.class);
            Project p = FileOwnerQuery.getOwner((FileObject)srcRoot);
            model = WSITModelSupport.getModelForClient(p, client, create, createdFiles);
        } else if (service != null) {
            FileObject implClass = (FileObject)node.getLookup().lookup(FileObject.class);
            if (jaxWsModel == null) {
                logger.log(Level.INFO, "JAX-WS Model is null: " + node);
                return null;
            }
            Project p = FileOwnerQuery.getOwner((FileObject)jaxWsModel.getJaxWsFile());
            model = WSITModelSupport.getModelForService(service, implClass, p, create, createdFiles);
        } else {
            logger.log(Level.INFO, "Unable to identify node type: " + node);
        }
        if (model != null && umHolder != null && umHolder.getUndoManager() == null) {
            UndoManager undoManager = new UndoManager();
            model.addUndoableEditListener((UndoableEditListener)undoManager);
            umHolder.setUndoManager(undoManager);
        }
        return model;
    }

    public static void doEndTransaction(Model model) {
        try {
            model.endTransaction();
        }
        catch (IllegalStateException e) {
            logger.log(Level.WARNING, null, e);
        }
    }

    public static WSDLModel getModelForService(Service service, FileObject implClass, Project p, boolean create, Collection<FileObject> createdFiles) {
        try {
            String wsdlUrl = service.getLocalWsdlFile();
            if (wsdlUrl == null) {
                if (implClass == null || !implClass.isValid() || implClass.isVirtual()) {
                    logger.log(Level.INFO, "Implementation class is null or not valid, or just virtual: " + implClass + ", service: " + service);
                    return null;
                }
                return WSITModelSupport.getModelForServiceFromJava(implClass, p, create, createdFiles);
            }
            if (p == null) {
                return null;
            }
            JAXWSSupport supp = JAXWSSupport.getJAXWSSupport((FileObject)p.getProjectDirectory());
            return WSITModelSupport.getModelForServiceFromWsdl(supp, service);
        }
        catch (IOException ex) {
            logger.log(Level.INFO, null, ex);
        }
        catch (Exception e) {
            logger.log(Level.INFO, null, e);
        }
        return null;
    }

    public static WSDLModel getModelFromFO(FileObject wsdlFO, boolean editable) {
        WSDLModel model = null;
        if (wsdlFO == null) {
            return null;
        }
        ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)editable);
        try {
            model = WSDLModelFactory.getDefault().getModel(ms);
            if (model != null) {
                model.sync();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, null, ex);
        }
        return model;
    }

    public static WSDLModel getModelForClient(Project p, Client client, boolean create, Collection<FileObject> createdFiles) throws IOException {
        return WSITModelSupport.getModelForClient(p, URI.create(client.getWsdlUrl()), create, createdFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WSDLModel getModelForClient(Project p, URI fileUri, boolean create, Collection<FileObject> createdFiles) throws IOException {
        WSDLModel model;
        block16: {
            model = null;
            FileObject srcFolder = WSITEditor.getClientConfigFolder(p);
            FileObject catalogfo = Utilities.getProjectCatalogFileObject((Project)p);
            ModelSource catalogms = Utilities.getModelSource((FileObject)catalogfo, (boolean)true);
            try {
                DataObject configDO;
                FileObject configFO;
                CatalogModel cm = Utilities.getCatalogModel((ModelSource)catalogms);
                ModelSource originalms = cm.getModelSource(fileUri);
                FileObject originalWsdlFO = originalms == null ? null : Utilities.getFileObject((ModelSource)originalms);
                WSDLModel originalwsdlmodel = WSITModelSupport.getModelFromFO(originalWsdlFO, true);
                if (originalWsdlFO != null) {
                    configFO = srcFolder.getFileObject(originalWsdlFO.getName(), "xml");
                    if (configFO != null && configFO.isValid()) {
                        return WSITModelSupport.getModelFromFO(configFO, true);
                    }
                } else {
                    logger.log(Level.INFO, "No original WSDL file found for " + fileUri);
                }
                if (!create) break block16;
                if (originalwsdlmodel == null) {
                    return null;
                }
                FileObject mainConfigFO = srcFolder.getFileObject(CONFIG_WSDL_CLIENT_PREFIX, "xml");
                if (mainConfigFO == null) {
                    mainConfigFO = WSITModelSupport.createMainConfig(srcFolder, createdFiles);
                }
                WSITModelSupport.copyImports(originalwsdlmodel, srcFolder, createdFiles);
                WSDLModel mainModel = WSITModelSupport.getModelFromFO(mainConfigFO, true);
                mainModel.startTransaction();
                try {
                    WSDLComponentFactory wcf = mainModel.getFactory();
                    FileObject configName = Utilities.getFileObject((ModelSource)originalwsdlmodel.getModelSource());
                    configFO = srcFolder.getFileObject(configName.getName(), "xml");
                    boolean importFound = false;
                    Collection imports = mainModel.getDefinitions().getImports();
                    for (Import i : imports) {
                        if (!i.getLocation().equals(configFO.getNameExt())) continue;
                        importFound = true;
                        break;
                    }
                    model = WSITModelSupport.getModelFromFO(configFO, true);
                    if (!importFound) {
                        Import imp = wcf.createImport();
                        imp.setLocation(configFO.getNameExt());
                        imp.setNamespace(model.getDefinitions().getTargetNamespace());
                        Definitions def = mainModel.getDefinitions();
                        def.setName("mainclientconfig");
                        def.addImport(imp);
                    }
                }
                finally {
                    mainModel.endTransaction();
                }
                DataObject mainConfigDO = DataObject.find((FileObject)mainConfigFO);
                if (mainConfigDO != null && mainConfigDO.isModified()) {
                    SaveCookie wsdlSaveCookie = (SaveCookie)mainConfigDO.getCookie(SaveCookie.class);
                    if (wsdlSaveCookie != null) {
                        wsdlSaveCookie.save();
                    }
                    mainConfigDO.setModified(false);
                }
                if ((configDO = DataObject.find((FileObject)configFO)) != null && configDO.isModified()) {
                    SaveCookie wsdlSaveCookie = (SaveCookie)configDO.getCookie(SaveCookie.class);
                    if (wsdlSaveCookie != null) {
                        wsdlSaveCookie.save();
                    }
                    configDO.setModified(false);
                }
            }
            catch (CatalogModelException ex) {
                logger.log(Level.INFO, null, ex);
            }
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void copyImports(WSDLModel model, FileObject srcFolder, Collection<FileObject> createdFiles) throws CatalogModelException {
        FileObject modelFO = Utilities.getFileObject((ModelSource)model.getModelSource());
        try {
            FileObject configFO = FileUtil.copyFile((FileObject)modelFO, (FileObject)srcFolder, (String)modelFO.getName(), (String)"xml");
            if (createdFiles != null) {
                createdFiles.add(configFO);
            }
            WSDLModel newModel = WSITModelSupport.getModelFromFO(configFO, true);
            WSITModelSupport.removePolicies(newModel);
            WSITModelSupport.removeTypes(newModel);
            Collection oldImports = model.getDefinitions().getImports();
            Collection newImports = newModel.getDefinitions().getImports();
            Iterator newImportsIt = newImports.iterator();
            for (Import i : oldImports) {
                WSDLModel oldImportedModel = i.getImportedWSDLModel();
                FileObject oldImportFO = Utilities.getFileObject((ModelSource)oldImportedModel.getModelSource());
                newModel.startTransaction();
                try {
                    ((Import)newImportsIt.next()).setLocation(oldImportFO.getName() + "." + "xml");
                }
                finally {
                    newModel.endTransaction();
                }
                WSITModelSupport.copyImports(oldImportedModel, srcFolder, createdFiles);
            }
        }
        catch (IOException e) {
            logger.log(Level.FINE, null, e);
        }
    }

    static FileObject createMainConfig(FileObject folder, Collection<FileObject> createdFiles) {
        FileObject mainConfig = null;
        try {
            mainConfig = FileUtil.createData((FileObject)folder, (String)"wsit-client.xml");
            if (mainConfig != null && mainConfig.isValid() && !mainConfig.isVirtual()) {
                if (createdFiles != null) {
                    createdFiles.add(mainConfig);
                }
                FileWriter fw = new FileWriter(FileUtil.toFile((FileObject)mainConfig));
                fw.write(NbBundle.getMessage(WSITEditor.class, (String)"EMPTY_WSDL"));
                fw.close();
                mainConfig.refresh(true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return mainConfig;
    }

    public static WSDLModel getMainClientModel(FileObject folder) {
        FileObject mainConfig;
        WSDLModel model = null;
        if (folder != null && (mainConfig = folder.getFileObject(CONFIG_WSDL_CLIENT_PREFIX, "xml")) != null) {
            model = WSITModelSupport.getModelFromFO(mainConfig, true);
        }
        return model;
    }

    public static WSDLModel getServiceModelForClient(JAXWSClientSupport supp, Client client) throws IOException, Exception {
        FileObject originalWsdlFolder = supp.getLocalWsdlFolderForClient(client.getName(), false);
        FileObject originalWsdlFO = originalWsdlFolder.getFileObject(client.getLocalWsdlFile());
        if (originalWsdlFO != null && originalWsdlFO.isValid()) {
            return WSITModelSupport.getModelFromFO(originalWsdlFO, true);
        }
        return null;
    }

    private static WSDLModel getModelForServiceFromWsdl(JAXWSSupport supp, Service service) throws IOException, Exception {
        String wsdlLocation = service.getLocalWsdlFile();
        FileObject wsdlFO = supp.getLocalWsdlFolderForService(service.getName(), false).getFileObject(wsdlLocation);
        return WSITModelSupport.getModelFromFO(wsdlFO, true);
    }

    public static WSDLModel getModelForServiceFromJava(FileObject jc, Project p, boolean create, Collection<FileObject> createdFiles) throws IOException {
        FileObject wsdlFO;
        WSDLModel model = null;
        String configWsdlName = CONFIG_WSDL_SERVICE_PREFIX;
        try {
            if (jc == null) {
                return null;
            }
            final String[] result = new String[1];
            JavaSource js = JavaSource.forFileObject((FileObject)jc);
            js.runUserActionTask((Task)new AbstractTask<CompilationController>(){

                public void run(CompilationController controller) throws IOException {
                    controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    SourceUtils sourceUtils = SourceUtils.newInstance(controller);
                    if (sourceUtils != null) {
                        result[0] = sourceUtils.getTypeElement().getQualifiedName().toString();
                    }
                }
            }, true);
            configWsdlName = configWsdlName + result[0];
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        WsitProvider wp = (WsitProvider)p.getLookup().lookup(WsitProvider.class);
        FileObject cfgFolder = wp.getConfigFilesFolder(false, create);
        if (cfgFolder != null && cfgFolder.isValid() && (wsdlFO = cfgFolder.getFileObject(configWsdlName, "xml")) != null && wsdlFO.isValid()) {
            return WSITModelSupport.getModelFromFO(wsdlFO, true);
        }
        if (create) {
            wsdlFO = cfgFolder.getFileObject(configWsdlName, "xml");
            if (wsdlFO == null || !FileUtil.toFile((FileObject)wsdlFO).exists()) {
                wsdlFO = cfgFolder.createData(configWsdlName, "xml");
                if (createdFiles != null) {
                    createdFiles.add(wsdlFO);
                }
                FileWriter fw = new FileWriter(FileUtil.toFile((FileObject)wsdlFO));
                fw.write(NbBundle.getMessage(WSITEditor.class, (String)"EMPTY_WSDL"));
                fw.close();
                wsdlFO.refresh(true);
            }
            model = WSITModelSupport.createModelFromFO(wsdlFO, jc);
            wsdlFO.refresh(true);
            DesignerListenerProvider.configCreated();
        }
        return model;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static WSDLModel createModelFromFO(FileObject wsdlFO, FileObject jc) {
        WSDLModel model;
        block11: {
            model = null;
            ModelSource ms = Utilities.getModelSource((FileObject)wsdlFO, (boolean)true);
            try {
                Definitions d;
                model = WSDLModelFactory.getDefault().getModel(ms);
                if (model == null || (d = model.getDefinitions()) == null) break block11;
                model.startTransaction();
                try {
                    WSDLComponentFactory wcf = model.getFactory();
                    QName serviceQName = JavaWsdlMapper.getServiceName(jc);
                    String serviceLocalName = serviceQName.getLocalPart();
                    String serviceTargetNamespace = serviceQName.getNamespaceURI();
                    d.setName(serviceLocalName);
                    d.setTargetNamespace(serviceTargetNamespace);
                    org.netbeans.modules.xml.wsdl.model.Service s = wcf.createService();
                    s.setName(serviceLocalName);
                    d.addService(s);
                    Port port = wcf.createPort();
                    QName portName = JavaWsdlMapper.getPortName(jc, serviceTargetNamespace);
                    if (portName != null) {
                        port.setName(portName.getLocalPart());
                    }
                    s.addPort(port);
                    Binding binding = wcf.createBinding();
                    String bindingName = JavaWsdlMapper.getBindingName(jc, serviceTargetNamespace);
                    binding.setName(bindingName);
                    d.addBinding(binding);
                    port.setBinding(binding.createReferenceTo((ReferenceableWSDLComponent)binding, Binding.class));
                    PortType portType = wcf.createPortType();
                    QName portTypeName = JavaWsdlMapper.getPortTypeName(jc);
                    portType.setName(portTypeName.getLocalPart());
                    d.addPortType(portType);
                    List<String> bindingOperationNames = JavaWsdlMapper.getOperationNames(jc);
                    for (String name : bindingOperationNames) {
                        BindingOperation bindingOperation = wcf.createBindingOperation();
                        bindingOperation.setName(name);
                        binding.addBindingOperation(bindingOperation);
                        Message inputMsg = wcf.createMessage();
                        inputMsg.setName(name);
                        d.addMessage(inputMsg);
                        Message outMsg = wcf.createMessage();
                        outMsg.setName(name + "Response");
                        d.addMessage(outMsg);
                        RequestResponseOperation oper = wcf.createRequestResponseOperation();
                        oper.setName(name);
                        portType.addOperation((Operation)oper);
                        List<String> faults = JavaWsdlMapper.getOperationFaults(jc, name);
                        for (String faultstr : faults) {
                            Collection msgs = d.getMessages();
                            Message fMsg = null;
                            for (Message msg : msgs) {
                                if (!msg.getName().equals(faultstr)) continue;
                                fMsg = msg;
                                break;
                            }
                            if (fMsg == null) {
                                fMsg = wcf.createMessage();
                                fMsg.setName(faultstr);
                                d.addMessage(fMsg);
                            }
                            Fault fault = wcf.createFault();
                            fault.setName(faultstr);
                            oper.addFault(fault);
                            fault.setMessage(fault.createReferenceTo((ReferenceableWSDLComponent)fMsg, Message.class));
                        }
                        Input input = wcf.createInput();
                        oper.setInput(input);
                        input.setMessage(input.createReferenceTo((ReferenceableWSDLComponent)inputMsg, Message.class));
                        Output out = wcf.createOutput();
                        oper.setOutput(out);
                        out.setMessage(out.createReferenceTo((ReferenceableWSDLComponent)outMsg, Message.class));
                        BindingOutput bindingOutput = wcf.createBindingOutput();
                        bindingOperation.setBindingOutput(bindingOutput);
                        BindingInput bindingInput = wcf.createBindingInput();
                        bindingOperation.setBindingInput(bindingInput);
                        List<String> operationFaults = JavaWsdlMapper.getOperationFaults(jc, name);
                        for (String fault : operationFaults) {
                            BindingFault bindingFault = wcf.createBindingFault();
                            bindingFault.setName(fault);
                            bindingOperation.addBindingFault(bindingFault);
                        }
                    }
                    binding.setType(binding.createReferenceTo((ReferenceableWSDLComponent)portType, PortType.class));
                }
                finally {
                    model.endTransaction();
                }
                DataObject dO = DataObject.find((FileObject)wsdlFO);
                SaveCookie sc = (SaveCookie)dO.getCookie(SaveCookie.class);
                sc.save();
                dO.setModified(false);
            }
            catch (IOException ex) {
                logger.log(Level.INFO, null, ex);
            }
        }
        return model;
    }

    private static void removeTypes(WSDLModel model) {
        model.startTransaction();
        try {
            Definitions d = model.getDefinitions();
            Types t = d.getTypes();
            if (t != null) {
                t.getSchemas().retainAll(new ArrayList());
            }
        }
        finally {
            model.endTransaction();
        }
    }

    private static void removePolicies(WSDLModel model) {
        model.startTransaction();
        try {
            WSITModelSupport.removePolicyElements((WSDLComponent)model.getDefinitions());
        }
        finally {
            model.endTransaction();
        }
    }

    public static boolean isServiceFromWsdl(Node node) {
        if (node != null) {
            Service service = (Service)node.getLookup().lookup(Service.class);
            if (service != null) {
                return WSITModelSupport.isServiceFromWsdl(service);
            }
            JaxWsService jaxService = (JaxWsService)node.getLookup().lookup(JaxWsService.class);
            if (jaxService != null && jaxService.isServiceProvider()) {
                return WSITModelSupport.isServiceFromWsdl(jaxService);
            }
        }
        return false;
    }

    public static boolean isServiceFromWsdl(JaxWsService service) {
        String wsdlUrl;
        return service != null && (wsdlUrl = service.getLocalWsdl()) != null;
    }

    public static boolean isServiceFromWsdl(Service service) {
        String wsdlUrl;
        return service != null && (wsdlUrl = service.getLocalWsdlFile()) != null;
    }

    private static void removePolicyElements(WSDLComponent c) {
        List policies = c.getExtensibilityElements(Policy.class);
        for (Object p : policies) {
            c.removeExtensibilityElement((ExtensibilityElement)p);
        }
        List policyReferences = c.getExtensibilityElements(PolicyReference.class);
        for (PolicyReference pr : policyReferences) {
            c.removeExtensibilityElement((ExtensibilityElement)pr);
        }
        List children = c.getChildren();
        for (WSDLComponent ch : children) {
            WSITModelSupport.removePolicyElements(ch);
        }
    }

    public static void fillImportedBindings(WSDLModel model, Collection<Binding> bindings, Set<FileObject> traversedModels) {
        FileObject modelFO = Util.getFOForModel(model);
        if (traversedModels.contains(modelFO)) {
            return;
        }
        traversedModels.add(modelFO);
        if (model == null || model.getDefinitions() == null) {
            return;
        }
        Collection importedBindings = model.getDefinitions().getBindings();
        bindings.addAll(importedBindings);
        Collection imports = model.getDefinitions().getImports();
        for (Import i : imports) {
            try {
                WSDLModel importedModel = i.getImportedWSDLModel();
                WSITModelSupport.fillImportedBindings(importedModel, bindings, traversedModels);
            }
            catch (CatalogModelException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void save(WSDLComponent c) {
        WSDLModel model = c.getModel();
        WSITModelSupport.save(model);
    }

    public static synchronized void save(WSDLModel model) {
        HashSet<FileObject> traversedModels = new HashSet<FileObject>();
        WSITModelSupport.save(model, traversedModels);
    }

    private static void save(WSDLModel model, Set<FileObject> traversedModels) {
        if (model == null) {
            logger.log(Level.INFO, "Model cannot be null.");
            return;
        }
        FileObject modelFO = Util.getFOForModel(model);
        if (modelFO == null) {
            logger.log(Level.INFO, "Cannot find fileobject in lookup for: " + model.getModelSource());
        }
        if (traversedModels.contains(modelFO)) {
            return;
        }
        traversedModels.add(modelFO);
        try {
            Definitions defs = model.getDefinitions();
            if (defs != null) {
                Collection imports = defs.getImports();
                for (Import i : imports) {
                    WSDLModel importedModel = i.getImportedWSDLModel();
                    WSITModelSupport.save(importedModel, traversedModels);
                }
                DataObject wsdlDO = DataObject.find((FileObject)modelFO);
                if (wsdlDO != null && wsdlDO.isModified()) {
                    SaveCookie wsdlSaveCookie = (SaveCookie)wsdlDO.getCookie(SaveCookie.class);
                    if (wsdlSaveCookie != null) {
                        wsdlSaveCookie.save();
                    }
                    wsdlDO.setModified(false);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, null, e);
        }
    }

    public static Binding getBinding(Service service, FileObject implClass, Project project, boolean create, Collection<FileObject> createdFiles) {
        QName serviceQ;
        String portName = service.getPortName();
        String serviceName = service.getServiceName();
        if (serviceName == null && (serviceQ = JavaWsdlMapper.getServiceName(implClass)) != null) {
            serviceName = serviceQ.getLocalPart();
        }
        if (serviceName == null) {
            return null;
        }
        WSDLModel model = WSITModelSupport.getModelForService(service, implClass, project, create, createdFiles);
        if (model == null) {
            return null;
        }
        Definitions definitions = model.getDefinitions();
        if (definitions == null) {
            return null;
        }
        Collection bindings = definitions.getBindings();
        if (bindings == null || bindings.isEmpty()) {
            return null;
        }
        if (bindings.size() == 1) {
            return (Binding)bindings.iterator().next();
        }
        Collection services = definitions.getServices();
        for (org.netbeans.modules.xml.wsdl.model.Service s : services) {
            if (s == null || !serviceName.equals(s.getName())) continue;
            Collection ports = s.getPorts();
            if (portName == null) {
                if (ports == null || ports.isEmpty()) continue;
                Port p = (Port)ports.iterator().next();
                QName b = p.getBinding().getQName();
                return (Binding)model.findComponentByName(b, Binding.class);
            }
            for (Port p : ports) {
                if (!portName.equals(p.getName())) continue;
                QName b = p.getBinding().getQName();
                return (Binding)model.findComponentByName(b, Binding.class);
            }
        }
        return null;
    }

    static void moveCurrentConfig(Binding b, ConfigVersion currentCfgVersion, ConfigVersion targetCfgVersion, Project project) {
        if (b == null) {
            return;
        }
        boolean addr = AddressingModelHelper.isAddressingEnabled(b);
        boolean mtom = TransportModelHelper.isMtomEnabled(b);
        boolean tcp = TransportModelHelper.isTCPEnabled(b);
        boolean fi = TransportModelHelper.isFIEnabled(b);
        RMModelHelper currentRMH = RMModelHelper.getInstance(currentCfgVersion);
        boolean rm = currentRMH.isRMEnabled((WSDLComponent)b);
        boolean ordered = currentRMH.isOrderedEnabled(b);
        boolean flowControl = RMModelHelper.isFlowControl(b);
        RMSequenceBinding seqBinding = RMSequenceBinding.getValue(currentCfgVersion, b);
        RMDeliveryAssurance assurance = RMDeliveryAssurance.getValue(currentCfgVersion, b);
        String bufSize = RMModelHelper.getMaxReceiveBufferSize(b);
        String inactTimeout = currentRMH.getInactivityTimeout(b);
        String profile = ProfilesModelHelper.getSecurityProfile((WSDLComponent)b);
        boolean security = SecurityPolicyModelHelper.isSecurityEnabled((WSDLComponent)b);
        boolean serviceDefaultsUsed = ProfilesModelHelper.isServiceDefaultSetupUsed(profile, b, project);
        boolean sts = ProprietarySecurityPolicyModelHelper.isSTSEnabled(b);
        ArrayList<ServiceProviderElement> sProviderElems = new ArrayList<ServiceProviderElement>();
        String issuer = null;
        String contract = null;
        String lifetime = null;
        boolean encKey = false;
        boolean encToken = false;
        if (sts) {
            STSConfiguration stsConfig = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(b);
            List<ServiceProvider> sProviders = ProprietarySecurityPolicyModelHelper.getSTSServiceProviders(stsConfig);
            for (ServiceProvider sP : sProviders) {
                String spCertAlias = ProprietarySecurityPolicyModelHelper.getSPCertAlias(sP);
                String spKeyType = ProprietarySecurityPolicyModelHelper.getSPKeyType(sP);
                String spTokenType = ProprietarySecurityPolicyModelHelper.getSPTokenType(sP);
                String endpoint = sP.getEndpoint();
                ServiceProviderElement sElem = new ServiceProviderElement(endpoint, spCertAlias, spTokenType, spKeyType);
                sProviderElems.add(sElem);
            }
            issuer = ProprietarySecurityPolicyModelHelper.getSTSIssuer(b);
            lifetime = ProprietarySecurityPolicyModelHelper.getSTSLifeTime(b);
            contract = ProprietarySecurityPolicyModelHelper.getSTSContractClass(b);
            encKey = ProprietarySecurityPolicyModelHelper.getSTSEncryptKey(b);
            encToken = ProprietarySecurityPolicyModelHelper.getSTSEncryptToken(b);
        }
        PolicyModelHelper.removePolicyForElement((WSDLComponent)b);
        for (BindingOperation bo : b.getBindingOperations()) {
            BindingInput bi = bo.getBindingInput();
            BindingOutput bout = bo.getBindingOutput();
            if (bi != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bi);
            }
            if (bout != null) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bout);
            }
            for (BindingFault bf : bo.getBindingFaults()) {
                PolicyModelHelper.removePolicyForElement((WSDLComponent)bf);
            }
            PolicyModelHelper.removePolicyForElement((WSDLComponent)bo);
        }
        PolicyModelHelper.getInstance(targetCfgVersion).createPolicy((WSDLComponent)b, addr);
        TransportModelHelper.enableMtom(b, mtom);
        TransportModelHelper.enableFI(b, fi);
        TransportModelHelper.enableTCP(b, tcp);
        if (rm) {
            RMModelHelper targetRMH = RMModelHelper.getInstance(targetCfgVersion);
            targetRMH.enableRM(b, true);
            if (flowControl) {
                targetRMH.enableFlowControl(b, flowControl);
            }
            if (ordered) {
                targetRMH.enableOrdered(b, ordered);
            }
            if (bufSize != null) {
                RMModelHelper.setMaxReceiveBufferSize(b, bufSize);
            }
            if (inactTimeout != null) {
                targetRMH.setInactivityTimeout(b, inactTimeout);
            }
            if (seqBinding != null) {
                seqBinding.set(targetCfgVersion, b);
            }
            if (assurance != null) {
                assurance.set(targetCfgVersion, b);
            }
        }
        if (security) {
            SecurityProfile p = SecurityProfileRegistry.getDefault().getProfile(profile);
            if (p != null && !p.isProfileSupported(project, (WSDLComponent)b, sts)) {
                ProfilesModelHelper.getInstance(targetCfgVersion).setSecurityProfile((WSDLComponent)b, ComboConstants.PROF_USERNAME, null, false);
            } else {
                ProfilesModelHelper.getInstance(targetCfgVersion).setSecurityProfile((WSDLComponent)b, profile, null, false);
                if (serviceDefaultsUsed) {
                    ProfilesModelHelper.setServiceDefaults(profile, b, project);
                }
            }
        }
        if (sts) {
            ProprietarySecurityPolicyModelHelper psmh = ProprietarySecurityPolicyModelHelper.getInstance(targetCfgVersion);
            psmh.enableSTS(b, sts);
            ProprietarySecurityPolicyModelHelper.setSTSIssuer(b, issuer);
            ProprietarySecurityPolicyModelHelper.setSTSContractClass(b, contract);
            ProprietarySecurityPolicyModelHelper.setSTSLifeTime(b, lifetime);
            ProprietarySecurityPolicyModelHelper.setSTSEncryptKey(b, encKey);
            ProprietarySecurityPolicyModelHelper.setSTSEncryptToken(b, encToken);
            STSConfiguration stsConfig = ProprietarySecurityPolicyModelHelper.getSTSConfiguration(b);
            for (ServiceProviderElement spe : sProviderElems) {
                ProprietarySecurityPolicyModelHelper.addSTSServiceProvider(stsConfig, spe, targetCfgVersion);
            }
        }
        PolicyModelHelper.getInstance(targetCfgVersion).createPolicy((WSDLComponent)b, false);
    }
}

