/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.ObjCRuntime;
import org.clang.basic.SanitizerKind;
import org.clang.basic.VersionTuple;
import org.clang.basic.vfs.FileSystem;
import org.clang.driver.Action;
import org.clang.driver.Driver;
import org.clang.driver.DriverGlobals;
import org.clang.driver.JobAction;
import org.clang.driver.MultilibSet;
import org.clang.driver.SanitizerArgs;
import org.clang.driver.Tool;
import org.clang.driver.impl.DriverSuffix;
import org.clang.driver.impl.ToolChainStatics;
import org.clang.driver.options;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.Clang;
import org.clang.driver.tools.impl.ClangAs;
import org.clang.driver.types;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.void;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.DerivedArgList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.ARM;
import org.llvm.support.TargetRegistry;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.fs;
import org.llvm.support.sys.path;
import org.llvm.target.target.DebuggerKind;

public abstract class ToolChain
implements Destructors.ClassWithDestructor {
    private Driver D;
    private Triple _Triple;
    private ArgList Args;
    private Arg CachedRTTIArg;
    private RTTIMode CachedRTTIMode;
    private SmallVector<std.string> FilePaths;
    private SmallVector<std.string> ProgramPaths;
    private std_ptr.unique_ptr<Tool> Clang;
    private std_ptr.unique_ptr<Tool> Assemble;
    private std_ptr.unique_ptr<Tool> Link;
    private std_ptr.unique_ptr<SanitizerArgs> SanitizerArguments;
    protected MultilibSet Multilibs;
    protected char.ptr DefaultLinker;

    private Tool getClang() {
        if (!this.Clang.$bool()) {
            this.Clang.reset((Object)new Clang(this));
        }
        return (Tool)this.Clang.get();
    }

    private Tool getAssemble() {
        if (!this.Assemble.$bool()) {
            this.Assemble.reset((Object)this.buildAssembler());
        }
        return (Tool)this.Assemble.get();
    }

    private Tool getLink() {
        if (!this.Link.$bool()) {
            this.Link.reset((Object)this.buildLinker());
        }
        return (Tool)this.Link.get();
    }

    private Tool getClangAs() {
        if (!this.Assemble.$bool()) {
            this.Assemble.reset((Object)new ClangAs(this));
        }
        return (Tool)this.Assemble.get();
    }

    protected ToolChain() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ToolChain(Driver D, Triple T, ArgList Args) {
        this.D = D;
        this._Triple = new Triple(T);
        this.Args = Args;
        this.CachedRTTIArg = ToolChainStatics.GetRTTIArgument(Args);
        this.CachedRTTIMode = ToolChainStatics.CalculateRTTIMode(Args, this._Triple, this.CachedRTTIArg);
        this.FilePaths = new SmallVector(16, (Object)new std.string());
        this.ProgramPaths = new SmallVector(16, (Object)new std.string());
        this.Clang = new std_ptr.unique_ptr();
        this.Assemble = new std_ptr.unique_ptr();
        this.Link = new std_ptr.unique_ptr();
        this.SanitizerArguments = new std_ptr.unique_ptr();
        this.Multilibs = new MultilibSet();
        this.DefaultLinker = Native.$tryClone((char.ptr)NativePointer.$((String)"ld"));
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mthread_model.getValue()));
        if (A != null && !this.isThreadModelSupported(new StringRef(A.getValue()))) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(336))), (char.ptr)A.getValue()), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
    }

    protected Tool buildAssembler() {
        return new ClangAs(this);
    }

    protected Tool buildLinker() {
        throw new llvm_unreachable("Linking is not supported by this toolchain");
    }

    protected Tool getTool(Action.ActionClass AC) {
        switch (AC) {
            case AssembleJobClass: {
                return this.getAssemble();
            }
            case LinkJobClass: {
                return this.getLink();
            }
            case InputClass: 
            case BindArchClass: 
            case OffloadClass: 
            case LipoJobClass: 
            case DsymutilJobClass: 
            case VerifyDebugInfoJobClass: {
                throw new llvm_unreachable("Invalid tool kind.");
            }
            case CompileJobClass: 
            case PrecompileJobClass: 
            case PreprocessJobClass: 
            case AnalyzeJobClass: 
            case MigrateJobClass: 
            case VerifyPCHJobClass: 
            case BackendJobClass: {
                return this.getClang();
            }
        }
        throw new llvm_unreachable("Invalid tool kind.");
    }

    protected static void addSystemInclude(ArgList DriverArgs, ArgStringList CC1Args, Twine Path) {
        CC1Args.push_back((Object)NativePointer.$((String)"-internal-isystem"));
        CC1Args.push_back((Object)DriverArgs.MakeArgString(Path));
    }

    protected static void addExternCSystemInclude(ArgList DriverArgs, ArgStringList CC1Args, Twine Path) {
        CC1Args.push_back((Object)NativePointer.$((String)"-internal-externc-isystem"));
        CC1Args.push_back((Object)DriverArgs.MakeArgString(Path));
    }

    protected static void addExternCSystemIncludeIfExists(ArgList DriverArgs, ArgStringList CC1Args, Twine Path) {
        if (fs.exists((Twine)Path)) {
            ToolChain.addExternCSystemInclude(DriverArgs, CC1Args, Path);
        }
    }

    protected static void addSystemIncludes(ArgList DriverArgs, ArgStringList CC1Args, ArrayRef<StringRef> Paths) {
        for (StringRef Path : Paths) {
            CC1Args.push_back((Object)NativePointer.$((String)"-internal-isystem"));
            CC1Args.push_back((Object)DriverArgs.MakeArgString(new Twine(Path)));
        }
    }

    public void $destroy() {
        this.Multilibs.$destroy();
        this.SanitizerArguments.$destroy();
        this.Link.$destroy();
        this.Assemble.$destroy();
        this.Clang.$destroy();
        this.ProgramPaths.$destroy();
        this.FilePaths.$destroy();
        this._Triple.$destroy();
    }

    public Driver getDriver() {
        return this.D;
    }

    public FileSystem getVFS() {
        return this.getDriver().getVFS();
    }

    public Triple getTriple() {
        return this._Triple;
    }

    public Triple.ArchType getArch() {
        return this._Triple.getArch();
    }

    public StringRef getArchName() {
        return this._Triple.getArchName();
    }

    public StringRef getPlatform() {
        return this._Triple.getVendorName();
    }

    public StringRef getOS() {
        return this._Triple.getOSName();
    }

    public StringRef getDefaultUniversalArchName() {
        switch (this._Triple.getArch()) {
            case ppc: {
                return new StringRef("ppc");
            }
            case ppc64: {
                return new StringRef("ppc64");
            }
            case ppc64le: {
                return new StringRef("ppc64le");
            }
        }
        return this._Triple.getArchName();
    }

    public std.string getTripleString() {
        return new std.string(this._Triple.getTriple());
    }

    public SmallVector<std.string> getFilePaths() {
        return this.FilePaths;
    }

    public SmallVector<std.string> getProgramPaths() {
        return this.ProgramPaths;
    }

    public MultilibSet getMultilibs() {
        return this.Multilibs;
    }

    public SanitizerArgs getSanitizerArgs() {
        if (this.SanitizerArguments.get() == null) {
            this.SanitizerArguments.reset((Object)new SanitizerArgs(this, this.Args));
        }
        return (SanitizerArgs)this.SanitizerArguments.get();
    }

    public Arg getRTTIArg() {
        return this.CachedRTTIArg;
    }

    public RTTIMode getRTTIMode() {
        return this.CachedRTTIMode;
    }

    public static std_pair.pair<std.string, std.string> getTargetAndModeFromProgramName(StringRef PN) {
        std.string ProgName = ToolChainStatics.normalizeProgramName(new StringRef(PN));
        DriverSuffix DS = ToolChainStatics.parseDriverSuffix(new StringRef(ProgName));
        if (DS == null) {
            return new std_pair.pair(std.make_pair_Ptr_Ptr((Object)std.string.EMPTY, (Object)std.string.EMPTY));
        }
        std.string ModeFlag = new std.string(Native.$eq_ptr((void.ptr)DS.ModeFlag, (void.ptr)((char.ptr)null)) ? NativePointer.$EMPTY : DS.ModeFlag);
        int LastComponent = ProgName.rfind((byte)45, ProgName.size() - std.strlen((char.ptr)DS.Suffix));
        if (LastComponent == std.string.npos) {
            return new std_pair.pair(std.make_pair_Ptr_Ptr((Object)std.string.EMPTY, (Object)ModeFlag));
        }
        StringRef Prefix = new StringRef(ProgName);
        Prefix.$assignMove(Prefix.slice(0, LastComponent));
        std.string IgnoredError = new std.string();
        std.string Target2 = new std.string();
        if (TargetRegistry.lookupTarget((std.string)Prefix.$basic_string(), (std.string)IgnoredError) != null) {
            Target2.$assignMove(Prefix.$basic_string());
        }
        return std.make_pair((Object)Target2, (Object)ModeFlag);
    }

    public DerivedArgList TranslateArgs(DerivedArgList Args, char.ptr BoundArch) {
        return null;
    }

    public Tool SelectTool(JobAction JA) {
        if (this.getDriver().ShouldUseClangCompiler(JA)) {
            return this.getClang();
        }
        Action.ActionClass AC = JA.getKind();
        if (AC == Action.ActionClass.AssembleJobClass && this.useIntegratedAs()) {
            return this.getClangAs();
        }
        return this.getTool(AC);
    }

    public std.string GetFilePath(char.ptr Name) {
        return this.D.GetFilePath(Name, this);
    }

    public std.string GetProgramPath(char.ptr Name) {
        return this.D.GetProgramPath(Name, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public std.string GetLinkerPath() {
        Arg A = this.Args.getLastArg(new OptSpecifier(options.ID.OPT_fuse_ld_EQ.getValue()));
        if (A != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                StringRef UseLinker = new StringRef(A.getValue());
                if (path.is_absolute((Twine)new Twine(UseLinker))) {
                    if (fs.exists((Twine)new Twine(UseLinker))) {
                        std.string string2 = UseLinker.$basic_string();
                        return string2;
                    }
                } else {
                    if (UseLinker.empty() || llvm.$eq_StringRef((StringRef)UseLinker, (String)"ld")) {
                        std.string string3 = this.GetProgramPath(NativePointer.$((String)"ld"));
                        return string3;
                    }
                    SmallString LinkerName = new SmallString(new StringRef("ld."), 8);
                    LinkerName.append(new StringRef(UseLinker));
                    std.string LinkerPath = this.GetProgramPath(LinkerName.c_str());
                    if (fs.exists((Twine)new Twine(LinkerPath))) {
                        std.string string4 = LinkerPath;
                        return string4;
                    }
                }
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(328))), (StringRef)new StringRef(A.getAsString(this.Args))));
                std.string string5 = new std.string(NativePointer.$EMPTY);
                return string5;
            }
            finally {
                $c$.$destroy();
            }
        }
        return this.GetProgramPath(this.DefaultLinker);
    }

    public void printVerboseInfo(raw_ostream OS) {
    }

    public boolean isCrossCompiling() {
        Triple HostTriple = new Triple(new Twine("x86_64-unknown-linux-gnu"));
        switch (HostTriple.getArch()) {
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: {
                return this.getArch() != Triple.ArchType.arm && this.getArch() != Triple.ArchType.thumb && this.getArch() != Triple.ArchType.armeb && this.getArch() != Triple.ArchType.thumbeb;
            }
        }
        return HostTriple.getArch() != this.getArch();
    }

    public boolean HasNativeLLVMSupport() {
        return false;
    }

    public types.ID LookupTypeForExtension(char.ptr Ext) {
        return types.lookupTypeForExtension(Ext);
    }

    public boolean IsBlocksDefault() {
        return false;
    }

    public boolean IsIntegratedAssemblerDefault() {
        return false;
    }

    public boolean useIntegratedAs() {
        return this.Args.hasFlag(new OptSpecifier(options.ID.OPT_fintegrated_as.getValue()), new OptSpecifier(options.ID.OPT_fno_integrated_as.getValue()), this.IsIntegratedAssemblerDefault());
    }

    public boolean IsMathErrnoDefault() {
        return true;
    }

    public boolean IsEncodeExtendedBlockSignatureDefault() {
        return false;
    }

    public boolean IsObjCNonFragileABIDefault() {
        return false;
    }

    public boolean UseObjCMixedDispatch() {
        return false;
    }

    public int GetDefaultStackProtectorLevel(boolean KernelOrKext) {
        return 0;
    }

    public RuntimeLibType GetDefaultRuntimeLibType() {
        return RuntimeLibType.RLT_Libgcc;
    }

    public CXXStdlibType GetDefaultCXXStdlibType() {
        return CXXStdlibType.CST_Libstdcxx;
    }

    public std.string getCompilerRT(ArgList Args, StringRef Component) {
        return this.getCompilerRT(Args, Component, false);
    }

    public std.string getCompilerRT(ArgList Args, StringRef Component, boolean Shared) {
        Triple TT = this.getTriple();
        char.ptr Env = Native.$tryClone((char.ptr)(TT.isAndroid() ? NativePointer.$((String)"-android") : NativePointer.$EMPTY));
        boolean IsITANMSVCWindows = TT.isWindowsMSVCEnvironment() || TT.isWindowsItaniumEnvironment();
        StringRef Arch = ToolChainStatics.getArchNameForCompilerRTLib(this, Args);
        char.ptr Prefix = Native.$tryClone((char.ptr)(IsITANMSVCWindows ? NativePointer.$EMPTY : NativePointer.$((String)"lib")));
        char.ptr Suffix = Native.$tryClone((char.ptr)(Shared ? (this._Triple.isOSWindows() ? NativePointer.$((String)".dll") : NativePointer.$((String)".so")) : (IsITANMSVCWindows ? NativePointer.$((String)".lib") : NativePointer.$((String)".a"))));
        SmallString Path = new SmallString(new StringRef(this.getDriver().ResourceDir), 128);
        StringRef OSLibName = this._Triple.isOSFreeBSD() ? new StringRef("freebsd") : this.getOS();
        path.append((SmallString)Path, (Twine)new Twine("lib"), (Twine)new Twine(OSLibName));
        path.append((SmallString)Path, (Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)llvm.$add_Twine((Twine)new Twine(Prefix), (Twine)new Twine("clang_rt.")), (Twine)new Twine(Component)), (Twine)new Twine(NativePointer.$MINUS)), (Twine)new Twine(Arch)), (Twine)new Twine(Env)), (Twine)new Twine(Suffix)));
        return Path.str().$basic_string();
    }

    public char.ptr getCompilerRTArgString(ArgList Args, StringRef Component) {
        return this.getCompilerRTArgString(Args, Component, false);
    }

    public char.ptr getCompilerRTArgString(ArgList Args, StringRef Component, boolean Shared) {
        return Args.MakeArgString(new Twine(this.getCompilerRT(Args, new StringRef(Component), Shared)));
    }

    public static boolean needsProfileRT(ArgList Args) {
        return Args.hasFlag(new OptSpecifier(options.ID.OPT_fprofile_arcs.getValue()), new OptSpecifier(options.ID.OPT_fno_profile_arcs.getValue()), false) || Args.hasArg(new OptSpecifier(options.ID.OPT_fprofile_generate.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fprofile_generate_EQ.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fprofile_instr_generate.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fprofile_instr_generate_EQ.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_fcreate_profile.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_coverage.getValue()));
    }

    public boolean IsUnwindTablesDefault() {
        return false;
    }

    public abstract boolean isPICDefault();

    public abstract boolean isPIEDefault();

    public abstract boolean isPICDefaultForced();

    public boolean SupportsProfiling() {
        return true;
    }

    public boolean SupportsObjCGC() {
        return true;
    }

    public void CheckObjCARC() {
    }

    public boolean UseDwarfDebugFlags() {
        return false;
    }

    public int GetDefaultDwarfVersion() {
        return 4;
    }

    public boolean GetDefaultStandaloneDebug() {
        return false;
    }

    public DebuggerKind getDefaultDebuggerTuning() {
        return DebuggerKind.GDB;
    }

    public boolean UseSjLjExceptions(ArgList Args) {
        return false;
    }

    public boolean SupportsEmbeddedBitcode() {
        return false;
    }

    public std.string getThreadModel() {
        return new std.string((CharSequence)"posix");
    }

    public boolean isThreadModelSupported(StringRef Model2) {
        if (llvm.$eq_StringRef((StringRef)Model2, (String)"single")) {
            return this._Triple.getArch() == Triple.ArchType.arm || this._Triple.getArch() == Triple.ArchType.armeb || this._Triple.getArch() == Triple.ArchType.thumb || this._Triple.getArch() == Triple.ArchType.thumbeb || this._Triple.getArch() == Triple.ArchType.wasm32 || this._Triple.getArch() == Triple.ArchType.wasm64;
        }
        return llvm.$eq_StringRef((StringRef)Model2, (String)"posix");
    }

    public std.string ComputeLLVMTriple(ArgList Args) {
        return this.ComputeLLVMTriple(Args, types.ID.TY_INVALID);
    }

    public std.string ComputeLLVMTriple(ArgList Args, types.ID InputType) {
        boolean ThumbDefault;
        switch (this.getTriple().getArch()) {
            default: {
                return this.getTripleString();
            }
            case x86_64: {
                StringRef MArch;
                Triple Triple2 = new Triple(this.getTriple());
                if (!Triple2.isOSBinFormatMachO()) {
                    return this.getTripleString();
                }
                Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
                if (A != null && llvm.$eq_StringRef((StringRef)(MArch = new StringRef(A.getValue())), (String)"x86_64h")) {
                    Triple2.setArchName(new StringRef(MArch));
                }
                return new std.string(Triple2.getTriple());
            }
            case aarch64: {
                Triple Triple3 = new Triple(this.getTriple());
                if (!Triple3.isOSBinFormatMachO()) {
                    return this.getTripleString();
                }
                Triple3.setArchName(new StringRef("arm64"));
                return new std.string(Triple3.getTriple());
            }
            case arm: 
            case armeb: 
            case thumb: 
            case thumbeb: 
        }
        Triple _Triple = new Triple(this.getTriple());
        boolean IsBigEndian = this.getTriple().getArch() == Triple.ArchType.armeb || this.getTriple().getArch() == Triple.ArchType.thumbeb;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mlittle_endian.getValue()), new OptSpecifier(options.ID.OPT_mbig_endian.getValue()));
        if (A != null) {
            IsBigEndian = !A.getOption().matches(new OptSpecifier(options.ID.OPT_mlittle_endian.getValue()));
        }
        StringRef MCPU = new StringRef();
        StringRef MArch = new StringRef();
        Arg A2 = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
        if (A2 != null) {
            MCPU.$assignMove(A2.getValue());
        }
        if ((A2 = Args.getLastArg(new OptSpecifier(options.ID.OPT_march_EQ.getValue()))) != null) {
            MArch.$assignMove(A2.getValue());
        }
        std.string CPU = _Triple.isOSBinFormatMachO() ? ArmStatics.getARMCPUForMArch(new StringRef(MArch), _Triple).str() : ArmStatics.getARMTargetCPU(new StringRef(MCPU), new StringRef(MArch), _Triple);
        StringRef Suffix = ArmStatics.getLLVMArchSuffixForARM(new StringRef(CPU), new StringRef(MArch), _Triple);
        boolean IsMProfile = ARM.parseArchProfile((StringRef)Suffix) == ARM.ProfileKind.PK_M.getValue();
        boolean bl = ThumbDefault = IsMProfile || ARM.parseArchVersion((StringRef)Suffix) == 7 && this.getTriple().isOSBinFormatMachO();
        if (this.getTriple().isOSWindows()) {
            ThumbDefault = true;
        }
        std.string ArchName = new std.string();
        if (IsBigEndian) {
            ArchName.$assign((CharSequence)"armeb");
        } else {
            ArchName.$assign((CharSequence)"arm");
        }
        if (InputType != types.ID.TY_PP_Asm && Args.hasFlag(new OptSpecifier(options.ID.OPT_mthumb.getValue()), new OptSpecifier(options.ID.OPT_mno_thumb.getValue()), ThumbDefault) || IsMProfile) {
            if (IsBigEndian) {
                ArchName.$assign((CharSequence)"thumbeb");
            } else {
                ArchName.$assign((CharSequence)"thumb");
            }
        }
        _Triple.setArchName(new StringRef(std.$add_string$C_string((std.string)ArchName, (std.string)Suffix.str())));
        return new std.string(_Triple.getTriple());
    }

    public std.string ComputeEffectiveClangTriple(ArgList Args) {
        return this.ComputeEffectiveClangTriple(Args, types.ID.TY_INVALID);
    }

    public std.string ComputeEffectiveClangTriple(ArgList Args, types.ID InputType) {
        return this.ComputeLLVMTriple(Args, InputType);
    }

    public ObjCRuntime getDefaultObjCRuntime(boolean isNonFragile) {
        return new ObjCRuntime(isNonFragile ? ObjCRuntime.Kind.GNUstep : ObjCRuntime.Kind.GCC, new VersionTuple());
    }

    public boolean hasBlocksRuntime() {
        return true;
    }

    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public void addClangTargetOptions(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public void addClangWarningOptions(ArgStringList CC1Args) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RuntimeLibType GetRuntimeLibType(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_rtlib_EQ.getValue()));
        if (A != null) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                StringRef Value = new StringRef(A.getValue());
                if (llvm.$eq_StringRef((StringRef)Value, (String)"compiler-rt")) {
                    RuntimeLibType runtimeLibType = RuntimeLibType.RLT_CompilerRT;
                    return runtimeLibType;
                }
                if (llvm.$eq_StringRef((StringRef)Value, (String)"libgcc")) {
                    RuntimeLibType runtimeLibType = RuntimeLibType.RLT_Libgcc;
                    return runtimeLibType;
                }
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(334))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
        return this.GetDefaultRuntimeLibType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CXXStdlibType GetCXXStdlibType(ArgList Args) {
        type.ref Type2 = NativePointer.create_type$ref(null);
        boolean HasValidType = false;
        boolean ForcePlatformDefault = false;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue()));
        if (A != null) {
            StringRef Value = new StringRef(A.getValue());
            HasValidType = ToolChainStatics.ParseCXXStdlibType(Value, (type.ref<CXXStdlibType>)Type2);
            if (llvm.$eq_StringRef((StringRef)Value, (String)"platform")) {
                ForcePlatformDefault = true;
            } else if (!HasValidType) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(335))), (StringRef)new StringRef(A.getAsString(Args))));
                }
                finally {
                    $c$.$destroy();
                }
            }
        }
        if (!(HasValidType || !ForcePlatformDefault && ToolChainStatics.ParseCXXStdlibType(new StringRef(NativePointer.$EMPTY), (type.ref<CXXStdlibType>)Type2))) {
            Type2.$set((Object)this.GetDefaultCXXStdlibType());
        }
        assert (Type2.$deref() != null);
        return (CXXStdlibType)((Object)Type2.$deref());
    }

    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        DriverArgs.AddAllArgs(CC1Args, new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue()));
    }

    public void AddCXXStdlibLibArgs(ArgList Args, ArgStringList CmdArgs) {
        CXXStdlibType Type2 = this.GetCXXStdlibType(Args);
        switch (Type2) {
            case CST_Libcxx: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lc++"));
                break;
            }
            case CST_Libstdcxx: {
                CmdArgs.push_back((Object)NativePointer.$((String)"-lstdc++"));
            }
        }
    }

    public void AddFilePathLibArgs(ArgList Args, ArgStringList CmdArgs) {
        for (std.string LibPath : this.getFilePaths()) {
            if (!Unsigned.$greater_uint((int)LibPath.length(), (int)0)) continue;
            CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_Twine((Twine)new Twine("-L"), (Twine)new Twine(LibPath))));
        }
    }

    public void AddCCKextLibArgs(ArgList Args, ArgStringList CmdArgs) {
        CmdArgs.push_back((Object)NativePointer.$((String)"-lcc_kext"));
    }

    public boolean AddFastMathRuntimeIfAvailable(ArgList Args, ArgStringList CmdArgs) {
        Arg A;
        if (!(DriverGlobals.isOptimizationLevelFast(Args) || (A = Args.getLastArg(new OptSpecifier(options.ID.OPT_ffast_math.getValue()), new OptSpecifier(options.ID.OPT_fno_fast_math.getValue()), new OptSpecifier(options.ID.OPT_funsafe_math_optimizations.getValue()), new OptSpecifier(options.ID.OPT_fno_unsafe_math_optimizations.getValue()))) != null && A.getOption().getID() != options.ID.OPT_fno_fast_math.getValue() && A.getOption().getID() != options.ID.OPT_fno_unsafe_math_optimizations.getValue())) {
            return false;
        }
        std.string Path = this.GetFilePath(NativePointer.$((String)"crtfastmath.o"));
        if (std.$eq_string$C_T((std.string)Path, (String)"crtfastmath.o")) {
            return false;
        }
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Path)));
        return true;
    }

    public void addProfileRTLibs(ArgList Args, ArgStringList CmdArgs) {
        if (!ToolChain.needsProfileRT(Args)) {
            return;
        }
        CmdArgs.push_back((Object)this.getCompilerRTArgString(Args, new StringRef("profile")));
    }

    public void AddCudaIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public void AddIAMCUIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
    }

    public long getSupportedSanitizers() {
        long Res = SanitizerKind.Undefined & (SanitizerKind.Vptr ^ 0xFFFFFFFFFFFFFFFFL) & (SanitizerKind.Function ^ 0xFFFFFFFFFFFFFFFFL) | SanitizerKind.CFI & (SanitizerKind.CFIICall ^ 0xFFFFFFFFFFFFFFFFL) | SanitizerKind.CFICastStrict | SanitizerKind.UnsignedIntegerOverflow | SanitizerKind.LocalBounds;
        if (this.getTriple().getArch() == Triple.ArchType.x86 || this.getTriple().getArch() == Triple.ArchType.x86_64) {
            Res |= SanitizerKind.CFIICall;
        }
        return Res;
    }

    public long getDefaultSanitizers() {
        return 0L;
    }

    public VersionTuple getMSVCVersionFromExe() {
        return new VersionTuple();
    }

    public String toString() {
        return "D=" + this.D + ", _Triple=" + this._Triple + ", Args=" + this.Args + ", CachedRTTIArg=" + this.CachedRTTIArg + ", CachedRTTIMode=" + (Object)((Object)this.CachedRTTIMode) + ", FilePaths=" + this.FilePaths + ", ProgramPaths=" + this.ProgramPaths + ", Clang=" + this.Clang + ", Assemble=" + this.Assemble + ", Link=" + this.Link + ", SanitizerArguments=" + this.SanitizerArguments + ", Multilibs=" + this.Multilibs + ", DefaultLinker=" + this.DefaultLinker;
    }

    public static final class RTTIMode
    extends Enum<RTTIMode>
    implements Native.ComparableLower {
        public static final /* enum */ RTTIMode RM_EnabledExplicitly = new RTTIMode(0);
        public static final /* enum */ RTTIMode RM_EnabledImplicitly = new RTTIMode(RM_EnabledExplicitly.getValue() + 1);
        public static final /* enum */ RTTIMode RM_DisabledExplicitly = new RTTIMode(RM_EnabledImplicitly.getValue() + 1);
        public static final /* enum */ RTTIMode RM_DisabledImplicitly = new RTTIMode(RM_DisabledExplicitly.getValue() + 1);
        private final int value;
        private static final /* synthetic */ RTTIMode[] $VALUES;

        public static RTTIMode[] values() {
            return (RTTIMode[])$VALUES.clone();
        }

        public static RTTIMode valueOf(String name) {
            return Enum.valueOf(RTTIMode.class, name);
        }

        public static RTTIMode valueOf(int val) {
            RTTIMode out;
            RTTIMode rTTIMode = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private RTTIMode(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((RTTIMode)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((RTTIMode)((Object)obj)).value);
        }

        static {
            $VALUES = new RTTIMode[]{RM_EnabledExplicitly, RM_EnabledImplicitly, RM_DisabledExplicitly, RM_DisabledImplicitly};
        }

        private static final class Values {
            private static final RTTIMode[] VALUES;
            private static final RTTIMode[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RTTIMode kind : RTTIMode.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RTTIMode[min < 0 ? 1 - min : 0];
                VALUES = new RTTIMode[max >= 0 ? 1 + max : 0];
                for (RTTIMode kind : RTTIMode.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RTTIMode)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RTTIMode)kind).value] = kind;
                }
            }
        }
    }

    public static final class RuntimeLibType
    extends Enum<RuntimeLibType>
    implements Native.ComparableLower {
        public static final /* enum */ RuntimeLibType RLT_CompilerRT = new RuntimeLibType(0);
        public static final /* enum */ RuntimeLibType RLT_Libgcc = new RuntimeLibType(RLT_CompilerRT.getValue() + 1);
        private final int value;
        private static final /* synthetic */ RuntimeLibType[] $VALUES;

        public static RuntimeLibType[] values() {
            return (RuntimeLibType[])$VALUES.clone();
        }

        public static RuntimeLibType valueOf(String name) {
            return Enum.valueOf(RuntimeLibType.class, name);
        }

        public static RuntimeLibType valueOf(int val) {
            RuntimeLibType out;
            RuntimeLibType runtimeLibType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private RuntimeLibType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((RuntimeLibType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((RuntimeLibType)((Object)obj)).value);
        }

        static {
            $VALUES = new RuntimeLibType[]{RLT_CompilerRT, RLT_Libgcc};
        }

        private static final class Values {
            private static final RuntimeLibType[] VALUES;
            private static final RuntimeLibType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (RuntimeLibType kind : RuntimeLibType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new RuntimeLibType[min < 0 ? 1 - min : 0];
                VALUES = new RuntimeLibType[max >= 0 ? 1 + max : 0];
                for (RuntimeLibType kind : RuntimeLibType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((RuntimeLibType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((RuntimeLibType)kind).value] = kind;
                }
            }
        }
    }

    public static final class CXXStdlibType
    extends Enum<CXXStdlibType>
    implements Native.ComparableLower {
        public static final /* enum */ CXXStdlibType CST_Libcxx = new CXXStdlibType(0);
        public static final /* enum */ CXXStdlibType CST_Libstdcxx = new CXXStdlibType(CST_Libcxx.getValue() + 1);
        private final int value;
        private static final /* synthetic */ CXXStdlibType[] $VALUES;

        public static CXXStdlibType[] values() {
            return (CXXStdlibType[])$VALUES.clone();
        }

        public static CXXStdlibType valueOf(String name) {
            return Enum.valueOf(CXXStdlibType.class, name);
        }

        public static CXXStdlibType valueOf(int val) {
            CXXStdlibType out;
            CXXStdlibType cXXStdlibType = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private CXXStdlibType(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((CXXStdlibType)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((CXXStdlibType)((Object)obj)).value);
        }

        static {
            $VALUES = new CXXStdlibType[]{CST_Libcxx, CST_Libstdcxx};
        }

        private static final class Values {
            private static final CXXStdlibType[] VALUES;
            private static final CXXStdlibType[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (CXXStdlibType kind : CXXStdlibType.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new CXXStdlibType[min < 0 ? 1 - min : 0];
                VALUES = new CXXStdlibType[max >= 0 ? 1 + max : 0];
                for (CXXStdlibType kind : CXXStdlibType.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((CXXStdlibType)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((CXXStdlibType)kind).value] = kind;
                }
            }
        }
    }
}

