/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.LTOKind;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Linux;
import org.clang.driver.tools.impl.ArmStatics;
import org.clang.driver.tools.impl.GnuTool;
import org.clang.driver.tools.impl.MipsStatics;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.Reloc;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class GnutoolsStatics {

    public static class Linker
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"GNU::Linker"), NativePointer.$((String)"linker"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                Linux ToolChain2 = (Linux)this.getToolChain();
                Driver D = ToolChain2.getDriver();
                std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args);
                Triple _Triple = new Triple(new Twine(TripleStr));
                Triple.ArchType Arch = ToolChain2.getArch();
                boolean isAndroid = ToolChain2.getTriple().isAndroid();
                boolean IsIAMCU = ToolChain2.getTriple().isOSIAMCU();
                boolean IsPIE = !Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) && (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue())) || ToolChain2.isPIEDefault());
                boolean HasCRTBeginEndFiles = ToolChain2.getTriple().hasEnvironment() || ToolChain2.getTriple().getVendor() != Triple.VendorType.MipsTechnologies;
                ArgStringList CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(ToolChain2.GetLinkerPath())));
                if (llvm.$eq_StringRef((StringRef)path.filename((StringRef)new StringRef(Exec)), (String)"lld")) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-flavor"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"old-gnu"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-target"));
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(this.getToolChain().getTripleString())));
                }
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_string$C((String)"--sysroot=", (std.string)D.SysRoot))));
                }
                if (IsPIE) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_s.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-s"));
                }
                if (Arch == Triple.ArchType.armeb || Arch == Triple.ArchType.thumbeb) {
                    ArmStatics.appendEBLinkFlags(Args, CmdArgs, _Triple);
                }
                for (std.string Opt : ToolChain2.ExtraOpts) {
                    CmdArgs.push_back((Object)Opt.c_str());
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--eh-frame-hdr"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                CmdArgs.push_back((Object)ToolsStatics.getLDMOption(ToolChain2.getTriple(), Args));
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    if (Arch == Triple.ArchType.arm || Arch == Triple.ArchType.armeb || Arch == Triple.ArchType.thumb || Arch == Triple.ArchType.thumbeb) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    } else {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-static"));
                    }
                } else if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                    }
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        std.string Loader = std.$add_string$C_string((std.string)D.DyldPrefix, (std.string)ToolChain2.getDynamicLinker(Args));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-dynamic-linker"));
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(Loader)));
                    }
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    if (!isAndroid && !IsIAMCU) {
                        char.ptr crt1 = null;
                        if (!Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                            crt1 = Args.hasArg(new OptSpecifier(options.ID.OPT_pg.getValue())) ? Native.$tryClone((char.ptr)NativePointer.$((String)"gcrt1.o")) : (IsPIE ? Native.$tryClone((char.ptr)NativePointer.$((String)"Scrt1.o")) : Native.$tryClone((char.ptr)NativePointer.$((String)"crt1.o")));
                        }
                        if (crt1 != null) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crt1))));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crti.o")))));
                    }
                    if (IsIAMCU) {
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crt0.o")))));
                    } else {
                        char.ptr crtbegin = Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_static.o") : NativePointer.$((String)"crtbeginT.o"))) : (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_so.o") : NativePointer.$((String)"crtbeginS.o"))) : (IsPIE ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_dynamic.o") : NativePointer.$((String)"crtbeginS.o"))) : Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtbegin_dynamic.o") : NativePointer.$((String)"crtbegin.o")))));
                        if (HasCRTBeginEndFiles) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crtbegin))));
                        }
                    }
                    ToolChain2.AddFastMathRuntimeIfAvailable(Args, CmdArgs);
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_u.getValue()));
                ToolChain2.AddFilePathLibArgs(Args, CmdArgs);
                if (D.isUsingLTO()) {
                    ToolsStatics.AddGoldPlugin(ToolChain2, Args, CmdArgs, D.getLTOMode() == LTOKind.LTOK_Thin);
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_Z_Xlinker__no_demangle.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--no-demangle"));
                }
                boolean NeedsSanitizerDeps = ToolsStatics.addSanitizerRuntimes(ToolChain2, Args, CmdArgs);
                boolean NeedsXRayDeps = ToolsStatics.addXRayRuntime(ToolChain2, Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(ToolChain2, Inputs, Args, CmdArgs);
                this.getToolChain().addProfileRTLibs(Args, CmdArgs);
                if (D.CCCIsCXX() && !Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    boolean OnlyLibstdcxxStatic;
                    boolean bl = OnlyLibstdcxxStatic = Args.hasArg(new OptSpecifier(options.ID.OPT_static_libstdcxx.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    }
                    ToolChain2.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (OnlyLibstdcxxStatic) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lm"));
                }
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue()));
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()))) {
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                        boolean WantPthread;
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--start-group"));
                        }
                        if (NeedsSanitizerDeps) {
                            ToolsStatics.linkSanitizerRuntimeDeps(ToolChain2, CmdArgs);
                        }
                        if (NeedsXRayDeps) {
                            ToolsStatics.linkXRayRuntimeDeps(ToolChain2, Args, CmdArgs);
                        }
                        boolean bl = WantPthread = Args.hasArg(new OptSpecifier(options.ID.OPT_pthread.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_pthreads.getValue()));
                        if (Args.hasFlag(new OptSpecifier(options.ID.OPT_fopenmp.getValue()), new OptSpecifier(options.ID.OPT_fopenmp_EQ.getValue()), new OptSpecifier(options.ID.OPT_fno_openmp.getValue()), false)) {
                            WantPthread = true;
                            switch (ToolsStatics.getOpenMPRuntime(ToolChain2, Args)) {
                                case OMPRT_OMP: {
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-lomp"));
                                    break;
                                }
                                case OMPRT_GOMP: {
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-lgomp"));
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-lrt"));
                                    break;
                                }
                                case OMPRT_IOMP5: {
                                    CmdArgs.push_back((Object)NativePointer.$((String)"-liomp5"));
                                    break;
                                }
                            }
                        }
                        ToolsStatics.AddRunTimeLibs(ToolChain2, D, CmdArgs, Args);
                        if (WantPthread && !isAndroid) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lpthread"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_fsplit_stack.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--wrap=pthread_create"));
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"-lc"));
                        if (IsIAMCU) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lgloss"));
                        }
                        if (Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--end-group"));
                        } else {
                            ToolsStatics.AddRunTimeLibs(ToolChain2, D, CmdArgs, Args);
                        }
                        if (IsIAMCU) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--as-needed"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"-lsoftfp"));
                            CmdArgs.push_back((Object)NativePointer.$((String)"--no-as-needed"));
                        }
                    }
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostartfiles.getValue())) && !IsIAMCU) {
                        char.ptr crtend = Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_so.o") : NativePointer.$((String)"crtendS.o"))) : (IsPIE ? Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_android.o") : NativePointer.$((String)"crtendS.o"))) : Native.$tryClone((char.ptr)(isAndroid ? NativePointer.$((String)"crtend_android.o") : NativePointer.$((String)"crtend.o"))));
                        if (HasCRTBeginEndFiles) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(crtend))));
                        }
                        if (!isAndroid) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ToolChain2.GetFilePath(NativePointer.$((String)"crtn.o")))));
                        }
                    }
                }
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends GnuTool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"GNU::Assembler"), NativePointer.$((String)"assembler"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                std.string TripleStr = this.getToolChain().ComputeEffectiveClangTriple(Args);
                Triple _Triple = new Triple(new Twine(TripleStr));
                ArgStringList CmdArgs = new ArgStringList();
                std.tuple ParsedPICArgs = ToolsStatics.ParsePICArgs(this.getToolChain(), _Triple, Args);
                Reloc.Model RelocationModel = (Reloc.Model)ParsedPICArgs.$getAt(0);
                int PICLevel = (Integer)ParsedPICArgs.$getAt(1);
                boolean IsPIE = (Boolean)ParsedPICArgs.$getAt(2);
                switch (this.getToolChain().getArch()) {
                    default: {
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case x86_64: {
                        if (this.getToolChain().getTriple().getEnvironment() == Triple.EnvironmentType.GNUX32) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"--x32"));
                            break;
                        }
                        CmdArgs.push_back((Object)NativePointer.$((String)"--64"));
                        break;
                    }
                    case ppc: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-a32"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mppc"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                        break;
                    }
                    case ppc64: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-a64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mppc64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                        break;
                    }
                    case ppc64le: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-a64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mppc64"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-many"));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mlittle-endian"));
                        break;
                    }
                    case sparc: 
                    case sparcel: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-32"));
                        std.string CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef(CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case sparcv9: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-64"));
                        std.string CPU = ToolsStatics.getCPUName(Args, this.getToolChain().getTriple());
                        CmdArgs.push_back((Object)ToolsStatics.getSparcAsmModeForCPU(new StringRef(CPU), this.getToolChain().getTriple()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case arm: 
                    case armeb: 
                    case thumb: 
                    case thumbeb: {
                        Triple Triple2 = this.getToolChain().getTriple();
                        switch (Triple2.getSubArch()) {
                            case ARMSubArch_v7: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=neon"));
                                break;
                            }
                            case ARMSubArch_v8: {
                                CmdArgs.push_back((Object)NativePointer.$((String)"-mfpu=crypto-neon-fp-armv8"));
                                break;
                            }
                        }
                        switch (ArmStatics.getARMFloatABI(this.getToolChain(), Args)) {
                            case Invalid: {
                                throw new llvm_unreachable("must have an ABI!");
                            }
                            case Soft: {
                                CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-mfloat-abi=soft")));
                                break;
                            }
                            case SoftFP: {
                                CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-mfloat-abi=softfp")));
                                break;
                            }
                            case Hard: {
                                CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-mfloat-abi=hard")));
                            }
                        }
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
                        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
                        if (A != null && std.$eq_string$C_T((std.string)new StringRef(A.getValue()).lower(), (String)"krait")) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mcpu=cortex-a15"));
                        } else {
                            Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()));
                        }
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mfpu_EQ.getValue()));
                        break;
                    }
                    case mips: 
                    case mipsel: 
                    case mips64: 
                    case mips64el: {
                        Object CPUName = new StringRef();
                        StringRef ABIName = new StringRef();
                        MipsStatics.getMipsCPUAndABI(Args, this.getToolChain().getTriple(), (StringRef)CPUName, ABIName);
                        ABIName.$assignMove(ToolsStatics.getGnuCompatibleMipsABIName(ABIName));
                        CmdArgs.push_back((Object)NativePointer.$((String)"-march"));
                        CmdArgs.push_back((Object)CPUName.data());
                        CmdArgs.push_back((Object)NativePointer.$((String)"-mabi"));
                        CmdArgs.push_back((Object)ABIName.data());
                        if (RelocationModel == Reloc.Model.Static) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mno-shared"));
                        }
                        CmdArgs.push_back((Object)(llvm.$eq_StringRef((StringRef)ABIName, (String)"64") ? NativePointer.$((String)"-KPIC") : NativePointer.$((String)"-call_nonpic")));
                        if (this.getToolChain().getArch() == Triple.ArchType.mips || this.getToolChain().getArch() == Triple.ArchType.mips64) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EB"));
                        } else {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-EL"));
                        }
                        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mnan_EQ.getValue()));
                        if (A != null && llvm.$eq_StringRef((char.ptr)A.getValue(), (String)"2008")) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-mnan=2008")));
                        }
                        if ((A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mfp32.getValue()), new OptSpecifier(options.ID.OPT_mfpxx.getValue()), new OptSpecifier(options.ID.OPT_mfp64.getValue()))) != null) {
                            A.claim();
                            A.render(Args, CmdArgs);
                        } else if (MipsStatics.shouldUseFPXX(Args, this.getToolChain().getTriple(), new StringRef((StringRef)CPUName), new StringRef(ABIName), ToolsStatics.getMipsFloatABI(this.getToolChain().getDriver(), Args))) {
                            CmdArgs.push_back((Object)NativePointer.$((String)"-mfpxx"));
                        }
                        A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mips16.getValue()), new OptSpecifier(options.ID.OPT_mno_mips16.getValue()));
                        if (A != null) {
                            if (A.getOption().matches(new OptSpecifier(options.ID.OPT_mips16.getValue()))) {
                                A.claim();
                                A.render(Args, CmdArgs);
                            } else {
                                A.claim();
                                CmdArgs.push_back((Object)NativePointer.$((String)"-no-mips16"));
                            }
                        }
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mmicromips.getValue()), new OptSpecifier(options.ID.OPT_mno_micromips.getValue()));
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mdsp.getValue()), new OptSpecifier(options.ID.OPT_mno_dsp.getValue()));
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mdspr2.getValue()), new OptSpecifier(options.ID.OPT_mno_dspr2.getValue()));
                        A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mmsa.getValue()), new OptSpecifier(options.ID.OPT_mno_msa.getValue()));
                        if (A != null && A.getOption().matches(new OptSpecifier(options.ID.OPT_mmsa.getValue()))) {
                            CmdArgs.push_back((Object)Args.MakeArgString(new Twine("-mmsa")));
                        }
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mhard_float.getValue()), new OptSpecifier(options.ID.OPT_msoft_float.getValue()));
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_mdouble_float.getValue()), new OptSpecifier(options.ID.OPT_msingle_float.getValue()));
                        Args.AddLastArg(CmdArgs, new OptSpecifier(options.ID.OPT_modd_spreg.getValue()), new OptSpecifier(options.ID.OPT_mno_odd_spreg.getValue()));
                        ToolsStatics.AddAssemblerKPIC(this.getToolChain(), Args, CmdArgs);
                        break;
                    }
                    case systemz: {
                        Object CPUName = new StringRef(ToolsStatics.getSystemZTargetCPU(Args));
                        CmdArgs.push_back((Object)Args.MakeArgString(llvm.$add_char$ptr$C_StringRef((String)"-march=", (StringRef)CPUName)));
                        break;
                    }
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_I.getValue()));
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo II : Inputs) {
                    CmdArgs.push_back((Object)II.getFilename());
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(this.getToolChain().GetProgramPath(NativePointer.$((String)"as")))));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_gsplit_dwarf.getValue())) && this.getToolChain().getTriple().isOSLinux()) {
                    ToolsStatics.SplitDebugInfo(this.getToolChain(), C, this, JA, Args, Output, ToolsStatics.SplitDebugName(Args, (InputInfo)Inputs.$at(0)));
                }
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

